# Copyright (c) 2023 The Old Man and the C
#
# This file is part of Elden Ring Randomizer Hints.
#
# Elden Ring Randomizer Hints is free software: you can redistribute it and/or
# modify it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Elden Ring Randomizer Hints is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
# or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License
# for more details.
#
# You should have received a copy of the GNU Affero General Public License along
# with Elden Ring Randomizer Hints. If not, see <https://www.gnu.org/licenses/>.

defaultSettings = {
    "useRandomizer": True,
    "useQuestHints": True,
    "useCategoryHints": True,
    "useChestHints": True,
    "useBossHints": True,
    "useNearbyHints": True,
    "useNeighboringBias": True,
    "useNearbyFogHints": True,
    "useChestFogHints": True,
    "useBossFogHints": True,
    "maidenItems": dict(),
    "chestHintsPercent": 100.0,
    "bossHintsPercent": 100.0,
    "chestFogHintsPercent": 100.0,
    "bossFogHintsPercent": 100.0,
}

msgPath = "msg/"
msgbndFile = "item.msgbnd.dcx"
msgbndPath = "item-msgbnd-dcx"
yabberXMLPath = "item-msgbnd-dcx/GR/data/INTERROOT_win64/msg/"
witchyXMLPath = "item-msgbnd-dcx/"

itemInfoModule = "source.data.locale.itemInfo."
localeDataModule = "source.data.locale.localeData."
missableLotsModule = "source.data.locale.missableLots."

shopLots = [
    "101800", "101801", "101859", "101860", "101861", "101862", "101863",
    "101864", "101865", "101866", "101867", "101868", "101869", "101870",
    "101871", "101872", "101873", "101874", "101875", "101876", "101877"
]
fingerMaidenLotID = "10010000"

exportKeys = \
    ["activeCategories", "bossFogHintsPercent", "bossHintsPercent",
     "chestFogHintsPercent", "chestHintsPercent", "customFogSeed", "customSeed",
     "hintCategories", "maidenItems", "useAllDirections", "useBossFogHints",
     "useBossHints", "useCategoryHints", "useChestFogHints", "useChestHints",
     "useFingerMaidenItems", "useFogRandomizer", "useNearbyFogHints",
     "useNearbyHints", "useNeighboringBias", "useQuestHints", "useRandomizer",
     "useShopInventory"]

# list of exported params and their keys for new data to patch
paramList = {
    "EquipParamWeapon": "",
    "EquipParamProtector": "",
    "EquipParamAccessory": "",
    "EquipParamGoods": "newEquipParamGoods",
    "EquipParamGem": "",
    "ItemLotParam_map": "newItemLotParam_map",
    "ShopLineupParam": "newShopLineupParam"
}

paramExportCommand = "\"{}\" \"{}\" -P \"{}\" -X {}-O \"{}\""
paramPatchCommand = "\"{}\" \"{}\" -P \"{}\"{} -M \"{}\" -O \"{}\""

xmlList = {
    "GoodsName.fmg": "nameXML",
    "GoodsInfo.fmg": "infoXML",
    "GoodsCaption.fmg": "captionXML",
    "GoodsDialog.fmg": "dialogXML",
}

toml = "# Generated by Elden Ring Randomizer Hints\n" \
       "\n" \
       "[modengine]\n" \
       "debug = false\n" \
       "external_dlls = []\n" \
       "[extension.mod_loader]\n" \
       "enabled = true\n" \
       "loose_params = false\n" \
       "mods = [\n"
tomlModEntry = "    {{ enabled = true, name = \"{}\", path = \"{}\" }},\n"
tomlEnd = "]\n" \
          "[extension.scylla_hide]\n" \
          "enabled = false"
tomlFile = "/config_randomizerhints.toml"

languages = ["engus", "deude", "frafr", "itait", "jpnjp", "korkr", "polpl",
             "porbr", "rusru", "spaar", "spaes", "thath", "zhocn", "zhotw"]

bellOfReturnXML = "<text id=\"141626\">{}</text>\n"
