# Copyright (c) 2023 The Old Man and the C
#
# This file is part of Elden Ring Randomizer Hints.
#
# Elden Ring Randomizer Hints is free software: you can redistribute it and/or
# modify it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Elden Ring Randomizer Hints is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
# or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License
# for more details.
#
# You should have received a copy of the GNU Affero General Public License along
# with Elden Ring Randomizer Hints. If not, see <https://www.gnu.org/licenses/>.

uiText_thath = {
    "mainController": {
        "changeLanguageTitle_engus": "Restart Required",
        "changeLanguagePrompt_engus": "Changing the language requires a restart. Please quit and restart the program.",
        "changeLanguageTitle_deude": "Neustart erforderlich",
        "changeLanguagePrompt_deude": "Das Ändern der Sprache erfordert einen Neustart. Bitte beenden Sie das Programm und starten Sie es neu.",
        "changeLanguageTitle_frafr": "Redémarrage requis",
        "changeLanguagePrompt_frafr": "Changer la langue nécessite un redémarrage. Veuillez quitter et redémarrer le programme.",
        "changeLanguageTitle_itait": "Riavvio richiesto",
        "changeLanguagePrompt_itait": "La modifica della lingua richiede un riavvio. Si prega di uscire e riavviare il programma.",
        "changeLanguageTitle_jpnjp": "再起動が必要です",
        "changeLanguagePrompt_jpnjp": "言語を変更するには再起動が必要です。 プログラムを終了して再起動してください。",
        "changeLanguageTitle_korkr": "다시 시작 필요",
        "changeLanguagePrompt_korkr": "언어를 변경하려면 다시 시작해야 합니다. 프로그램을 종료하고 다시 시작하십시오.",
        "changeLanguageTitle_polpl": "Wymagane jest ponowne uruchomienie",
        "changeLanguagePrompt_polpl": "Zmiana języka wymaga ponownego uruchomienia. Proszę wyjść i uruchomić ponownie program.",
        "changeLanguageTitle_porbr": "Reinicialização necessária",
        "changeLanguagePrompt_porbr": "Alterar o idioma requer uma reinicialização. Feche e reinicie o programa.",
        "changeLanguageTitle_rusru": "Требуется перезагрузка",
        "changeLanguagePrompt_rusru": "Изменение языка требует перезагрузки. Пожалуйста, закройте и перезапустите программу.",
        "changeLanguageTitle_spaar": "Reinicio requerido",
        "changeLanguagePrompt_spaar": "Cambiar el idioma requiere un reinicio. Salga y reinicie el programa.",
        "changeLanguageTitle_spaes": "Reinicio requerido",
        "changeLanguagePrompt_spaes": "Cambiar el idioma requiere un reinicio. Salga y reinicie el programa.",
        "changeLanguageTitle_thath": "จำเป็นต้องรีสตาร์ท",
        "changeLanguagePrompt_thath": "การเปลี่ยนภาษาจำเป็นต้องรีสตาร์ท กรุณาออกและรีสตาร์ทโปรแกรม",
        "changeLanguageTitle_zhocn": "需要重新启动",
        "changeLanguagePrompt_zhocn": "更改语言需要重新启动。 请退出并重新启动该程序。",
        "changeLanguageTitle_zhotw": "需要重新啟動",
        "changeLanguagePrompt_zhotw": "更改語言需要重新啟動。 請退出並重新啟動該程式。",
        "languageChangedTitle": "เปลี่ยนภาษาแล้ว",
        "languageChangedPrompt": "ภาษามีการเปลี่ยนแปลง หากคุณต้องการชื่อหมวดหมู่ที่แปลแล้ว ขอแนะนำให้คุณ \"โหลดหมวดหมู่เริ่มต้นซ้ำ\" ในแท็บ \"แก้ไขหมวดหมู่\" จากนั้น \"โหลดการเลือกหมวดหมู่เริ่มต้นซ้ำ\" ในแท็บ \"การเลือกหมวดหมู่\" อย่างไรก็ตาม สิ่งนี้ไม่จำเป็น",
        "newTitle": "หมวดหมู่ใหม่",
        "newPrompt": "ป้อนชื่อสำหรับหมวดหมู่ใหม่:",
        "renameTitle": "เปลี่ยนชื่อหมวดหมู่",
        "renamePrompt": "ป้อนชื่อใหม่สำหรับหมวดหมู่:",
        "reloadTitle": "โหลดค่าเริ่มต้นซ้ำหรือไม่",
        "reloadPrompt": "คุณแน่ใจหรือไม่ว่าต้องการโหลดหมวดหมู่คำใบ้เริ่มต้นซ้ำ สิ่งนี้ไม่สามารถยกเลิกได้",
        "reloadActivePrompt": "คุณแน่ใจหรือไม่ว่าต้องการโหลดรายการหมวดหมู่ที่ใช้งานเริ่มต้นซ้ำ สิ่งนี้ไม่สามารถยกเลิกได้",
        "shopTitle": "โหลดสินค้าคงคลังของร้านค้า",
        "shopPrompt": "คุณแน่ใจหรือไม่ว่าต้องการโหลดสินค้าคงคลังของร้านค้า หญิง​ชรา​แฝด การเปลี่ยนแปลงใด ๆ ที่เกิดขึ้นกับสินค้าคงคลังที่คุณทำไว้จะสูญหาย",
        "invalidMaidenTitle": "ไม่สามารถเพิ่มรายการ หญิง​ร่าง​ทรง​องคุลี",
        "invalidPropertyTitle": "ไม่สามารถตั้งค่าคุณสมบัติได้",
        "invalidDropPrompt": "เฉพาะคำแนะนำไอเท็มแต่ละรายการเท่านั้นที่สามารถมีชุดคุณสมบัติ \"เดน เท่านั้น\" ได้",
        "fullMaidenPrompt": "หญิง​ร่าง​ทรง​องคุลี ล็อตรายการเต็มแล้ว โปรดทราบว่าคำใบ้สี่คำสามารถรวมอยู่ในล็อตรายการเดียวได้",
        "maidenSpace": "ใช้ล็อตรายการ {}/{} แล้ว เหลืออีก {} คำใบ้ในล็อตที่ใช้อยู่ในปัจจุบัน",
        "itemPriceTitle": "กำหนดราคาสินค้า",
        "itemPricePrompt": "ป้อนราคาของรายการเป็นอักษรรูน:",
        "clearConsoleTitle": "ล้าง คอนโซล หรือไม่",
        "clearConsolePrompt": "คุณแน่ใจหรือไม่ว่าต้องการล้างแผง คอนโซล?",
        "saveSettingsTitle": "บันทึกการตั้งค่า",
        "loadSettingsTitle": "โหลดการตั้งค่า",
        "settingsFileType": "การตั้งค่า Elden Ring Randomizer Hints",
        "exportSettingsTitle": "การตั้งค่าการส่งออก",
        "importSettingsTitle": "นำเข้าการตั้งค่า",
        "exportSettingsFileType": "Elden Ring Randomizer Hints ส่งออก",
        "shopChangedText": "\nข้อสังเกต: สินค้าคงคลังพื้นฐานของร้านค้า หญิง​ชรา​แฝด มีการเปลี่ยนแปลง ดังนั้นการเปลี่ยนแปลงใด ๆ ในร้านค้าจึงถูกรีเซ็ต กรุณาตรวจสอบแท็บ \"รายการเริ่มต้น\"\n",
        "shopChangedTitle": "สินค้าคงคลังของร้านค้ามีการเปลี่ยนแปลง",
        "shopChangedPrompt": "สินค้าคงคลังพื้นฐานของร้านค้า หญิง​ชรา​แฝด มีการเปลี่ยนแปลง ดังนั้นการเปลี่ยนแปลงใด ๆ ในร้านค้าจึงถูกรีเซ็ต",
        "loadSettingsText": "\nกำลังโหลดการตั้งค่า...",
        "importSettingsText": "\nกำลังนำเข้าการตั้งค่า...",
        "readSpoilersText": "กำลังอ่านไฟล์ Elden Ring Item and Enemy Randomizer spoiler...",
        "seedText": "เมล็ดสุ่ม: {}",
        "fogSeedText": "เมล็ดสุ่มประตูหมอก: {}",
        "readFogText": "กำลังอ่านไฟล์ Elden Ring Fog Gate Randomizer spoiler...",
        "readRegulationText": "กำลังอ่านไฟล์ regulation.bin...",
        "invalidPathsText": "เส้นทางไฟล์ไม่ถูกต้อง โปรดเลือกไฟล์ปฏิบัติการที่ถูกต้อง\n",
        "notBuildReadyText": "ไม่มีการเปิดใช้งานการสุ่ม ปิดใช้งานการสร้างคำใบ้",
        "buildReadyText": "เส้นทางไฟล์ถูกต้อง พร้อมสร้างคำแนะนำ\nคลิกปุ่ม \"สร้างคำแนะนำ\" เมื่อพร้อมที่จะดำเนินการต่อ",
        "noBuildText": "ไม่มีการเปิดใช้งานการสุ่ม ไม่มีอะไรที่จะสร้าง! โปรดเปิดใช้งานโปรแกรมสุ่มแล้วลองอีกครั้ง",
        "readingFilesText": "\nกำลังอ่านไฟล์ XML...",
        "generatingHintsText": "กำลังเริ่มต้นการสร้างคำใบ้รายการ...",
        "generatingFogHintsText": "กำลังเริ่มสร้างคำแนะนำไฟตัดหมอก...",
        "usedSeedText": "ใช้เมล็ด: {}",
        "processingItemsText": "กำลังประมวลผลรายการ...",
        "numLotsText": "จำนวนล็อตสินค้า: {}",
        "useMaidenItemsText": "การสร้างไอเท็ม หญิง​ร่าง​ทรง​องคุลี และคำแนะนำใน หอ​ธรรม​เฝา​คอย​ราชา...",
        "useQuestHintsText": "คำแนะนำในการสร้างภารกิจ...",
        "useCategoryHintsText": "คำแนะนำหมวดหมู่อาคาร...",
        "useChestHintsText": "กำลังเพิ่มคำแนะนำรายการให้กับ หีบ...",
        "useBossHintsText": "กำลังเพิ่มคำแนะนำรายการให้กับบอส เดน...",
        "useNearbyHintsText": "เพิ่มคำแนะนำรายการกุญแจประตูสำคัญไปยังสถานที่ใกล้เคียง...",
        "useNearbyFogHintsText": "กำลังเพิ่มคำแนะนำประตูไปยังสถานที่ใกล้เคียง...",
        "useChestFogHintsText": "กำลังเพิ่มคำแนะนำเกตให้กับ หีบ...",
        "useBossFogHintsText": "กำลังเพิ่มคำแนะนำเกตให้กับบอส เดน...",
        "numItemsText": "จำนวนรายการที่วางไว้: {}",
        "numHintsText": "จำนวนรายการคำใบ้ที่สร้างขึ้น: {}",
        "totalNumHintsText": "จำนวนรายการคำใบ้ที่สร้างขึ้นทั้งหมด: {}",
        "useShopText": "ทำการเปลี่ยนแปลงร้านค้า หญิง​ชรา​แฝด...",
        "shopNumText": "จำนวนรายการสินค้าคงคลังที่เปลี่ยนแปลง: {}",
        "writingFilesText": "กำลังเขียนไฟล์ XML...",
        "writingParamsText": "กำลังสร้าง regulation.bin จาก params...",
        "tomlText": "กำลังสร้างไฟล์การกำหนดค่า Mod Engine...",
        "buildDoneText": "การสร้างคำแนะนำเสร็จสมบูรณ์แล้ว! กรุณาเริ่มเกมใหม่\n",
        "buildError": "มีข้อผิดพลาดในระหว่างกระบวนการสร้างคำใบ้ โปรดตรวจสอบการติดตั้งปฏิบัติการของคุณ\n",
        "missingXMLFileError": "ข้อผิดพลาด: ไม่มีไฟล์ XML {} สำหรับ {}",
        "witchyError": "ตรวจสอบให้แน่ใจว่าได้ติดตั้ง oo2core_6_win64.dll ในโฟลเดอร์ WitchyBND แล้ว",
        "yabberError": "ตรวจสอบให้แน่ใจว่าได้ติดตั้ง oo2core_6_win64.dll ในโฟลเดอร์ Yabber lib แล้ว",
    },
    "mainView": {
        "settingsTab": "Elden Ring Randomizer Hints",
        "missableTab": "สิ่งของที่พลาดได้",
        "selectCategoriesTab": "การเลือกหมวดหมู่",
        "startingTab": "รายการเริ่มต้น",
        "editCategoriesTab": "แก้ไขหมวดหมู่",
    },
    "settingsPane": {
        "gameLabel": "Elden Ring ปฏิบัติการได้",
        "gameButton": "เลือก Elden Ring",
        "gameTooltip": "พาธที่ถูกต้องไปยังไฟล์ปฏิบัติการเกม Elden Ring จำเป็นในการสร้างคำแนะนำ",
        "gameFileType": "Elden Ring",
        "randomizerLabel": "Elden Ring Item and Enemy Randomizer ปฏิบัติการได้ (ทางเลือก)",
        "randomizerButton": "เลือกเครื่องสุ่ม",
        "randomizerTooltip": "พาธที่ถูกต้องไปยังไฟล์เรียกทำงาน Elden Ring Item and Enemy Randomizer จำเป็นเท่านั้นหากใช้มัน",
        "randomizerFileType": "Elden Ring Item and Enemy Randomizer",
        "fogLabel": "Elden Ring Fog Gate Randomizer ปฏิบัติการได้ (ทางเลือก)",
        "fogButton": "เลือก Fog Randomizer",
        "fogTooltip": "พาธที่ถูกต้องไปยังไฟล์เรียกทำงาน Elden Ring Fog Gate Randomizer จำเป็นเท่านั้นหากใช้มัน โปรดทราบว่าตัวดัดแปลงนี้มีไว้สำหรับใช้กับโหมด World Shuffle ของตัวสุ่มหมอกเกตเท่านั้น โหมดอื่นๆ อาจมีผลลัพธ์ที่ไม่คาดคิด",
        "fogFileType": "Elden Ring Fog Gate Randomizer",
        "yabberLabel": "Yabber/WitchyBND ปฏิบัติการได้",
        "yabberButton": "เลือก Yabber/WitchyBND",
        "yabberTooltip": "พาธที่ถูกต้องไปยังไฟล์เรียกทำงาน Yabber หรือ WitchyBND จำเป็นในการสร้างคำแนะนำ",
        "yabberFileType": "Yabber",
        "witchyBNDFileType": "WitchyBND",
        "dsmspLabel": "DSMSPortable ปฏิบัติการได้",
        "dsmspButton": "เลือก DSMSPortable",
        "dsmspTooltip": "พาธที่ถูกต้องไปยังไฟล์เรียกทำงาน DSMSPortable จำเป็นในการสร้างคำแนะนำ",
        "dsmspFileType": "DSMSPortable",
        "fileDialog": "เลือกไฟล์",
        "dirDialog": "เลือกไดเรกทอรี",
        "languageText": "ภาษา",
        "languageTooltip": "เปลี่ยนภาษา (ต้องรีสตาร์ท)",
        "useRandomizerText": "ใช้ Elden Ring Item and Enemy Randomizer",
        "useRandomizerTooltip": "เปิดใช้งานหากใช้ Elden Ring Item and Enemy Randomizer แม้ว่าจะไม่เปิดใช้งานตัวเลือกคำใบ้รายการใดต่อไปนี้ เพื่อให้ไฟล์ Mod Engine จะมีการอ้างอิงที่ถูกต้อง",
        "seedLabel": "เมล็ดพันธุ์ที่กำหนดเอง:",
        "seedTooltip": "ป้อนเมล็ดสุ่มแบบกำหนดเองที่จะใช้ในการสร้างคำแนะนำรายการ หากเว้นว่างไว้ ระบบจะใช้ไฟล์เริ่มต้นจากไฟล์ Elden Ring Item and Enemy Randomizer spoiler",
        "useQuestHintsText": "สร้างคำแนะนำสำหรับรายการภารกิจ NPC",
        "useQuestHintsTooltip": "เปิดใช้งานเพื่อวางคำแนะนำในล็อตรายการ NPC ที่ชี้ไปยังรายการจริงที่จำเป็นสำหรับภารกิจของพวกเขา",
        "useCategoryHintsText": "สร้างคำแนะนำด้วยรายการที่อยู่ในหมวดหมู่เดียวกัน",
        "useCategoryHintsTooltip": "เปิดใช้งานเพื่อวางคำแนะนำในตำแหน่งรายการซึ่งชี้ไปยังรายการอื่นในหมวดหมู่เดียวกัน สำหรับตำแหน่งของรายการใด ๆ วัตถุคำใบ้จะถูกวางพร้อมคำแนะนำที่ชี้ไปยังรายการอื่น ๆ ในหมวดหมู่เดียวกันกับรายการที่พบที่นั่น ใช้กับรายการใน \"หมวดหมู่ทั่วไป\" เท่านั้น คุณสามารถตั้งค่าหมวดหมู่เหล่านี้ได้ในแท็บ \"การเลือกหมวดหมู่\"",
        "useNeighboringBiasText": "หมวดหมู่อคติบ่งบอกถึงภูมิภาคใกล้เคียง",
        "useNeighboringBiasTooltip": "เปิดใช้งานเพื่อทำให้คำแนะนำหมวดหมู่มีแนวโน้มที่จะชี้ไปยังรายการในภูมิภาคใกล้กับตำแหน่งที่พบออบเจ็กต์คำใบ้มากขึ้น โปรดทราบว่าตัวเลือกนี้จะไม่ทำอะไรเลยหากใช้ Elden Ring Fog Gate Randomizer",
        "percentHintsText": "สร้างคำแนะนำรายการใน",
        "chestHintsPercentText": "% ของ หีบ",
        "changePercentButton": "เปลี่ยน %",
        "getPercentTitle": "ป้อนเปอร์เซ็นต์",
        "getPercentPrompt": "ป้อนเปอร์เซ็นต์ใหม่:",
        "useChestHintsTooltip": "เปิดใช้งานเพื่อวางคำแนะนำสำหรับรายการใน \"หมวดหมู่ หีบ\" เป็นเปอร์เซ็นต์ของ หีบ ทั้งหมด คุณสามารถตั้งค่าหมวดหมู่เหล่านี้ได้ในแท็บ \"การเลือกหมวดหมู่\"",
        "bossHintsPercentText": "% ของบอส เดน",
        "useBossHintsTooltip": "สามารถวางคำใบ้สำหรับไอเท็มใน \"หมวดหมู่บอส\" เป็นเปอร์เซ็นต์ของบอส เดน ทั้งหมด คุณสามารถตั้งค่าหมวดหมู่เหล่านี้ได้ในแท็บ \"การเลือกหมวดหมู่\"",
        "useNearbyHintsText": "สร้างคำแนะนำสำหรับไอเท็มสำคัญไปยังประตูสำคัญและวาร์ปใกล้เคียง",
        "useNearbyHintsTooltip": "สามารถวางคำใบ้สำหรับไอเท็มสำคัญที่จำเป็นสำหรับประตูสำคัญและวาร์ปในตำแหน่งสุ่มใกล้ประตูเหล่านั้น ซึ่งรวมถึง เห​รียญ​ศิลา​เดคทัส, เหรียญ​ศิลา​โร​ลด์ และ เหรียญ​ศิลา​ลับ​พฤกษา​ศักดิสิทธิ, กุญแจ​หิน​จรัส​วิทยาลัย, รูป​น​คา​เรียก​ลับ​ทิศ, กุญแจ​ดาบ​หิน​เวท และ แหวน​จันทร์​ดับ โปรดทราบว่าคำใบ้สำหรับ กุญแจ​ห้อง​รับรอง มีอยู่ใน ทา​นิธ ภายใต้ตัวเลือก \"สร้างคำแนะนำสำหรับรายการภารกิจ NPC\"",
        "useAllDirectionsText": "ใช้ทิศทางเข็มทิศสำหรับคำแนะนำทั้งหมด",
        "useAllDirectionsTooltip": "โดยปกติคำแนะนำไปยังรายการในพื้นที่ขนาดใหญ่จะแสดงทิศทางของเข็มทิศและการประมาณระยะทางจากจุดสังเกตบนแผนที่ที่ใกล้ที่สุด แต่คำแนะนำไปยังรายการในพื้นที่ที่มีชื่อเล็กกว่าจะแสดงเฉพาะชื่อพื้นที่เท่านั้น เปิดใช้งานเพื่อแสดงข้อมูลทิศทางนี้ในคำแนะนำรายการทั้งหมด",
        "useFogText": "ใช้ Elden Ring Fog Gate Randomizer",
        "useFogTooltip": "เปิดใช้งานหากใช้ Elden Ring Fog Gate Randomizer แม้ว่าจะไม่ได้เปิดใช้งานตัวเลือกคำใบ้หมอกใดๆ ต่อไปนี้ เพื่อให้ไฟล์ Mod Engine มีการอ้างอิงที่ถูกต้อง โปรดทราบว่าคำอธิบายพื้นที่ในคำแนะนำไอเทมและประตูจะแตกต่างจากเกมหลัก",
        "fogSeedLabel": "เมล็ดหมอกแบบกำหนดเอง:",
        "fogSeedTooltip": "ป้อนเมล็ดแบบสุ่มที่กำหนดเองซึ่งจะใช้เพื่อสร้างคำใบ้ประตูหมอก หากเว้นว่างไว้ ระบบจะใช้ไฟล์เริ่มต้นจากไฟล์ Elden Ring Fog Gate Randomizer spoiler",
        "useNearbyFogHintsText": "สร้างคำใบ้ประตูหมอกใกล้ประตู",
        "useNearbyFogHintsTooltip": "สามารถวางคำใบ้สำหรับประตูหมอกและวาร์ปในตำแหน่งสุ่มใกล้ประตูเหล่านั้นได้ โปรดทราบว่าประตูบางแห่งอาจไม่มีตำแหน่งหรือพื้นที่ว่างภายในตำแหน่งที่มีอยู่",
        "percentFogHintsText": "สร้างคำใบ้ประตูหมอก",
        "useChestFogHintsText": "สร้างคำแนะนำประตูหมอกใน หีบ",
        "useChestFogHintsTooltip": "เปิดใช้งานการวางคำใบ้สำหรับประตูหมอกและวาร์ปเป็นเปอร์เซ็นต์ของ หีบ ทั้งหมด คำแนะนำเหล่านี้ไม่จำกัดเฉพาะพื้นที่ที่ หีบ อยู่",
        "useBossFogHintsText": "สร้างคำแนะนำประตูหมอกในบอส เดน",
        "useBossFogHintsTooltip": "สามารถวางคำใบ้สำหรับประตูหมอกและการวาร์ปเป็นเปอร์เซ็นต์ของบอส เดน ทั้งหมด คำแนะนำเหล่านี้ไม่จำกัดเฉพาะพื้นที่ที่เจ้านายอยู่",
        "useMaidenItemsText": "เพิ่มรายการให้กับศพ หญิง​ร่าง​ทรง​องคุลี ใน หอ​ธรรม​เฝา​คอย​ราชา",
        "useMaidenItemsTooltip": "เปิดใช้งานเพื่อเพิ่มไอเท็มและ/หรือคำแนะนำไอเท็มให้กับศพ หญิง​ร่าง​ทรง​องคุลี ใน หอ​ธรรม​เฝา​คอย​ราชา เมื่อเริ่มเกม คุณสามารถตั้งค่าเหล่านี้ได้ในแท็บ \"รายการเริ่มต้น\" โปรดทราบว่าหากไม่ได้ใช้ Elden Ring Item and Enemy Randomizer คำแนะนำรายการและคำแนะนำหมวดหมู่จะไม่ถูกวาง",
        "useShopText": "ใช้สินค้าคงคลังของร้านค้าแบบกำหนดเองสำหรับ หญิง​ชรา​แฝด ใน โต๊ะ​กลม",
        "useShopTooltip": "เปิดใช้งานเพื่อตั้งค่าสินค้าคงคลังร้านค้าแบบกำหนดเองสำหรับร้านค้า หญิง​ชรา​แฝด ใน โต๊ะ​กลม คุณสามารถแก้ไขได้ในแท็บ \"รายการเริ่มต้น\"",
        "buildButton": "สร้างคำแนะนำ",
        "buildTooltip": "เริ่มสร้างคำใบ้ที่จะวางไว้ในโลกของเกม",
        "consoleLabel": "คอนโซล:",
        "consoleTooltip": "แผงเอาต์พุตแสดงผลการประมวลผล",
        "consoleClearButton": "ล้าง คอนโซล",
        "consoleClearTooltip": "ล้างเนื้อหาของพาเนล คอนโซล",
        "consoleCopyButton": "คัดลอก คอนโซล",
        "consoleCopyTooltip": "คัดลอกเนื้อหาของพาเนล คอนโซล ไปยังคลิปบอร์ด",
        "loadSettingsButton": "โหลดการตั้งค่า",
        "loadSettingsTooltip": "โหลดการตั้งค่า หมวดหมู่ และรายการเริ่มต้นทั้งหมดจากไฟล์ คำเตือน การตั้งค่า หมวดหมู่ และรายการเริ่มต้นในปัจจุบันทั้งหมดจะหายไป",
        "saveSettingsButton": "บันทึกการตั้งค่า",
        "saveSettingsTooltip": "บันทึกการตั้งค่า หมวดหมู่ และรายการเริ่มต้นทั้งหมดลงในไฟล์",
        "importSettingsButton": "นำเข้าการตั้งค่า",
        "importSettingsTooltip": "นำเข้าหมวดหมู่ทั้งหมด รายการ หญิง​ร่าง​ทรง​องคุลี และการตั้งค่าพาธที่ไม่ใช่ไฟล์จากไฟล์การตั้งค่าแบบพกพา เส้นทางไฟล์และการเปลี่ยนแปลงร้านค้าจะไม่เปลี่ยนแปลง",
        "exportSettingsButton": "การตั้งค่าการส่งออก",
        "exportSettingsTooltip": "ส่งออกทุกหมวดหมู่ รายการ หญิง​ร่าง​ทรง​องคุลี และการตั้งค่าพาธที่ไม่ใช่ไฟล์ไปยังไฟล์ เพื่อการถ่ายโอนการตั้งค่าแบบพกพา โปรดทราบว่าการเปลี่ยนแปลงร้านค้าจะไม่ถูกส่งออก",
        "helpIcon": "การตั้งค่าทั่วไปและการสร้างคำใบ้ เส้นทางของไฟล์ต้องถูกต้องก่อนที่จะสร้างคำแนะนำหรือแก้ไขสินค้าคงคลังของร้านค้า หญิง​ชรา​แฝด",
    },
    "missablePane": {
        "missableLabel": "สิ่งของที่พลาดได้:",
        "selectorTooltip": "ไอเทมที่พลาดง่ายหรือไม่ได้มา เลือกรายการเพื่อเปิดเผยข้อมูลเกี่ยวกับวิธีการได้มา",
        "spoilersLabel": "สปอยเลอร์:",
        "spoilersTooltip": "สปอยเลอร์เกี่ยวกับวิธีการรับไอเทมที่เลือกในแผงด้านซ้าย",
        "helpIcon": "สิ่งของที่พลาดได้. รายการที่หาซื้อไม่ได้หรือพลาดง่ายมีแสดงไว้ที่นี่ เลือกรายการเพื่อเปิดเผยข้อมูลเกี่ยวกับวิธีการรับและวิธีที่สามารถพลาดได้ หากไอเท็มเหล่านี้มีความสำคัญต่อคุณ คุณสามารถปิดโปรแกรมนี้และรัน Elden Ring Item and Enemy Randomizer อีกครั้ง หรือคุณสามารถเพิ่มไอเท็มเข้ากับไอเท็ม หญิง​ร่าง​ทรง​องคุลี หรือร้านค้า หญิง​ชรา​แฝด สามารถแก้ไขได้ในแท็บ \"รายการเริ่มต้น\"",
    },
    "selectionsPane": {
        "generalLabel": "หมวดหมู่ทั่วไป",
        "generalTooltip": "หมวดหมู่ของรายการโดยที่ตำแหน่งของรายการจะมีคำแนะนำเพิ่มชี้ไปยังรายการอื่นในหมวดหมู่เดียวกัน",
        "chestLabel": "หมวดหมู่ หีบ",
        "chestTooltip": "หมวดหมู่ไอเทมซึ่งจะมีคำใบ้อยู่ใน หีบ",
        "bossLabel": "หมวดหมู่บอส",
        "bossTooltip": "หมวดหมู่ไอเทมซึ่งจะมีคำใบ้อยู่ในบอส เดน",
        "categoriesLabel": "หมวดหมู่ทั้งหมด:",
        "categoriesTooltip": "หมวดหมู่คำใบ้ที่มีอยู่ทั้งหมด คุณสามารถแก้ไขได้ในแท็บ \"แก้ไขหมวดหมู่\"",
        "defaultButton": "โหลดการเลือกหมวดหมู่เริ่มต้นซ้ำ",
        "defaultTooltip": "โหลดการเลือกหมวดหมู่ที่ใช้งานเริ่มต้นซ้ำ คำเตือน การดำเนินการนี้ไม่สามารถยกเลิกได้ โปรดทราบว่าเฉพาะหมวดหมู่ที่มีอยู่ในแท็บ \"แก้ไขหมวดหมู่\" เท่านั้นที่จะถูกโหลด",
        "helpIcon": "การเลือกหมวดหมู่. หมวดหมู่ที่ใช้งานอยู่สำหรับคำแนะนำเกี่ยวกับตำแหน่งที่เชื่อมต่อ คำแนะนำใน หีบ และคำแนะนำในบอส เดน สามารถเลือกได้ที่นี่ สำหรับแต่ละประเภท แผงด้านซ้ายจะแสดงหมวดหมู่คำใบ้ที่เลือก แผงด้านขวาแสดงรายการหมวดหมู่คำใบ้ทั้งหมด ปุ่ม '<->' จะเพิ่มหมวดหมู่ที่เลือกในแผงด้านขวาไปยังรายการหมวดหมู่ และลบหมวดหมู่ที่เลือกในแผงด้านซ้ายออกจากรายการหมวดหมู่",
    },
    "startingPane": {
        "maidenTooltip": "ไอเท็ม คำแนะนำไอเท็ม และคำแนะนำหมวดหมู่ไอเท็มที่จะวางไว้บนศพ หญิง​ร่าง​ทรง​องคุลี ใน หอ​ธรรม​เฝา​คอย​ราชา โปรดทราบว่ามีพื้นที่จำกัด และสามารถวางคำใบ้ได้สูงสุดสี่คำในหนึ่งล็อตรายการ",
        "maidenSpaceTooltip": "ล็อตรายการ หญิง​ร่าง​ทรง​องคุลี ปัจจุบันที่ใช้โดยการเลือก โปรดทราบว่าตัวสุ่มประตูหมอกและม็อดอื่นๆ สามารถเปลี่ยนจำนวนล็อตที่มีอยู่ได้ คำใบ้สี่คำสามารถใส่ลงในล็อตรายการเดียวได้ และเมื่อมีการสร้างคำใบ้ คำแนะนำที่เลือกจะถูกซ้อนกันเป็นล็อตรายการน้อยที่สุดเท่าที่จะทำได้ หากมีตัวเลือกในรายการมากกว่าจำนวนที่มีอยู่เมื่อสร้างคำแนะนำ ระบบจะใช้เฉพาะตัวเลือกด้านบนที่เหมาะสมเท่านั้น",
        "propertyDropTooltip": "คำแนะนำรายการที่เลือกด้านล่างจะถูกสลับระหว่างการสร้างคำแนะนำทั้งหมดและการสร้างคำแนะนำ เดน ของศัตรูเท่านั้น",
        "propertyQtyTag": "(จำนวน: {})",
        "propertyQtyButton": "กำหนดปริมาณ",
        "propertyQtyTitle": "จำนวนรายการ",
        "propertyQtyPrompt": "กรอกจำนวน:",
        "propertyQtyTooltip": "กำหนดปริมาณของตัวเลือกด้านล่าง",
        "propertyItemTag": "(รายการ)",
        "propertyHintTag": "(คำแนะนำรายการ)",
        "propertyCategoryTag": "(หมวดหมู่คำแนะนำ)",
        "maidenLabel": "หญิง​ร่าง​ทรง​องคุลี รายการ:",
        "itemListLabel": "รายการ:",
        "itemListTooltip": "รายการที่มีอยู่ทั้งหมด",
        "hintListLabel": "คำแนะนำรายการ:",
        "hintListTooltip": "คำแนะนำสำหรับรายการที่มีอยู่ทั้งหมด",
        "categoryListLabel": "คำแนะนำหมวดหมู่:",
        "categoryListTooltip": "คำแนะนำสำหรับหมวดหมู่ที่มีอยู่ทั้งหมด",
        "shopLabel": "หญิง​ชรา​แฝด ร้านค้า:",
        "shopTooltip": "แก้ไขสินค้าคงคลังเริ่มต้นของร้านค้า หญิง​ชรา​แฝด ใน โต๊ะ​กลม",
        "slotLabel": "สล็อต",
        "useItemTooltip": "แทนที่รายการในสินค้าคงคลังของร้านค้า สล็อต ด้วยรายการที่เลือกจากแผงทางด้านขวา",
        "priceTag": "({})",
        "priceButton": "ตั้งราคา",
        "priceTooltip": "ป้อนราคาเป็นรูนสำหรับสินค้าคงคลังของร้านค้า สล็อต ราคาต้องไม่ต่ำกว่า 1",
        "loadButton": "โหลดสินค้าคงคลังของร้านค้า",
        "loadTooltip": "โหลดเนื้อหาแบบสุ่มของร้านค้า หญิง​ชรา​แฝด การเปลี่ยนแปลงใด ๆ ที่คุณทำจะสูญหาย",
        "helpIcon": "รายการเริ่มต้น. เพิ่มไอเท็มและคำแนะนำให้กับศพ หญิง​ร่าง​ทรง​องคุลี ใน หอ​ธรรม​เฝา​คอย​ราชา และแก้ไขสินค้าคงคลังเริ่มต้นของร้านค้า หญิง​ชรา​แฝด ใน โต๊ะ​กลม",
    },
    "editPane": {
        "categoryLabel": "หมวดหมู่:",
        "categoryTooltip": "หมวดหมู่คำใบ้ที่มีอยู่ทั้งหมด",
        "addButton": "เพิ่ม",
        "addTooltip": "เพิ่มหมวดหมู่ใหม่ หมวดหมู่ใหม่จะอยู่ที่ด้านล่างของรายการ",
        "duplicateButton": "ทำซ้ำ",
        "duplicateTooltip": "ทำซ้ำหมวดหมู่ที่เลือก หมวดหมู่ใหม่จะอยู่ที่ด้านล่างของรายการ",
        "renameButton": "เปลี่ยนชื่อ",
        "renameTooltip": "เปลี่ยนชื่อหมวดหมู่ที่เลือก หมวดหมู่ที่เปลี่ยนชื่อจะย้ายไปที่ด้านล่างของรายการ",
        "removeButton": "ลบ",
        "removeTooltip": "ลบหมวดหมู่ที่เลือก คำเตือน การดำเนินการนี้ไม่สามารถยกเลิกได้",
        "reloadButton": "โหลดหมวดหมู่เริ่มต้นซ้ำ",
        "reloadTooltip": "โหลดหมวดหมู่คำใบ้รายการเริ่มต้นอีกครั้ง คำเตือน การดำเนินการนี้ไม่สามารถยกเลิกได้ โปรดทราบว่าการดำเนินการนี้จะไม่รีเซ็ตการเลือกหมวดหมู่ในแท็บ \"การเลือกหมวดหมู่\"",
        "propertyDropTooltip": "รายการที่เลือกด้านล่างจะถูกสลับระหว่างการสร้างคำแนะนำทั้งหมดและการสร้างคำแนะนำ เดน ของศัตรูเท่านั้น",
        "builderTooltip": "เนื้อหาของหมวดหมู่ที่กำลังได้รับการแก้ไข",
        "itemListLabel": "รายการ:",
        "itemListTooltip": "รายการที่มีอยู่ทั้งหมด",
        "helpIcon": "แก้ไขหมวดหมู่. แผงด้านซ้ายแสดงหมวดหมู่คำใบ้ ปุ่มด้านล่างช่วยให้คุณสามารถเพิ่ม ทำซ้ำ ลบ หรือเปลี่ยนชื่อหมวดหมู่ได้ แผงกลางแสดงรายการภายในหมวดหมู่ที่เลือก ปุ่ม \"สลับ เดน เท่านั้น\" ด้านบนจะเปลี่ยนรายการที่เลือกในหมวดหมู่ระหว่างการสร้างคำใบ้ทั้งหมดหรือเฉพาะคำใบ้สำหรับศัตรู เดน แผงด้านขวาแสดงรายการทั้งหมด ปุ่ม \"<->\" จะเพิ่มรายการที่เลือกในแผงด้านขวาไปยังหมวดหมู่ และลบรายการที่เลือกในแผงกลางออกจากหมวดหมู่",
    },
    "**COMMON**": {
        "filterLabel": "กรอง:",
        "filterTooltip": "ป้อนข้อความเพื่อกรองการแสดงรายการในแผงด้านล่าง",
        "filterButton": "ล้างตัวกรอง",
        "filterButtonTooltip": "ล้างตัวกรองสำหรับบานหน้าต่างนี้",
        "builderButtonTooltip": "หากเลือกรายการในแผงด้านซ้าย รายการเหล่านั้นจะถูกลบออก หากมีการเลือกรายการในแผงทางด้านขวา รายการเหล่านั้นจะถูกเพิ่มลงในแผงด้านซ้าย",
        "propertyDropTag": "(เดน เท่านั้น)",
        "propertyDropButton": "สลับ เดน เท่านั้น",
    },
}
