# Copyright (c) 2023 The Old Man and the C
#
# This file is part of Elden Ring Randomizer Hints.
#
# Elden Ring Randomizer Hints is free software: you can redistribute it and/or
# modify it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Elden Ring Randomizer Hints is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
# or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License
# for more details.
#
# You should have received a copy of the GNU Affero General Public License along
# with Elden Ring Randomizer Hints. If not, see <https://www.gnu.org/licenses/>.

regionHints = {
    "Abandoned Cave": {
        "hintRegion": "northern Caelid",
        "hintArea": "Abandoned Cave"
    },
    "Academy Crystal Cave": {
        "hintRegion": "the Great Lake of Liurnia",
        "hintArea": "Academy Crystal Cave"
    },
    "Academy of Raya Lucaria": {
        "hintRegion": "the Academy of Raya Lucaria",
        "exceptions": [
            {
                "replaces": "Terra Magica",
                "hintRegion": "the Great Lake of Liurnia",
                "hintArea": "Academy Crystal Cave"
            }
        ]
    },
    "Ainsel River": {
        "hintRegion": "Ainsel River",
        "exceptions": [
            {
                "NPC": "Merchant",
                "hintRegion": "Ainsel River",
                "hintArea": "Uhl Palace Ruins"
            },
            {
                "replaces": "Wing of Astel",
                "hintRegion": "Ainsel River Main"
            },
            {
                "hintLandmark": "Ainsel River Downstream",
                "replaces": "Furlcalling Finger Remedy",
                "hintRegion": "Ainsel River",
                "hintArea": "Uhl Palace Ruins"
            },
            {
                "hintLandmark": "Ainsel River Downstream",
                "replaces": "Golden Rune [2]",
                "hintRegion": "Ainsel River",
                "hintArea": "Uhl Palace Ruins"
            },
            {
                "hintLandmark": "Ainsel River Downstream",
                "replaces": "Golden Rune [3]",
                "hintRegion": "Ainsel River",
                "hintArea": "Uhl Palace Ruins"
            },
            {
                "hintLandmark": "Ainsel River Downstream",
                "replaces": "Magic Grease 2x",
                "hintRegion": "Ainsel River",
                "hintArea": "Uhl Palace Ruins"
            },
            {
                "hintLandmark": "Ainsel River Downstream",
                "replaces": "Shield Grease",
                "hintRegion": "Ainsel River",
                "hintArea": "Uhl Palace Ruins"
            },
            {
                "hintLandmark": "Ainsel River Downstream",
                "replaces": "Smithing Stone [1] 3x",
                "hintRegion": "Ainsel River",
                "hintArea": "Uhl Palace Ruins"
            },
            {
                "hintLandmark": "Ainsel River Downstream",
                "replaces": "Smithing Stone [3] 2x",
                "hintRegion": "Ainsel River",
                "hintArea": "Uhl Palace Ruins"
            },
            {
                "hintLandmark": "Ainsel River Downstream",
                "replaces": "Smithing Stone [3] 3x",
                "hintRegion": "Ainsel River",
                "hintArea": "Uhl Palace Ruins"
            },
            {
                "hintLandmark": "Ainsel River Downstream",
                "replaces": "Throwing Dagger 6x",
                "hintRegion": "Ainsel River",
                "hintArea": "Uhl Palace Ruins"
            },
            {
                "hintLandmark": "Ainsel River Main",
                "hintRegion": "Ainsel River Main"
            },
            {
                "replaces": "Frozen Lightning Spear",
                "hintLandmark": "Dragonkin Soldier of Nokstella",
                "hintRegion": "Ainsel River"
            },
            {
                "replaces": "Great Ghost Glovewort",
                "hintLandmark": "Dragonkin Soldier of Nokstella",
                "directions": "Near Dragonkin Soldier of Nokstella (Site of "
                              "Grace) - 66.58 away in 10 o'clock direction, "
                              "-0.97 height offset",
                "hintRegion": "Ainsel River"
            },
            {
                "hintLandmark": "Dragonkin Soldier of Nokstella",
                "hintRegion": "Ainsel River Main",
                "hintArea": "Nokstella, Eternal City"
            },
            {
                "hintLandmark": "East Raya Lucaria Gate",
                "hintRegion": "Ainsel River Main",
                "hintArea": "Nokstella, Eternal City"
            },
            {
                "replaces": "Golden Rune [10] 8x",
                "hintLandmark": "Nokstella, Eternal City",
                "hintRegion": "Ainsel River Main"
            },
            {
                "replaces": "Shield Grease 2x",
                "hintLandmark": "Nokstella, Eternal City",
                "hintRegion": "Ainsel River Main"
            },
            {
                "replaces": "Somber Smithing Stone [6]",
                "hintLandmark": "Nokstella, Eternal City",
                "hintRegion": "Ainsel River Main"
            },
            {
                "hintLandmark": "Nokstella, Eternal City",
                "hintRegion": "Ainsel River Main",
                "hintArea": "Nokstella, Eternal City"
            },
            {
                "replaces": "Smithing Stone [4]",
                "hintLandmark": "Nokstella Waterfall Basin",
                "hintRegion": "Ainsel River Main"
            },
            {
                "replaces": "Smithing Stone [5]",
                "hintLandmark": "Nokstella Waterfall Basin",
                "hintRegion": "Ainsel River Main"
            },
            {
                "hintLandmark": "Nokstella Waterfall Basin",
                "hintRegion": "Ainsel River Main",
                "hintArea": "Nokstella, Eternal City"
            },
            {
                "replaces": "Stimulating Boluses",
                "hintLandmark": "Uhl Palace Ruins",
                "hintRegion": "Ainsel River Main"
            },
            {
                "replaces": "Clayman Ashes",
                "hintLandmark": "Uhl Palace Ruins",
                "hintRegion": "Ainsel River Main",
                "hintArea": "Uhl Palace Ruins"
            },
            {
                "replaces": "Golden Rune [7]",
                "hintLandmark": "Uhl Palace Ruins",
                "hintRegion": "Ainsel River Main",
                "hintArea": "Uhl Palace Ruins"
            },
            {
                "replaces": "Human Bone Shard 3x",
                "hintLandmark": "Uhl Palace Ruins",
                "hintRegion": "Ainsel River Main",
                "hintArea": "Uhl Palace Ruins"
            },
            {
                "replaces": "Smithing Stone [4]",
                "hintLandmark": "Uhl Palace Ruins",
                "directions": "Near Uhl Palace Ruins (Underground Ruins) - "
                              "33.57 away in 3 o'clock direction, 0.56 height "
                              "offset",
                "hintRegion": "Ainsel River Main",
                "hintArea": "Uhl Palace Ruins"
            },
            {
                "replaces": "Somber Smithing Stone [7]",
                "hintLandmark": "Uhl Palace Ruins",
                "hintRegion": "Ainsel River Main",
                "hintArea": "Uhl Palace Ruins"
            },
            {
                "replaces": "Stonesword Key",
                "hintLandmark": "Uhl Palace Ruins",
                "hintRegion": "Ainsel River Main",
                "hintArea": "Uhl Palace Ruins"
            },
            {
                "hintLandmark": "Uhl Palace Ruins",
                "hintRegion": "Ainsel River",
                "hintArea": "Uhl Palace Ruins"
            },
            
            {
                "replaces": "Alabaster Lord's Sword",
                "hintLandmark": "Grand Cloister",
                "hintRegion": "the Lake of Rot"
            },
            {
                "replaces": "Lightningproof Dried Liver",
                "hintLandmark": "Grand Cloister",
                "hintRegion": "the Lake of Rot"
            },
            {
                "replaces": "Mushroom Crown",
                "hintLandmark": "Grand Cloister",
                "hintRegion": "the Lake of Rot"
            },
            {
                "replaces": "Nomadic Warrior's Cookbook [22]",
                "hintLandmark": "Grand Cloister",
                "hintRegion": "the Lake of Rot"
            },
            {
                "replaces": "Somber Smithing Stone [6]",
                "hintLandmark": "Grand Cloister",
                "hintRegion": "the Lake of Rot"
            },
            {
                "replaces": "Somber Smithing Stone [8]",
                "hintLandmark": "Grand Cloister",
                "hintRegion": "the Lake of Rot"
            },
            {
                "hintLandmark": "Grand Cloister",
                "hintRegion": "the Lake of Rot",
                "hintArea": "Grand Cloister"
            },
            {
                "hintLandmark": "Lake of Rot Shoreside",
                "hintRegion": "the Lake of Rot"
            }
        ]
    },
    "Ainsel River - Boss": {
        "hintRegion": "the Lake of Rot",
        "graphRegion": "the Lake of Rot Basin"
    },
    "Altus Plateau - Abandoned Coffin, Ruin-Strewn Precipice Exit": {
        "hintRegion": "Altus Plateau",
        "exceptions": [
            {
                "replaces": "Ash of War: Barbaric Roar",
                "hintRegion": "the Great Lake of Liurnia"
            }
        ]
    },
    "Altus Plateau - Altus Highway Junction": {
        "hintRegion": "Altus Plateau"
    },
    "Altus Plateau - Bower of Bounty, Writheblood Ruins": {
        "hintRegion": "Altus Plateau",
        "exceptions": [
            {
                "replaces": "Nascent Butterfly",
                "hintLandmark": "Writheblood Ruins",
                "hintRegion": "Altus Plateau"
            },
            {
                "hintLandmark": "Writheblood Ruins",
                "hintRegion": "Altus Plateau",
                "hintArea": "Writheblood Ruins"
            }
        ]
    },
    "Altus Plateau - East Windmill Village, Highway Lookout Tower": {
        "hintRegion": "Windmill Village",
        "hintArea": "Dominula, Windmill Village",
        "exceptions": [
            {
                "replaces": "Four-Toed Fowl Foot 3x",
                "hintLandmark": "Highway Lookout Tower",
                "hintRegion": "Altus Plateau",
                "hintArea": "Altus Plateau"
            },
            {
                "replaces": "Golden Seed",
                "hintLandmark": "Highway Lookout Tower",
                "hintRegion": "Altus Plateau",
                "hintArea": "Altus Plateau"
            },
            {
                "hintLandmark": "Highway Lookout Tower",
                "hintRegion": "Altus Plateau",
                "hintArea": "Highway Lookout Tower"
            }
        ]
    },
    "Altus Plateau - Erdtree-Gazing Hill, Lux Ruins": {
        "hintRegion": "Altus Plateau",
        "exceptions": [
            {
                "replaces": "Ash of War: Shield Crash",
                "hintRegion": "Altus Plateau",
                "hintArea": "Lux Ruins"
            },
            {
                "replaces": "Golden Rune [3]",
                "hintRegion": "Altus Plateau",
                "hintArea": "Lux Ruins"
            },
            {
                "replaces": "Ritual Sword Talisman",
                "hintRegion": "Altus Plateau",
                "hintArea": "Lux Ruins"
            },
            {
                "replaces": "String 3x",
                "hintRegion": "Altus Plateau",
                "hintArea": "Lux Ruins"
            }
        ]
    },
    "Altus Plateau - Forest-Spanning Greatbridge, St. Trina's Hideaway, "
    "Sainted Hero's Grave Entrance": {
        "hintRegion": "Altus Plateau"
    },
    "Altus Plateau - Golden Lineage Evergaol": {
        "hintRegion": "Altus Plateau",
        "exceptions": [
            {
                "replaces": "Godfrey Icon",
                "hintRegion": "Altus Plateau",
                "hintArea": "Golden Lineage Evergaol"
            }
        ]
    },
    "Altus Plateau - Mirage Rise; Mt. Gelmir - Bridge of Iniquity": {
        "hintRegion": "Altus Plateau",
        "exceptions": [
            {
                "replaces": "Mirage Riddle",
                "hintRegion": "Altus Plateau",
                "hintArea": "Mirage Rise"
            },
            {
                "replaces": "Slumbering Egg 5x",
                "hintRegion": "Altus Plateau",
                "hintArea": "Mirage Rise"
            },
            {
                "replaces": "Unseen Blade",
                "hintRegion": "Altus Plateau",
                "hintArea": "Mirage Rise"
            }
        ]
    },
    "Altus Plateau - Old Altus Tunnel Entrance": {
        "hintRegion": "Mt. Gelmir"
    },
    "Altus Plateau - Perfumer's Ruins, Unsightly Catacombs Entrance": {
        "hintRegion": "Altus Plateau",
        "hintArea": "Perfumer's Ruins"
    },
    "Altus Plateau - Rampartside Path, Altus Tunnel Entrance": {
        "hintRegion": "Altus Plateau"
    },
    "Altus Plateau - Road of Iniquity Side Path": {
        "hintRegion": "Altus Plateau"
    },
    "Altus Plateau - Second Church of Marika": {
        "hintRegion": "Altus Plateau",
        "hintArea": "the Second Church of Marika",
        "exceptions": [
            {
                "replaces": "Ash of War: Blood Blade",
                "hintRegion": "Altus Plateau",
                "hintArea": "Altus Plateau"
            }
        ]
    },
    "Altus Plateau - Shaded Castle": {
        "hintRegion": "Altus Plateau",
        "hintArea": "the Shaded Castle"
    },
    "Altus Plateau - South of Tree Sentinel Duo": {
        "hintRegion": "Altus Plateau"
    },
    "Altus Plateau - Southwest of Tree Sentinel Duo": {
        "hintRegion": "Altus Plateau"
    },
    "Altus Plateau - Tree Sentinel Duo, Perfumer's Grotto Entrance": {
        "hintRegion": "Altus Plateau"
    },
    "Altus Plateau - Village Windmill Pasture, East Windmill Pasture": {
        "hintRegion": "Windmill Village",
        "hintArea": "East Windmill Pasture",
        "exceptions": [
            {
                "replaces": "Raw Meat Dumpling 10x",
                "hintRegion": "Windmill Village",
                "hintArea": "Village Windmill Pasture"
            }
        ]
    },
    "Altus Plateau - West of Tree Sentinel Duo, Stormcaller Church": {
        "hintRegion": "Altus Plateau",
        "exceptions": [
            {
                "replaces": "Ash of War: Lightning Ram",
                "hintLandmark": "Stormcaller Church",
                "hintRegion": "Altus Plateau"
            },
            {
                "hintLandmark": "Stormcaller Church",
                "hintRegion": "Altus Plateau",
                "hintArea": "Stormcaller Church"
            }
        ]
    },
    "Altus Plateau - West Windmill Pasture": {
        "hintRegion": "Windmill Village",
        "hintArea": "West Windmill Pasture",
        "exceptions": [
            {
                "replaces": "Haima Glintstone Crown",
                "hintRegion": "Windmill Village",
                "hintArea": "Windmill Village"
            }
        ]
    },
    "Altus Plateau - West Windmill Village": {
        "hintRegion": "Windmill Village",
        "exceptions": [
            {
                "replaces": "Golden Seed",
                "hintRegion": "Altus Plateau"
            }
        ]
    },
    "Altus Plateau - Windmill Heights": {
        "hintRegion": "Windmill Village",
        "hintArea": "Dominula, Windmill Village"
    },
    "Altus Plateau - Woodfolk Ruins, Minor Erdtree": {
        "hintRegion": "Altus Plateau",
        "hintArea": "Woodfolk Ruins",
        "exceptions": [
            {
                "replaces": "Crimsonspill Crystal Tear",
                "hintRegion": "Altus Plateau",
                "hintArea": "the Minor Erdtree"
            },
            {
                "replaces": "Speckled Hardtear",
                "hintRegion": "Altus Plateau",
                "hintArea": "the Minor Erdtree"
            }
        ]
    },
    "Altus Plateau - Wyndham Ruins, Wyndham Catacombs Entrance": {
        "hintRegion": "Altus Plateau",
        "hintArea": "Wyndham Ruins"
    },
    "Altus Tunnel": {
        "hintRegion": "Altus Plateau",
        "hintArea": "Altus Tunnel"
    },
    "Auriza Hero's Grave": {
        "hintRegion": "the Capital Outskirts",
        "hintArea": "Auriza Hero's Grave"
    },
    "Auriza Side Tomb": {
        "hintRegion": "the Capital Outskirts",
        "hintArea": "Auriza Side Tomb"
    },
    "Bellum Highway - Church of Inhibition, Southwest of Grand Lift of "
    "Dectus": {
        "hintRegion": "Bellum Highway",
        "exceptions": [
            {
                "replaces": "Finger Maiden Fillet",
                "hintRegion": "Bellum Highway",
                "hintArea": "the Church of Inhibition"
            },
            {
                "replaces": "Fingerprint Grape",
                "hintRegion": "Bellum Highway",
                "hintArea": "the Church of Inhibition"
            },
            {
                "replaces": "Sacred Tear",
                "hintRegion": "Bellum Highway",
                "hintArea": "the Church of Inhibition"
            }
        ]
    },
    "Bellum Highway - Converted Fringe Tower; Liurnia of the Lakes - Black "
    "Knife Catacombs Entrance": {
        "hintRegion": "Bellum Highway",
        "hintArea": "Converted Fringe Tower",
        "exceptions": [
            {
                "replaces": "Cannon of Haima",
                "hintRegion": "Bellum Highway",
                "hintArea": "Converted Fringe Tower",
                "graphRegion": "the Converted Fringe Tower apex"
            }
        ]
    },
    "Bellum Highway - East Raya Lucaria Gate": {
        "hintRegion": "Bellum Highway"
    },
    "Bellum Highway - Frenzied Flame Village, Minor Erdtree": {
        "hintRegion": "Bellum Highway",
        "hintArea": "Frenzied Flame Village",
        "exceptions": [
            {
                "replaces": "Lightning-Shrouding Cracked Tear",
                "hintRegion": "eastern Liurnia",
                "hintArea": "the Minor Erdtree"
            },
            {
                "replaces": "Eye of Yelough",
                "hintRegion": "Bellum Highway",
                "hintArea": "Bellum Highway"
            },
            {
                "replaces": "Frenzyflame Stone",
                "hintRegion": "Bellum Highway",
                "hintArea": "Bellum Highway"
            }
        ]
    },
    "Bellum Highway - Frenzy-Flaming Tower": {
        "hintRegion": "Bellum Highway",
        "exceptions": [
            {
                "replaces": "Howl of Shabriri",
                "hintRegion": "Bellum Highway",
                "hintArea": "Frenzy-Flaming Tower"
            }
        ]
    },
    "Black Knife Catacombs": {
        "hintRegion": "eastern Liurnia",
        "hintArea": "Black Knife Catacombs"
    },
    "Caelid - Caelem Ruins, Forsaken Ruins, Minor Erdtree, Minor Erdtree "
    "Catacombs Entrance": {
        "hintRegion": "northern Caelid",
        "exceptions": [
            {
                "hintLandmark": "Forsaken Ruins",
                "hintRegion": "northern Caelid",
                "hintArea": "Forsaken Ruins"
            },
            {
                "replaces": "Drawstring Fire Grease 3x",
                "hintRegion": "northern Caelid",
                "hintArea": "Caelem Ruins"
            },
            {
                "replaces": "Fire Blossom 3x",
                "hintRegion": "northern Caelid",
                "hintArea": "Caelem Ruins"
            },
            {
                "replaces": "Smoldering Butterfly 3x",
                "hintRegion": "northern Caelid",
                "hintArea": "Caelem Ruins"
            },
            {
                "replaces": "Cracked Pot",
                "hintRegion": "northern Caelid",
                "hintArea": "the Minor Erdtree"
            },
            {
                "replaces": "Flame-Shrouding Cracked Tear",
                "hintRegion": "northern Caelid",
                "hintArea": "the Minor Erdtree"
            },
            {
                "replaces": "Greenburst Crystal Tear",
                "hintRegion": "northern Caelid",
                "hintArea": "the Minor Erdtree"
            }
        ]
    },
    "Caelid - Caelid Highway South": {
        "hintRegion": "southern Caelid",
        "exceptions": [
            {
                "replaces": "Ash of War: Poisonous Mist",
                "hintRegion": "the Swamp of Aeonia"
            }
        ]
    },
    "Caelid Catacombs": {
        "hintRegion": "southern Caelid",
        "hintArea": "Caelid Catacombs"
    },
    "Caelid - Cathedral of Dragon Communion, Caelid Catacombs Entrance": {
        "hintRegion": "southern Caelid",
        "hintArea": "the Cathedral of Dragon Communion"
    },
    "Caelid - Deep Siofra Well; Greyoll's Dragonbarrow - Dragonbarrow West": {
        "hintRegion": "northern Caelid",
        "exceptions": [
            {
                "replaces": "Fire Blossom 3x",
                "hintRegion": "northern Caelid",
                "hintArea": "Caelem Ruins"
            },
            {
                "replaces": "Visage Shield",
                "hintRegion": "northern Caelid",
                "hintArea": "Caelem Ruins"
            },
            {
                "replaces": "Spiked Palisade Shield",
                "hintRegion": "Greyoll's Dragonbarrow",
                "graphRegion": "Caelid Canyon"
            }
        ]
    },
    "Caelid - East Aeonia Swamp": {
        "hintRegion": "the Swamp of Aeonia",
        "exceptions": [
            {
                "hintLandmark": "Sellia Gateway",
                "hintRegion": "southern Caelid",
                "hintArea": "Sellia Gateway"
            },
            {
                "hintLandmark": "Southern Aeonia Swamp Bank",
                "hintRegion": "southern Caelid",
                "hintArea": "southern Caelid"
            },
            {
                "hintLandmark": "Swamp Lookout Tower",
                "hintRegion": "southern Caelid",
                "hintArea": "Swamp Lookout Tower"
            }
        ]
    },
    "Caelid - East Sellia, Church of the Plague, Sellia Hideaway Entrance": {
        "hintRegion": "southern Caelid",
        "hintArea": "Sellia, Town of Sorcery",
        "exceptions": [
            {
                "hintLandmark": "Church of the Plague",
                "hintRegion": "southern Caelid",
                "hintArea": "southern Caelid"
            },
            {
                "replaces": "Beast Blood 2x",
                "hintLandmark": "Sellia Hideaway",
                "hintRegion": "southern Caelid",
                "hintArea": "southern Caelid"
            },
            {
                "hintLandmark": "Sellia Hideaway",
                "hintRegion": "Greyoll's Dragonbarrow",
                "hintArea": "Greyoll's Dragonbarrow"
            }
        ]
    },
    # Fog randomizer version:
    "Caelid - East Sellia, Church of the Plague": {
        "hintRegion": "southern Caelid",
        "hintArea": "Sellia, Town of Sorcery",
        "exceptions": [
            {
                "hintLandmark": "Church of the Plague",
                "hintRegion": "southern Caelid",
                "hintArea": "southern Caelid"
            },
            {
                "replaces": "Beast Blood 2x",
                "hintLandmark": "Sellia Hideaway",
                "hintRegion": "southern Caelid",
                "hintArea": "southern Caelid"
            },
            {
                "hintLandmark": "Sellia Hideaway",
                "hintRegion": "Greyoll's Dragonbarrow",
                "hintArea": "Greyoll's Dragonbarrow"
            }
        ]
    },
    "Caelid - Fort Gael, Caelid Waypoint Ruins, Gaol Cave Entrance": {
        "hintRegion": "northern Caelid",
        "hintArea": "Fort Gael",
        "exceptions": [
            {
                "hintLandmark": "Caelid Waypoint Ruins",
                "hintRegion": "northern Caelid",
                "hintArea": "Caelid Waypoint Ruins"
            },
            {
                "replaces": "Meteoric Ore Blade",
                "hintRegion": "northern Caelid",
                "hintArea": "Caelid Waypoint Ruins"
            },
            {
                "replaces": "Somber Smithing Stone [4]",
                "hintRegion": "northern Caelid",
                "hintArea": "northern Caelid"
            }
        ]
    },
    "Caelid - Fort Gael North": {
        "hintRegion": "northern Caelid",
        "exceptions": [
            {
                "replaces": "Fire Blossom 3x",
                "hintRegion": "northern Caelid",
                "hintArea": "Fort Gael"
            }
        ]
    },
    "Caelid - Gowry's Shack": {
        "hintRegion": "southern Caelid",
        "exceptions": [
            {
                "replaces": "Sacred Tear",
                "hintRegion": "southern Caelid",
                "hintArea": "the Church of the Plague"
            },
            {
                "NPC": "Sage Gowry",
                "hintRegion": "southern Caelid",
                "hintArea": "Gowry's Shack"
            }
        ]
    },
    "Caelid - Impassable Greatbridge": {
        "hintRegion": "southern Caelid"
    },
    "Caelid - Redmane Castle": {
        "hintRegion": "southern Caelid",
        "hintArea": "Redmane Castle",
        "exceptions": [
            {
                "replaces": "Smithing Stone [6]",
                "hintLandmark": "Redmane Castle Plaza",
                "hintRegion": "southern Caelid",
                "hintArea": "Redmane Castle",
                "graphRegion": "Redmane Castle Chapel"
            }
        ]
    },
    "Caelid - Redmane Castle South Cliffside": {
        "hintRegion": "southern Caelid",
        "hintArea": "Redmane Castle"
    },
    "Caelid - Smoldering Church, Rotview Balcony": {
        "hintRegion": "northern Caelid",
        "hintArea": "the Shack of the Rotting",
        "exceptions": [
            {
                "replaces": "Drawstring Lightning Grease 2x",
                "hintRegion": "northern Caelid",
                "hintArea": "northern Caelid"
            },
            {
                "replaces": "Rune Arc",
                "hintRegion": "northern Caelid",
                "hintArea": "northern Caelid"
            },
            {
                "hintLandmark": "Smoldering Church",
                "hintRegion": "northern Caelid",
                "hintArea": "Smoldering Church"
            }
        ]
    },
    "Caelid - Smoldering Wall, Abandoned Cave Entrance": {
        "hintRegion": "northern Caelid",
        "exceptions": [
            {
                "replaces": "Sacramental Bud",
                "hintRegion": "the Swamp of Aeonia",
            },
            {
                "replaces": "Stonesword Key",
                "hintRegion": "Greyoll's Dragonbarrow",
                "graphRegion": "Caelid Canyon"
            },
            {
                "replaces": "Fire Blossom 3x",
                "hintRegion": "northern Caelid",
                "hintArea": "Caelem Ruins"
            },
            {
                "replaces": "Great Dragonfly Head 3x",
                "hintRegion": "northern Caelid",
                "hintArea": "Caelem Ruins"
            },
            {
                "hintLandmark": "Street of Sages Ruins",
                "hintRegion": "the Swamp of Aeonia",
                "hintArea": "Street of Sages Ruins"
            }
        ]
    },
    "Caelid - Southern Aeonia Swamp Bank": {
        "hintRegion": "southern Caelid",
        "exceptions": [
            {
                "replaces": "Golden Rune [2]",
                "hintRegion": "southern Caelid",
                "hintArea": "Sellia Gateway"
            }
        ]
    },
    "Caelid - Southwest of Caelid Highway South": {
        "hintRegion": "southern Caelid"
    },
    "Caelid - West Aeonia Swamp": {
        "hintRegion": "southern Caelid",
        "exceptions": [
            {
                "replaces": "Ash of War: Lifesteal Fist",
                "hintRegion": "northern Caelid",
            },
            {
                "replaces": "Meteorite Staff",
                "hintRegion": "the Swamp of Aeonia",
                "hintArea": "Street of Sages Ruins"
            },
            {
                "NPC": "Millicent",
                "hintRegion": "the Swamp of Aeonia"
            },
            {
                "hintLandmark": "Street of Sages Ruins",
                "hintRegion": "the Swamp of Aeonia",
                "hintArea": "Street of Sages Ruins"
            }
        ]
    },
    "Caelid - West of Caelid Highway South": {
        "hintRegion": "southern Caelid",
        "exceptions": [
            {
                "hintLandmark": "Caelid Waypoint Ruins",
                "hintRegion": "northern Caelid",
                "hintArea": "Caelid Waypoint Ruins"
            }
        ]
    },
    "Caelid - West Radahn Arena": {
        "hintRegion": "southern Caelid",
        "hintArea": "the Wailing Dunes"
    },
    "Caelid - West Sellia, Sellia Crystal Tunnel Entrance": {
        "hintRegion": "southern Caelid",
        "hintArea": "Sellia, Town of Sorcery",
        "exceptions": [
            {
                "hintLandmark": "Sellia Evergaol",
                "hintRegion": "Greyoll's Dragonbarrow",
                "hintArea": "Sellia Evergaol"
            },
            {
                "replaces": "Poison Armament",
                "hintRegion": "the Swamp of Aeonia",
                "hintArea": "the Swamp of Aeonia"
            },
            {
                "replaces": "Rune Arc",
                "hintRegion": "the Swamp of Aeonia",
                "hintArea": "the Swamp of Aeonia"
            }
        ]
    },
    "Capital Outskirts - Capital Rampart, Auriza Side Tomb Entrance": {
        "hintRegion": "the Capital Outskirts"
    },
    "Capital Outskirts - East of Outer Wall Phantom Tree": {
        "hintRegion": "the Capital Outskirts"
    },
    "Capital Outskirts - Minor Erdtree": {
        "hintRegion": "the Capital Outskirts",
        "exceptions": [
            {
                "replaces": "Crimson Crystal Tear",
                "hintRegion": "the Capital Outskirts",
                "hintArea": "the Minor Erdtree"
            },
            {
                "replaces": "Twiggy Cracked Tear",
                "hintRegion": "the Capital Outskirts",
                "hintArea": "the Minor Erdtree"
            }
        ]
    },
    "Capital Outskirts - Minor Erdtree Church, Sealed Tunnel Entrance": {
        "hintRegion": "the Capital Outskirts",
        "hintArea": "Minor Erdtree Church"
    },
    "Capital Outskirts - Northeast Outer Wall Battleground, Hermit Merchant's "
    "Shack": {
        "hintRegion": "the Capital Outskirts",
        "exceptions": [
            {
                "replaces": "Ash of War: Lightning Slash",
                "hintRegion": "Altus Plateau"
            },
            {
                "replaces": "Golden Rune [9]",
                "hintRegion": "Altus Plateau"
            },
            {
                "replaces": "Medicine Peddler's Bell Bearing",
                "hintRegion": "the Capital Outskirts",
                "hintArea": "Hermit Merchant's Shack"
            },
            {
                "NPC": "Merchant",
                "hintRegion": "the Capital Outskirts",
                "hintArea": "Hermit Merchant's Shack"
            }
        ]
    },
    "Capital Outskirts - Northwest Outer Wall Battleground": {
        "hintRegion": "Altus Plateau"
    },
    "Capital Outskirts - Outer Wall Phantom Tree": {
        "hintRegion": "the Capital Outskirts"
    },
    "Capital Outskirts - Southeast Outer Wall Battleground": {
        "hintRegion": "the Capital Outskirts"
    },
    "Capital Outskirts - South of Minor Erdtree": {
        "hintRegion": "the Capital Outskirts"
    },
    "Capital Outskirts - South of Outer Wall Phantom Tree": {
        "hintRegion": "the Capital Outskirts"
    },
    "Capital Outskirts - Southwest Outer Wall Battleground": {
        "hintRegion": "the Capital Outskirts"
    },
    "Cave of the Forlorn": {
        "hintRegion": "the Consecrated Snowfield",
        "hintArea": "the Cave of the Forlorn"
    },
    "Chapel of Anticipation": {
        "hintRegion": "the Chapel of Anticipation"
    },
    "Cliffbottom Catacombs": {
        "hintRegion": "eastern Liurnia",
        "hintArea": "Cliffbottom Catacombs"
    },
    "Coastal Cave": {
        "hintRegion": "western Limgrave",
        "hintArea": "Coastal Cave"
    },
    "Consecrated Snowfield - Apostate Derelict": {
        "hintRegion": "the Consecrated Snowfield",
        "hintArea": "Apostate Derelict",
        "exceptions": [
            {
                "replaces": "Somber Smithing Stone [9]",
                "hintRegion": "the Consecrated Snowfield",
                "hintArea": "the Consecrated Snowfield"
            }
        ]
    },
    "Consecrated Snowfield Catacombs": {
        "hintRegion": "the Consecrated Snowfield",
        "hintArea": "the Consecrated Snowfield Catacombs"
    },
    "Consecrated Snowfield - Consecrated Snowfield Catacombs Entrance": {
        "hintRegion": "the Consecrated Snowfield"
    },
    "Consecrated Snowfield - East of Apostate Derelict": {
        "hintRegion": "the Consecrated Snowfield"
    },
    "Consecrated Snowfield - East of Ordina": {
        "hintRegion": "the Consecrated Snowfield"
    },
    "Consecrated Snowfield - Far West Cliffside": {
        "hintRegion": "the Consecrated Snowfield"
    },
    "Consecrated Snowfield - Hidden Path to the Haligtree, Southeast Foggy "
    "Area": {
        "hintRegion": "the Consecrated Snowfield"
    },
    "Consecrated Snowfield - Northeast Foggy Area, Inner Consecrated "
    "Snowfield": {
        "hintRegion": "the Consecrated Snowfield"
    },
    "Consecrated Snowfield - North of Yelough Anix Ruins": {
        "hintRegion": "the Consecrated Snowfield"
    },
    "Consecrated Snowfield - Northwest Foggy Area, East of Yelough Anix "
    "Ruins": {
        "hintRegion": "the Consecrated Snowfield"
    },
    "Consecrated Snowfield - Ordina, Liturgical Town": {
        "hintRegion": "the Consecrated Snowfield",
        "hintArea": "Ordina, Liturgical Town",
        "exceptions": [
            {
                "replaces": "Rotten Duelist Greaves",
                "hintRegion": "the Consecrated Snowfield",
                "hintArea": "the Consecrated Snowfield"
            },
            {
                "replaces": "Explosive Ghostflame",
                "hintRegion": "the Consecrated Snowfield",
                "hintArea": "the Consecrated Snowfield"
            },
            {
                "replaces": "Golden Seed",
                "hintRegion": "the Consecrated Snowfield",
                "hintArea": "the Consecrated Snowfield"
            }
        ]        
    },
    "Consecrated Snowfield - Southeast of Ordina": {
        "hintRegion": "the Consecrated Snowfield"
    },
    "Consecrated Snowfield - South of Ordina": {
        "hintRegion": "the Consecrated Snowfield"
    },
    "Consecrated Snowfield - Southwest Foggy Area": {
        "hintRegion": "the Consecrated Snowfield"
    },
    "Consecrated Snowfield - West of Ordina": {
        "hintRegion": "the Consecrated Snowfield"
    },
    "Consecrated Snowfield - Yelough Anix Ruins, Yelough Anix Tunnel "
    "Entrance": {
        "hintRegion": "the Consecrated Snowfield",
        "hintArea": "Yelough Anix Ruins",
        "exceptions": [
            {
                "replaces": "Smithing Stone [7]",
                "hintRegion": "the Consecrated Snowfield",
                "hintArea": "the Consecrated Snowfield"
            }
        ]
    },
    "Crumbling Farum Azula": {
        "hintRegion": "Crumbling Farum Azula",
        "exceptions": [
            {
                "replaces": "Pearldrake Talisman",
                "hintRegion": "Crumbling Farum Azula",
                "graphRegion": "the outskirts of Farum Azula"
            }
        ]
    },
    "Deathtouched Catacombs": {
        "hintRegion": "Stormhill",
        "hintArea": "Deathtouched Catacombs"
    },
    "Deeproot Depths": {
        "hintRegion": "Deeproot Depths",
        "exceptions": [
            {
                "hintLandmark": "Root-Facing Cliffs",
                "hintRegion": "Deeproot Depths",
                "graphRegion": "the upper roots of Deeproot Depths"
            },
            {
                "replaces": "Golden Arrow 10x",
                "hintLandmark": "Great Waterfall Crest",
                "hintRegion": "Deeproot Depths",
                "graphRegion": "the upper roots of Deeproot Depths"
            },
            {
                "replaces": "Golden Rune [5]",
                "hintLandmark": "Great Waterfall Crest",
                "hintRegion": "Deeproot Depths",
                "graphRegion": "the upper roots of Deeproot Depths"
            },
            {
                "replaces": "Golden Rune [8]",
                "hintLandmark": "Great Waterfall Crest",
                "hintRegion": "Deeproot Depths",
                "graphRegion": "the upper roots of Deeproot Depths"
            },
        ]
    },
    "Divine Tower of Caelid": {
        "hintRegion": "Greyoll's Dragonbarrow",
        "hintArea": "the Divine Tower of Caelid"
    },
    "Divine Tower of East Altus": {
        "hintRegion": "the Capital Outskirts",
        "graphRegion": "the bridge to the Forbidden Lands",
        "exceptions": [
            {
                "replaces": "Golden Rune [9]",
                "hintRegion": "the Capital Outskirts",
                "hintArea": "the Divine Tower of East Altus"
            },
            {
                "replaces": "Omenkiller Rollo",
                "hintRegion": "the Capital Outskirts",
                "hintArea": "the Divine Tower of East Altus"
            },
            {
                "hintLandmark": "East Capital Rampart",
                "hintRegion": "the Capital Outskirts",
                "graphRegion": "the Capital Outskirts east gate"
            }
        ]
    },
    "Divine Tower of Limgrave": {
        "hintRegion": "Stormhill",
        "hintArea": "the Divine Tower of Limgrave"
    },
    "Divine Tower of Liurnia": {
        "hintRegion": "eastern Liurnia",
        "hintArea": "the Divine Tower of Liurnia",
        "exceptions": [
            {
                "replaces": "Mask of Confidence",
                "hintLandmark": "Carian Study Hall",
                "hintRegion": "eastern Liurnia",
                "hintArea": "Carian Study Hall",
                "graphRegion": "the inverted Carian Study Hall"
            },
            {
                "replaces": "Lucidity",
                "hintLandmark": "Carian Study Hall",
                "hintRegion": "eastern Liurnia",
                "hintArea": "Carian Study Hall",
                "graphRegion": "the inverted Carian Study Hall"
            },
            {
                "replaces": "Glintstone Firefly 8x",
                "hintLandmark": "Carian Study Hall",
                "hintRegion": "eastern Liurnia",
                "hintArea": "Carian Study Hall",
                "graphRegion": "the inverted Carian Study Hall"
            },
            {
                "replaces": "Holyproof Dried Liver 2x",
                "hintLandmark": "Carian Study Hall",
                "hintRegion": "eastern Liurnia",
                "hintArea": "Carian Study Hall",
                "graphRegion": "the inverted Carian Study Hall"
            },
            {
                "hintLandmark": "Carian Study Hall",
                "hintRegion": "eastern Liurnia",
                "hintArea": "Carian Study Hall"
            }
        ]
    },
    "Divine Tower of West Altus": {
        "hintRegion": "the Capital Outskirts",
        "hintArea": "the Sealed Tunnel"
    },
    "Dragonbarrow Cave": {
        "hintRegion": "Greyoll's Dragonbarrow",
        "hintArea": "Dragonbarrow Cave"
    },
    "Earthbore Cave": {
        "hintRegion": "the Weeping Peninsula",
        "hintArea": "Earthbore Cave"
    },
    "East Limgrave": {
        "hintRegion": "eastern Limgrave"
    },
    "East Weeping Peninsula": {
        "hintRegion": "the Weeping Peninsula"
    },
    "Far Northwest Caelid": {
        "hintRegion": "Greyoll's Dragonbarrow",
        "graphRegion": "Caelid Canyon"
    },
    "Far West Altus Plateau": {
        "hintRegion": "Mt. Gelmir",
        "hintArea": "Fort Laiedd"
    },
    "Flame Peak - Northeast Giants' Gravepost": {
        "hintRegion": "Flame Peak"
    },
    "Flame Peak - Northwest Fire Giant Arena, Foot of the Forge": {
        "hintRegion": "Flame Peak"
    },
    "Flame Peak - Northwest Giants' Gravepost": {
        "hintRegion": "Flame Peak"
    },
    "Flame Peak - Southwest Giants' Gravepost": {
        "hintRegion": "Flame Peak",
        "exceptions": [
            {
                "replaces": "Rivers of Blood",
                "hintRegion": "Flame Peak",
                "hintArea": "the Church of Repose"
            },
            {
                "replaces": "Sacred Tear",
                "hintRegion": "Flame Peak",
                "hintArea": "the Church of Repose"
            }
        ]
    },
    "Gael Tunnel": {
        "hintRegion": "northern Caelid",
        "hintArea": "Gael Tunnel"
    },
    "Gaol Cave": {
        "hintRegion": "northern Caelid",
        "hintArea": "Gaol Cave"
    },
    "Gelmir Hero's Grave": {
        "hintRegion": "Mt. Gelmir",
        "hintArea": "Gelmir Hero's Grave"
    },
    "Giant-Conquering Hero's Grave": {
        "hintRegion": "Flame Peak",
        "hintArea": "Giant-Conquering Hero's Grave"
    },
    "Giants' Mountaintop Catacombs": {
        "hintRegion": "the western Mountaintops of the Giants",
        "hintArea": "Giants' Mountaintop Catacombs"
    },
    "Greyoll's Dragonbarrow - Bestial Sanctum": {
        "hintRegion": "Greyoll's Dragonbarrow",
        "hintArea": "Bestial Sanctum",
        "exceptions": [
            {
                "replaces": "Golden Seed",
                "hintRegion": "Greyoll's Dragonbarrow",
                "hintArea": "Greyoll's Dragonbarrow"
            }
        ]        
    },
    "Greyoll's Dragonbarrow - Divine Tower of Caelid Entrance": {
        "hintRegion": "Greyoll's Dragonbarrow",
        "exceptions": [
            {
                "replaces": "Numen's Rune",
                "hintRegion": "Greyoll's Dragonbarrow",
                "hintArea": "the Divine Tower of Caelid"
            }
        ]        
    },
    "Greyoll's Dragonbarrow - Dragonbarrow Fork": {
        "hintRegion": "Greyoll's Dragonbarrow"
    },
    "Greyoll's Dragonbarrow - Fort Faroth": {
        "hintRegion": "Greyoll's Dragonbarrow",
        "hintArea": "Fort Faroth"
    },
    "Greyoll's Dragonbarrow - Isolated Merchant's Shack": {
        "hintRegion": "Greyoll's Dragonbarrow",
        "hintArea": "Isolated Merchant's Shack",
        "exceptions": [
            {
                "replaces": "Ash of War: Sky Shot",
                "hintRegion": "Greyoll's Dragonbarrow",
                "hintArea": "Greyoll's Dragonbarrow"
            }
        ]        
    },
    "Greyoll's Dragonbarrow - Minor Erdtree, Dragonbarrow Cave Entrance": {
        "hintRegion": "Greyoll's Dragonbarrow",
        "hintArea": "the Minor Erdtree",
        "exceptions": [
            {
                "replaces": "Rune Arc",
                "hintRegion": "Greyoll's Dragonbarrow",
                "hintArea": "Greyoll's Dragonbarrow"
            }
        ]        
    },
    "Greyoll's Dragonbarrow - Northeast Cliffside": {
        "hintRegion": "Greyoll's Dragonbarrow"
    },
    "Greyoll's Dragonbarrow - Northwest Farum Greatbridge": {
        "hintRegion": "Greyoll's Dragonbarrow"
    },
    "Greyoll's Dragonbarrow - Southeast Farum Greatbridge, Lenne's Rise": {
        "hintRegion": "Greyoll's Dragonbarrow",
        "exceptions": [
            {
                "replaces": "Memory Stone",
                "hintRegion": "Greyoll's Dragonbarrow",
                "hintArea": "Lenne's Rise"
            }
        ]        
    },
    "Greyoll's Dragonbarrow - South of Divine Tower of Caelid, Deep Siofra "
    "Well": {
        "hintRegion": "Greyoll's Dragonbarrow"
    },
    "Greyoll's Dragonbarrow - Southwest Farum Greatbridge": {
        "hintRegion": "Greyoll's Dragonbarrow"
    },
    "Groveside Cave": {
        "hintRegion": "western Limgrave",
        "hintArea": "Groveside Cave"
    },
    "Hidden Path to the Haligtree": {
        "hintRegion": "the Forbidden Lands",
        "hintArea": "the Hidden Path to the Haligtree"
    },
    "Highroad Cave": {
        "hintRegion": "western Limgrave",
        "hintArea": "Highroad Cave"
    },
    "Impaler's Catacombs": {
        "hintRegion": "the Weeping Peninsula",
        "hintArea": "Impaler's Catacombs"
    },
    "Lakeside Crystal Cave": {
        "hintRegion": "the Great Lake of Liurnia",
        "hintArea": "Lakeside Crystal Cave"
    },
    "Leyndell": {
        "hintRegion": "Leyndell, Royal Capital"
    },
    "Leyndell - Divine Tower of East Altus Entrance; Mountaintops of the "
    "Giants - Forbidden Lands Start": {
        "hintRegion": "the Forbidden Lands"
    },
    "Leyndell, Ashen Capital": {
        "hintRegion": "Leyndell, Ashen Capital"
    },
    "Leyndell, Royal Capital": {
        "hintRegion": "Leyndell, Royal Capital",
        "exceptions": [
            {
                "replaces": "Blessed Dew Talisman",
                "hintRegion": "Leyndell, Royal Capital",
                "graphRegion": "the Divine Bridge"
            }
        ]
    },
    "Limgrave - Agheel Lake, Dragon-Burnt Ruins": {
        "hintRegion": "Agheel Lake",
        "hintArea": "Dragon-Burnt Ruins",
        "exceptions": [
            {
                "replaces": "Arteria Leaf",
                "hintRegion": "Agheel Lake",
                "hintArea": "Agheel Lake"
            },
            {
                "replaces": "Dragon Heart",
                "hintRegion": "Agheel Lake",
                "hintArea": "Agheel Lake"
            },
            {
                "replaces": "Incantation Scarab",
                "hintRegion": "western Limgrave",
                "hintArea": "western Limgrave"
            }
        ]
    },
    "Limgrave - Agheel Lake North, Murkwater Cave Entrance": {
        "hintRegion": "western Limgrave"
    },
    "Limgrave - Agheel Lake South, Forlorn Hound Evergaol": {
        "hintRegion": "western Limgrave",
        "exceptions": [
            {
                "replaces": "Crab Eggs",
                "hintRegion": "Agheel Lake"
            },
            {
                "replaces": "Bloodhound's Fang",
                "hintRegion": "western Limgrave",
                "hintArea": "Forlorn Hound Evergaol"
            }
        ]
    },
    "Limgrave - Artist's Shack": {
        "hintRegion": "eastern Limgrave",
        "exceptions": [
            {
                "hintLandmark": "Artist's Shack",
                "hintRegion": "eastern Limgrave",
                "hintArea": "Artist's Shack",
            },
        ]
    },
    "Limgrave - Church of Dragon Communion, Coastal Cave Exit": {
        "hintRegion": "western Limgrave",
        "hintArea": "the Church of Dragon Communion"
    },
    "Limgrave - Church of Elleh, Stranded Graveyard Exit": {
        "hintRegion": "western Limgrave",
        "hintArea": "the Church of Elleh",
        "exceptions": [
            {
                "replaces": "Golden Halberd",
                "hintRegion": "western Limgrave",
                "hintArea": "western Limgrave"
            },
            {
                "replaces": "Golden Rune [1]",
                "hintRegion": "western Limgrave",
                "hintArea": "western Limgrave"
            },
            {
                "hintLandmark": "Stranded Graveyard",
                "hintRegion": "western Limgrave",
                "hintArea": "western Limgrave"
            }
        ]
    },
    "Limgrave - Coastal Cave Entrance": {
        "hintRegion": "western Limgrave"
    },
    "Limgrave - East of Siofra River Well": {
        "hintRegion": "eastern Limgrave"
    },
    "Limgrave - Fort Haight": {
        "hintRegion": "eastern Limgrave",
        "hintArea": "Fort Haight"
    },
    "Limgrave - Fort Haight West (Meteored)": {
        "hintRegion": "Mistwood"
    },
    "Limgrave - Gatefront, Stormhill Evergaol, Groveside Cave Entrance, "
    "Limgrave Tunnels Entrance": {
        "hintRegion": "western Limgrave",
        "hintArea": "Gatefront Ruins",
        "exceptions": [
            {
                "replaces": "Arrow's Reach Talisman",
                "hintRegion": "Stormhill",
                "hintArea": "Stormgate"
            },
            {
                "replaces": "Aspects of the Crucible: Tail",
                "hintRegion": "Stormhill",
                "hintArea": "Stormhill Evergaol"
            },
            {
                "replaces": "Kukri 4x",
                "hintRegion": "western Limgrave",
                "hintArea": "western Limgrave"
            }
        ]
    },
    "Limgrave - Mistwood Outskirts": {
        "hintRegion": "eastern Limgrave",
        "exceptions": [
            {
                "replaces": "Sacrificial Twig",
                "hintRegion": "Mistwood"
            },
            {
                "replaces": "Gold-Pickled Fowl Foot",
                "hintRegion": "western Limgrave",
            }
        ]
    },
    "Limgrave - Murkwater Coast, Murkwater Catacombs Entrance": {
        "hintRegion": "western Limgrave"
    },
    "Limgrave - Rear Gael Tunnel Entrance; Caelid - Gael Tunnel Entrance": {
        "hintRegion": "northern Caelid",
        "exceptions": [
            {
                "replaces": "Ash of War: Sacred Blade",
                "hintRegion": "eastern Limgrave"
            }
        ]
    },
    "Limgrave - Seaside Ruins": {
        "hintRegion": "western Limgrave",
        "exceptions": [
            {
                "replaces": "Sacred Tear",
                "hintRegion": "the Weeping Peninsula",
                "hintArea": "the Church of Pilgrimage"
            }
        ]
    },
    "Limgrave - Siofra River Well, Mistwood Ruins, Minor Erdtree, Nokron "
    "Entrance": {
        "hintRegion": "Mistwood",
        "exceptions": [
            {
                "replaces": "Greenspill Crystal Tear",
                "hintRegion": "Mistwood",
                "hintArea": "the Minor Erdtree"
            },
            {
                "replaces": "Spiked Cracked Tear",
                "hintRegion": "Mistwood",
                "hintArea": "the Minor Erdtree"
            },
            {
                "replaces": "Axe Talisman",
                "hintRegion": "Mistwood",
                "hintArea": "Mistwood Ruins"
            },
            {
                "replaces": "Golden Rune [2]",
                "hintRegion": "Mistwood",
                "hintArea": "Mistwood Ruins"
            },
            {
                "replaces": "Smithing Stone [2]",
                "hintRegion": "Mistwood",
                "hintArea": "Mistwood Ruins"
            }
        ]
    },
    "Limgrave - South of Stranded Graveyard Exit": {
        "hintRegion": "western Limgrave",
        "exceptions": [
            {
                "replaces": "Bewitching Branch 3x",
                "hintRegion": "the Weeping Peninsula"
            },
            {
                "replaces": "Sliver of Meat",
                "hintRegion": "the Weeping Peninsula"
            },
            {
                "replaces": "Warhawk Ashes",
                "hintRegion": "the Weeping Peninsula"
            }
        ]
    },
    "Limgrave - South of Summonwater Village": {
        "hintRegion": "eastern Limgrave"
    },
    "Limgrave - Southwest of Fort Haight": {
        "hintRegion": "eastern Limgrave"
    },
    "Limgrave - Stormfoot Catacombs Entrance": {
        "hintRegion": "western Limgrave",
        "exceptions": [
            {
                "replaces": "Starlight Shards",
                "hintRegion": "Stormhill"
            }
        ]
    },
    "Limgrave - Summonwater Village": {
        "hintRegion": "eastern Limgrave",
        "hintArea": "Summonwater Village",
        "exceptions": [
            {
                "container": "Open Coffin",
                "hintRegion": "eastern Limgrave",
                "hintArea": "eastern Limgrave"
            },
            {
                "replaces": "Smithing Stone [2]",
                "hintRegion": "eastern Limgrave",
                "hintArea": "eastern Limgrave"
            }
        ]
    },
    "Limgrave - Summonwater Village Outskirts": {
        "hintRegion": "eastern Limgrave"
    },
    "Limgrave - Third Church of Marika, Gaol Cave Exit": {
        "hintRegion": "eastern Limgrave",
        "hintArea": "the Third Church of Marika",
        "exceptions": [
            {
                "replaces": "Neutralizing Boluses",
                "hintRegion": "eastern Limgrave",
                "hintArea": "eastern Limgrave"
            }
        ]
    },
    "Limgrave Tunnels": {
        "hintRegion": "Agheel Lake",
        "hintArea": "Limgrave Tunnels"
    },
    "Limgrave - Waypoint Ruins": {
        "hintRegion": "eastern Limgrave",
        "hintArea": "Waypoint Ruins",
        "exceptions": [
            {
                "container": "Open Coffin",
                "hintRegion": "eastern Limgrave",
                "hintArea": "eastern Limgrave"
            },
            {
                "replaces": "Glintstone Staff",
                "hintRegion": "western Limgrave",
                "hintArea": "western Limgrave"
            },
            {
                "replaces": "Smoldering Butterfly 4x",
                "hintRegion": "western Limgrave",
                "hintArea": "western Limgrave"
            },
            {
                "replaces": "Somber Smithing Stone [1]",
                "hintRegion": "western Limgrave",
                "hintArea": "western Limgrave"
            },
            {
                "replaces": "Greataxe",
                "hintRegion": "western Limgrave",
                "hintArea": "western Limgrave"
            },
            {
                "replaces": "Ash of War: Unsheathe",
                "hintRegion": "Agheel Lake",
                "hintArea": "Agheel Lake"
            }
        ]
    },
    "Liurnia of the Lake - Northeast Ravine; Bellum Highway - West of Grand "
    "Lift of Dectus": {
        "hintRegion": "the Great Lake of Liurnia",
        "exceptions": [
            {
                "replaces": "Neutralizing Boluses 5x",
                "hintRegion": "the Great Lake of Liurnia",
                "graphRegion": "UNREACHABLE"
            }
        ]
    },
    "Liurnia of the Lakes - Artist's Shack, Eastern Liurnia Lake Shore": {
        "hintRegion": "eastern Liurnia",
        "exceptions": [
            {
                "container": "Painting",
                "hintRegion": "eastern Liurnia",
                "hintArea": "Artist's Shack"
            }
        ]
    },
    "Liurnia of the Lakes - Behind Caria Manor, Royal Grave Evergaol, Part of "
    "Ravine": {
        "hintRegion": "the Caria Estate",
        "exceptions": [
            {
                "replaces": "Meteorite",
                "hintRegion": "the Caria Estate",
                "hintArea": "Royal Grave Evergaol"
            }
        ]
    },
    "Liurnia of the Lakes - Boilprawn Shack, Fallen Ruins of the Lake": {
        "hintRegion": "the Great Lake of Liurnia",
        "exceptions": [
            {
                "NPC": "Blackguard",
                "hintRegion": "the Great Lake of Liurnia",
                "hintArea": "Boilprawn Shack"
            }
        ]
    },
    "Liurnia of the Lakes - Caria Manor": {
        "hintRegion": "the Caria Estate",
        "hintArea": "Caria Manor",
        "exceptions": [
            {
                "replaces": "Frozen Armament",
                "hintRegion": "the Caria Estate",
                "hintArea": "the Caria Estate"
            }
        ]
    },
    "Liurnia of the Lakes - Church of Irith": {
        "hintRegion": "eastern Liurnia",
        "hintArea": "the Church of Irith"
    },
    "Liurnia of the Lakes - Church of Vows": {
        "hintRegion": "eastern Liurnia",
        "hintArea": "the Church of Vows",
        "exceptions": [
            {
                "replaces": "Stormhawk Feather 5x",
                "hintRegion": "eastern Liurnia",
                "hintArea": "eastern Liurnia"
            }
        ]
    },
    "Liurnia of the Lakes - Converted Tower": {
        "hintRegion": "western Liurnia",
        "hintArea": "Converted Tower",
        "exceptions": [
            {
                "replaces": "Golden Rune [6]",
                "hintRegion": "the Great Lake of Liurnia",
                "hintArea": "the Great Lake of Liurnia"
            },
            {
                "replaces": "Somber Smithing Stone [2]",
                "hintRegion": "western Liurnia",
                "hintArea": "western Liurnia"
            }
        ]
    },
    "Liurnia of the Lakes - Crystalline Woods, Path to the Four Belfries": {
        "hintRegion": "the Great Lake of Liurnia"
    },
    "Liurnia of the Lakes - Cuckoo's Evergaol, West of Meeting Place": {
        "hintRegion": "western Liurnia",
        "exceptions": [
            {
                "replaces": "Somber Smithing Stone [2]",
                "hintRegion": "the Great Lake of Liurnia"
            },
            {
                "replaces": "Greatblade Phalanx",
                "hintRegion": "western Liurnia",
                "hintArea": "Cuckoo's Evergaol"
            }
        ]
    },
    "Liurnia of the Lakes - Eastern Tableland, Ainsel River Well": {
        "hintRegion": "eastern Liurnia"
    },
    "Liurnia of the Lakes - Eastern Tableland Southeast Cliffside": {
        "hintRegion": "eastern Liurnia"
    },
    "Liurnia of the Lakes - Far West Gate Town, North Rose Church": {
        "hintRegion": "the Great Lake of Liurnia",
        "exceptions": [
            {
                "replaces": "Fire Blossom 3x",
                "enemy": "Flame Chariot",
                "hintRegion": "the Great Lake of Liurnia",
                "hintArea": "Academy Gate Town"
            },
            {
                "replaces": "Blue-White Wooden Shield",
                "hintRegion": "the Great Lake of Liurnia",
                "hintArea": "Academy Gate Town"
            },
            {
                "replaces": "Smithing Stone [3]",
                "hintRegion": "the Great Lake of Liurnia",
                "hintArea": "Academy Gate Town"
            },
            {
                "hintLandmark": "Rose Church",
                "hintRegion": "the Great Lake of Liurnia",
                "hintArea": "Rose Church"
            },
            {
                "NPC": "White Mask Varré",
                "hintRegion": "the Great Lake of Liurnia",
                "hintArea": "Rose Church"
            }
        ]
    },
    "Liurnia of the Lakes - Folly on the Lake, South Rose Church": {
        "hintRegion": "the Great Lake of Liurnia"
    },
    "Liurnia of the Lakes - Foot of the Four Belfries": {
        "hintRegion": "western Liurnia",
        "exceptions": [
            {
                "replaces": "Strip of White Flesh",
                "hintRegion": "the Great Lake of Liurnia"
            }
        ]
    },
    "Liurnia of the Lakes - Gate Town Bridge": {
        "hintRegion": "the Great Lake of Liurnia",
        "exceptions": [
            {
                "replaces": "Sliver of Meat",
                "hintRegion": "eastern Liurnia"
            }
        ]
    },
    "Liurnia of the Lakes - Gate Town Northeast": {
        "hintRegion": "the Great Lake of Liurnia"
    },
    "Liurnia of the Lakes - Gate Town Northwest": {
        "hintRegion": "the Great Lake of Liurnia",
        "hintArea": "Academy Gate Town"
    },
    "Liurnia of the Lakes - Gate Town Southeast": {
        "hintRegion": "the Great Lake of Liurnia",
        "hintArea": "Academy Gate Town"
    },
    "Liurnia of the Lakes - Gate Town Southwest": {
        "hintRegion": "the Great Lake of Liurnia",
        "hintArea": "Academy Gate Town"
    },
    "Liurnia of the Lakes - Highway Lookout Tower": {
        "hintRegion": "eastern Liurnia",
        "hintArea": "Highway Lookout Tower",
        "exceptions": [
            {
                "replaces": "Smithing Stone [2] 3x",
                "hintRegion": "the Great Lake of Liurnia",
                "hintArea": "the Great Lake of Liurnia"
            }
        ]
    },
    "Liurnia of the Lakes - Jarburg, Divine Tower of Liurnia Entrance": {
        "hintRegion": "eastern Liurnia",
        "hintArea": "Jarburg",
        "exceptions": [
            {
                "container": "Living Jar Warrior",
                "hintRegion": "eastern Liurnia",
                "hintArea": "Jarburg"
            },
            {
                "hintLandmark": "Carian Study Hall",
                "hintRegion": "eastern Liurnia",
                "hintArea": "eastern Liurnia"
            }
        ]
    },
    "Liurnia of the Lakes - Lake-Facing Cliffs, Stormveil Castle Exit, "
    "Stillwater Cave Entrance": {
        "hintRegion": "eastern Liurnia"
    },
    "Liurnia of the Lakes - Laskyar Ruins, Malefactor's Evergaol": {
        "hintRegion": "the Great Lake of Liurnia",
        "exceptions": [
            {
                "replaces": "Flame of the Fell God",
                "hintRegion": "eastern Liurnia",
                "hintArea": "Malefactor's Evergaol"
            },
            {
                "replaces": "Glintstone Craftsman's Cookbook [2]",
                "hintRegion": "the Great Lake of Liurnia",
                "hintArea": "Laskyar Ruins"
            },
            {
                "replaces": "Sacrificial Twig",
                "hintRegion": "eastern Liurnia"
            }
        ]
    },
    "Liurnia of the Lakes - Liurnia Highway Far North": {
        "hintRegion": "eastern Liurnia",
        "exceptions": [
            {
                "container": "Open Coffin",
                "hintRegion": "eastern Liurnia",
                "hintArea": "Jarburg"
            }
        ]
    },
    "Liurnia of the Lakes - Liurnia Highway North": {
        "hintRegion": "eastern Liurnia",
        "exceptions": [
            {
                "hintLandmark": "Purified Ruins",
                "hintRegion": "eastern Liurnia",
                "hintArea": "Purified Ruins"
            }
        ]
    },
    "Liurnia of the Lakes - Liurnia Highway South, Purified Ruins, Cliffbottom "
    "Catacombs Entrance": {
        "hintRegion": "eastern Liurnia",
        "exceptions": [
            {
                "hintLandmark": "Purified Ruins",
                "hintRegion": "eastern Liurnia",
                "hintArea": "Purified Ruins"
            }
        ]
    },
    "Liurnia of the Lakes - Liurnia Lake Shore": {
        "hintRegion": "eastern Liurnia"
    },
    "Liurnia of the Lakes - Main Academy Gate, Academy of Raya Lucaria "
    "Entrance": {
        "hintRegion": "the Academy of Raya Lucaria",
        "exceptions": [
            {
                "replaces": "Stonesword Key",
                "hintRegion": "the Great Lake of Liurnia",
                "hintArea": "the Great Lake of Liurnia"
            }
        ]
    },
    "Liurnia of the Lakes - Mausoleum Compound": {
        "hintRegion": "Bellum Highway",
        "exceptions": [
            {
                "replaces": "Somber Smithing Stone [2]",
                "hintRegion": "eastern Liurnia"
            }
        ]
    },
    "Liurnia of the Lakes - Meeting Place, Academy Crystal Cave Entrance": {
        "hintRegion": "the Great Lake of Liurnia"
    },
    "Liurnia of the Lakes - Minor Erdtree, Road's End Catacombs Entrance": {
        "hintRegion": "western Liurnia",
        "hintArea": "the Minor Erdtree",
        "exceptions": [
            {
                "replaces": "Ash of War: Sword Dance",
                "hintRegion": "western Liurnia",
                "hintArea": "western Liurnia"
            }
        ]
    },
    "Liurnia of the Lakes - Northern Liurnia Lake Shore, Kingsrealm Ruins": {
        "hintRegion": "western Liurnia",
        "hintArea": "Kingsrealm Ruins",
        "exceptions": [
            {
                "replaces": "Golden Rune [6]",
                "hintRegion": "the Great Lake of Liurnia",
                "hintArea": "the Great Lake of Liurnia"
            }
        ]
    },
    "Liurnia of the Lakes - North of Gate Town Bridge": {
        "hintRegion": "the Great Lake of Liurnia",
        "exceptions": [
            {
                "replaces": "Dragon Cult Prayerbook",
                "hintRegion": "eastern Liurnia"
            }
        ]
    },
    "Liurnia of the Lakes - North of Scenic Isle": {
        "hintRegion": "the Great Lake of Liurnia",
        "hintArea": "Academy Gate Town",
        "exceptions": [
            {
                "replaces": "Smithing Stone [3] 3x",
                "hintRegion": "the Great Lake of Liurnia",
                "hintArea": "the Great Lake of Liurnia"
            }
        ]
    },
    "Liurnia of the Lakes - North of Sorcerer's Isle": {
        "hintRegion": "the Great Lake of Liurnia"
    },
    "Liurnia of the Lakes - Ranni's Rise, Seluvis's Rise": {
        "hintRegion": "the Caria Estate",
        "exceptions": [
            {
                "NPC": "Blaidd the Half-Wolf",
                "hintRegion": "the Caria Estate",
                "hintArea": "Ranni's Rise"
            },
            {
                "NPC": "Preceptor Seluvis",
                "hintRegion": "the Caria Estate",
                "hintArea": "Seluvis's Rise"
            },
            {
                "NPC": "Ranni the Witch",
                "hintRegion": "the Caria Estate",
                "hintArea": "Ranni's Rise"
            },
            # not locked behind joining Ranni
            # {
            #     "replaces": "Black Wolf Mask",
            #     "hintRegion": "the Caria Estate",
            #     "hintArea": "Seluvis's Rise"
            # },
            {
                "replaces": "Memory Stone",
                "hintRegion": "the Caria Estate",
                "hintArea": "Seluvis's Rise"
            },
            {
                "container": "Open Coffin",
                "hintRegion": "western Liurnia"
            }
        ]
    },
    "Liurnia of the Lakes - Ravine-Veiled Village; Bellum Highway - Grand Lift "
    "of Dectus; Altus Plateau - Altus Plateau; Ruin-Strewn Precipice "
    "Entrance": {
        "hintRegion": "Bellum Highway",
        "exceptions": [
            {
                "replaces": "Smithing Stone [5]",
                "hintRegion": "the Great Lake of Liurnia"
            }
        ]
    },
    "Liurnia of the Lakes - Renna's Rise": {
        "hintRegion": "the Caria Estate",
        "hintArea": "Renna's Rise"
    },
    "Liurnia of the Lakes - Revenger's Shack": {
        "hintRegion": "western Liurnia",
        "hintArea": "Revenger's Shack"
    },
    "Liurnia of the Lakes - Road to the Manor": {
        "hintRegion": "western Liurnia"
    },
    "Liurnia of the Lakes - Ruined Labyrinth, Uld Palace Ruins": {
        "hintRegion": "eastern Liurnia"
    },
    "Liurnia of the Lakes - Scenic Isle, Laskyar Ruins": {
        "hintRegion": "the Great Lake of Liurnia",
        "hintArea": "Laskyar Ruins",
        "exceptions": [
            {
                "hintLandmark": "Scenic Isle",
                "hintRegion": "the Great Lake of Liurnia",
                "hintArea": "the Great Lake of Liurnia"
            }
        ]
    },
    "Liurnia of the Lakes - Slumbering Wolf's Shack, Lakeside Crystal Cave "
    "Entrance": {
        "hintRegion": "eastern Liurnia",
        "exceptions": [
            {
                "hintLandmark": "Slumbering Wolf's Shack",
                "hintRegion": "eastern Liurnia",
                "hintArea": "Slumbering Wolf's Shack"
            },
            {
                "NPC": "Latenna the Albinauric",
                "hintRegion": "eastern Liurnia",
                "hintArea": "Slumbering Wolf's Shack"
            }
        ]
    },
    "Liurnia of the Lakes - Sorcerer's Isle West, East Belfry": {
        "hintRegion": "the Great Lake of Liurnia"
    },
    "Liurnia of the Lakes - Southeast Ravine, Lake at Caria Manor Entrance; "
    "Bellum Highway - Bellum Church": {
        "hintRegion": "Bellum Highway",
        "exceptions": [
            {
                "hintLandmark": "Bellum Church",
                "hintRegion": "Bellum Highway",
                "hintArea": "Bellum Church"
            },
            {
                "replaces": "Ash of War: Hoarfrost Stomp",
                "hintRegion": "western Liurnia"
            }
        ]
    },
    "Liurnia of the Lakes - South of Caria Manor, West of Ravine Entrance": {
        "hintRegion": "western Liurnia",
        "exceptions": [
            {
                "replaces": "Somber Smithing Stone [4]",
                "hintRegion": "the Great Lake of Liurnia"
            }
        ]
    },
    "Liurnia of the Lakes - South of Mausoleum Compound, Raya Lucaria Crystal "
    "Tunnel Entrance": {
        "hintRegion": "eastern Liurnia"
    },
    "Liurnia of the Lakes - South of Scenic Isle, East of Slumbering Wolf's "
    "Shack": {
        "hintRegion": "eastern Liurnia"
    },
    "Liurnia of the Lakes - South Raya Lucaria Gate": {
        "hintRegion": "the Academy of Raya Lucaria",
        "exceptions": [
            {
                "replaces": "Meeting Place Map",
                "hintRegion": "the Great Lake of Liurnia",
                "hintArea": "Academy Gate Town"
            }
        ]
    },
    "Liurnia of the Lakes - Southwest of Converted Tower; Moonlight Altar - "
    "Ringleader's Evergaol": {
        "hintRegion": "Moonlight Altar",
        "hintArea": "the Ringleader's Evergaol"
    },
    "Liurnia of the Lakes - Temple Quarter": {
        "hintRegion": "the Great Lake of Liurnia",
        "exceptions": [
            {
                "hintLandmark": "Temple Quarter",
                "hintRegion": "the Great Lake of Liurnia",
                "hintArea": "the Temple Quarter"
            }
        ]
    },
    "Liurnia of the Lakes - Testu's Rise, East Gate Bridge Trestle": {
        "hintRegion": "the Great Lake of Liurnia",
        "exceptions": [
            {
                "replaces": "Memory Stone",
                "hintRegion": "the Great Lake of Liurnia",
                "hintArea": "Testu's Rise"
            }
        ]
    },
    "Liurnia of the Lakes - The Four Belfries, Giant's Caravan Below": {
        "hintRegion": "western Liurnia",
        "exceptions": [
            {
                "replaces": "Imbued Sword Key 2",
                "hintRegion": "western Liurnia",
                "hintArea": "The Four Belfries"
            }
        ]
    },
    "Liurnia of the Lakes - Village of the Albinaurics; Moonlight Altar - "
    "Moonfolk Ruins": {
        "hintRegion": "Moonlight Altar",
        "exceptions": [
            {
                "replaces": "Smithing Stone [2] 2x",
                "hintRegion": "western Liurnia"
            },
            {
                "hintLandmark": "Cathedral of Manus Celes",
                "hintRegion": "Moonlight Altar",
                "hintArea": "the Cathedral of Manus Celes"
            },
            {
                "hintLandmark": "Moonfolk Ruins",
                "hintRegion": "Moonlight Altar",
                "hintArea": "Moonfolk Ruins"
            },
            {
                "hintLandmark": "Village of the Albinaurics",
                "hintRegion": "western Liurnia",
                "hintArea": "the Village of the Albinaurics"
            }
        ]
    },
    "Liurnia of the Lakes - West Albinauric Village; Moonlight Altar - "
    "Cathedral of Manus Celes": {
        "hintRegion": "western Liurnia",
        "exceptions": [
            {
                "replaces": "Crucible Knot Talisman",
                "hintRegion": "western Liurnia",
                "hintArea": "the Village of the Albinaurics"
            },
            {
                "NPC": "Old Albus",
                "hintRegion": "western Liurnia",
                "hintArea": "the Village of the Albinaurics"
            },
            {
                "hintLandmark": "Village of the Albinaurics",
                "hintRegion": "western Liurnia",
                "hintArea": "the Village of the Albinaurics"
            },
            {
                "NPC": "Ranni the Witch",
                "hintRegion": "Moonlight Altar",
                "hintArea": "the Cathedral of Manus Celes"
            },
            {
                "hintLandmark": "Cathedral of Manus Celes",
                "hintRegion": "Moonlight Altar",
                "hintArea": "the Cathedral of Manus Celes"
            }
        ]
    },
    "Liurnia of the Lakes - West of Church of Irith": {
        "hintRegion": "eastern Liurnia"
    },
    "Liurnia of the Lakes - West of Raya Lucaria Crystal Tunnel; Bellum "
    "Highway - South of East Raya Lucaria Gate": {
        "hintRegion": "the Great Lake of Liurnia"
    },
    "Liurnia of the Lakes - West of Scenic Isle": {
        "hintRegion": "the Great Lake of Liurnia"
    },
    "Liurnia to Altus Plateau": {
        "hintRegion": "Altus Plateau"
    },
    "Minor Erdtree Catacombs": {
        "hintRegion": "northern Caelid",
        "hintArea": "Minor Erdtree Catacombs"
    },
    "Miquella's Haligtree": {
        "hintRegion": "Elphael, Brace of the Haligtree",
        "exceptions": [
            {
                "hintLandmark": "Miquella's Haligtree",
                "hintRegion": "Miquella's Haligtree"
            },
            {
                "hintLandmark": "Haligtree Canopy",
                "hintRegion": "Miquella's Haligtree"
            },
            {
                "hintLandmark": "Haligtree Town",
                "hintRegion": "Miquella's Haligtree"
            },
            {
                "hintLandmark": "Haligtree Town Plaza",
                "hintRegion": "Miquella's Haligtree"
            },
            {
                "replaces": "Loretta's Mastery",
                "hintRegion": "Miquella's Haligtree"
            }
        ]
    },
    "Mohgwyn Palace": {
        "hintRegion": "Mohgwyn Palace",
        "exceptions": [
            {
                "replaces": "Haligdrake Talisman +2",
                "hintRegion": "Mohgwyn Palace"
            },
            {
                "replaces": "Numen's Rune",
                "hintRegion": "Mohgwyn Palace",
                "hintArea": "Mohgwyn Dynasty Mausoleum"
            },
            {
                "hintLandmark": "Cocoon of the Empyrean",
                "hintRegion": "Mohgwyn Palace",
                "hintArea": "Mohgwyn Dynasty Mausoleum"
            },
            {
                "hintLandmark": "Dynasty Mausoleum Midpoint",
                "hintRegion": "Mohgwyn Palace",
                "hintArea": "Mohgwyn Dynasty Mausoleum"
            },
            {
                "NPC": "Merchant",
                "hintRegion": "Mohgwyn Palace",
                "hintArea": "Mohgwyn Dynasty Mausoleum"
            },
            {
                "NPC": "White Mask Varré",
                "hintRegion": "Mohgwyn Palace",
                "hintArea": "Mohgwyn Dynasty Mausoleum"
            }
        ]
    },
    "Morne Tunnel": {
        "hintRegion": "the Weeping Peninsula",
        "hintArea": "Morne Tunnel"
    },
    "Moonlight Altar - Altar South, Chelona's Rise": {
        "hintRegion": "Moonlight Altar",
        "hintArea": "Chelona's Rise"
    },
    "Moonlight Altar - Deep Ainsel Well": {
        "hintRegion": "Moonlight Altar"
    },
    "Moonlight Altar - Lunar Estate Ruins": {
        "hintRegion": "Moonlight Altar",
        "hintArea": "Lunar Estate Ruins"
    },
    "Moonlight Altar - West of Deep Ainsel Well": {
        "hintRegion": "Moonlight Altar"
    },
    "Mountaintops of the Giants - Ancient Snow Valley Ruins, Stargazers' "
    "Ruins": {
        "hintRegion": "the western Mountaintops of the Giants",
        "exceptions": [
            {
                "replaces": "Primal Glintstone Blade",
                "hintRegion": "the western Mountaintops of the Giants",
                "hintArea": "Stargazers' Ruins",
                "graphRegion": "Stargazers' Ruins basement"
            },
            {
                "hintLandmark": "Stargazers' Ruins",
                "hintRegion": "the western Mountaintops of the Giants",
                "hintArea": "Stargazers' Ruins"
            }
        ]
    },
    "Mountaintops of the Giants - Before Ancient Snow Valley Ruins": {
        "hintRegion": "the western Mountaintops of the Giants"
    },
    "Mountaintops of the Giants - Before Freezing Lake, Heretical Rise": {
        "hintRegion": "the western Mountaintops of the Giants",
        "exceptions": [
            {
                "replaces": "Golden Seed",
                "hintRegion": "the western Mountaintops of the Giants"
            },
            {
                "hintLandmark": "Heretical Rise",
                "hintRegion": "the eastern Mountaintops of the Giants",
                "hintArea": "Heretical Rise"
            }
        ]
    },
    "Mountaintops of the Giants - Before Grand Lift of Rold": {
        "hintRegion": "the Forbidden Lands"
    },
    "Mountaintops of the Giants - East Zamor Ruins; Flame Peak - "
    "Giant-Conquering Hero's Grave Entrance": {
        "hintRegion": "the western Mountaintops of the Giants",
        "exceptions": [
            {
                "replaces": "Somber Smithing Stone [7]",
                "container": "Corpse",
                "hintRegion": "Flame Peak"
            },
            {
                "replaces": "Somber Smithing Stone [7]",
                "enemy": "Fingercreeper",
                "hintRegion": "Flame Peak"
            }
        ]
    },
    "Mountaintops of the Giants - First Church of Marika": {
        "hintRegion": "the eastern Mountaintops of the Giants",
        "hintArea": "the First Church of Marika",
        "exceptions": [
            {
                "replaces": "Smithing Stone [7] 3x",
                "hintRegion": "the eastern Mountaintops of the Giants",
                "hintArea": "the eastern Mountaintops of the Giants"
            }
        ]
    },
    "Mountaintops of the Giants - Forbidden Lands Midway": {
        "hintRegion": "the Forbidden Lands"
    },
    "Mountaintops of the Giants - Guardians' Garrison": {
        "hintRegion": "the eastern Mountaintops of the Giants",
        "hintArea": "Guardians' Garrison"
    },
    "Mountaintops of the Giants - North Castle Sol": {
        "hintRegion": "the western Mountaintops of the Giants",
        "hintArea": "Castle Sol"
    },
    "Mountaintops of the Giants - North of Zamor Ruins; Flame Peak - Hero's "
    "Grave North Cliffside": {
        "hintRegion": "the western Mountaintops of the Giants"
    },
    "Mountaintops of the Giants - Northwest Freezing Lake": {
        "hintRegion": "the eastern Mountaintops of the Giants"
    },
    "Mountaintops of the Giants - Northwest of Freezing Lake, East of Castle "
    "Sol": {
        "hintRegion": "the western Mountaintops of the Giants",
        "hintArea": "Castle Sol"
    },
    "Mountaintops of the Giants - Shack of the Lofty; Consecrated Snowfield - "
    "Minor Erdtree, Albinauric Rise, Cave of the Forlorn Entrance": {
        "hintRegion": "the western Mountaintops of the Giants",
        "exceptions": [
            {
                "replaces": "Traveling Maiden Hood",
                "hintRegion": "the western Mountaintops of the Giants",
                "hintArea": "the Shack of the Lofty"
            },
            {
                "hintLandmark": "Albinauric Rise",
                "hintRegion": "the Consecrated Snowfield",
                "hintArea": "Albinauric Rise"
            },
            {
                "hintLandmark": "Cave of the Forlorn",
                "hintRegion": "the Consecrated Snowfield"
            },
            {
                "replaces": "Tarnished Golden Sunflower 3x",
                "hintRegion": "the Consecrated Snowfield",
                "hintArea": "the Minor Erdtree"
            }
        ]
    },
    "Mountaintops of the Giants - South Castle Sol, Snow Valley Ruins "
    "Overlook": {
        "hintRegion": "the western Mountaintops of the Giants",
        "exceptions": [
            {
                "hintLandmark": "Castle Sol",
                "hintRegion": "the western Mountaintops of the Giants",
                "hintArea": "Castle Sol"
            },
            {
                "hintLandmark": "Castle Sol Rooftop",
                "hintRegion": "the western Mountaintops of the Giants",
                "hintArea": "Castle Sol"
            },
            {
                "hintLandmark": "Church of the Eclipse",
                "hintRegion": "the western Mountaintops of the Giants",
                "hintArea": "Castle Sol"
            }
        ]
    },
    "Mountaintops of the Giants - Southeast Freezing Lake": {
        "hintRegion": "the eastern Mountaintops of the Giants"
    },
    "Mountaintops of the Giants - Southwest Freezing Lake, Lord Contender's "
    "Evergaol, Spiritcaller Cave Entrance": {
        "hintRegion": "the eastern Mountaintops of the Giants",
        "exceptions": [
            {
                "replaces": "Vyke's Dragonbolt",
                "hintRegion": "the eastern Mountaintops of the Giants",
                "hintArea": "Lord Contender's Evergaol"
            }
        ]        
    },
    "Mountaintops of the Giants - West of Castle Sol; Consecrated Snowfield - "
    "North of Minor Erdtree": {
        "hintRegion": "the Consecrated Snowfield",
        "exceptions": [
            {
                "hintLandmark": "Minor Erdtree",
                "hintRegion": "the Consecrated Snowfield",
                "hintArea": "the Minor Erdtree"
            },
            {
                "hintLandmark": "Shack of the Lofty",
                "hintRegion": "the western Mountaintops of the Giants"
            }
        ]        
    },
    "Mountaintops of the Giants - West Zamor Ruins, Grand Lift of Rold": {
        "hintRegion": "the western Mountaintops of the Giants",
        "hintArea": "Zamor Ruins",
        "exceptions": [
            {
                "replaces": "Beast Blood 2x",
                "hintRegion": "the western Mountaintops of the Giants",
                "hintArea": "the Grand Lift of Rold"
            },
            {
                "replaces": "Golden Rune [10]",
                "hintRegion": "the western Mountaintops of the Giants",
                "hintArea": "the western Mountaintops of the Giants"
            },
            {
                "replaces": "Sliver of Meat 2x",
                "hintRegion": "the western Mountaintops of the Giants",
                "hintArea": "the western Mountaintops of the Giants"
            }
        ]        
    },
    "Mountaintops of the Giants - Whiteridge Road, Minor Erdtree": {
        "hintRegion": "the eastern Mountaintops of the Giants",
        "exceptions": [
            {
                "hintLandmark": "Minor Erdtree",
                "hintRegion": "the western Mountaintops of the Giants",
                "hintArea": "the Minor Erdtree"
            }
        ]
    },
    "Mt. Gelmir - Before Hermit Shack": {
        "hintRegion": "Mt. Gelmir"
    },
    "Mt. Gelmir - Craftsman's Shack, Hermit's Shack": {
        "hintRegion": "Mt. Gelmir",
        "exceptions": [
            {
                "replaces": "Roiling Magma",
                "hintRegion": "Mt. Gelmir",
                "hintArea": "Hermit's Shack"
            },
            {
                "hintLandmark": "Craftsman's Shack",
                "hintRegion": "Mt. Gelmir",
                "hintArea": "Craftsman's Shack"
            },
            {
                "hintLandmark": "Perfumer's Ruins",
                "hintRegion": "Altus Plateau",
                "hintArea": "Perfumer's Ruins"
            }
        ]
    },
    "Mt. Gelmir - First Mt. Gelmir Campsite, Corpse-Stench Shack; Altus "
    "Plateau - West of Shaded Castle": {
        "hintRegion": "Mt. Gelmir",
        "exceptions": [
            {
                "replaces": "Golden Vow",
                "hintRegion": "Mt. Gelmir",
                "hintArea": "Corpse-Stench Shack"
            },
            {
                "replaces": "Sacred Butchering Knife",
                "hintRegion": "Mt. Gelmir",
                "hintArea": "Corpse-Stench Shack"
            },
            {
                "replaces": "Antspur Rapier",
                "hintRegion": "Altus Plateau",
                "hintArea": "the Shaded Castle"
            },
            {
                "replaces": "Smithing Stone [5]",
                "hintRegion": "Altus Plateau",
                "hintArea": "the Shaded Castle"
            }
        ]
    },
    "Mt. Gelmir - Fort Laiedd": {
        "hintRegion": "Mt. Gelmir",
        "exceptions": [
            {
                "hintLandmark": "Fort Laiedd",
                "hintRegion": "Mt. Gelmir",
                "hintArea": "Fort Laiedd"
            }
        ]
    },
    "Mt. Gelmir - Minor Erdtree, Seethewater Cave Entrance": {
        "hintRegion": "Mt. Gelmir",
        "exceptions": [
            {
                "container": "Ulcerated Tree Spirit",
                "hintRegion": "Mt. Gelmir",
                "hintArea": "the Minor Erdtree"
            },
            {
                "replaces": "Drawstring Fire Grease 3x",
                "hintRegion": "Mt. Gelmir",
                "hintArea": "the Minor Erdtree"
            },
            {
                "replaces": "Golden Arrow 5x",
                "hintRegion": "Mt. Gelmir",
                "hintArea": "the Minor Erdtree"
            },
            {
                "replaces": "Golden Rune [4]",
                "hintRegion": "Mt. Gelmir",
                "hintArea": "the Minor Erdtree"
            }
        ]
    },
    "Mt. Gelmir - Ninth Mt. Gelmir Campsite, Road of Iniquity, Volcano Manor "
    "Entrance": {
        "hintRegion": "Mt. Gelmir"
    },
    "Mt. Gelmir - Outside Volcano Manor": {
        "hintRegion": "Mt. Gelmir"
    },
    "Mt. Gelmir - Primeval Sorcerer Azur, Gelmir Hero's Grave Entrance": {
        "hintRegion": "Mt. Gelmir",
        "exceptions": [
            {
                "replaces": "Memory Stone",
                "hintRegion": "Mt. Gelmir",
                "hintArea": "Hermit Village"
            }
        ]
    },
    "Mt. Gelmir - Seethewater River, Hermit Village, Wyndham Catacombs "
    "Entrance, Sage's Cave Entrance, Abductor Virgins Exit": {
        "hintRegion": "Mt. Gelmir",
        "hintArea": "Hermit Village",
        "exceptions": [
            {
                "replaces": "Sacramental Bud 2x",
                "hintRegion": "Mt. Gelmir",
                "hintArea": "Mt. Gelmir"
            },
            {
                "hintLandmark": "Seethewater River",
                "hintRegion": "Mt. Gelmir",
                "hintArea": "Mt. Gelmir"
            },
            {
                "hintLandmark": "Sage's Cave",
                "hintRegion": "Altus Plateau",
                "hintArea": "Altus Plateau"
            }
        ]
    },
    "Mt. Gelmir - Seethewater Terminus": {
        "hintRegion": "Mt. Gelmir",
        "exceptions": [
            {
                "hintLandmark": "Fort Laiedd",
                "hintRegion": "Mt. Gelmir",
                "hintArea": "Fort Laiedd"
            }
        ]
    },
    "Mt. Gelmir - Volcano Cave Entrance": {
        "hintRegion": "Mt. Gelmir"
    },
    "Murkwater Catacombs": {
        "hintRegion": "western Limgrave",
        "hintArea": "Murkwater Catacombs"
    },
    "Murkwater Cave": {
        "hintRegion": "western Limgrave",
        "hintArea": "Murkwater Cave"
    },
    "North Altus Plateau": {
        "hintRegion": "Altus Plateau"
    },
    "Northeast Altus Plateau": {
        "hintRegion": "the Capital Outskirts"
    },
    "Northwest Caelid": {
        "hintRegion": "northern Caelid"
    },
    "Northwest Limgrave Coast": {
        "hintRegion": "eastern Liurnia"
    },
    "Old Altus Tunnel": {
        "hintRegion": "Altus Plateau",
        "hintArea": "Old Altus Tunnel"
    },
    "Perfumer's Grotto": {
        "hintRegion": "Altus Plateau",
        "hintArea": "Perfumer's Grotto"
    },
    "Raya Lucaria Crystal Tunnel": {
        "hintRegion": "the Great Lake of Liurnia",
        "hintArea": "Raya Lucaria Crystal Tunnel"
    },
    "Road's End Catacombs": {
        "hintRegion": "western Liurnia",
        "hintArea": "Road's End Catacombs"
    },
    "Roundtable Hold": {
        "hintRegion": "Roundtable Hold"
    },
    "Ruin-Strewn Precipice": {
        "hintRegion": "the Great Lake of Liurnia",
        "hintArea": "Ruin-Strewn Precipice",
        "exceptions": [
            {
                "replaces": "Golden Rune [1]",
                "hintRegion": "the Great Lake of Liurnia",
                "graphRegion": "UNREACHABLE"
            }
        ]
    },
    "Sage's Cave": {
        "hintRegion": "Altus Plateau",
        "hintArea": "Sage's Cave"
    },
    "Sainted Hero's Grave": {
        "hintRegion": "Altus Plateau",
        "hintArea": "Sainted Hero's Grave"
    },
    "Seethewater Cave": {
        "hintRegion": "Mt. Gelmir",
        "hintArea": "Seethewater Cave"
    },
    "Sellia Crystal Tunnel": {
        "hintRegion": "southern Caelid",
        "hintArea": "Sellia Crystal Tunnel"
    },
    "Sellia Hideaway": {
        "hintRegion": "southern Caelid",
        "hintArea": "Sellia Hideaway",
        "exceptions": [
            {
                "NPC": "Master Lusat",
                "hintRegion": "southern Caelid",
                "hintArea": "Sellia Hideaway",
                "graphRegion": "Sellia Hideaway's sealed tunnel"
            }
        ]
    },
    "Siofra River": {
        "hintRegion": "Siofra River",
        "exceptions": [
            {
                "replaces": "Celestial Dew",
                "hintLandmark": "Ancestral Woods",
                "hintRegion": "Nokron, Eternal City",
                "hintArea": "Night's Sacred Ground"
            },
            {
                "replaces": "Fingerslayer Blade",
                "hintLandmark": "Ancestral Woods",
                "hintRegion": "Nokron, Eternal City",
                "hintArea": "Night's Sacred Ground"
            },
            {
                "replaces": "Golden Rune [7]",
                "hintLandmark": "Ancestral Woods",
                "hintRegion": "Nokron, Eternal City",
                "hintArea": "Night's Sacred Ground"
            },
            {
                "replaces": "Rejuvenating Boluses",
                "hintLandmark": "Ancestral Woods",
                "hintRegion": "Nokron, Eternal City",
                "hintArea": "Night's Sacred Ground"
            },
            {
                "replaces": "Rune Arc",
                "hintLandmark": "Ancestral Woods",
                "hintRegion": "Nokron, Eternal City",
                "hintArea": "Night's Sacred Ground"
            },
            {
                "hintLandmark": "Ancestral Woods",
                "hintRegion": "Nokron, Eternal City"
            },
            {
                "replaces": "Crucible Hornshield",
                "hintLandmark": "Aqueduct-Facing Cliffs",
                "hintRegion": "Nokron, Eternal City",
                "hintArea": "Siofra Aqueduct"
            },
            {
                "replaces": "Missionary's Cookbook [5]",
                "hintLandmark": "Aqueduct-Facing Cliffs",
                "hintRegion": "Nokron, Eternal City",
                "hintArea": "Siofra Aqueduct"
            },
            {
                "hintLandmark": "Aqueduct-Facing Cliffs",
                "hintRegion": "Nokron, Eternal City"
            },
            {
                "hintLandmark": "Great Waterfall Basin",
                "hintRegion": "Nokron, Eternal City",
                "hintArea": "Siofra Aqueduct"
            },
            {
                "replaces": "Mottled Necklace",
                "hintLandmark": "Hallowhorn Grounds",
                "hintRegion": "Nokron, Eternal City",
                "graphRegion": "Nokron Bridge"
            },
            {
                "replaces": "Ancestral Follower Ashes",
                "hintLandmark": "Hallowhorn Grounds",
                "hintRegion": "Siofra River",
                "hintArea": "Hallowhorn Grounds"
            },
            {
                "replaces": "Golden Rune [6]",
                "hintLandmark": "Hallowhorn Grounds",
                "hintRegion": "Siofra River",
                "hintArea": "Hallowhorn Grounds"
            },
            {
                "replaces": "Horn Bow",
                "hintLandmark": "Hallowhorn Grounds",
                "hintRegion": "Siofra River",
                "hintArea": "Hallowhorn Grounds"
            },
            {
                "replaces": "Mottled Necklace +1",
                "hintLandmark": "Hallowhorn Grounds",
                "hintRegion": "Nokron, Eternal City",
                "hintArea": "Hallowhorn Grounds"
            },
            {
                "replaces": "Remembrance of the Regal Ancestor",
                "hintLandmark": "Hallowhorn Grounds",
                "hintRegion": "Nokron, Eternal City",
                "hintArea": "Hallowhorn Grounds"
            },
            {
                "replaces": "Celestial Dew",
                "hintLandmark": "Hallowhorn Grounds",
                "hintRegion": "Nokron, Eternal City"
            },
            {
                "replaces": "Clarifying Horn Charm +1",
                "hintLandmark": "Hallowhorn Grounds",
                "hintRegion": "Nokron, Eternal City"
            },
            {
                "replaces": "Hefty Beast Bone 3x",
                "hintLandmark": "Hallowhorn Grounds",
                "hintRegion": "Nokron, Eternal City"
            },
            {
                "replaces": "Hefty Beast Bone 5x",
                "hintLandmark": "Hallowhorn Grounds",
                "hintRegion": "Nokron, Eternal City"
            },
            {
                "replaces": "Kukri 8x",
                "hintLandmark": "Hallowhorn Grounds",
                "hintRegion": "Nokron, Eternal City"
            },
            {
                "replaces": "Old Fang 4x",
                "hintLandmark": "Hallowhorn Grounds",
                "hintRegion": "Nokron, Eternal City"
            },
            {
                "replaces": "Shining Horned Headband",
                "hintLandmark": "Hallowhorn Grounds",
                "hintRegion": "Nokron, Eternal City"
            },
            {
                "replaces": "Smithing Stone [2]",
                "hintLandmark": "Hallowhorn Grounds",
                "hintRegion": "Nokron, Eternal City"
            },
            {
                "replaces": "Smithing Stone [5]",
                "hintLandmark": "Hallowhorn Grounds",
                "hintRegion": "Nokron, Eternal City"
            },
            {
                "replaces": "Stonesword Key",
                "hintLandmark": "Hallowhorn Grounds",
                "directions": "Near Hallowhorn Grounds (Underground Ruins) - "
                              "72.82 away in 12 o'clock direction, 17.69 "
                              "height offset",
                "hintRegion": "Nokron, Eternal City"
            },
            {
                "hintLandmark": "Night's Sacred Ground",
                "hintRegion": "Nokron, Eternal City",
                "hintArea": "Night's Sacred Ground"
            },
            {
                "hintLandmark": "Mimic Tear",
                "hintRegion": "Nokron, Eternal City"
            },
            {
                "hintLandmark": "Rear Gael Tunnel Entrance",
                "hintRegion": "Nokron, Eternal City"
            },
            {
                "replaces": "Dragon Halberd",
                "hintLandmark": "Siofra Aqueduct",
                "hintRegion": "Siofra River"
            },
            {
                "replaces": "Golden Rune [7]",
                "hintLandmark": "Siofra Aqueduct",
                "directions": "Near Siofra Aqueduct (Underground) - "
                              "125.09 away in 6 o'clock direction, -136.08 "
                              "height offset",
                "hintRegion": "Siofra River"
            },
            {
                "replaces": "Marika's Scarseal",
                "hintLandmark": "Siofra Aqueduct",
                "hintRegion": "Siofra River"
            },
            {
                "replaces": "Rune Arc",
                "hintLandmark": "Siofra Aqueduct",
                "directions": "Near Siofra Aqueduct (Underground) - 116.01 "
                              "away in 12 o'clock direction, -159.28 height "
                              "offset",
                "hintRegion": "Siofra River"
            },
            {
                "hintLandmark": "Siofra Aqueduct",
                "hintRegion": "Nokron, Eternal City",
                "hintArea": "Siofra Aqueduct"
            },
            {
                "replaces": "Smithing Stone [5]",
                "hintLandmark": "Worshippers' Woods",
                "hintRegion": "Nokron, Eternal City"
            }
        ]
    },
    "Siofra River Start": {
        "hintRegion": "Nokron, Eternal City",
        "exceptions": [
            {
                "replaces": "Preserving Boluses",
                "hintRegion": "Siofra River"
            },
            {
                "hintLandmark": "Siofra River Bank",
                "hintRegion": "Siofra River"
            },
            {
                "hintLandmark": "Siofra River Well Depths",
                "hintRegion": "Siofra River"
            }
        ]
    },
    "South Altus Plateau": {
        "hintRegion": "the Capital Outskirts"
    },
    "Southeast Caelid": {
        "hintRegion": "southern Caelid",
        "hintArea": "the Wailing Dunes"
    },
    "Southeast Mountaintops": {
        "hintRegion": "Flame Peak"
    },
    "Southwest Mountaintops": {
        "hintRegion": "the Consecrated Snowfield"
    },
    "Spiritcaller Cave": {
        "hintRegion": "the eastern Mountaintops of the Giants",
        "hintArea": "Spiritcaller Cave"
    },
    "Stillwater Cave": {
        "hintRegion": "the Great Lake of Liurnia",
        "hintArea": "Stillwater Cave"
    },
    "Stone Platform": {
        "hintRegion": "the heart of the Erdtree"
    },
    "Stormfoot Catacombs": {
        "hintRegion": "western Limgrave",
        "hintArea": "Stormfoot Catacombs"
    },
    "Stormhill - Forested West Cliffside": {
        "hintRegion": "Stormhill"
    },
    "Stormhill - Northeast Cliffside": {
        "hintRegion": "Stormhill"
    },
    "Stormhill - North of Stormhill Shack": {
        "hintRegion": "Stormhill"
    },
    "Stormhill - North of Warmaster's Shack": {
        "hintRegion": "Stormhill"
    },
    "Stormhill - Northwest Cliffside, Limgrave Colosseum Entrance": {
        "hintRegion": "Stormhill"
    },
    # Fog randomizer version:
    "Stormhill - Northwest Cliffside": {
        "hintRegion": "Stormhill"
    },
    "Stormhill - Path to Liurnia": {
        "hintRegion": "Stormhill"
    },
    "Stormhill - Saintsbridge, Deathtouched Catacombs Entrance; Limgrave - "
    "Highroad Cave Entrance": {
        "hintRegion": "Stormhill",
        "exceptions": [
            {
                "replaces": "Smithing Stone [1] 2x",
                "hintRegion": "eastern Limgrave"
            },
            {
                "replaces": "Turtle Neck Meat",
                "hintRegion": "western Limgrave"
            }
        ]
    },
    # Fog randomizer version:
    "Stormhill - Saintsbridge, Deathtouched Catacombs Entrance, Highroad Cave "
    "Entrance": {
        "hintRegion": "Stormhill",
        "exceptions": [
            {
                "replaces": "Smithing Stone [1] 2x",
                "hintRegion": "eastern Limgrave"
            },
            {
                "replaces": "Turtle Neck Meat",
                "hintRegion": "western Limgrave"
            }
        ]
    },
    "Stormhill - Stormhill Shack, Stormveil Castle Entrance": {
        "hintRegion": "Stormhill",
        "exceptions": [
            {
                "NPC": "Roderika, Spirit Tuner",
                "hintRegion": "Stormhill",
                "hintArea": "Stormhill Shack"
            },
            {
                "replaces": "Stonesword Key",
                "hintRegion": "Stormhill",
                "hintArea": "Stormhill Shack"
            }
        ]
    },
    "Stormhill - Warmaster's Shack, Stormgate": {
        "hintRegion": "Stormhill",
        "exceptions": [
            {
                "NPC": "Knight Bernahl",
                "hintRegion": "Stormhill",
                "hintArea": "Warmaster's Shack"
            },
            {
                "replaces": "Bone Peddler's Bell Bearing",
                "hintRegion": "Stormhill",
                "hintArea": "Warmaster's Shack"
            },
            {
                "hintLandmark": "Stormgate",
                "hintRegion": "Stormhill",
                "hintArea": "Stormgate"
            }
        ]
    },
    "Stormveil Castle": {
        "hintRegion": "Stormveil Castle"
    },
    "Stranded Graveyard": {
        "hintRegion": "western Limgrave",
        "hintArea": "Fringefolk Hero's Grave",
        "exceptions": [
            {
                "replaces": "Haligdrake Talisman",
                "hintRegion": "western Limgrave",
                "hintArea": "Stranded Graveyard"
            },
            {
                "hintLandmark": "Stranded Graveyard",
                "hintRegion": "western Limgrave",
                "hintArea": "Stranded Graveyard"
            }
        ]
    },
    "Subterranean Shunning-Grounds": {
        "hintRegion": "the Subterranean Shunning-Grounds",
        "exceptions": [
            {
                "replaces": "Crimson Amber Medallion +2",
                "hintRegion": "the Subterranean Shunning-Grounds",
                "graphRegion": "the rafters of the Shunning-Grounds"
            },
            {
                "replaces": "Bloodflame Talons",
                "hintLandmark": "Cathedral of the Forsaken",
                "hintRegion": "the Subterranean Shunning-Grounds"
            },
            {
                "replaces": "Erdtree's Favor +1",
                "hintLandmark": "Cathedral of the Forsaken",
                "hintRegion": "the Subterranean Shunning-Grounds"
            },
            {
                "replaces": "Smithing Stone [6]",
                "hintLandmark": "Cathedral of the Forsaken",
                "hintRegion": "the Subterranean Shunning-Grounds"
            },
            {
                "hintLandmark": "Cathedral of the Forsaken",
                "hintRegion": "the Subterranean Shunning-Grounds",
                "graphRegion": "Frenzied Flame Proscription"
            },
            {
                "hintLandmark": "Frenzied Flame Proscription",
                "hintRegion": "the Subterranean Shunning-Grounds",
                "graphRegion": "Frenzied Flame Proscription"
            },
            {
                "NPC": "Lightseeker Hyetta",
                "hintRegion": "the Subterranean Shunning-Grounds",
                "graphRegion": "Frenzied Flame Proscription"
            },
            {
                "NPC": "Irina of Morne",
                "hintRegion": "the Weeping Peninsula"
            },
            {
                "replaces": "Crucible Scale Talisman",
                "hintLandmark": "Leyndell Catacombs",
                "hintRegion": "the Subterranean Shunning-Grounds",
                "hintArea": "Leyndell Catacombs"
            },
            {
                "replaces": "Ghost Glovewort [6]",
                "hintLandmark": "Leyndell Catacombs",
                "hintRegion": "the Subterranean Shunning-Grounds",
                "hintArea": "Leyndell Catacombs"
            },
            {
                "replaces": "Golden Rune [11]",
                "hintLandmark": "Leyndell Catacombs",
                "directions": "Near Leyndell Catacombs (Site of Grace) - "
                              "98.91 away in 8 o'clock direction, 5.75 height "
                              "offset",
                "hintRegion": "the Subterranean Shunning-Grounds",
                "hintArea": "Leyndell Catacombs"
            },
            {
                "replaces": "Lord of Blood's Exultation",
                "hintLandmark": "Leyndell Catacombs",
                "hintRegion": "the Subterranean Shunning-Grounds",
                "hintArea": "Leyndell Catacombs"
            },
            {
                "replaces": "Root Resin 4x",
                "hintLandmark": "Leyndell Catacombs",
                "hintRegion": "the Subterranean Shunning-Grounds",
                "hintArea": "Leyndell Catacombs"
            },
            {
                "replaces": "Sacramental Bud 2x",
                "hintLandmark": "Leyndell Catacombs",
                "hintRegion": "the Subterranean Shunning-Grounds",
                "hintArea": "Leyndell Catacombs"
            }
        ]
    },
    "Tombsward Catacombs": {
        "hintRegion": "the Weeping Peninsula",
        "hintArea": "Tombsward Catacombs"
    },
    "Tombsward Cave": {
        "hintRegion": "the Weeping Peninsula",
        "hintArea": "Tombsward Cave"
    },
    "Unsightly Catacombs": {
        "hintRegion": "Altus Plateau",
        "hintArea": "Unsightly Catacombs"
    },
    "Volcano Cave": {
        "hintRegion": "Mt. Gelmir",
        "hintArea": "Volcano Cave"
    },
    "Volcano Manor": {
        "hintRegion": "Volcano Manor",
        "exceptions": [
            {
                "NPC": "Knight Bernahl",
                "hintRegion": "Volcano Manor",
                "graphRegion": "Volcano Manor Drawing Rooms"
            },
            {
                "NPC": "Patches",
                "hintRegion": "Volcano Manor",
                "graphRegion": "Volcano Manor Entrance Hall"
            },
            {
                "replaces": "Consort's Mask",
                "hintRegion": "Volcano Manor"
            },
            {
                "NPC": "Tanith, Volcano Manor Proprietress",
                "hintRegion": "Volcano Manor",
                "graphRegion": "Volcano Manor Entrance Hall"
            },
            {
                "replaces": "Bloodhound Claws",
                "hintRegion": "Volcano Manor",
                "graphRegion": "Volcano Manor Drawing Rooms"
            },
            {
                "replaces": "Fireproof Dried Liver",
                "hintRegion": "Volcano Manor",
                "graphRegion": "Volcano Manor Drawing Rooms"
            },
            {
                "replaces": "Ash of War: Royal Knight's Resolve",
                "hintLandmark": "Volcano Manor",
                "hintRegion": "Volcano Manor"
            },
            {
                "replaces": "Commoner's Headband",
                "hintLandmark": "Volcano Manor",
                "hintRegion": "Volcano Manor"
            },
            {
                "replaces": "Man-Serpent Ashes",
                "hintLandmark": "Volcano Manor",
                "hintRegion": "Volcano Manor"
            },
            {
                "replaces": "Somber Smithing Stone [6]",
                "hintLandmark": "Volcano Manor",
                "hintRegion": "Volcano Manor"
            },
            {
                "replaces": "Ghiza's Wheel",
                "hintLandmark": "Volcano Manor",
                "hintRegion": "Volcano Manor",
                "graphRegion": "Volcano Manor Entrance Hall"
            },
            {
                "replaces": "Smithing Stone [6]",
                "hintLandmark": "Volcano Manor",
                "hintRegion": "Volcano Manor",
                "graphRegion": "Volcano Manor Entrance Hall"
            },
            {
                "hintLandmark": "Volcano Manor",
                "hintRegion": "Volcano Manor",
                "graphRegion": "Volcano Manor Drawing Rooms"
            }
        ]
    },
    "War-Dead Catacombs": {
        "hintRegion": "southern Caelid",
        "hintArea": "the War-Dead Catacombs"
    },
    "Weeping Peninsula - Beside the Crater-Pocked Glade, Oridys's Rise": {
        "hintRegion": "the Weeping Peninsula",
        "exceptions": [
            {
                "replaces": "Memory Stone",
                "hintRegion": "the Weeping Peninsula",
                "hintArea": "Oridys's Rise"
            }
        ]
    },
    "Weeping Peninsula - Bridge of Sacrifice, Forest Lookout Tower, Earthbore "
    "Cave Entrance": {
        "hintRegion": "the Weeping Peninsula",
        "exceptions": [
            {
                "hintLandmark": "Bridge of Sacrifice",
                "hintRegion": "the Weeping Peninsula",
                "hintArea": "the Bridge of Sacrifice"
            },
            {
                "hintLandmark": "Forest Lookout Tower",
                "hintRegion": "the Weeping Peninsula",
                "hintArea": "Forest Lookout Tower"
            },
            {
                "replaces": "Large Club",
                "hintRegion": "western Limgrave"
            },
            {
                "replaces": "Ruin Fragment 3x",
                "hintRegion": "western Limgrave"
            }
        ]
    },
    "Weeping Peninsula - Castle Morne": {
        "hintRegion": "Castle Morne's Ramparts",
        "hintArea": "Castle Morne",
        "exceptions": [
            {
                "replaces": "Golden Rune [1]",
                "hintRegion": "Castle Morne's Ramparts",
                "hintArea": "Castle Morne's Ramparts"
            }
        ]
    },
    "Weeping Peninsula - Castle Morne Approach North": {
        "hintRegion": "Castle Morne's Ramparts"
    },
    "Weeping Peninsula - Castle Morne Approach Northwest Cliffside": {
        "hintRegion": "the Weeping Peninsula"
    },
    "Weeping Peninsula - Castle Morne Approach South": {
        "hintRegion": "Castle Morne's Ramparts"
    },
    "Weeping Peninsula - Castle Morne Rampart, Ailing Village Outskirts": {
        "hintRegion": "the Weeping Peninsula",
        "exceptions": [
            {
                "hintLandmark": "Ailing Village",
                "hintRegion": "the Weeping Peninsula",
                "hintArea": "Ailing Village"
            },
            {
                "hintLandmark": "Callu Baptismal Church",
                "hintRegion": "the Weeping Peninsula",
                "hintArea": "Callu Baptismal Church"
            }
        ]
    },
    "Weeping Peninsula - Church of Pilgrimage, Demi-Human Forest Ruins": {
        "hintRegion": "the Weeping Peninsula",
        "hintArea": "Demi-Human Forest Ruins",
        "exceptions": [
            {
                "replaces": "Faith-knot Crystal Tear",
                "hintRegion": "the Weeping Peninsula",
                "hintArea": "the Weeping Peninsula"
            }
        ]
    },
    "Weeping Peninsula - Fourth Church of Marika, Witchbane Ruins": {
        "hintRegion": "the Weeping Peninsula",
        "hintArea": "Witchbane Ruins",
        "exceptions": [
            {
                "hintLandmark": "Fourth Church of Marika",
                "hintRegion": "the Weeping Peninsula",
                "hintArea": "the Fourth Church of Marika"
            },
            {
                "replaces": "Golden Rune [1]",
                "hintRegion": "the Weeping Peninsula",
                "hintArea": "the Weeping Peninsula"
            },
            {
                "replaces": "Golden Rune [5]",
                "hintRegion": "the Weeping Peninsula",
                "hintArea": "the Weeping Peninsula"
            }
        ]
    },
    "Weeping Peninsula - Impaler's Catacombs Entrance": {
        "hintRegion": "the Weeping Peninsula"
    },
    "Weeping Peninsula - Isolated Merchant's Shack": {
        "hintRegion": "the Weeping Peninsula",
        "exceptions": [
            {
                "NPC": "Merchant",
                "hintRegion": "the Weeping Peninsula",
                "hintArea": "Isolated Merchant's Shack"
            }
        ]
    },
    "Weeping Peninsula - Minor Erdtree, Tombsward Catacombs Entrance, Morne "
    "Tunnel Entrance": {
        "hintRegion": "the Weeping Peninsula",
        "exceptions": [
            {
                "hintLandmark": "Minor Erdtree",
                "hintRegion": "the Weeping Peninsula",
                "hintArea": "the Minor Erdtree"
            },
            {
                "replaces": "Golden Rune [2]",
                "directions": "Near Ailing Village (Marker) - 49.14 away in 9 "
                              "o'clock direction, -4.45 height offset",
                "hintRegion": "the Weeping Peninsula",
                "hintArea": "Ailing Village"
            }
        ]
    },
    "Weeping Peninsula - Morne Moangrave": {
        "hintRegion": "Castle Morne's Ramparts",
        "hintArea": "Castle Morne"
    },
    "Weeping Peninsula - Tombsward Ruins": {
        "hintRegion": "the Weeping Peninsula",
        "exceptions": [
            {
                "hintLandmark": "Church of Pilgrimage",
                "hintRegion": "the Weeping Peninsula",
                "hintArea": "the Church of Pilgrimage"
            },
            {
                "hintLandmark": "Tombsward Ruins",
                "hintRegion": "the Weeping Peninsula",
                "hintArea": "Tombsward Ruins"
            }
        ]
    },
    "Weeping Peninsula - Tombsward; Weeping Evergaol; Tombsward Cave "
    "Entrance": {
        "hintRegion": "the Weeping Peninsula",
        "exceptions": [
            {
                "hintLandmark": "Weeping Evergaol",
                "hintRegion": "the Weeping Peninsula",
                "hintArea": "Weeping Evergaol"
            }
        ]
    },
    "Weeping Peninsula - Tower of Return": {
        "hintRegion": "the Weeping Peninsula"
    },
    "West Consecrated Snowfield": {
        "hintRegion": "the Consecrated Snowfield"
    },
    "West Limgrave": {
        "hintRegion": "western Limgrave",
        "hintArea": "Gatefront Ruins"
    },
    "West Liurnia": {
        "hintRegion": "western Liurnia"
    },
    "Wyndham Catacombs": {
        "hintRegion": "Altus Plateau",
        "hintArea": "Wyndham Catacombs"
    },
    "Yelough Anix Tunnel": {
        "hintRegion": "the Consecrated Snowfield",
        "hintArea": "Yelough Anix Tunnel"
    }
}
