# Copyright (c) 2023 The Old Man and the C
#
# This file is part of Elden Ring Randomizer Hints.
#
# Elden Ring Randomizer Hints is free software: you can redistribute it and/or
# modify it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Elden Ring Randomizer Hints is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
# or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License
# for more details.
#
# You should have received a copy of the GNU Affero General Public License along
# with Elden Ring Randomizer Hints. If not, see <https://www.gnu.org/licenses/>.

hintNames = {
    "type": {
        "map": [
            "map",
            "chart",
            "atlas",
            "projection",
            "draft",
            "plan",
            "cartograph",
            "survey"
        ],
        "note": [
            "note",
            "letter",
            "missive",
            "paper",
            "scrap",
            "memorandum",
            "message",
            "report",
            "dispatch",
            "epistle",
            "record",
            "notation",
            "inscription"
        ],
        "scroll": [
            "scroll",
            "parchment",
            "scripture",
            "document",
            "manuscript",
            "log",
            "chronicle",
            "papyrus"
        ],
        "book": [
            "diary",
            "notebook",
            "album",
            "book",
            "tome",
            "codex",
            "volume",
            "tract",
            "treatise",
            "compendium",
            "folio",
            "account",
            "journal"
        ]
    },
    "adjectives": {
        "GENERIC_MAP_WORN": [
            "torn",
            "worn",
            "weathered",
            "dusty",
            "faded",
            "fragile",
            "frayed",
            "ragged",
            "tattered",
            "wrinkled",
            "curling",
            "stained"
        ],
        "GENERIC_NOTE_WORN": [
            "torn",
            "worn",
            "weathered",
            "dusty",
            "faded",
            "fragile",
            "frayed",
            "ragged",
            "tattered",
            "wrinkled",
            "curling",
            "stained"
        ],
        "GENERIC_BOOK_WORN": [
            "torn",
            "worn",
            "weathered",
            "dusty",
            "faded",
            "fragile",
            "frayed",
            "ragged",
            "tattered",
            "stained"
        ],
    },
    "ownerGroups": {
        "GENERIC_OWNER_ADJECTIVE": [
            "dead",
            "lost",
            "forgotten",
            "nameless",
            "helpless",
            "hopeless",
            "abandoned"
        ],
        "GENERIC_OWNER": [
            "person",
            "woman",
            "man",
            "soul",
            "wanderer",
            "orphan",
            "wretch"
        ],
        "GROUP_STR": [
            "GROUP_AXE",
            "GROUP_COLOSSAL_WEAPON",
            "GROUP_CURVED_SWORD",
            "GROUP_FIST",
            "GROUP_FLAIL",
            "GROUP_HALBERD",
            "GROUP_HAMMER",
            "GROUP_SPEAR",
            "GROUP_GREAT_SPEAR",
            "GROUP_STRAIGHT_SWORD"
        ],
        "GROUP_DEX": [
            "GROUP_AXE",
            "GROUP_BOW",
            "GROUP_CLAW",
            "GROUP_CURVED_SWORD",
            "GROUP_DAGGER",
            "GROUP_FIST",
            "GROUP_FLAIL",
            "GROUP_HALBERD",
            "GROUP_KATANA",
            "GROUP_REAPER",
            "GROUP_SPEAR",
            "GROUP_GREAT_SPEAR",
            "GROUP_STRAIGHT_SWORD",
            "GROUP_THRUSTING_SWORD",
            "GROUP_TWINBLADE",
            "GROUP_WHIP",
            "GROUP_HOLY",
            "GROUP_MAGIC",
        ],
        "GROUP_END": [
            "GROUP_AXE",
            "GROUP_BALLISTA",
            "GROUP_COLOSSAL_WEAPON",
            "GROUP_CURVED_SWORD",
            "GROUP_HALBERD",
            "GROUP_HAMMER",
            "GROUP_REAPER"
        ],
        "GROUP_MIN": [
            "GROUP_MAGIC",
            "GROUP_HOLY",
            "GROUP_SPIRIT_TUNER",
            "GROUP_GOLDEN_ORDER",
            "GROUP_ROAR",
            "GROUP_BEAST",
            "GROUP_DRAGON",
            "GROUP_LIGHTNING",
            "GROUP_GRAVITY",
            "GROUP_MADNESS",
            "GROUP_DEATH"
        ],
        "GROUP_INT": [
            "GROUP_MAGIC"
        ],
        "GROUP_FAI": [
            "GROUP_HOLY"
        ],
        "GROUP_ARC": [
            "GROUP_GREED",
            "GROUP_BLOOD",
            "GROUP_POISON",
            "GROUP_SLEEP",
            "GROUP_MADNESS",
            "GROUP_MAGIC",
            "GROUP_DRAGON"
        ],
        "GROUP_CLOTHING": [
            "Commoner",
            "Peasant",
            "Merchant",
            "Lesser Noble",
            "Traveler",
            "Farmer",
            "Worker",
            "Arisocrat",
            "Trader"
        ],
        "GROUP_LIGHT_ARMOR": [
            "GROUP_DAGGER",
            "GROUP_TWINBLADE",
            "GROUP_THRUSTING_SWORD",
            "GROUP_FIST",
            "GROUP_CLAW",
            "GROUP_WHIP",
            "GROUP_BOW"
        ],
        "GROUP_MEDIUM_ARMOR": [
            "GROUP_STRAIGHT_SWORD",
            "GROUP_CURVED_SWORD",
            "GROUP_KATANA",
            "GROUP_SPEAR",
            "GROUP_REAPER",
            "GROUP_CROSSBOW"
        ],
        "GROUP_HEAVY_ARMOR": [
            "GROUP_HAMMER",
            "GROUP_AXE",
            "GROUP_FLAIL",
            "GROUP_GREAT_SPEAR",
            "GROUP_HALBERD",
            "GROUP_COLOSSAL_WEAPON",
            "GROUP_BALLISTA"
        ],
        "GROUP_KNIGHT": [
            "Knight",
            "Hedge Knight",
            "Black Knight",
            "Paladin",
            "Crusader",
            "White Knight",
            "Pureblood Knight"
        ],
        "GROUP_MERCHANT": [
            "Merchant",
            "Nomadic Merchant",
            "Trader",
            "Wandering Trader",
            "Shopkeeper",
            "Factor"
        ],
        "GROUP_ENTERTAINER": [
            "Bard",
            "Entertainer",
            "Actor",
            "Mummer",
            "Performer",
            "Troubadour"
        ],
        "GROUP_RECUSANT": [
            "Recusant",
            "Serpent-Follower",
            "Rebel",
            "Tarnished-Hunter",
            "Manorsworn"
        ],
        "GROUP_LORD": [
            "Runeseeker",
            "Tarnished",
            "Lordling",
            "Woman of Ambition",
            "Man of Ambition",
            "Ambitious Person",
            "Throneseeker"
        ],
        "GROUP_EXPLORER": [
            "Explorer",
            "Traveler",
            "Cartographer",
            "Adventurer",
            "Archaeologist",
            "Wanderer",
            "Pathfinder",
            "Guide"
        ],
        "GROUP_SMITH": [
            "Blacksmith",
            "Smith",
            "Weaponcrafter",
            "Artisan",
            "Craftswoman",
            "Craftsman",
            "Tinkerer"
        ],
        "GROUP_RECOVERY": [
            "Healer",
            "Physician",
            "Physicker",
            "Leech",
            "Nurse",
            "Bonesetter",
            "Mender",
            "Medicine Woman",
            "Medicine Man"
        ],
        "GROUP_GREED": [
            "Serpent-kin",
            "Hoarder",
            "Glutton",
            "Miser",
            "Skinflint",
            "Scrounger"
        ],
        "GROUP_SPIRIT_TUNER": [
            "Spirit Tuner",
            "Medium",
            "Shaman",
            "Sensitive",
            "Seer",
            "Fortune Teller",
            "Spirit Guide"
        ],
        "GROUP_POTTER": [
            "Potter",
            "Living Jar",
            "Clayshaper",
            "Kilnworker",
            "Warrior Jar",
            "Kilnmaster",
            "Master Potter"
        ],
        "GROUP_PERFUMER": [
            "Perfumer",
            "Depraved Perfumer",
            "Scent Artist",
            "Sommelier",
            "Apothecary",
            "Perfume Artist",
            "Mistress of Perfumes",
            "Master of Perfumes"
        ],
        "GROUP_GOLDEN_ORDER": [
            "Golden Order Acolyte",
            "Fundamentalist",
            "Adherent of the Golden Order",
            "Golden Order Priestess",
            "Golden Order Priest",
            "Golden Order Ascetic",
            "Ordersworn"
        ],
        "GROUP_ROAR": [
            "Berserker",
            "Howling Warrior",
            "Mighty Warrior",
            "Howler",
            "Bullroarer"
        ],
        "GROUP_BEAST": [
            "Beast",
            "Man-Beast",
            "Lycanthrope",
            "Lycan",
            "Beastwoman",
            "Beastman"
        ],
        "GROUP_DRAGON": [
            "Dragon-born",
            "Dragon Worshipper",
            "Drake Knight",
            "Dragon Priestess",
            "Dragon Priest",
            "Crucible Knight",
            "Dragon Follower"
        ],
        "GROUP_DEFENSE": [
            "Shieldmaiden",
            "Shieldman",
            "Castellan",
            "Defender",
            "Guard",
            "Protector",
            "Guardian"
        ],
        "GROUP_OFFENSE": [
            "Warrior",
            "Fighter",
            "Killer",
            "Attacker",
            "Berserker",
            "Fury",
            "Shock Trooper",
            "Vanguard",
            "Frontliner"
        ],
        "GROUP_STEALTH": [
            "Spy",
            "Ninja",
            "Assassin",
            "Footpad",
            "Thief",
            "Sneak",
            "Rogue",
            "Shadow",
            "Prowler"
        ],
        "GROUP_FIRE": [
            "Pyromaniac",
            "Pyromancer",
            "Flame Nun",
            "Flame Monk",
            "Fire Worshipper",
            "Flame Worshipper",
            "Frenzied",
            "Fire Mistress",
            "Fire Master",
            "Flame Mistress",
            "Flame Master",
            "Follower of Fire",
            "Follower of Flame",
            "Burner",
            "Arsonist"
        ],
        "GROUP_MAGIC": [
            "Magician",
            "Mage",
            "Sorcerer",
            "Wizard",
            "Spellcaster",
            "Magi",
            "Sage",
            "Astrologer",
            "Magus",
            "Witch",
            "Thaumaturge",
            "Warlock"
        ],
        "GROUP_LIGHTNING": [
            "Spark",
            "Thunder Priestess",
            "Thunder Priest",
            "Electrick Mage",
            "Electrick Magi",
            "Conjurer of Lightning",
            "Storm Sorcerer",
            "Storm Warlock",
            "Storm Witch",
            "Ancient Dragon"
        ],
        "GROUP_HOLY": [
            "Priestess",
            "Priest",
            "Bishop",
            "Cardinal",
            "Pontiff",
            "Acolyte",
            "Worshipper",
            "Pious",
            "Holy One",
            "Holy Woman",
            "Holy Man"
        ],
        "GROUP_GRAVITY": [
            "Fallingstar Thaumaturge",
            "Gravity Bender",
            "Massbender",
            "Mistress of Gravity",
            "Master of Gravity",
            "Fallingstar Sage"
        ],
        "GROUP_POISON": [
            "Poisoner",
            "Alchemist",
            "Assassin",
            "Envenomed",
            "Poison Mistress",
            "Poison Master",
            "Harvester of Poisons"
        ],
        "GROUP_ROT": [
            "Rotted",
            "Child of Rot",
            "Blighted",
            "Corrupted",
            "Priestess of Rot",
            "Priest of Rot",
            "Worshipper of Rot",
            "Unclean",
            "Follower of the Rot Goddess"
        ],
        "GROUP_BLOOD": [
            "Bloodletter",
            "Vampire",
            "Blood Cultist",
            "Dismemberer",
            "Sanguine Noble",
            "Pureblood Knight",
            "Mohgwyn Retainer",
            "Mohgwyn Servant",
            "Priestess of Blood",
            "Priest of Blood"
        ],
        "GROUP_FROST": [
            "Snow Witch",
            "Snow Warlock",
            "Frozen Soul",
            "Follower of Ranni",
            "Follower of the Snow Witch",
            "Frost Giant",
            "Ice Troll",
            "Invoker of Frost"
        ],
        "GROUP_SLEEP": [
            "Follower of St. Trina",
            "St. Trina's Worshipper",
            "Somnambulist",
            "Narcoleptic",
            "Sandman",
            "Insomniac"
        ],
        "GROUP_MADNESS": [
            "Maddened",
            "Madwoman",
            "Madman",
            "Frenzied",
            "Pyromaniac",
            "Burner",
            "Berserker"
        ],
        "GROUP_DEATH": [
            "Mariner",
            "Necromancer",
            "Death Cultist",
            "Death Priestess",
            "Death Priest",
            "Dark Priestess",
            "Dark Priest",
            "Lich",
            "Wight"
        ],
        "GROUP_WEAPONS": [
            "GROUP_MELEE_WEAPONS",
            "GROUP_RANGED_WEAPONS"
        ],
        "GROUP_MELEE_WEAPONS": [
            "GROUP_DAGGER",
            "GROUP_STRAIGHT_SWORD",
            "GROUP_CURVED_SWORD",
            "GROUP_KATANA",
            "GROUP_TWINBLADE",
            "GROUP_THRUSTING_SWORD",
            "GROUP_HAMMER",
            "GROUP_AXE",
            "GROUP_FLAIL",
            "GROUP_SPEAR",
            "GROUP_GREAT_SPEAR",
            "GROUP_HALBERD",
            "GROUP_REAPER",
            "GROUP_FIST",
            "GROUP_CLAW",
            "GROUP_WHIP",
            "GROUP_COLOSSAL_WEAPON"
        ],
        "GROUP_RANGED_WEAPONS": [
            "GROUP_BOW",
            "GROUP_CROSSBOW",
            "GROUP_BALLISTA"
        ],
        "GROUP_DAGGER": [
            "Ninja",
            "Assassin",
            "Footpad",
            "Thief",
            "Rogue",
            "Shanker",
            "Cutthroat"
        ],
        "GROUP_STRAIGHT_SWORD": [
            "Swordswoman",
            "Swordsman",
            "Soldier",
            "Mercenary"
        ],
        "GROUP_CURVED_SWORD": [
            "Pirate",
            "Dervish",
            "Sword Dancer",
            "Raider",
            "Nomad"
        ],
        "GROUP_KATANA": [
            "Samurai",
            "Kendoka",
            "Daimyo",
            "Shogun",
            "Ronin"
        ],
        "GROUP_TWINBLADE": [
            "Blademistress",
            "Blademaster",
            "Sword Nun",
            "Sword Monk",
        ],
        "GROUP_THRUSTING_SWORD": [
            "Fencer",
            "Duelist",
            "Swashbuckler",
            "Matador"
        ],
        "GROUP_HAMMER": [
            "Hammermaid",
            "Hammerman",
            "Shock Trooper",
            "Soldier",
            "Mercenary",
            "Gladiator"
        ],
        "GROUP_AXE": [
            "Axemaiden",
            "Axeman",
            "Executioner",
            "Mercenary",
            "Gladiator"
        ],
        "GROUP_FLAIL": [
            "Crusader",
            "Black Knight",
            "Flailmaiden",
            "Flailman",
            "Dark Rider"
        ],
        "GROUP_SPEAR": [
            "Spearwoman",
            "Spearman",
            "Hoplite",
            "Soldier"
        ],
        "GROUP_GREAT_SPEAR": [
            "Knight",
            "Lancer",
            "Spearwoman",
            "Spearman",
        ],
        "GROUP_HALBERD": [
            "Guardswoman",
            "Guardsman",
            "Soldier",
            "Guard",
            "Halbderdier",
            "Guisarmier"
        ],
        "GROUP_REAPER": [
            "Reaper",
            "Thresher",
            "Harvester",
            "Death Cultist",
            "Scythewoman",
            "Scytheman"
        ],
        "GROUP_FIST": [
            "Brute",
            "Boxer",
            "Pugilist",
            "Gladiator",
            "Fighter"
        ],
        "GROUP_CLAW": [
            "Ninja",
            "Bloodhound Knight",
            "Tiger Warrior",
            "Claw Wrestler"
        ],
        "GROUP_WHIP": [
            "Gladiator",
            "Cattlewoman",
            "Cattleman",
            "Drover"
        ],
        "GROUP_COLOSSAL_WEAPON": [
            "Giant",
            "Titan",
            "Godling",
            "Demigod",
            "Troll"
        ],
        "GROUP_BOW": [
            "Archer",
            "Bowmaid",
            "Bowman",
            "Artillerist",
            "Sharpshooter",
            "Sniper",
            "Ranger",
            "Scout",
            "Soldier",
            "Mercenary"
        ],
        "GROUP_CROSSBOW": [
            "Artillerist",
            "Sharpshooter",
            "Sniper",
            "Ranger",
            "Scout",
            "Soldier",
            "Mercenary"
        ],
        "GROUP_BALLISTA": [
            "Artillerist",
            "Sniper",
            "Ranger",
            "Soldier",
            "Mercenary"
        ]
    }
}
