# Copyright (c) 2023 The Old Man and the C
#
# This file is part of Elden Ring Randomizer Hints.
#
# Elden Ring Randomizer Hints is free software: you can redistribute it and/or
# modify it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Elden Ring Randomizer Hints is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
# or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License
# for more details.
#
# You should have received a copy of the GNU Affero General Public License along
# with Elden Ring Randomizer Hints. If not, see <https://www.gnu.org/licenses/>.

# Church of Elleh - Smithing Stone [1], lot 1042360060 - on the anvil

questHints = [
    {
        "lotID": "100010",
        "hintItems": ["Rold Medallion"],
        "hintName": "Melina's Guidance",
        "hintDescription": "Melina's Guidance.\nA way to reach the forbidden "
                           "flame, given by Melina, so that she might burn "
                           "away the Erdtree's thorns.",
        "hintIconTypes": ["note", "map"]
    },
    {
        "lotID": "101300",
        "hintItems": ["Haligtree Secret Medallion (Right)"],
        "hintName": "Plea from Old Albus",
        "hintDescription": "Plea from Old Albus.\nA request from an aged "
                           "Albinauric to find and deliver an important "
                           "treasure to his kin.",
        "hintIconTypes": ["note", "map"]
    },
    {
        "lotID": "111300",
        "hintItems": ["Haligtree Secret Medallion (Right)"],
        "hintName": "Plea from Old Albus",
        "hintDescription": "Plea from Old Albus.\nA request from an aged "
                           "Albinauric to find and deliver an important "
                           "treasure to his kin.",
        "hintIconTypes": ["note", "map"]
    },
    {
        "lotID": "104100",
        "hintItems": ["Latenna the Albinauric",
                      "Haligtree Secret Medallion (Left)"],
        "hintName": "Latenna's Request",
        "hintDescription": "Latenna's Request.\nThe last request of an "
                           "Albinauric archer to carry her spirit to the "
                           "Haligtree.",
        "hintIconTypes": ["map"]
    },


    {
        "lotID": "101700",
        "hintItems": ["Nomadic Warrior's Cookbook [17]", "Melted Mushroom"],
        "hintName": "Pot Cleaning and Care",
        "hintDescription": "Pot Cleaning and Care.\nA manual about how to keep "
                           "pots clean and well seasoned.",
        "hintIconTypes": ["book"]
    },
    {
        "lotID": "101740",
        "hintItems": ["Alexander's Innards"],
        "hintName": "Alexander's Bequest",
        "hintDescription": "Alexander's Bequest.\nThe last will and testament "
                           "of Iron Fist Alexander, to bear his brave innards "
                           "home.",
        "hintIconTypes": ["scroll"]
    },
    

    {
        "lotID": "102710",
        "hintItems": ["Sewing Needle"],
        "hintName": "Boc's Note",
        "hintDescription": "Boc's Note.\nThe location of a sewing needle "
                           "belonging to Boc's mother.",
        "hintIconTypes": ["note"]
    },
    {
        "lotItems": ["Sewing Needle"],
        "hintItems": ["Gold Sewing Needle"],
        "hintName": "Journal of a Seamstress",
        "hintDescription": "Journal of a Seamstress.\nA faded journal with a "
                           "hint to a sewing needle worthy of a god's attire.",
        "hintIconTypes": ["book"],
        "altHintName": "Boc's Note"
    },
    {
        "lotItems": ["Gold Sewing Needle"],
        "hintItems": ["Prattling Pate \"You're beautiful\""],
        "hintName": "A Mother's Keepsake",
        "hintDescription": "A Mother's Keepsake.\nA note with a message of "
                           "love from a mother to her son.",
        "hintIconTypes": ["note"],
        "altHintName": "Boc's Note"
    },

    {
        "lotID": "11000940",
        "hintItems": ["Law of Regression"],
        "hintName": "Royal Sculptor's Draft",
        "hintDescription": "Royal Sculptor's Draft.\nA Draft notes on a "
                           "project by a famed sculptor, cleverly encoding "
                           "hidden knowledge.",
        "hintIconTypes": ["book"]
    },
    {
        "lotID": "4900",
        "hintItems": ["Mending Rune of Perfect Order"],
        "hintName": "The Noble's Meditation",
        "hintDescription": "The Noble's Meditation.\nA musing to correct the "
                           "world from The Enlightened Goldmask.",
        "hintIconTypes": ["scroll"]
    },


    {
        "lotID": "103800",
        "hintItems": ["Sewer-Gaol Key"],
        "hintName": "Scrap from the Dung Eater",
        "hintDescription": "Scrap from the Dung Eater.\nFilthy scrap of paper "
                           "with the location of a key to his cell.",
        "hintIconTypes": ["note"]
    },
    {
        "lotItems": ["Seedbed Curse"],
        "roundRobin": True,
        "hintName": "Gloating of the Dung Eater",
        "hintDescription": "Gloating of the Dung Eater.\nCruel boasting from "
                           "the Dung Eater about the people he has tortured "
                           "and cursed.",
        "hintIconTypes": ["note"]
    },
    {
        "lotID": "4920",
        "hintItems": ["Mending Rune of the Fell Curse"],
        "hintName": "The Cursed-one's Hatred",
        "hintDescription": "The Cursed-one's Hatred.\nA lust to curse the "
                           "world from the loathsome Dung Eater.",
        "hintIconTypes": ["note"]
    },


    {
        "lotID": "103340",
        "hintItems": ["Black Knifeprint"],
        "hintName": "Fia's Clue",
        "hintDescription": "Fia's Clue.\nA clue to the location of a Black "
                           "Knifeprint for Rogier.",
        "hintIconTypes": ["map", "note"]
    },
    {
        "lotID": "103310",
        "hintItems": ["Weathered Dagger"],
        "hintName": "Fia's Charge",
        "hintDescription": "Fia's Charge.\nThe location of a dagger she wishes "
                           "to see reunited with its owner.",
        "hintIconTypes": ["book", "scroll"]
    },
    {
        "lotID": "103590",
        "hintItems": ["Cursemark of Death"],
        "hintName": "Rogier's Discovery",
        "hintDescription": "Rogier's Discovery.\nThe fruition of Rogier's "
                           "research.",
        "hintIconTypes": ["book", "scroll"]
    },
    {
        "lotID": "103350",
        "hintItems": ["Mending Rune of the Death-Prince"],
        "hintName": "The Deathmother's Wish",
        "hintDescription": "The Deathmother's Wish.\nA wish to mend the world "
                           "from Fia, Mother of Death.",
        "hintIconTypes": ["scroll"]
    },


    {
        "lotID": "100500",
        "hintItems": ["Rusty Key"],
        "hintName": "The Gatekeeper's Secret",
        "hintDescription": "The Gatekeeper's Secret.\nCraven gatekeeper's "
                           "admission of the location of a key that unlocks "
                           "the side passage of Stormveil.",
        "hintIconTypes": ["note"]
    },


    {
        "lotID": "1048380500",
        "hintItems": ["Unalloyed Gold Needle (Broken)"],
        "hintName": "Account of the Rotted",
        "hintDescription": "Account of the Rotted.\nA desperately penned tale "
                           "of a gold needle said to be able to quell the "
                           "scarlet rot."
    },
    # Gowry (initial shop): 100175
    {
        "lotID": "103100",
        "hintItems": ["Unalloyed Gold Needle (Fixed)"],
        "hintName": "Sage Gowry's Advice",
        "hintDescription": "Sage Gowry's Advice.\nAdvice from Sage Gowry on "
                           "where to find the repaired needle.",
        "hintIconTypes": ["scroll"]
    },
    # {
    #     "lotID": "103200",
    #     "hintItems": ["Valkyrie's Prosthesis"],
    #     "hintName": "Gift from Millicent",
    #     "hintDescription": "Gift from Millicent.\nGuide to a treasure that "
    #                        "Millicent no longer remembers.",
    #     "hintIconTypes": ["map"]
    # },
    {
        "lotID": "100175",
        "hintItems": ["Valkyrie's Prosthesis"],
        "hintName": "Gift for Millicent",
        "hintDescription": "Gift for Millicent.\nGuide to a treasure that "
                           "Sage Gowry wishes for Millicent to have.",
        "hintIconTypes": ["map"],
        "shopValue": "0"
    },
    {
        "lotID": "103210",
        "hintItems": ["Unalloyed Gold Needle (Milicent)"],
        "hintName": "Millicent's Legacy",
        "hintDescription": "Millicent's Legacy.\nMillicent's final words "
                           "telling the fate of the golden needle.",
        "hintIconTypes": ["scroll"]
    },
    {
        "lotID": "113210",
        "hintItems": ["Unalloyed Gold Needle (Milicent)"],
        "hintName": "Millicent's Legacy",
        "hintDescription": "Millicent's Legacy.\nMillicent's final words "
                           "telling the fate of the golden needle.",
        "hintIconTypes": ["scroll"]
    },
    {
        "lotID": "103240",
        "hintItems": ["Miquella's Needle"],
        "hintName": "Empyrian's Myth",
        "hintDescription": "Empyrian's Myth.\nCantos about soothing the flames "
                           "of chaos.",
        "hintIconTypes": ["book"]
    },


    {
        "lotID": "100126",
        "hintItems": ["Deathroot"],
        "hintNumber": 4,
        "excludeShop": True,
        "hintName": "D's Targets",
        "hintDescription": "D's Targets.\nList of targets possessing Deathroot "
                           "discovered by D.",
        "shopValue": "1500"
    },
    {
        "lotItems": ["Deathroot"],
        "roundRobin": True,
        "hintName": "Mariner's Log",
        "hintDescription": "Mariner's Log.\nDeathroot planting log of a "
                           "mariner who lives in death.",
        "hintIconTypes": ["book", "scroll", "map"]
    },

    {
        "lotID": "103400",
        "hintItems": ["Twinned Helm", "Twinned Armor", "Twinned Gauntlets",
                      "Twinned Greaves"],
        "hintName": "Bequest of a Twin",
        "hintDescription": "Bequest of a Twin.\nLocations of the scattered "
                           "pieces of D's armor, as a request to return them "
                           "to his brother.",
        "hintIconTypes": ["map", "note"]
    },

    {
        "lotID": "100800",
        "hintItems": ["Irina's Letter"],
        "hintName": "Irina's Directions",
        "hintDescription": "Irina's Directions.\nThe last known location of "
                           "Irina's letter to her father.",
        "hintIconTypes": ["map", "note"]
    },
    {
        "lotID": "110800",
        "hintItems": ["Irina's Letter"],
        "hintName": "Irina's Directions",
        "hintDescription": "Irina's Directions.\nThe last known location of "
                           "Irina's letter to her father.",
        "hintIconTypes": ["map", "note"]
    },
    {
        "lotID": "110810",
        "hintItems": ["Irina's Letter"],
        "hintName": "Irina's Directions",
        "hintDescription": "Irina's Directions.\nThe last known location of "
                           "Irina's letter to her father.",
        "hintIconTypes": ["map", "note"]
    },
    {
        "lotID": "100610",
        "hintItems": ["Shabriri Grape", "Fingerprint Grape"],
        "excludeShop": True,
        "hintName": "Edgar's Lamentation",
        "hintDescription": "Edgar's Lamentation.\nRavings of the "
                           "grief-maddened Castellan of Castle Morne, "
                           "describing where he tore out his eye."
    },
    {
        "lotID": "110620",
        "hintItems": ["Shabriri Grape", "Fingerprint Grape"],
        "excludeShop": True,
        "hintName": "Edgar's Lamentation",
        "hintDescription": "Edgar's Lamentation.\nRavings of the "
                           "grief-maddened Castellan of Castle Morne, "
                           "describing where he tore out his eye."
    },
    {
        "lotItems": ["Shabriri Grape", "Fingerprint Grape"],
        "roundRobin": True,
        "hintName": "Frenzied's Prayer",
        "hintDescription": "Frenzied's Prayer.\nAn entreaty from one "
                           "afflicted with frenzy for the Lightseeker to "
                           "consume their eye.",
        "hintIconTypes": ["note", "book", "scroll"]
    },


    {
        "lotID": "30225",
        "hintItems": ["The Stormhawk King"],
        "hintName": "The Falconer's Treatise",
        "hintDescription": "The Falconer's Treatise.\nA royal falconer's "
                           "account of a spirit hawk with an indomitable will.",
        "hintIconTypes": ["book"]
    },


    {
        "lotID": "101400",
        "hintItems": ["Seluvis's Potion"],
        "hintName": "Assignment from Seluvis",
        "hintDescription": "Assignment from Seluvis.\nDirections to a potion "
                           "that can enthrall the consumer.",
        "hintIconTypes": ["scroll"]
    },
    {
        "lotID": "101430",
        "hintItems": ["Seluvis's Introduction"],
        "hintName": "Seluvis's Orders",
        "hintDescription": "Seluvis's Orders.\nInstructions to obtain a "
                           "letter of introduction to Sorceress Sellen.",
        "hintIconTypes": ["scroll"]
    },
    {
        "lotID": "1034500100",
        "hintItems": ["Starlight Shards"],
        "hintNumber": 4,
        "hintName": "Preceptor's Notes",
        "hintDescription": "Preceptor's Notes.\nNotes on locations of shards "
                           "of starlight needed for Seluvis's private "
                           "projects.",
        "hintIconTypes": ["scroll"],
    },
    # Pidia: 100325
    # Pidia (Weathered Map): 100340
    # item next to Pidia, lot 1035500110
    {
        "lotID": "100340",
        "hintItems": ["Amber Starlight"],
        "hintName": "Pidia's Research",
        "hintDescription": "Pidia's Research.\nDiscovery of the Amber "
                           "Starlight sought by Pidia's master.",
        "shopValue": "5000"
    },
    {
        "lotID": "101450",
        "hintItems": ["Amber Draught"],
        "hintName": "Seluvis's Conspiracy",
        "hintDescription": "Seluvis's Conspiracy.\nReveals the place of "
                           "Preceptor Seluvis's potion that can tame an "
                           "empyrean.",
        "hintIconTypes": ["scroll"]
    },
    {
        "lotID": "12020080",
        "hintItems": ["Fingerslayer Blade"],
        "hintName": "Doctrine of Nokron",
        "hintDescription": "Doctrine of Nokron.\nThe hiding place of the "
                           "eldritch weapon crafted by Nokron in its "
                           "rebellion against the Greater Will.",
        "hintIconTypes": ["scroll"]
    },
    {
        "lotID": "1034510900",
        "hintItems": ["Miniature Ranni"],
        "hintName": "Renna's Secret",
        "hintDescription": "Renna's Secret.\nLocation of a hidden doll "
                           "created by Ranni's mentor.",
        "hintIconTypes": ["scroll"]
    },
    # {
    #     "lotID": "101590",
    #     "hintItems": ["Dark Moon Ring"],
    #     "hintName": "Confession of a Shadow",
    #     "hintDescription": "Confession of a Shadow.\nConfession of a "
    #                        "conflicted thief about his theft of an "
    #                        "empyrean's bauble.",
    #     "hintIconTypes": ["note", "map"]
    # },
    # added this because sometimes Baleful Shadow won't drop
    {
        "lotItems": ["Miniature Ranni"],
        "hintItems": ["Dark Moon Ring"],
        "hintName": "Dark Moon's Coda",
        "hintDescription": "Dark Moon's Coda.\nA ceremony for the ascension "
                           "of an empyrean under the auspices of the dark "
                           "moon.",
        "hintIconTypes": ["book"],
        "altLotID": "1034510900",
    },

    {
        "lotID": "101900",
        "hintItems": ["Chrysalids' Memento"],
        "hintName": "Forlorn Maiden's Message",
        "hintDescription": "Forlorn Maiden's Message.\nDirections to the last "
                           "known location of the guardians of a lost lady.",
        "hintIconTypes": ["note", "map"]
    },

    # Blackguard (Necklace): 100150
    # Blackguard (Prawn): 100160 eventFlag_forRelease: 1036439209
    # Blackguard (Crab): 100155 eventFlag_forRelease: 1044529255
    {
        "lotID": "100160",
        "hintItems": ["Rya's Necklace", "Seedbed Curse"],
        "hintName": "Blackguard's Map",
        "excludeShop": True,
        "hintDescription": "Blackguard's Map.\nMap to a stolen treasure, also "
                           "with markings in a different place warning about "
                           "a terrifying villain.",
        "hintIconTypes": ["map"],
        "shopValue": "0"
    },
    # {
    #     "lotID": "1036420000",    # tear basin southwest of Boilprawn Shack
    #     "hintItems": ["Rya's Necklace"],
    #     "hintName": "Blackguard's Map",
    #     "hintDescription": "Blackguard's Map.\nTreasure map to a stolen "
    #                        "piece of jewelry.",
    #     "hintIconTypes": ["map"]
    # },
    {
        "lotID": "100900",
        "hintItems": ["Volcano Manor Invitation"],
        "hintName": "Scout's Briefing",
        "hintDescription": "Scout's Briefing.\nScout Rya's instructions to a "
                           "letter of invitation."
    },
    {
        "lotID": "1039530700",  # Rileigh the Idle drop
        "hintItems": ["Serpent's Amnion"],
        "hintName": "Eiglay's Revelation",
        "hintDescription": "Eiglay's Revelation.\nA serpent worshipper's "
                           "scripture about a failed foul ritual that birthed "
                           "an innocent instead of a monster.",
        "hintIconTypes": ["book", "scroll"]
    },
    {
        "lotID": "100720",
        "hintItems": ["Drawing-Room Key"],
        "hintName": "Lady Tanith's Offer",
        "hintDescription": "Lady Tanith's Offer.\nThe whereabouts of the key "
                           "needed to join Volcano Manor.",
        "hintIconTypes": ["scroll"]
    },
    {
        "lotID": "100730",
        "hintItems": ["Letter from Volcano Manor (Istvan)"],
        "hintName": "Lady Tanith's Instructions",
        "hintDescription": "Lady Tanith's Instructions.\nThe location of a "
                           "letter which has an assignment from Lady Tanith.",
        "hintIconTypes": ["map"]
    },
    {
        "lotID": "100740",
        "hintItems": ["Letter from Volcano Manor (Rileigh)"],
        "hintName": "Lady Tanith's Instructions",
        "hintDescription": "Lady Tanith's Instructions.\nThe location of a "
                           "letter which has an assignment from Lady Tanith.",
        "hintIconTypes": ["map"]
    },
    {
        "lotID": "102900",
        "hintItems": ["Letter to Bernahl"],
        "hintName": "Bernahl's Note",
        "hintDescription": "Bernahl's Note.\nThe location of a letter which "
                           "has an assignment from Lady Tanith.",
        "hintIconTypes": ["note"]
    },
    {
        "lotID": "101800",
        "hintItems": ["Letter to Patches"],
        "hintName": "Patches' Tip",
        "hintDescription": "Patches' Tip.\nThe location of a letter which "
                           "has an assignment from Lady Tanith.",
        "hintIconTypes": ["note"]
    },
    {
        "lotID": "100750",
        "hintItems": ["Red Letter"],
        "hintName": "Lady Tanith's Instructions",
        "hintDescription": "Lady Tanith's Instructions.\nThe location of a "
                           "letter which has an assignment from Lady Tanith.",
        "hintIconTypes": ["map"]
    },
    {
        "lotID": "100700",
        "hintItems": ["Tonic of Forgetfulness"],
        "hintName": "A Mother's Admission",
        "hintDescription": "A Mother's Admission.\nTanith's creation of a "
                           "potion to protect her adopted daughter from a "
                           "cruel truth.",
        "hintIconTypes": ["note"]
    },
    {
        "lotID": "100726",
        "hintItems": ["Tonic of Forgetfulness"],
        "hintName": "A Mother's Admission",
        "hintDescription": "A Mother's Admission.\nTanith's creation of a "
                           "potion to protect her adopted daughter from a "
                           "cruel truth.",
        "hintIconTypes": ["note"]
    },
    {
        "lotID": "100910",
        "hintItems": ["Zorayas's Letter"],
        "hintName": "The Snake-Maiden's Farewell",
        "hintDescription": "The Snake-Maiden's Farewell.\nA slip from Zorayas "
                           "about her preparations for a journey.",
        "hintIconTypes": ["note"]
    },
    {
        "lotID": "101810",
        "hintItems": ["Dancer's Castanets"],
        "hintName": "Entreaty from Patches",
        "hintDescription": "Entreaty from Patches.\nSupplication from the "
                           "thief Patches to find a keepsake of Lady Tanith "
                           "and return it to her.",
        "hintIconTypes": ["note"]
    },
    {
        "lotID": "111815",
        "hintItems": ["Dancer's Castanets"],
        "hintName": "Entreaty from Patches",
        "hintDescription": "Entreaty from Patches.\nSupplication from the "
                           "thief Patches to find a keepsake of Lady Tanith "
                           "and return it to her.",
        "hintIconTypes": ["note"]
    },


    {
        "lotID": "101020",
        "hintItems": ["Sellian Sealbreaker"],
        "hintName": "Sellen's Request",
        "hintDescription": "Sellen's Request.\nLocation of a magical key "
                           "needed to break the seal imprisoning Sellen's "
                           "mentor.",
        "hintIconTypes": ["note", "map"]
    },
    # the randomizer currently just lets you do the primal glintstone transplant
    # directly after the cutscene of removing it from her, so this isn't needed
    # {
    #     "lotID": "101000",
    #     "hintItems": ["Sellen's Primal Glintstone"],
    #     "hintName": "Directions from Sellen",
    #     "hintDescription": "Directions from Sellen.\nContains the location "
    #                        "of Sellen's precious primal glintstone.",
    #     "hintIconTypes": ["scroll"]
    # },

    # Thops (shop): 100250
    {
        "lotID": "100250",
        "hintItems": ["Academy Glintstone Key"],
        "hintName": "Thops's Inquiries",
        "hintDescription": "Thops's Inquiries.\nRumors of the location of a "
                           "key to the Academy of Raya Lucaria collected by "
                           "Sorcerer Thops.",
        "hintIconTypes": ["map"],
        "shopValue": "0"
    },
    {
        "lotItems": ["Academy Glintstone Key"],
        "hintItems": ["Academy Glintstone Key (Thops)"],
        "hintName": "Scholar's Diary",
        "hintDescription": "Scholar's Diary.\nThe account of a scheming "
                           "scholar of Raya Lucaria who sought to steal the "
                           "Academy key of another.",
        "hintIconTypes": ["book"],
        # default to Meeting Place Map location near South Raya Lucaria Gate
        "altLotID": "1035450100"
    },
    {
        "lotItems": ["Academy Glintstone Key (Thops)"],
        "hintItems": ["Academy Glintstone Key"],
        "hintName": "Scholar's Diary",
        "hintDescription": "Scholar's Diary.\nThe account of a desperate "
                           "scholar of Raya Lucaria who had their Academy key "
                           "stolen.",
        "hintIconTypes": ["book"],
        # default to Meeting Place Map location near South Raya Lucaria Gate
        "altLotID": "1035450100"
    },

    {
        "lotID": "100310",
        "hintItems": ["Lord of Blood's Favor"],
        "hintName": "Varré's Charge",
        "hintDescription": "Varré's Charge.\nA task to retrieve a favor of "
                           "Luminary Mohg and stain it with the blood of a "
                           "Maiden.",
        "hintIconTypes": ["note", "map"]
    },
    {
        "lotID": "100320",
        "hintItems": ["Pureblood Knight's Medal"],
        "hintName": "Varré's Decree",
        "hintDescription": "Varré's Decree.\nDeclaration from White Mask "
                           "Varré of your fitness as a servant of the Mohgwyn "
                           "Dynasty.",
        "hintIconTypes": ["scroll"]
    },
]
