# Copyright (c) 2023 The Old Man and the C
#
# This file is part of Elden Ring Randomizer Hints.
#
# Elden Ring Randomizer Hints is free software: you can redistribute it and/or
# modify it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Elden Ring Randomizer Hints is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
# or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License
# for more details.
#
# You should have received a copy of the GNU Affero General Public License along
# with Elden Ring Randomizer Hints. If not, see <https://www.gnu.org/licenses/>.

fogRegionHints = {
    # region1 - Abandoned Cave
    # landmark1 - Sellia Crystal Tunnel
    "20450": "Abandoned Lair",  # Gold Scarab - WNW 107h 1v
    # region2 - Academy Crystal Cave
    # landmark1 - Raya Lucaria Grand Library
    "14000920": "Academy Tower",  # Terra Magica - SSE 69h 131v
    # landmark2 - Academy Crystal Cave
    "20380": "Academy Lair",  # Crystal Release - E 119h -20v
    "31060000": "Academy Cave",  # Cuckoo Glintstone 5x - SE 109h -20v
    "31060010": "Academy Cave",  # Stonesword Key - ESE 30h -26v
    "31060110": "Academy Cave",  # Crystal Staff - ESE 64h -11v
    "31060100": "Academy Cave",  # Rune Arc - ESE 64h -17v
    # region6 - Ainsel River
    # landmark2 - Dragonkin Soldier of Nokstella
    "10090": "Ainsel Falls",  # Frozen Lightning Spear - ESE 73h -1v
    "12010910": "Ainsel Vault",  # Great Ghost Glovewort - WNW 67h -1v
    # region7 - Ainsel River Main
    # landmark1 - Ainsel River Main
    "103940": "Ainsel Main",  # Miniature Ranni - N 33h 0v
    # landmark2 - Nokstella, Eternal City
    "12010520": "Ainsel Ledge",  # Somber Smithing Stone [6] - SSE 102h 14v
    "12010550": "Ainsel Main",  # Shield Grease 2x - ESE 106h 29v
    "12010560": "Ainsel Main",  # Golden Rune [10] 8x - ESE 113h 30v
    # landmark3 - Uhl Palace Ruins
    "12010540": "Ainsel Main",  # Stimulating Boluses - SW 113h -24v
    # landmark4 - Nokstella Waterfall Basin
    "12010800": "Ainsel Main",  # Smithing Stone [4] - SSW 76h 0v
    "12010810": "Ainsel Main",  # Smithing Stone [5] - SSW 84h 0v
    # landmark5 - Ainsel River Downstream
    "12010900": "Ainsel Ledge",  # Wing of Astel - NNE 64h 46v
    # region9 - Altus Plateau
    # landmark11 - Mirage Rise
    "1039530051": "Mirage Rise",  # Unseen Form - S 2h 22v
    # region10 - Altus Tunnel
    # landmark1 - Rampartside Path
    "20650": "Altus Lair",  # Somberstone Miner's Bell Bearing [2] - SSW 68h -127v
    # region14 - Auriza Hero's Grave
    # landmark1 - Auriza Side Tomb
    "20100": "Auriza Tomb",  # Ordovis's Greatsword - WNW 223h -208v
    "20101": "Auriza Tomb",  # Crucible Axe Helm - WNW 223h -208v
    "20102": "Auriza Tomb",  # Crucible Axe Armor - WNW 223h -208v
    "20103": "Auriza Tomb",  # Crucible Gauntlets - WNW 223h -208v
    "20104": "Auriza Tomb",  # Crucible Greaves - WNW 223h -208v
    # landmark2 - Forsaken Depths
    "30100010": "Auriza Grave",  # Holy Grease 2x - NNW 242h -49v
    "30100020": "Auriza Grave",  # Fan Daggers 5x - NNW 106h -2v
    "30100030": "Auriza Grave",  # Golden Rune [7] - NNW 239h -32v
    "30100040": "Auriza Grave",  # Crucible Feather Talisman - N 98h -77v
    "30100060": "Auriza Grave",  # Great Dragonfly Head 3x - NNW 201h -19v
    "30100070": "Auriza Grave",  # Stonesword Key - NNW 153h -7v
    # landmark3 - Cathedral of the Forsaken
    "30100050": "Auriza Grave",  # Golden Epitaph - WNW 23h 45v
    "30100080": "Auriza Grave",  # Vulgar Militia Ashes - NW 231h -37v
    # landmark4 - Auriza Hero's Grave
    "30100101": "Auriza Grave",  # Tree Sentinel Helm - WNW 190h -171v
    "30100102": "Auriza Grave",  # Tree Sentinel Armor - WNW 190h -171v
    "30100103": "Auriza Grave",  # Tree Sentinel Gauntlets - WNW 190h -171v
    "30100104": "Auriza Grave",  # Tree Sentinel Greaves - WNW 190h -171v
    "30100100": "Auriza Grave",  # Ash of War: Holy Ground - WNW 190h -171v
    # region15 - Auriza Side Tomb
    # landmark1 - Auriza Side Tomb
    "30130100": "Auriza Sham Gaol",  # Cracked Pot - WNW 87h -49v
    "30130110": "Auriza Sham Gaol",  # Cracked Pot - NW 90h -50v
    "30130120": "Auriza Gaol",  # Cracked Pot - WNW 90h -34v
    "30130130": "Auriza Gaol",  # Cracked Pot - WNW 71h -35v
    "30130140": "Auriza Sham Hall",  # Ritual Pot - NW 148h -35v
    "30130150": "Auriza Sham Entrance",  # Ritual Pot - NW 107h -25v
    "30130010": "Auriza Gaol",  # Perfumer's Cookbook [3] - WNW 81h -35v
    "20130": "Auriza Side Tomb",  # Soldjars of Fortune Ashes - WNW 112h -15v
    "30130020": "Auriza Sham Gallery",  # Golden Rune [7] - WNW 107h -44v
    "30130030": "Auriza Sham Entrance",  # Smithing Stone [5] - NW 114h -25v
    "30130040": "Auriza Sham Hall",  # Root Resin 2x - NW 152h -35v
    "449033032": "Auriza Sham Entrance",  # Raw Meat Dumpling - NW 117h -25v
    "449033031": "Auriza Sham Entrance",  # Living Jar Shard - NW 117h -25v
    "449033022": "Auriza Sham Hall",  # Raw Meat Dumpling - NW 149h -35v
    "449033021": "Auriza Sham Hall",  # Living Jar Shard - NW 149h -35v
    "449033012": "Auriza Gaol",  # Raw Meat Dumpling - WNW 89h -34v
    "449033011": "Auriza Gaol",  # Living Jar Shard - WNW 89h -34v
    "449033002": "Auriza Gaol",  # Raw Meat Dumpling - WNW 74h -34v
    "449033001": "Auriza Gaol",  # Living Jar Shard - WNW 74h -34v
    # region17 - Bellum Highway
    # landmark5 - Church of Inhibition
    "1037490031": "the Church of Inhibition",  # Finger Maiden Robe - NNW 5h 1v
    "1037490032": "the Church of Inhibition",  # Finger Maiden Shoes - NNW 5h 1v
    "1037490301": "the Church of Inhibition",  # Vyke's War Spear - S 55h -9v
    # region19 - Black Knife Catacombs
    # landmark1 - Frenzied Flame Village Outskirts
    "20050": "Black Knife Tomb",  # Twinsage Sorcerer Ashes - NNE 53h -44v
    "30050030": "Black Knife Tomb",  # Deathroot - N 54h -43v
    # landmark2 - Frenzied Flame Village
    "20210": "Black Knife Chapel",  # Assassin's Cerulean Dagger - ENE 62h -18v
    "20211": "Black Knife Chapel",  # Black Knifeprint - ENE 62h -18v
    # region21 - Caelem Ruins
    # landmark1 - Caelem Ruins
    "1048400900": "Caelem Vault",  # Visage Shield - SSE 68h -26v
    # region23 - Caelid Catacombs
    # landmark1 - Southern Aeonia Swamp Bank
    "20150": "Caelid Tomb",  # Kindred of Rot Ashes - WSW 146h -64v
    # region26 - Caria Manor
    # landmark2 - Main Caria Manor Gate
    "1035500020": "the Caria Estate",  # Stonesword Key - NW 23h 12v
    # landmark3 - Manor Lower Level
    "101490": "the Caria Estate",  # Pidia's Bell Bearing - NW 31h 7v
    "101496": "the Caria Estate",  # Nepheli Loux Puppet - NW 31h 7v
    "101491": "the Caria Estate",  # Dolores the Sleeping Arrow Puppet - NW 31h 7v
    "1035500030": "the Caria Estate",  # Slumbering Egg 3x - S 36h -6v
    "1035500110": "the Caria Estate",  # Spellproof Dried Liver - WNW 18h 7v
    "1035500180": "the Caria Estate",  # Old Fang 5x - ENE 9h 23v
    # landmark4 - Royal Moongazing Grounds
    "10810": "Moongazing Grounds",  # Loretta's Greatbow - NNE 0h 0v
    "10811": "Moongazing Grounds",  # Ash of War: Loretta's Slash - NNE 0h 0v
    # region27 - Carian Study Hall
    # landmark1 - Carian Study Hall
    "34110010": "Study Hall",  # Golden Rune [3] - W 31h -9v
    "34110060": "Study Hall",  # Golden Rune [4] - ENE 31h 25v
    "34110080": "Study Hall",  # Cerulean Seed Talisman - SW 17h 40v
    "34110200": "Study Hall",  # Carian Glintstone Staff - S 33h 10v
    "34110700": "Study Hall",  # Magic Downpour - NE 32h -1v
    # region28 - Castle Morne
    # landmark1 - Morne Moangrave
    "10800": "Morne Moangrave",  # Grafted Blade Greatsword - N 5h 0v
    # region30 - Castle Sol
    # landmark1 - Castle Sol Rooftop
    "10840": "Sol Rooftop",  # Veteran's Prosthesis - NNW 14h 0v
    "1051580800": "Sol Keep",  # Haligtree Secret Medallion (Left) - N 80h 32v
    # region32 - Cliffbottom Catacombs
    # landmark1 - Cliffbottom Catacombs
    "20070": "Cliffbottom Tomb",  # Kaiden Sellsword Ashes - SSW 104h -45v
    # region33 - Coastal Cave
    # landmark1 - Coastal Cave
    "20341": "Coastal Lair",  # Tailoring Tools - SSW 60h -29v
    "20340": "Coastal Lair",  # Sewing Needle - SSW 60h -29v
    # landmark2 - Church of Dragon Communion
    "31150020": "Dragon Church",  # Smoldering Butterfly - NE 92h -43v
    # region34 - Converted Fringe Tower
    # landmark1 - Converted Fringe Tower
    "1039480101": "the Converted Fringe Tower apex",  # Gavel of Haima - N 0h 40v
    # region38 - Crumbling Farum Azula
    # landmark1 - Tempest-Facing Balcony
    "13000650": "Upper Azula",  # Ancient Dragon Apostle's Cookbook [4] - WNW 46h 8v
    "13000035": "Beast Grave Depths",  # Great Grave Glovewort - SW 17h 21v
    "13000070": "Beast Grave Depths",  # Smithing Stone [8] - W 74h -86v
    "13000110": "Beast Grave Depths",  # Golden Rune [12] - WSW 79h 11v
    "13000120": "Beast Grave Depths",  # Ancient Dragon Prayerbook - SW 46h 3v
    "13000140": "Beast Grave Depths",  # Smithing Stone [6] - SW 44h 19v
    "13000150": "Beast Grave Depths",  # Somberstone Miner's Bell Bearing [4] - N 12h -2v
    "13000250": "Beast Grave Depths",  # Somber Smithing Stone [7] - NW 56h -25v
    "13000260": "Beast Grave Depths",  # Golden Rune [9] - NW 75h -14v
    "13000640": "Upper Azula",  # Smithing Stone [7] - NW 107h -9v
    "13000660": "Upper Azula",  # Somber Smithing Stone [8] - NW 64h 5v
    "13000860": "Beast Grave Depths",  # Gravel Stone 3x - WSW 58h 21v
    "13000880": "Upper Azula",  # Smithing Stone [8] - NW 59h -6v
    # landmark3 - Dragon Temple
    "101741": "Upper Azula",  # Alexander's Innards - W 54h 36v
    "40772": "Upper Azula",  # Golden Lightning Fortification - SE 38h 24v
    "13000025": "Dragon Temple",  # Great Grave Glovewort - W 49h 26v
    "13000270": "Beast Grave Depths",  # Golden Arrow 14x - SW 81h 26v
    "13000290": "Dragon Temple",  # Gravel Stone 3x - W 46h 11v
    "13000300": "Dragon Temple",  # Golden Rune [10] - WSW 64h -6v
    "13000310": "Dragon Temple",  # Golden Rune [12] - W 26h -9v
    "13000320": "Dragon Temple",  # Smithing Stone [6] - SSE 23h 0v
    "13000330": "Dragon Temple",  # Golden Rune [11] - NNE 32h 0v
    "13000380": "Dragon Temple",  # Rune Arc - NNE 30h -28v
    "13000390": "Dragon Temple",  # Somber Smithing Stone [9] - SSE 45h -27v
    "13000590": "Upper Azula",  # Dragonwound Grease 2x - NNW 26h 16v
    "13000600": "Upper Azula",  # Smithing Stone [8] - SE 63h 24v
    "13000620": "Upper Azula",  # Golden Rune [12] - WSW 63h 36v
    "13000870": "Dragon Temple",  # Somber Smithing Stone [9] - WSW 34h 7v
    # landmark4 - Dragon Temple Rooftop
    "102920": "Farum Azula",  # Blasphemous Claw - SE 68h 6v
    "102921": "Farum Azula",  # Devourer's Scepter - SE 68h 6v
    "102922": "Farum Azula",  # Beast Champion Helm - SE 68h 6v
    "102924": "Farum Azula",  # Beast Champion Gauntlets - SE 68h 6v
    "102925": "Farum Azula",  # Beast Champion Greaves - SE 68h 6v
    "102923": "Farum Azula",  # Beast Champion Armor (Altered) - SE 68h 6v
    "13000510": "Farum Azula",  # Dappled Cured Meat - SW 63h 24v
    "13000520": "Farum Azula",  # Smithing Stone [8] - NW 34h 4v
    "13000670": "Farum Azula",  # Smithing Stone [6] - E 24h -12v
    "13000680": "Farum Azula",  # Arteria Leaf 3x - SSE 21h -27v
    "13000700": "Farum Azula",  # Lightning Greatbolt 5x - ENE 7h 13v
    "13000740": "Farum Azula",  # Golden Rune [12] - ESE 135h -107v
    "13000760": "Farum Azula",  # Boltdrake Talisman +2 - S 51h -22v
    "13000820": "Farum Azula",  # Somber Smithing Stone [8] - SW 7h 20v
    "13000920": "Farum Azula",  # Drake Knight Helm - NE 28h -39v
    "13000921": "Farum Azula",  # Drake Knight Armor - NE 28h -39v
    "13000922": "Farum Azula",  # Drake Knight Gauntlets - NE 28h -39v
    "13000923": "Farum Azula",  # Drake Knight Greaves - NE 28h -39v
    "13000940": "Farum Azula",  # Dragon Towershield - SE 156h -97v
    "13000950": "Farum Azula",  # Old Lord's Talisman - SE 82h 6v
    # landmark5 - Dragon Temple Altar
    "10140": "Temple Altar",  # Smithing-Stone Miner's Bell Bearing [4] - WSW 18h -13v
    "10141": "Temple Altar",  # Ash of War: Black Flame Tornado - WSW 18h -13v
    "13000015": "Dragon Temple",  # Dragonwound Grease 2x - WNW 33h 14v
    "13000350": "Dragon Temple",  # Stonesword Key - ENE 31h 11v
    "13000360": "Dragon Temple",  # Golden Rune [12] - NW 49h 7v
    "13000550": "Upper Azula",  # Golden Rune [12] - NNE 35h 45v
    "13000560": "Upper Azula",  # Smithing Stone [8] - ENE 35h 48v
    "13000570": "Upper Azula",  # Rune Arc - W 23h 48v
    "13000580": "Upper Azula",  # Smithing Stone [7] - N 56h 45v
    "13000800": "Farum Azula",  # Golden Rune [12] - E 73h -2v
    "13000990": "Upper Azula",  # Golden Seed - W 31h 48v
    # landmark6 - Dragonlord Placidusax
    "10150": "Heart of the Tempest",  # Remembrance of the Dragonlord - SSW 1h 0v
    # landmark7 - Maliketh, the Black Blade
    "10160": "Azula Rotunda",  # Remembrance of the Black Blade - WNW 28h -30v
    "13000005": "Farum Azula",  # Somber Ancient Dragon Smithing Stone - NW 83h -89v
    # landmark8 - Crumbling Beast Grave
    "13000000": "Beast Grave",  # Smithing Stone [8] - E 96h 29v
    "13000010": "Beast Grave",  # Golden Rune [9] - E 104h 20v
    "13000020": "Beast Grave",  # Old Fang 3x - ENE 64h 0v
    "13000030": "Beast Grave",  # Lightningproof Dried Liver - NE 27h 0v
    "13000040": "Beast Grave Depths",  # Smithing Stone [6] - WNW 73h -12v
    "13000050": "Beast Grave Depths",  # Smithing Stone [8] - WNW 106h -15v
    "13000240": "Beast Grave Depths",  # Gravel Stone 5x - WSW 81h -131v
    # landmark9 - Crumbling Beast Grave Depths
    "13000060": "Beast Grave Depths",  # Dragonwound Grease - E 60h -10v
    "13000080": "Beast Grave Depths",  # Smithing Stone [8] - SE 22h 0v
    "13000090": "Beast Grave Depths",  # Lightning Greatbolt 14x - WNW 43h -4v
    "13000130": "Beast Grave Depths",  # Hero's Rune [2] - WNW 76h -9v
    "13000170": "Beast Grave Depths",  # Somber Smithing Stone [9] - SW 44h -105v
    "13000180": "Beast Grave Depths",  # Fulgurbloom 4x - SSW 20h -94v
    "13000190": "Beast Grave Depths",  # Smithing Stone [8] - SSW 76h -78v
    "13000200": "Beast Grave Depths",  # Rejuvenating Boluses - S 105h -116v
    "13000220": "Beast Grave Depths",  # Smithing Stone [8] - SSE 117h -116v
    "13000850": "Beast Grave Depths",  # Smithing Stone [7] - W 24h 1v
    "13000910": "Beast Grave Depths",  # Glovewort Picker's Bell Bearing [3] - S 150h -114v
    "13002091": "Beast Grave Depths",  # Ancient Dragon Smithing Stone - ESE 77h -8v
    # landmark10 - Dragon Temple Lift
    "13000420": "Farum Azula",  # Golden Rune [11] - ESE 41h -55v
    "13000430": "Farum Azula",  # Old Fang 5x - SSE 35h -58v
    "13000440": "Farum Azula",  # Hero's Rune [5] - SSE 32h -58v
    "13000450": "Farum Azula",  # Smithing Stone [7] - NE 70h -63v
    "13000460": "Farum Azula",  # Lightning Grease 5x - NE 23h -63v
    "13000470": "Farum Azula",  # Somber Smithing Stone [9] - N 42h -49v
    "13000480": "Farum Azula",  # Ancient Dragon Smithing Stone - ESE 52h -41v
    "13000530": "Upper Azula",  # Lord's Rune - SE 40h 3v
    "13000540": "Upper Azula",  # Nascent Butterfly 2x - ESE 71h -2v
    # landmark11 - Beside the Great Bridge
    "13000490": "Farum Azula",  # Golden Rune [12] - WNW 52h -3v
    "13000500": "Farum Azula",  # Dragoncrest Shield Talisman +2 - WNW 68h -2v
    "13000710": "Farum Azula",  # Fulgurbloom 8x - ESE 81h -52v
    "13000720": "Farum Azula",  # Golden Rune [12] - ESE 80h -52v
    "13000730": "Farum Azula",  # Smithing Stone [7] - E 95h -48v
    "13000770": "Farum Azula",  # Somber Smithing Stone [7] - S 42h -39v
    "13000790": "Farum Azula",  # Somberstone Miner's Bell Bearing [5] - W 4h -33v
    "13000980": "Farum Azula",  # Golden Seed - E 88h -48v
    "13002093": "Farum Azula",  # Ancient Dragon Smithing Stone - ESE 88h -52v
    # landmark12 - Dragon Temple Transept
    "13000810": "Farum Azula",  # Somber Smithing Stone [7] - ENE 82h 11v
    "13000890": "Dragon Temple",  # Azula Beastman Ashes - WSW 65h 1v
    "13002095": "Farum Azula",  # Malformed Dragon Helm - ENE 98h 13v
    "13002096": "Farum Azula",  # Malformed Dragon Armor - ENE 98h 13v
    "13002097": "Farum Azula",  # Malformed Dragon Gauntlets - ENE 98h 13v
    "13002098": "Farum Azula",  # Malformed Dragon Greaves - ENE 98h 13v
    # region40 - Deathtouched Catacombs
    # landmark1 - Deathtouched Catacombs
    "20030": "Deathtouched Tomb",  # Assassin's Crimson Dagger - W 124h -15v
    "30110000": "Deathtouched Tomb",  # Deathroot - W 131h -14v
    # region41 - Deeproot Depths
    # landmark2 - Prince of Death's Throne
    "10110": "Godwyn's Rest",  # Remembrance of the Lichdragon - ENE 23h 1v
    "10350": "Godwyn's Rest",  # Fia's Mist - E 9h 0v
    # region45 - Dragonbarrow Cave
    # landmark1 - Dragonbarrow Cave
    "20440": "Dragonbarrow Lair",  # Flamedrake Talisman +2 - SSE 72h -56v
    # region46 - Earthbore Cave
    # landmark1 - Earthbore Cave
    "20310": "Earthbore Lair",  # Spelldrake Talisman - SSW 113h -39v
    "31010030": "Earthbore Lair",  # Smoldering Butterfly 5x - SSW 111h -39v
    "31010040": "Earthbore Lair",  # Trina's Lily - SSW 113h -38v
    # region48 - Elphael, Brace of the Haligtree
    # landmark1 - Malenia, Goddess of Rot
    "10201": "Haligtree Roots",  # Malenia's Great Rune - S 22h 1v
    "103240": "Haligtree Roots",  # Miquella's Needle - ENE 19h -1v
    "103241": "Haligtree Roots",  # Somber Ancient Dragon Smithing Stone - ENE 19h -1v
    "10200": "Haligtree Roots",  # Remembrance of the Rot Goddess - S 22h 1v
    # landmark3 - Elphael, Brace of the Haligtree
    "15001200": "Elphael",  # Golden Seed - SSE 62h 34v
    "15000890": "Elphael",  # Great Grave Glovewort - SSE 64h 34v
    # landmark4 - Haligtree Promenade
    "10191": "Haligtree Promenade",  # Loretta's War Sickle - N 10h 0v
    "15000460": "Elphael",  # Ancient Dragon Smithing Stone - NNW 65h -58v
    # landmark5 - Elphael Inner Wall
    "15001270": "Elphael",  # Lord's Rune - ENE 24h 0v
    "402056031": "Elphael",  # Ghost Glovewort [9] - E 107h -17v
    "402056041": "Elphael",  # Ghost Glovewort [9] - E 56h -17v
    "15000590": "Elphael",  # Somber Ancient Dragon Smithing Stone - ESE 95h 23v
    "15000650": "Elphael",  # Old Fang 5x - ESE 87h 14v
    "15000660": "Elphael",  # Warming Stone 2x - E 99h -5v
    "15000670": "Elphael",  # Spiritflame Arrow 15x - ENE 83h -6v
    "15000680": "Elphael",  # Smithing Stone [8] - NE 42h 6v
    "15000690": "Elphael",  # Haligtree Soldier Ashes - NNE 51h 8v
    "15000700": "Elphael",  # Golden Rune [11] - E 59h -3v
    "15000710": "Elphael",  # Arteria Leaf - E 42h -1v
    "15000720": "Elphael",  # Sacramental Bud - E 19h 0v
    "15000730": "Elphael",  # Smithing Stone [8] - E 64h -17v
    "15000820": "Elphael",  # Haligtree Knight Helm - NNE 15h 12v
    "15000830": "Elphael",  # Smithing Stone [6] - NNW 19h 0v
    "15000840": "Elphael",  # Seedbed Curse - ESE 77h 23v
    "15000860": "Elphael",  # Rotten Crystal Sword - SE 44h -3v
    "15000870": "Elphael",  # Hero's Rune [5] - SSW 83h -3v
    "15000880": "Elphael",  # Rot Grease - SSE 43h -12v
    # landmark6 - Drainage Channel
    "15001280": "Elphael",  # Rotten Staff - NNE 38h 43v
    "402056001": "Elphael",  # Ghost Glovewort [9] - SSW 33h 24v
    "402056011": "Elphael",  # Ghost Glovewort [9] - NNE 14h 24v
    "402056021": "Elphael",  # Ghost Glovewort [9] - N 46h 24v
    "15000540": "Elphael",  # Lightning Greatbolt 5x - NNW 51h 64v
    "15000550": "Elphael",  # Smithing Stone [7] - W 17h 57v
    "15000570": "Elphael",  # Immunizing White Cured Meat - NNW 59h 49v
    "15000580": "Elphael",  # Cleanrot Knight Finlay - NW 73h 55v
    "15000600": "Elphael",  # Numen's Rune - ENE 20h 42v
    "15000620": "Elphael",  # Somber Smithing Stone [9] - N 96h 51v
    "15000630": "Elphael",  # Golden Rune [10] - NNW 73h 49v
    "15000640": "Elphael",  # Smithing Stone [7] - NNW 85h 49v
    "15000740": "Elphael",  # Lord's Rune - NNW 109h 24v
    "15000750": "Elphael",  # Seedbed Curse - NNW 70h 31v
    "15000760": "Elphael",  # Somber Smithing Stone [9] - NW 72h 24v
    "15000770": "Elphael",  # Pickled Turtle Neck - NNW 69h 24v
    "15000780": "Elphael",  # Beast Blood 3x - NNW 44h 24v
    "15000790": "Elphael",  # Aeonian Butterfly 4x - S 17h 24v
    "15000810": "Elphael",  # Golden Rune [12] - S 47h 24v
    "15000900": "Elphael",  # Golden Rune [10] - W 35h 12v
    "15000950": "Elphael",  # Arteria Leaf 3x - NE 50h -55v
    "15000960": "Elphael",  # Hero's Rune [5] - E 46h -62v
    # landmark7 - Prayer Room
    "15000500": "Elphael",  # Holy Grease 3x - SE 47h 0v
    "15000510": "Elphael",  # Golden Rune [12] - NNE 53h -3v
    "15000520": "Elphael",  # Smithing Stone [8] - N 90h 0v
    "15000530": "Elphael",  # Miquellan Knight's Sword - NNE 81h 4v
    "15000560": "Elphael",  # Triple Rings of Light - ENE 18h -20v
    "15000610": "Elphael",  # Somber Ancient Dragon Smithing Stone - E 39h -34v
    "15000800": "Elphael",  # Marika's Soreseal - ESE 25h -52v
    # landmark8 - Haligtree Roots
    "15000910": "Elphael",  # Ghost-Glovewort Picker's Bell Bearing [3] - N 82h 41v
    "15000920": "Elphael",  # Nascent Butterfly - ENE 71h 71v
    "15000930": "Elphael",  # Dragoncrest Greatshield Talisman - ENE 45h 76v
    "15000940": "Elphael",  # Aeonian Butterfly - NE 58h 66v
    "15000970": "Elphael",  # Numen's Rune - N 60h 51v
    "15000980": "Elphael",  # Traveler's Clothes - ESE 27h 0v
    "15000981": "Elphael",  # Traveler's Manchettes - ESE 27h 0v
    "15000982": "Elphael",  # Traveler's Boots - ESE 27h 0v
    # region49 - Flame Peak
    # landmark2 - Church of Repose
    "1051530501": "the Church of Repose",  # Okina Mask - ENE 44h -1v
    # landmark5 - Fire Giant
    "10310": "Giants' Forge",  # Remembrance of the Fire Giant - NW 85h -103v
    # region51 - Forlorn Hound Evergaol
    # landmark1 - Forlorn Hound Evergaol
    "30130": "Hound Evergaol",  # Bloodhound's Fang - S 22h 1v
    # region57 - Frenzied Flame Proscription
    # landmark1 - Cathedral of the Forsaken
    "35000800": "Frenzied Flame",  # Frenzied's Cookbook [2] - ENE 44h -25v
    "35000060": "Frenzied Flame",  # Eye of Yelough 5x - ENE 39h -15v
    "35000650": "Frenzied Flame",  # Grace Mimic 5x - E 56h -10v
    "35000660": "Frenzied Flame",  # Golden Rune [11] - E 42h -20v
    "35000670": "Frenzied Flame",  # Hefty Beast Bone 3x - E 50h -30v
    "35000710": "Frenzied Flame",  # Nomadic Merchant's Chapeau - E 62h -10v
    "35000711": "Frenzied Flame",  # Nomadic Merchant's Finery - E 62h -10v
    "35000712": "Frenzied Flame",  # Nomadic Merchant's Trousers - E 62h -10v
    # landmark2 - Frenzied Flame Proscription
    "35000070": "Frenzied Flame",  # Note: Miquella's Needle - SE 16h 40v
    "35000680": "Frenzied Flame",  # Inescapable Frenzy - S 11h 41v
    "35000720": "Frenzied Flame",  # Fingerprint Stone Shield - SSW 26h 40v
    "35000780": "Frenzied Flame",  # Rune Arc - SSE 41h 0v
    # region60 - Fringefolk Hero's Grave
    # landmark1 - Cave of Knowledge
    "10280": "Fringefolk Tomb",  # Golden Seed - E 118h -101v
    "10281": "Fringefolk Tomb",  # Banished Knight Oleg - E 118h -101v
    "18000020": "Fringefolk Grave",  # Golden Rune [5] - N 32h -45v
    "18000060": "Fringefolk Grave",  # Grave Glovewort [1] - NE 48h -79v
    # landmark2 - Fringefolk Hero's Grave
    "18000000": "Fringefolk Grave",  # Poisonbone Dart 5x - SSE 1h 0v
    "18000010": "Fringefolk Grave",  # Stonesword Key - ENE 96h -24v
    "18000030": "Fringefolk Grave",  # Dragonwound Grease - WNW 96h -35v
    "18000040": "Fringefolk Grave",  # Lightning Grease 2x - NE 92h -75v
    "301000010": "Fringefolk Grave",  # Dragon Communion Seal - WNW 97h -34v
    "18000900": "Fringefolk Grave",  # Erdtree Greatbow - ENE 91h -35v
    "18000901": "Fringefolk Grave",  # Great Arrow 10x - ENE 91h -35v
    # landmark3 - Dragon-Burnt Ruins
    "18000050": "Fringefolk Grave",  # Erdtree's Favor - NNW 141h -124v
    # region61 - Gael Tunnel
    # landmark1 - Rear Gael Tunnel Entrance
    "20661": "Gael Lair",  # Moonveil - NNE 48h -1v
    "20660": "Gael Lair",  # Dragon Heart - NNE 48h -1v
    # landmark2 - Gael Tunnel
    "32070000": "Gael Shaft",  # Somber Smithing Stone [2] - N 62h -20v
    # region62 - Gaol Cave
    # landmark1 - Gaol Cave
    "20430": "Gaol Lair",  # Putrid Corpse Ashes - W 103h -75v
    "31210190": "Gaol Cliff",  # Glowstone 3x - W 133h -75v
    "31210350": "Gaol Cliff",  # Regalia of Eochaid - W 132h -76v
    # region64 - Gelmir Hero's Grave
    # landmark1 - Audience Pathway
    "20090": "Gelmir Tomb",  # Bloodhound Knight Floh - N 7h 100v
    "30090000": "Gelmir Tomb",  # Deathroot - NNW 14h 101v
    # landmark2 - Rykard, Lord of Blasphemy
    "30090010": "Gelmir Grave",  # Ringed Finger - SSE 90h 147v
    "30090070": "Gelmir Grave",  # Beast Blood 3x - ESE 38h 122v
    # landmark3 - Abductor Virgin
    "30090020": "Gelmir Grave",  # Golden Rune [6] - WNW 66h -126v
    "30090040": "Gelmir Grave",  # Stonesword Key - WNW 59h -115v
    # landmark4 - Subterranean Inquisition Chamber
    "30090030": "Gelmir Grave",  # Smoldering Butterfly 6x - E 59h -178v
    "30090060": "Gelmir Grave",  # Root Resin 5x - ENE 55h -164v
    "366400700": "Gelmir Grave",  # Mantis Blade - ENE 67h -174v
    # landmark5 - Seethewater Cave
    "30090050": "Gelmir Grave",  # Gelmir Knight Helm - S 134h -106v
    "30090051": "Gelmir Grave",  # Gelmir Knight Armor - S 134h -106v
    "30090052": "Gelmir Grave",  # Gelmir Knight Gauntlets - S 134h -106v
    "30090053": "Gelmir Grave",  # Gelmir Knight Greaves - S 134h -106v
    "429000800": "Gelmir Grave",  # Bloodhound Knight Helm - S 138h -107v
    "429000801": "Gelmir Grave",  # Bloodhound Knight Armor - S 138h -107v
    "429000802": "Gelmir Grave",  # Bloodhound Knight Gauntlets - S 138h -107v
    "429000803": "Gelmir Grave",  # Bloodhound Knight Greaves - S 138h -107v
    # region65 - Giant-Conquering Hero's Grave
    # landmark1 - Giants' Mountaintop Catacombs
    "20170": "Conquering Tomb",  # Zamor Curved Sword - SSW 149h -126v
    "20171": "Conquering Tomb",  # Zamor Mask - SSW 149h -126v
    "20172": "Conquering Tomb",  # Zamor Armor - SSW 149h -126v
    "20173": "Conquering Tomb",  # Zamor Bracelets - SSW 149h -126v
    "20174": "Conquering Tomb",  # Zamor Legwraps - SSW 149h -126v
    # landmark2 - Zamor Ruins
    "30170000": "Conquering Grave",  # Cranial Vessel Candlestand - SW 30h -52v
    "30170040": "Conquering Grave",  # Freezing Grease - S 88h -53v
    "30170050": "Conquering Grave",  # Golden Rune [11] - SSE 29h -51v
    # landmark3 - Giant-Conquering Hero's Grave
    "30170010": "Conquering Grave",  # Flame, Protect Me - W 31h -2v
    "30170030": "Conquering Grave",  # Giant's Seal - S 166h -50v
    # region66 - Giants' Mountaintop Catacombs
    # landmark1 - Giant-Conquering Hero's Grave
    "30180040": "Giants' Catacombs",  # Ritual Pot - ESE 76h -34v
    "20181": "Giants' Tomb",  # Glovewort Picker's Bell Bearing [2] - NNW 43h -34v
    "20180": "Giants' Tomb",  # Golden Seed - NNW 43h -34v
    "30180000": "Giants' Catacombs",  # Golden Rune [10] - SE 89h -54v
    "30180010": "Giants' Catacombs",  # Stimulating Boluses - SE 94h -34v
    "30180020": "Giants' Catacombs",  # Nascent Butterfly - SE 89h -39v
    "30180030": "Giants' Catacombs",  # Root Resin 5x - ENE 51h -18v
    "30180900": "Giants' Tomb",  # Deathroot - NW 54h -34v
    "449050042": "Giants' Catacombs",  # Raw Meat Dumpling - ESE 84h -33v
    "449050041": "Giants' Catacombs",  # Living Jar Shard - ESE 84h -33v
    "449050032": "Giants' Catacombs",  # Raw Meat Dumpling - ESE 78h -19v
    "449050031": "Giants' Catacombs",  # Living Jar Shard - ESE 78h -19v
    "449050022": "Giants' Catacombs",  # Raw Meat Dumpling - SE 63h -54v
    "449050021": "Giants' Catacombs",  # Living Jar Shard - SE 63h -54v
    "449050012": "Giants' Catacombs",  # Raw Meat Dumpling - SSE 85h -54v
    "449050011": "Giants' Catacombs",  # Living Jar Shard - SSE 85h -54v
    "449050002": "Giants' Catacombs",  # Raw Meat Dumpling - S 130h -34v
    "449050001": "Giants' Catacombs",  # Living Jar Shard - S 130h -34v
    # landmark2 - Consecrated Snowfield Catacombs
    "30180070": "Giants' Catacombs",  # Fire Monk Ashes - SSE 186h 32v
    # region67 - Golden Lineage Evergaol
    # landmark1 - Golden Lineage Evergaol
    "1039500100": "Golden Evergaol",  # Godfrey Icon - ESE 20h 1v
    # region69 - Grand Cloister
    # landmark1 - Grand Cloister
    "12010470": "Grand Cloister",  # Preserving Boluses - NNW 94h 12v
    "12010820": "Grand Cloister",  # Golden Rune [10] - W 58h -12v
    "12010830": "Grand Cloister",  # Smithing Stone [5] - W 148h -44v
    "12010840": "Grand Cloister",  # Fan Daggers 8x - W 143h -45v
    "12010850": "Grand Cloister",  # Golden Rune [10] - WSW 42h -45v
    "12010860": "Grand Cloister",  # Smithing Stone [7] - N 43h -45v
    "12010870": "Grand Cloister",  # Smithing Stone [6] - N 43h -45v
    "12010920": "Grand Cloister",  # Scorpion's Stinger - W 217h -36v
    "12015997": "Grand Cloister",  # Golden Seed - N 50h -45v
    # region70 - Greyoll's Dragonbarrow
    # landmark1 - Isolated Merchant's Shack
    "40412": "Dragonbarrow",  # Ash of War: Sky Shot - WNW 48h -6v
    # landmark2 - Dragonbarrow West
    "1049400500": "Dragonbarrow",  # Map: Dragonbarrow - E 122h 0v
    "1049400020": "Dragonbarrow",  # Sliver of Meat 3x - E 188h -6v
    # landmark3 - Sellia Crystal Tunnel
    "1049400000": "Dragonbarrow",  # Golden Rune [5] - NNE 162h 94v
    "1049400010": "Dragonbarrow",  # Gravel Stone - N 157h 94v
    # landmark4 - Deep Siofra Well
    "1049400040": "Dragonbarrow",  # Smithing Stone [5] 3x - SE 117h 64v
    # landmark5 - Divine Tower of Caelid
    "40426": "Dragonbarrow",  # Somber Smithing Stone [8] - SW 112h -69v
    # landmark6 - Divine Tower of Caelid: Basement
    "1049410040": "Dragonbarrow",  # Arteria Leaf 2x - SW 67h 108v
    "1049410070": "Dragonbarrow",  # Dragonwound Grease - SW 72h 108v
    "1049410080": "Dragonbarrow",  # Rune Arc - SW 70h 108v
    "1049410090": "Dragonbarrow",  # Somber Smithing Stone [9] - SW 69h 108v
    # landmark7 - Sellia Hideaway
    "1050390020": "Dragonbarrow",  # Smithing Stone [7] - W 143h 39v
    "1050390030": "Dragonbarrow",  # Smithing Stone [7] - W 137h 40v
    "1050390040": "Dragonbarrow",  # Stonesword Key - W 143h 39v
    "1050390050": "Dragonbarrow",  # Smithing Stone [8] - W 147h 38v
    # landmark8 - Fort Faroth
    "1050400800": "Dragonbarrow",  # Dragon Heart 5x - NW 116h -23v
    # landmark9 - Minor Erdtree
    "1051400040": "the Minor Erdtree in Dragonbarrow",  # Rune Arc - S 90h -97v
    # landmark10 - Lenne's Rise
    "40420": "Dragonbarrow",  # Bestial Constitution - W 168h 13v
    "1052410000": "Dragonbarrow",  # Golden Rune [8] - S 56h 27v
    "1052410010": "Dragonbarrow",  # Golden Rune [6] - SSW 57h 26v
    "1052410020": "Dragonbarrow",  # Golden Rune [3] - SSW 67h 26v
    "1052410030": "Dragonbarrow",  # Golden Rune [1] - S 56h 28v
    "1052410100": "Dragonbarrow",  # Ash of War: Bloodhound's Step - N 110h 2v
    # landmark11 - Farum Greatbridge
    "40428": "Dragonbarrow",  # Somber Smithing Stone [9] - W 101h -3v
    "1051430020": "Dragonbarrow",  # Golden Seed - NNW 157h 44v
    "30420": "Dragonbarrow",  # Dragon Heart - S 145h -4v
    "1052430000": "Dragonbarrow",  # Starlight Shards - NE 152h 41v
    # region71 - Groveside Cave
    # landmark2 - Stormhill Evergaol
    "20330": "Groveside Lair",  # Flamedrake Talisman - NW 66h -70v
    # region73 - Hallowhorn Grounds in Nokron, Eternal City
    # landmark1 - Hallowhorn Grounds
    "10330": "Nokron Lair",  # Remembrance of the Regal Ancestor - NNE 36h 0v
    "12020620": "Hallowhorn Grounds in Nokron Woods",  # Mottled Necklace +1 - NNE 26h 29v
    # region74 - Hallowhorn Grounds in Siofra River
    # landmark1 - Hallowhorn Grounds
    "10320": "Siofra Lair",  # Ancestral Follower Ashes - SE 69h 0v
    # region79 - Highroad Cave
    # landmark1 - Highroad Cave
    "20350": "Highroad Lair",  # Blue Dancer Charm - NNE 54h -106v
    # region80 - Highway Lookout Tower in Altus Plateau
    # landmark1 - Highway Lookout Tower
    "1042540040": "Highway Lookout Tower in Altus Plateau",  # Hefty Beast Bone 10x - WNW 15h 6v
    "1042540050": "Highway Lookout Tower in Altus Plateau",  # Golden Arrow 6x - WNW 21h 0v
    "1042540060": "Highway Lookout Tower in Altus Plateau",  # Greatbow - WNW 9h 18v
    "1042540061": "Highway Lookout Tower in Altus Plateau",  # Great Arrow 20x - WNW 9h 18v
    # region82 - Impaler's Catacombs
    # landmark1 - Beside the Crater-Pocked Glade
    "20010": "Impaler's Tomb",  # Demi-Human Ashes - NE 52h -49v
    # region83 - Isolated Merchant's Shack in Greyoll's Dragonbarrow
    # landmark1 - Isolated Merchant's Shack
    "1048410800": "Isolated Merchant's Shack in Dragonbarrow",  # Gravity Stone Peddler's Bell Bearing - N 17h -1v
    # region85 - Kingsrealm Ruins
    # landmark1 - Northern Liurnia Lake Shore
    "1034480200": "western Liurnia",  # Map: Liurnia, West - NE 48h 2v
    # landmark3 - Kingsrealm Ruins
    "1034480100": "Kingsrealm Vault",  # Frozen Needle - SSW 33h -10v
    # region86 - Lakeside Crystal Cave
    # landmark1 - Slumbering Wolf's Shack
    "20370": "Lakeside Lair",  # Cerulean Amber Medallion - NW 65h 10v
    # landmark2 - Lakeside Crystal Cave
    "31050000": "Lakeside Cave",  # Hefty Beast Bone 3x - W 45h 2v
    "31050010": "Lakeside Cave",  # Throwing Dagger 5x - NNE 27h -43v
    "31050020": "Lakeside Cave",  # Golden Rune [5] - N 50h -46v
    "31050030": "Lakeside Cave",  # Soft Cotton 2x - NNW 23h -61v
    "31050040": "Lakeside Cave",  # Smithing Stone [4] - NNW 21h -70v
    "31050050": "Lakeside Cave",  # Smithing Stone [2] - NW 20h -71v
    "31050060": "Lakeside Cave",  # Lump of Flesh - NW 23h -71v
    "31050070": "Lakeside Cave",  # Arteria Leaf - NNE 3h 0v
    "31050100": "Lakeside Cave",  # Spear Talisman - NW 85h -16v
    # region89 - Leyndell Catacombs
    # landmark1 - Leyndell Catacombs
    "20220": "Leyndell Tomb",  # Lord of Blood's Exultation - SW 92h -10v
    # region90 - Leyndell, Ashen Capital
    # landmark2 - Erdtree Sanctuary
    "4900": "Ashen Sanctuary",  # Mending Rune of Perfect Order - WSW 113h -55v
    "105000": "Ashen Sanctuary",  # Goldmask's Rags - WSW 113h -55v
    "105001": "Ashen Sanctuary",  # Gold Bracelets - WSW 113h -55v
    "105002": "Ashen Sanctuary",  # Gold Waistwrap - WSW 113h -55v
    "10060": "Ashen Sanctuary",  # Scepter of the All-Knowing - E 1h 0v
    "10061": "Ashen Sanctuary",  # All-Knowing Helm - E 1h 0v
    "10062": "Ashen Sanctuary",  # All-Knowing Armor - E 1h 0v
    "10063": "Ashen Sanctuary",  # All-Knowing Gauntlets - E 1h 0v
    "10064": "Ashen Sanctuary",  # All-Knowing Greaves - E 1h 0v
    "11050050": "Ashen Leyndell",  # Hero's Rune [4] - N 92h -39v
    # landmark3 - Elden Throne
    "10070": "Ashen Throne",  # Remembrance of Hoarah Loux - SSE 9h -59v
    # landmark4 - Queen's Bedchamber
    "11050000": "Ashen Bedchamber",  # Erdtree Heal - ENE 8h 1v
    "11050100": "Ashen Leyndell East",  # Erdtree's Favor +2 - NE 93h -89v
    # landmark5 - Subterranean Shunning-Grounds
    "11050010": "Ashen Leyndell",  # Somber Ancient Dragon Smithing Stone - SW 122h 63v
    "11050020": "Ashen Leyndell",  # Tarnished Golden Sunflower - SW 21h 44v
    "11050030": "Ashen Leyndell",  # Rune Arc - SSE 58h 64v
    "11050040": "Ashen Leyndell",  # Golden Sunflower - SSW 69h 60v
    # region91 - Leyndell, Royal Capital
    # landmark1 - Elden Throne
    "10041": "Elden Throne",  # Morgott's Great Rune - SE 7h 0v
    "10040": "Elden Throne",  # Remembrance of the Omen King - SE 7h 0v
    # landmark2 - Erdtree Sanctuary
    "10050": "Erdtree Sanctuary",  # Talisman Pouch - ENE 0h 0v
    "11000015": "Queen's Bedchamber",  # Erdtree Bow - W 43h 9v
    "11000025": "Queen's Bedchamber",  # Celestial Dew - WSW 42h 9v
    "11000890": "Leyndell",  # Holy Grease 3x - WSW 56h -16v
    "11000910": "Queen's Bedchamber",  # Golden Order Principia - W 1h 15v
    "11000920": "Sanctuary Alcove",  # Somber Smithing Stone [5] 3x - WNW 41h -1v
    "11000930": "Sanctuary Balcony",  # Holy Grease 6x - SE 61h 3v
    "11000940": "Sanctuary Lift",  # Holy Grease 5x - NNW 64h -52v
    # landmark3 - Fortified Manor, First Floor
    "11001010": "Leyndell",  # Sanctified Whetblade - SE 55h 10v
    "80050": "Leyndell",  # "Flightless Bird" Painting - ENE 8h 0v
    "11000005": "Leyndell",  # Alberich's Pointed Hat - SE 34h 0v
    "11000006": "Leyndell",  # Alberich's Robe - SE 34h 0v
    "11000007": "Leyndell",  # Alberich's Bracers - SE 34h 0v
    "11000008": "Leyndell",  # Alberich's Trousers - SE 34h 0v
    "11000055": "Leyndell",  # Hammer - SE 54h 10v
    "11000065": "Leyndell",  # Rune Arc - S 38h 12v
    "11000075": "Leyndell",  # Hero's Rune [1] - SE 66h 11v
    "11000105": "Leyndell",  # Stormhawk Axe - N 15h -3v
    "11000125": "Leyndell",  # Black-Key Bolt 20x - SSE 54h 0v
    "11000145": "Leyndell",  # Somber Smithing Stone [6] - NW 65h -1v
    "11000690": "Leyndell",  # Two Fingers' Prayerbook - SSE 50h 0v
    "11000700": "Leyndell",  # Smithing Stone [5] - E 33h 0v
    "11000720": "Leyndell",  # Smithing Stone [6] - SE 57h 5v
    "11000740": "Leyndell",  # Furlcalling Finger Remedy - ENE 8h 11v
    "11000760": "Leyndell",  # Smithing Stone [5] - SE 31h 14v
    "11000780": "Leyndell",  # Smithing Stone [6] - ENE 47h 3v
    "11000790": "Leyndell",  # Nascent Butterfly 3x - NW 42h -3v
    "11000850": "Leyndell",  # Seedbed Curse - ENE 47h 10v
    "11000970": "Leyndell",  # Coded Sword - SSW 69h 15v
    "11001985": "Leyndell",  # Raging Wolf Helm - SSE 30h 1v
    "11001986": "Leyndell",  # Raging Wolf Armor - SSE 30h 1v
    "11001987": "Leyndell",  # Raging Wolf Gauntlets - SSE 30h 1v
    "11001988": "Leyndell",  # Raging Wolf Greaves - SSE 30h 1v
    # landmark4 - Avenue Balcony
    "11000560": "Leyndell",  # Cracked Pot - NW 34h -18v
    "11000020": "Leyndell",  # Hefty Beast Bone - WNW 40h -24v
    "11000085": "Leyndell",  # Golden Rune [12] - NNW 20h -10v
    "11000150": "Leyndell",  # Gold Firefly 3x - ENE 36h 5v
    "11000160": "Leyndell",  # Holy Grease - ESE 36h 8v
    "11000190": "Leyndell",  # Smithing Stone [4] - ESE 44h 11v
    "11000350": "Leyndell",  # Smithing Stone [6] - W 27h 0v
    "11000370": "Leyndell",  # Smithing Stone [5] - E 87h 20v
    "11000490": "Leyndell",  # Stonesword Key - NE 26h -13v
    "11000520": "Leyndell",  # Golden Arrow 15x - NW 69h -18v
    "11000530": "Leyndell",  # Smithing Stone [6] - NW 82h -18v
    "11000540": "Leyndell",  # Clarifying Boluses - NW 13h -12v
    "11000550": "Leyndell",  # Golden Rune [8] - NW 38h -23v
    "11000580": "Leyndell",  # Rune Arc - WNW 66h -24v
    "11000620": "Leyndell",  # Albinauric Bloodclot - WNW 67h -15v
    "11000640": "Leyndell",  # Pickled Turtle Neck 3x - NW 53h -15v
    "11000660": "Leyndell",  # Golden Rune [9] - NW 75h -6v
    "11000670": "Leyndell",  # Black Bow - N 39h -8v
    "11000680": "Leyndell",  # Dragonwound Grease - NW 111h -5v
    "11000980": "Leyndell",  # Stonesword Key - NW 17h -17v
    "11001193": "Leyndell",  # Golden Seed - NNW 68h -18v
    "11001198": "Leyndell",  # Lord's Rune - SE 26h 4v
    # landmark5 - Queen's Bedchamber
    "11000130": "Leyndell",  # Perfume Bottle - N 86h -76v
    "11000470": "Leyndell East",  # Perfume Bottle - ENE 156h -94v
    "11000050": "Leyndell",  # Cave Moss 10x - NNE 86h -64v
    "11000080": "Leyndell",  # Upper-Class Robe - N 69h -78v
    "11000090": "Leyndell",  # Miranda Powder 10x - N 74h -88v
    "11000165": "Leyndell",  # Golden Rune [11] - N 47h -87v
    "11000200": "Leyndell",  # Golden Rune [8] - N 52h -85v
    "11000210": "Leyndell",  # Somber Smithing Stone [5] - NNE 48h -84v
    "11001000": "Queen's Bedchamber",  # Blessing of the Erdtree - ENE 8h 1v
    # landmark7 - West Capital Rampart
    "40370": "Sanctuary Lift",  # Barrier of Gold - SE 69h -9v
    "11000115": "Leyndell",  # Cane Sword - SSE 21h -8v
    "11000135": "Leyndell",  # Gravel Stone 2x - E 51h -22v
    "11000175": "Leyndell",  # Hero's Rune [2] - SSE 86h -24v
    "11000185": "Leyndell",  # Somber Smithing Stone [6] - SSE 72h -24v
    "11000186": "Leyndell",  # Beast Blood - SSE 72h -24v
    "11000187": "Leyndell",  # Old Fang 2x - SSE 72h -24v
    "11000205": "Leyndell",  # Golden Rune [13] - ESE 37h -23v
    "11000230": "Leyndell",  # Lordsworn's Bolt 10x - E 71h -23v
    "11000235": "Leyndell",  # Lightningproof Dried Liver 2x - NNE 14h -25v
    "11000240": "Leyndell",  # Tarnished Golden Sunflower 8x - SE 61h -23v
    "11000245": "Leyndell",  # Golden Rune [11] - NW 21h 0v
    "11000250": "Leyndell",  # Stonesword Key - ESE 61h -27v
    "11000260": "Leyndell",  # Golden Rune [10] - SSE 81h -24v
    "11000270": "Leyndell",  # Golden Rune [8] - SE 32h -34v
    "11000710": "Leyndell",  # Golden Rune [9] - SW 64h -12v
    "11000820": "Leyndell",  # Smithing Stone [6] - S 31h -13v
    "11000830": "Leyndell",  # Golden Rune [9] - NNW 14h -7v
    "11000900": "Leyndell",  # Smithing Stone [6] - S 109h -24v
    "11001187": "Leyndell",  # Gargoyle's Halberd - S 61h -6v
    "11000990": "Leyndell",  # Golden Seed - SSE 66h -4v
    "11001040": "Sanctuary Lift",  # Bolt of Gransax - E 54h -15v
    # landmark8 - Lower Capital Church
    "40372": "Leyndell",  # Ash of War: Thunderbolt - NNW 62h 0v
    "11000035": "Leyndell",  # Deathbed Dress - NNW 7h 0v
    "11000045": "Leyndell",  # Lionel's Helm - NNW 8h 0v
    "11000046": "Leyndell",  # Lionel's Armor - NNW 8h 0v
    "11000047": "Leyndell",  # Lionel's Gauntlets - NNW 8h 0v
    "11000048": "Leyndell",  # Lionel's Greaves - NNW 8h 0v
    "11000070": "Leyndell",  # String 4x - WNW 54h -9v
    "11000170": "Leyndell",  # Golden Rune [8] - SE 18h 22v
    "11000225": "Leyndell",  # Golden Rune [12] - SSE 17h 24v
    "11000570": "Leyndell",  # Lost Ashes of War - SE 55h -9v
    "11000590": "Leyndell",  # Erdsteel Dagger - NW 97h -12v
    "11000600": "Leyndell",  # Poisonbone Dart 8x - SW 16h -9v
    "11000630": "Leyndell",  # Smithing Stone [5] - NW 58h 0v
    "11000650": "Leyndell",  # Smithing Stone [6] - NNE 26h 0v
    "11000730": "Leyndell",  # Holyproof Dried Liver - NW 101h -12v
    "11000810": "Leyndell",  # Fan Daggers 5x - NW 92h -12v
    "424034000": "Leyndell",  # Somber Smithing Stone [4] - SE 57h -2v
    "482000400": "Leyndell",  # Omensmirk Mask - NNE 18h 1v
    # landmark9 - East Capital Rampart
    "11000000": "Leyndell Lift",  # Magic Grease 3x - N 85h -7v
    "11000010": "Leyndell",  # Furlcalling Finger Remedy - NNE 93h -5v
    "11000030": "Leyndell",  # Smithing Stone [4] - S 75h -20v
    "11000040": "Leyndell",  # Golden Rune [7] - S 120h -20v
    "11000155": "Leyndell",  # Hero's Rune [5] - WSW 39h -56v
    "11000215": "Leyndell",  # Golden Rune [10] - SSE 75h -12v
    "11000300": "Leyndell",  # Golden Rune [9] - S 95h -48v
    "11000320": "Leyndell",  # Imp Head (Corpse) - S 93h -54v
    "11000330": "Leyndell",  # Golden Rune [9] - WSW 50h -56v
    "11000380": "Leyndell",  # Stonesword Key - SSW 64h -43v
    "11000390": "Leyndell",  # Golden Rune [12] - SSW 77h -41v
    "11000400": "Leyndell East",  # Beast Blood 3x - SE 60h -54v
    "11000410": "Leyndell East",  # Nascent Butterfly 3x - ESE 120h -36v
    "11000420": "Leyndell East",  # Exalted Flesh - ESE 123h -32v
    "11000430": "Leyndell East",  # Soporific Grease 2x - E 74h -38v
    "11000440": "Leyndell East",  # Somber Smithing Stone [6] - E 90h -44v
    "11000450": "Leyndell East",  # Golden Rune [9] - SE 125h -54v
    "11000460": "Leyndell East",  # Lightningproof Dried Liver - SE 150h -54v
    # landmark10 - Subterranean Shunning-Grounds
    "11000060": "Leyndell",  # Preserving Boluses - ESE 89h 54v
    "11000100": "Leyndell",  # Smithing Stone [6] - ESE 60h 48v
    "11000110": "Leyndell",  # Warming Stone 5x - ESE 99h 48v
    "11000120": "Leyndell",  # Golden Rune [10] - ESE 87h 48v
    "11000140": "Leyndell",  # Fan Daggers 8x - E 70h 46v
    "11000180": "Leyndell",  # Old Fang 3x - E 54h 43v
    "11000220": "Leyndell",  # Golden Rune [8] - SE 84h 53v
    "11000340": "Leyndell",  # Seedbed Curse - ESE 93h 66v
    # landmark11 - Underground Roadside
    "11000095": "Leyndell",  # Guilty Hood - NNW 45h 25v
    "11000280": "Leyndell",  # Golden Rune [9] - E 33h 53v
    "11000290": "Leyndell",  # Smithing Stone [6] - E 65h 58v
    "11000310": "Leyndell",  # Arteria Leaf 2x - E 78h 53v
    "11000360": "Leyndell",  # Golden Rune [9] - ESE 61h 66v
    "11000480": "Leyndell",  # Gravel Stone - NE 20h 34v
    "11000500": "Leyndell",  # Golden Rune [9] - NNW 28h 35v
    "11000510": "Leyndell",  # Smithing Stone [4] - NNE 8h 36v
    # landmark12 - Leyndell, Royal Capital
    "11000610": "Leyndell",  # Somber Smithing Stone [6] - NW 96h -43v
    "11000750": "Leyndell",  # Gravel Stone 3x - WNW 66h -13v
    "11000770": "Leyndell",  # Old Fang 5x - W 30h -13v
    "11000800": "Leyndell",  # Stonesword Key - WSW 53h -6v
    "11000840": "Leyndell",  # Gravel Stone 5x - WSW 13h 7v
    "11000950": "Leyndell",  # Rune Arc - WNW 55h -11v
    "435300706": "Leyndell",  # Gravel Stone Seal - W 42h -13v
    # landmark13 - Royal Colosseum
    "11000860": "Leyndell",  # Smithing Stone [5] - ESE 116h 1v
    "11000870": "Leyndell",  # Furlcalling Finger Remedy - WNW 38h 0v
    "11000880": "Leyndell",  # Star Fist - ESE 83h 0v
    "11001030": "Leyndell",  # Ritual Shield Talisman - NNE 33h -1v
    # region92 - Limgrave Tunnels
    # landmark1 - Limgrave Tunnels
    "20610": "Limgrave Lair",  # Roar Medallion - WNW 112h -97v
    # region93 - Lord Contender's Evergaol
    # landmark1 - Lord Contender's Evergaol
    "30515": "Contender's Evergaol",  # Vyke's Dragonbolt - SW 9h 1v
    # region97 - Minor Erdtree Catacombs
    # landmark1 - Forsaken Ruins
    "20140": "Minor Erdtree Tomb",  # Mad Pumpkin Head Ashes - NNW 72h -73v
    # region99 - Miquella's Haligtree
    # landmark1 - Haligtree Promenade
    "10190": "Haligtree Promenade",  # Loretta's Mastery - N 10h 0v
    # landmark2 - Haligtree Canopy
    "15000000": "Haligtree",  # Stonesword Key - S 26h 10v
    "15000010": "Haligtree",  # Sacramental Bud 3x - S 20h 1v
    "15000020": "Haligtree",  # Golden Rune [10] - ENE 57h -10v
    "15000030": "Haligtree",  # Stonesword Key - E 98h -31v
    "15000040": "Haligtree",  # Fire Grease 3x - ENE 117h -22v
    "15000070": "Haligtree",  # Golden Rune [10] - E 83h -25v
    "15000080": "Haligtree",  # Envoy Crown - SE 84h -10v
    "15000090": "Haligtree",  # Dappled Cured Meat - E 65h -19v
    "15000100": "Haligtree",  # Smithing Stone [8] - SE 49h -3v
    "15000110": "Haligtree",  # Prattling Pate "My beloved" - E 41h -20v
    # landmark3 - Miquella's Haligtree
    "15000050": "Haligtree",  # Aeonian Butterfly 2x - SE 125h 40v
    "15000060": "Haligtree",  # Preserving Boluses - SSE 82h 41v
    "15000120": "Haligtree",  # Warming Stone 4x - SE 41h 9v
    "15000130": "Haligtree",  # Flaming Bolt 10x - E 40h -5v
    "15000140": "Haligtree",  # Numen's Rune - ENE 52h -14v
    "15000160": "Haligtree",  # Lost Ashes of War - NNE 36h -15v
    # landmark4 - Haligtree Town
    "15000150": "Haligtree",  # Golden Rune [13] - ESE 65h 34v
    "15000170": "Haligtree",  # Oracle Envoy Ashes - ENE 93h 72v
    "15000200": "Haligtree",  # Golden Rune [10] - NW 44h -6v
    "15000220": "Haligtree",  # Pearldrake Talisman +2 - NW 19h 8v
    "15000360": "Haligtree",  # Smithing Stone [6] - W 23h -45v
    "15000370": "Haligtree",  # Sacramental Bud - WNW 25h -53v
    "15000380": "Haligtree",  # Smithing Stone [7] - SE 56h -64v
    "15000390": "Haligtree",  # Hero's Rune [4] - SSE 47h -58v
    "15000400": "Haligtree",  # Smithing Stone [8] - SE 69h -64v
    # landmark5 - Haligtree Town Plaza
    "15000210": "Haligtree",  # Rot Grease 2x - ESE 41h 34v
    "15000230": "Haligtree",  # Smithing Stone [8] - ENE 33h 15v
    "15000240": "Haligtree",  # Golden Rune [13] - E 34h 9v
    "15000250": "Haligtree",  # Hefty Beast Bone 6x - ENE 49h 9v
    "15000260": "Haligtree",  # Fire Grease 5x - NE 59h 4v
    "15000270": "Haligtree",  # Ancient Dragon Smithing Stone - NNE 69h 4v
    "15000280": "Haligtree",  # Somber Smithing Stone [8] - NNE 37h 4v
    "15000290": "Haligtree",  # Golden Rune [12] - W 8h 0v
    "15000300": "Haligtree",  # Aeonian Butterfly 4x - ENE 25h -9v
    "15000310": "Haligtree",  # Smithing Stone [6] - S 27h -3v
    "15000320": "Haligtree",  # Somber Smithing Stone [9] - SSW 21h -11v
    "15000330": "Haligtree",  # Golden Rune [10] - SSE 44h -12v
    "15000340": "Haligtree",  # Golden Rune [12] - SSE 47h -20v
    "15000350": "Haligtree",  # Viridian Amber Medallion +2 - S 27h -20v
    # region103 - Mohgwyn Dynasty Mausoleum
    # landmark1 - Cocoon of the Empyrean
    "10121": "Mohgwyn Throne",  # Mohg's Great Rune - WNW 6h 0v
    "10120": "Mohgwyn Throne",  # Remembrance of the Blood Lord - WNW 6h 0v
    "12050640": "Mohgwyn Mausoleum",  # Smithing Stone [8] 3x - S 85h -71v
    # landmark2 - Dynasty Mausoleum Midpoint
    "100360": "Mohgwyn Mausoleum",  # Varré's Bouquet - WSW 19h 1v
    "12050010": "Mohgwyn Palace",  # Golden Seed - SE 92h -9v
    "12050590": "Mohgwyn Mausoleum",  # Smithing Stone [7] - ESE 46h -39v
    "12050600": "Mohgwyn Mausoleum",  # Stanching Boluses 3x - SSE 108h -25v
    "12050610": "Mohgwyn Mausoleum",  # Stonesword Key - SE 84h -23v
    "12050620": "Mohgwyn Mausoleum",  # Bloodrose 8x - SSE 121h -18v
    "12050670": "Mohgwyn Mausoleum",  # Golden Rune [13] - SSE 81h 5v
    "12050690": "Mohgwyn Mausoleum",  # Lord's Rune - SW 89h -10v
    "12050900": "Mohgwyn Mausoleum",  # Somber Ancient Dragon Smithing Stone - SSE 77h 7v
    # landmark3 - Dynasty Mausoleum Entrance
    "12050650": "Mohgwyn Mausoleum",  # Numen's Rune - S 77h 15v
    # region104 - Mohgwyn Palace
    # landmark1 - Dynasty Mausoleum Entrance
    "12050070": "Mohgwyn Palace",  # Smithing Stone [8] - E 125h -9v
    "12050080": "Mohgwyn Palace",  # Hero's Rune [3] - ENE 149h -10v
    "12050090": "Mohgwyn Palace",  # Blood-Tainted Excrement 8x - ENE 159h -9v
    "12050110": "Mohgwyn Palace",  # Swarm of Flies - ENE 216h -10v
    "12050120": "Mohgwyn Palace",  # Drawstring Blood Grease 4x - ENE 160h -10v
    "12050130": "Mohgwyn Palace",  # Blood-Tainted Excrement 8x - ENE 131h -10v
    "12050140": "Mohgwyn Palace",  # Golden Rune [12] - NE 121h -8v
    "12050150": "Mohgwyn Palace",  # Smithing Stone [7] - NE 132h -9v
    "12050160": "Mohgwyn Palace",  # Golden Rune [12] - NNE 119h -9v
    "12050170": "Mohgwyn Palace",  # Sacramental Bud - NNE 115h -9v
    "12050180": "Mohgwyn Palace",  # Nascent Butterfly 3x - NNE 103h -9v
    "12050190": "Mohgwyn Palace",  # Rune Arc - NE 183h -7v
    "12050210": "Mohgwyn Palace",  # Golden Rune [13] - ENE 209h -9v
    "12050300": "Mohgwyn Palace",  # Holy Grease - SSE 127h -9v
    "12050310": "Mohgwyn Palace",  # Stonesword Key - SSE 163h -9v
    "12050320": "Mohgwyn Palace",  # Smithing Stone [6] - SE 121h -10v
    "12050330": "Mohgwyn Palace",  # Arteria Leaf 4x - S 50h -9v
    "12050340": "Mohgwyn Palace",  # Golden Rune [13] - SE 126h -10v
    "12050350": "Mohgwyn Palace",  # Clarifying Boluses - SE 104h -10v
    "12050700": "Mohgwyn Palace",  # Smithing Stone [6] - ENE 205h -10v
    # landmark2 - Palace Approach Ledge-Road
    "12050050": "Mohgwyn Palace",  # Nomadic Warrior's Cookbook [24] - NW 37h -20v
    "40686": "Mohgwyn Palace",  # Ash of War: Blood Tax - N 164h -21v
    "12050020": "Mohgwyn Palace",  # Golden Rune [11] - NNE 33h -3v
    "12050030": "Mohgwyn Palace",  # Smithing Stone [6] - N 84h -12v
    "12050040": "Mohgwyn Palace",  # Bloodrose 5x - N 97h -15v
    "12050060": "Mohgwyn Palace",  # Hero's Rune [4] - N 165h -21v
    "12050100": "Mohgwyn Palace",  # Somber Smithing Stone [9] - N 162h -21v
    "12050290": "Mohgwyn Palace",  # Bloodrose 5x - W 75h -22v
    "12050360": "Mohgwyn Palace",  # Rot Grease 3x - WNW 68h -21v
    "12050680": "Mohgwyn Palace",  # Golden Rune [11] - ENE 75h 10v
    "12050950": "Mohgwyn Palace",  # White Mask - NNW 97h -22v
    "12050952": "Mohgwyn Palace",  # War Surgeon Gloves - NNW 97h -22v
    "12050953": "Mohgwyn Palace",  # War Surgeon Trousers - NNW 97h -22v
    "12050951": "Mohgwyn Palace",  # War Surgeon Gown (Altered) - NNW 97h -22v
    # landmark4 - Dynasty Mausoleum Midpoint
    "12050370": "Mohgwyn Palace",  # Haligdrake Talisman +2 - SSE 130h -58v
    # region107 - Morne Tunnel
    # landmark1 - Morne Tunnel
    "20600": "Morne Lair",  # Rusted Anchor - NE 65h -52v
    # region108 - Mt. Gelmir
    # landmark12 - Corpse-Stench Shack
    "1038540101": "the Shaded Castle",  # Marais Mask - ENE 137h -79v
    "1038540102": "the Shaded Castle",  # Marais Robe - ENE 137h -79v
    # region109 - Murkwater Catacombs
    # landmark1 - Murkwater Catacombs
    "20040": "Murkwater Tomb",  # Banished Knight Engvall - WNW 109h -20v
    # region110 - Murkwater Cave
    # landmark2 - Murkwater Cave
    "101830": "Murkwater Lair",  # Golden Rune [1] 2x - W 51h -10v
    "31000010": "Murkwater Lair",  # Cloth Garb - WNW 31h -17v
    "31000011": "Murkwater Lair",  # Cloth Trousers - WNW 31h -17v
    "31000030": "Murkwater Lair",  # Glass Shard 3x - WNW 31h -17v
    # region113 - Nokron, Eternal City
    # landmark1 - Mimic Tear
    "10341": "Nokron Temple",  # Silver Tear Mask - NNE 25h -25v
    "10340": "Nokron Temple",  # Larval Tear 2x - NNE 25h -25v
    "40642": "Nokron Woods",  # Somber Smithing Stone [5] - NNE 73h 5v
    "12020500": "Nokron Woods",  # Golden Rune [4] - NNE 132h 4v
    "12070470": "Nokron",  # Rune Arc - WNW 106h 12v
    # landmark2 - Aqueduct-Facing Cliffs
    "40646": "Nokron Woods",  # Ash of War: Enchanted Shot - WSW 177h 27v
    "12020630": "Nokron Woods",  # Old Fang - S 70h 24v
    "12020690": "Nokron Woods",  # Golden Rune [12] - W 261h 7v
    "12020760": "Nokron Woods",  # Silver Tear Husk 2x - WSW 23h 3v
    # landmark3 - Ancestral Woods
    "12020081": "Night's Sacred Ground",  # Great Ghost Glovewort - SSE 35h -54v
    "12020510": "Nokron Woods",  # Dwelling Arrow 8x - ESE 187h -7v
    "12020520": "Nokron Woods",  # Nascent Butterfly - ESE 138h -12v
    "12020530": "Nokron Woods",  # Gold-Tinged Excrement 5x - ENE 69h -15v
    "12020540": "Nokron Woods",  # Fireproof Dried Liver - ENE 62h -13v
    "12020550": "Nokron Woods",  # Golden Rune [4] - NE 75h -10v
    "12020650": "Nokron Woods",  # Smithing Stone [4] - N 115h 3v
    "12020660": "Nokron Woods",  # Beast Blood - NNW 105h 2v
    "12020670": "Nokron Woods",  # Beast Blood 3x - NNW 128h 8v
    "12020680": "Nokron Woods",  # Somber Smithing Stone [5] - NW 106h -4v
    # landmark4 - Rear Gael Tunnel Entrance
    "12020090": "Nokron Woods",  # Ancestral Infant's Head - W 21h -270v
    # landmark5 - Hallowhorn Grounds
    "12020490": "Nokron Woods",  # Clarifying Horn Charm +1 - SE 92h -80v
    "12020570": "Nokron Woods",  # Old Fang 4x - W 101h 1v
    "12020590": "Nokron Woods",  # Kukri 8x - S 51h -10v
    "12020600": "Nokron Woods",  # Hefty Beast Bone 5x - SSW 82h -8v
    "12020610": "Nokron Woods",  # Smithing Stone [5] - S 120h -3v
    "12020640": "Nokron Woods",  # Hefty Beast Bone 3x - WNW 95h 16v
    "12020710": "Nokron Woods",  # Smithing Stone [5] - S 169h -30v
    "12020720": "Nokron Woods",  # Smithing Stone [2] - SE 92h -80v
    "12020730": "Nokron Woods",  # Celestial Dew - SE 108h -79v
    "12020750": "Nokron Woods",  # Stonesword Key - N 73h 18v
    "337000704": "Nokron Woods",  # Shining Horned Headband - W 93h 3v
    # landmark6 - Worshippers' Woods
    "12020740": "Nokron Woods",  # Smithing Stone [5] - WSW 96h 117v
    # landmark7 - Mistwood Ruins
    "12070300": "Nokron Entrance",  # Golden Rune [5] - ESE 49h -109v
    "12070310": "Nokron Entrance",  # Soporific Grease 2x - ESE 42h -120v
    # landmark8 - Nokron, Eternal City
    "12070320": "Nokron Entrance",  # Burred Bolt 10x - SSW 154h 23v
    "12070330": "Nokron Entrance",  # Nascent Butterfly 3x - S 102h 19v
    "12070350": "Nokron Entrance",  # Golden Rune [6] - S 141h 13v
    "12070360": "Nokron Entrance",  # Smithing Stone [5] - SSW 83h 19v
    "12070370": "Nokron Entrance",  # Furlcalling Finger Remedy - SSW 60h 18v
    "12070380": "Nokron",  # Clarifying White Cured Meat - SSW 41h 3v
    "12070390": "Nokron",  # Golden Rune [6] - SSW 62h 3v
    "12070400": "Nokron",  # Ghost-Glovewort Picker's Bell Bearing [1] - ENE 52h -5v
    "12070410": "Nokron",  # Smithing Stone [3] - ESE 21h -4v
    "12070420": "Nokron",  # Somber Smithing Stone [4] - ENE 116h -4v
    "12070430": "Nokron",  # Smithing Stone [5] - ESE 125h -4v
    "12070440": "Nokron",  # Greatshield Soldier Ashes - E 133h -4v
    "12070480": "Nokron",  # Larval Tear - ESE 92h -4v
    # landmark9 - Minor Erdtree
    "12070340": "Nokron Entrance",  # Rune Arc - SW 58h -155v
    "12070500": "Nokron Entrance",  # Ghostflame Torch - WSW 69h -144v
    # landmark10 - Night's Sacred Ground
    "12070450": "Nokron",  # Golden Rune [7] - WSW 113h 82v
    "12070460": "Nokron",  # Golden Rune [7] - SW 78h 77v
    "12070490": "Nokron",  # Larval Tear - SW 117h 78v
    # region114 - Nokstella, Eternal City
    # landmark1 - East Raya Lucaria Gate
    "40602": "Nokstella",  # Somber Smithing Stone [6] - NE 104h -164v
    "12010960": "Nokstella",  # Moon of Nokstella - NW 73h -143v
    # landmark2 - Nokstella Waterfall Basin
    "12010100": "Nokstella",  # Golden Seed - N 77h 125v
    "12010720": "Nokstella",  # Stonesword Key - NNE 126h 113v
    "12010790": "Nokstella",  # Celestial Dew - NW 34h 110v
    # landmark3 - Dragonkin Soldier of Nokstella
    "12010600": "Nokstella",  # Golden Rune [10] - N 66h 53v
    "12010640": "Nokstella",  # Golden Rune [10] - ENE 63h 88v
    "12010650": "Nokstella",  # Golden Rune [10] - NNE 62h 94v
    "12010670": "Nokstella",  # Smithing Stone [6] - N 120h 112v
    "12010680": "Nokstella",  # Golden Rune [10] - N 104h 104v
    "12010690": "Nokstella",  # Great Ghost Glovewort - NNE 124h 94v
    "12010700": "Nokstella",  # Somber Smithing Stone [7] - N 168h 112v
    "12010750": "Nokstella",  # Silver Tear Husk 3x - NNE 163h 61v
    "12010760": "Nokstella",  # Smithing Stone [6] - NNE 86h 59v
    "12010770": "Nokstella",  # Celestial Dew - NE 121h 59v
    "12010780": "Nokstella",  # Somber Smithing Stone [7] - WNW 83h 56v
    "12010940": "Nokstella",  # Somber Smithing Stone [7] - ENE 42h 88v
    "12010950": "Nokstella",  # Ghost Glovewort [9] - NNW 62h 64v
    "333062021": "Nokstella",  # Larval Tear - NNW 110h 112v
    "333062011": "Nokstella",  # Larval Tear - NNW 158h 122v
    "333062001": "Nokstella",  # Larval Tear - NNE 101h 104v
    "12010990": "Nokstella",  # Nightmaiden & Swordstress Puppets - E 41h 94v
    # landmark4 - Nokstella, Eternal City
    "12010610": "Nokstella",  # Fan Daggers - WNW 60h 12v
    "12010620": "Nokstella",  # Smithing Stone [6] - NNW 102h -3v
    "12010630": "Nokstella",  # Archer Ashes - W 92h 24v
    "12010660": "Nokstella",  # Golden Rune [10] - WNW 96h 25v
    "12010730": "Nokstella",  # Magic Grease 3x - WSW 13h 1v
    "12010740": "Nokstella",  # Drawstring Holy Grease 2x - N 92h -3v
    "12010970": "Nokstella",  # Ant's Skull Plate - W 60h 6v
    "12010980": "Nokstella",  # Ghost-Glovewort Picker's Bell Bearing [2] - W 88h 24v
    # region115 - Old Altus Tunnel
    # landmark1 - Old Altus Tunnel
    "20630": "Old Altus Lair",  # Great Club - WSW 134h -55v
    # region116 - Ordina, Liturgical Town
    # landmark1 - Ordina, Liturgical Town
    "1048570000": "Ordina",  # Rune Arc - E 59h 11v
    "1048570010": "Ordina",  # Golden Rune [13] - N 54h 10v
    "1048570020": "Ordina",  # Hefty Beast Bone 3x - E 59h 5v
    "1048570030": "Ordina",  # Golden Rune [13] - N 49h 6v
    "1048570040": "Ordina",  # Freezing Grease 2x - NNW 53h 0v
    "1048570050": "Ordina",  # Cuckoo Glintstone 8x - E 19h 8v
    "1048570060": "Ordina",  # Crystal Dart 5x - NW 47h 5v
    "1048570070": "Ordina",  # Old Fang 3x - N 55h 5v
    "1048570080": "Ordina",  # Slumbering Egg 3x - NE 34h 14v
    "1048570090": "Ordina",  # Golden Rune [12] - NW 67h 14v
    "1048570300": "Ordina",  # Invigorating Cured Meat - NNE 99h 19v
    "1048570310": "Ordina",  # Golden Rune [10] - ENE 41h 5v
    "1048570810": "Ordina",  # Black Knife Hood - NE 86h 5v
    "1048570811": "Ordina",  # Black Knife Armor - NE 86h 5v
    "1048570812": "Ordina",  # Black Knife Gauntlets - NE 86h 5v
    "1048570813": "Ordina",  # Black Knife Greaves - NE 86h 5v
    "1048570900": "Ordina Evergaol",  # Ghost Glovewort [9] - NNW 65h 0v
    "1048570910": "Ordina Evergaol",  # Ghost Glovewort [9] - ESE 55h 1v
    "1048570920": "Ordina Evergaol",  # Ghost Glovewort [9] - NE 85h 4v
    "1048570930": "Ordina Evergaol",  # Ghost Glovewort [9] - ENE 34h 5v
    "340052101": "Ordina",  # Rotten Greataxe - NNW 146h 4v
    # region118 - Perfumer's Grotto
    # landmark2 - Altus Tunnel
    "20410": "Perfumer's Lair",  # Great Omenkiller Cleaver - SSW 118h -23v
    # region122 - Raya Lucaria Crystal Tunnel
    # landmark1 - Nokstella, Eternal City
    "20620": "Lucaria Lair",  # Smithing-Stone Miner's Bell Bearing [1] - E 39h 3v
    "32020010": "Lucaria Tunnel",  # Somber Smithing Stone [3] - E 42h 97v
    "32020020": "Lucaria Tunnel",  # Golden Rune [3] - SE 75h 82v
    "32020030": "Lucaria Tunnel",  # Smithing Stone [3] - SE 113h 84v
    "32020040": "Lucaria Tunnel",  # Somber Smithing Stone [3] - ESE 53h 62v
    "32020060": "Lucaria Tunnel",  # Smithing Stone [1] 3x - NW 8h 45v
    "32020070": "Lucaria Tunnel",  # Shatter Earth - SSE 52h 39v
    "32020900": "Lucaria Tunnel",  # Crystal Knife - SW 31h 45v
    # landmark2 - Raya Lucaria Crystal Tunnel
    "32020000": "Lucaria Tunnel",  # Somber Smithing Stone [2] - ESE 59h -33v
    # region123 - Redmane Castle
    # landmark2 - Redmane Castle Plaza
    "10830": "Redmane Plaza",  # Ruins Greatsword - NE 23h 14v
    "1051360110": "Redmane Chapel",  # Somber Smithing Stone [5] - N 80h 3v
    # region124 - Redmane Castle Chapel
    # landmark1 - Redmane Castle Plaza
    "1051360100": "Redmane Chapel",  # Smithing Stone [6] - NNW 113h 9v
    # region127 - Road's End Catacombs
    # landmark1 - Road's End Catacombs
    "20060": "Road's End Tomb",  # Glintstone Sorcerer Ashes - ENE 116h -29v
    # region129 - Roundtable Hold
    # landmark1 - Table of Lost Grace
    "11100800": "Roundtable Hall",  # Taunter's Tongue - ENE 48h -13v
    "11100000": "Roundtable Hall",  # Cipher Pata - NNW 36h -12v
    # region130 - Royal Grave Evergaol
    # landmark1 - Royal Grave Evergaol
    "30255": "Royal Evergaol",  # Meteorite - ESE 22h -1v
    # region131 - Ruin-Strewn Precipice
    # landmark1 - Magma Wyrm Makar
    "10260": "Precipice Lair",  # Magma Wyrm's Scalesword - E 22h 0v
    "10261": "Precipice Lair",  # Dragon Heart - E 22h 0v
    "39200500": "Precipice Lair",  # Bull-Goat Helm - ESE 40h -1v
    "39200501": "Precipice Lair",  # Bull-Goat Armor - ESE 40h -1v
    "39200502": "Precipice Lair",  # Bull-Goat Gauntlets - ESE 40h -1v
    "39200503": "Precipice Lair",  # Bull-Goat Greaves - ESE 40h -1v
    # region132 - Sage's Cave
    # landmark1 - Sage's Cave
    "20420": "Sage's Lair",  # Concealing Veil - NE 52h -31v
    "20490": "Sage's Hidden Lair",  # Family Heads - NNE 13h -27v
    # region133 - Sainted Hero's Grave
    # landmark1 - Altus Tunnel
    "20080": "Sainted Tomb",  # Ancient Dragon Knight Kristoff - ESE 130h -72v
    "30080020": "Sainted Grave",  # Leyndell Soldier Ashes - SSW 103h -37v
    "30080030": "Sainted Grave",  # Dragoncrest Shield Talisman +1 - SSW 113h -37v
    "30080040": "Sainted Grave",  # Root Resin 3x - SW 42h -42v
    "30080050": "Sainted Grave",  # Prattling Pate "Let's get to it" - WSW 59h -37v
    "30080060": "Sainted Grave",  # Human Bone Shard 5x - SSE 36h -42v
    "402030011": "Sainted Grave",  # Ghost Glovewort [4] - SSE 35h -42v
    "402030001": "Sainted Grave",  # Ghost Glovewort [4] - SSE 38h -42v
    # landmark2 - St. Trina's Hideaway
    "30080010": "Sainted Grave",  # Crimson Seed Talisman - ENE 25h -16v
    "402030021": "Sainted Grave",  # Ghost Glovewort [4] - ESE 74h -19v
    # region134 - Seethewater Cave
    # landmark1 - Seethewater Cave
    "20390": "Seethewater Lair",  # Kindred of Rot's Exultation - NW 161h -80v
    # region135 - Sellia Crystal Tunnel
    # landmark1 - Deep Siofra Well
    "20672": "Sellia Lair",  # Gravity Stone Chunk 10x - ESE 83h 10v
    "20673": "Sellia Lair",  # Somberstone Miner's Bell Bearing [1] - ESE 83h 10v
    "20671": "Sellia Lair",  # Smithing Stone [7] 5x - ESE 83h 10v
    "20670": "Sellia Lair",  # Somber Smithing Stone [6] - ESE 83h 10v
    "32080110": "Sellia Tunnel",  # Dragonwound Grease - E 135h 10v
    "32080120": "Sellia Tunnel",  # Faithful's Canvas Talisman - E 151h 13v
    # landmark2 - Sellia Crystal Tunnel
    "32080000": "Sellia Tunnel",  # Rot Grease - NNW 43h 1v
    "32080020": "Sellia Tunnel",  # Golden Rune [5] - N 96h 18v
    "32080030": "Sellia Tunnel",  # Glintstone Scrap 6x - N 101h 22v
    "32080050": "Sellia Tunnel",  # Rune Arc - N 85h 35v
    "32080060": "Sellia Tunnel",  # Cuckoo Glintstone 5x - NNE 101h 29v
    "32080070": "Sellia Tunnel",  # Somber Smithing Stone [4] - NNE 86h 36v
    "32080100": "Sellia Tunnel",  # Golden Rune [4] - N 112h 39v
    "32080900": "Sellia Tunnel",  # Gravity Stone Fan 6x - N 93h 26v
    "32080901": "Sellia Tunnel",  # Gravity Stone Chunk 3x - N 93h 26v
    "32080910": "Sellia Tunnel",  # Rock Blaster - NNE 112h 36v
    # region138 - Sellia Hideaway
    # landmark2 - Chair-Crypt of Sellia
    "20460": "Hideaway Lair",  # Crystal Torrent - NNE 63h 44v
    # region139 - Sellia, Town of Sorcery
    # landmark3 - Chair-Crypt of Sellia
    "1049390800": "Sellia Chair-Crypt",  # Nox Flowing Sword - NNW 9h 0v
    "1049390900": "Sellia Vault",  # Lusat's Glintstone Staff - N 26h 3v
    # region141 - Siofra Aqueduct
    # landmark2 - Great Waterfall Basin
    "10100": "Waterfall Basin",  # Gargoyle's Greatsword - ESE 23h 32v
    "10101": "Waterfall Basin",  # Gargoyle's Twinblade - ESE 23h 32v
    # region142 - Siofra River
    # landmark1 - Hallowhorn Grounds
    "40610": "Upper Siofra",  # Great Oracular Bubble - SE 89h -137v
    "12020950": "Upper Siofra",  # Somber Smithing Stone [5] - SE 105h -137v
    "12020960": "Upper Siofra",  # Dragonwound Grease 3x - S 155h -136v
    "12020980": "Upper Siofra",  # Golden Rune [7] - S 78h -133v
    # landmark4 - Siofra Aqueduct
    "30620": "Upper Siofra",  # Dragon Halberd - SW 86h -122v
    "12020050": "Upper Siofra",  # Marika's Scarseal - SW 27h -122v
    "12020990": "Upper Siofra",  # Golden Rune [7] - S 125h -136v
    # landmark5 - Worshippers' Woods
    "12020970": "Upper Siofra",  # Slumbering Egg 2x - W 166h 69v
    # region143 - Slumbering Wolf's Shack
    # landmark1 - Slumbering Wolf's Shack
    "104100": "Wolf's Shack",  # Latenna the Albinauric - WNW 7h 0v
    "114100": "Wolf's Shack",  # Blue Silver Mail Hood - WNW 7h 0v
    "114101": "Wolf's Shack",  # Blue Silver Mail Armor - WNW 7h 0v
    "114102": "Wolf's Shack",  # Blue Silver Bracelets - WNW 7h 0v
    "114103": "Wolf's Shack",  # Blue Silver Mail Skirt - WNW 7h 0v
    "1036410020": "Wolf's Shack",  # Rune Arc - SSE 11h 2v
    # region145 - Spiritcaller Cave
    # landmark1 - Lord Contender's Evergaol
    "20480": "Spiritcaller Lair",  # Godskin Swaddling Cloth - S 5h -88v
    "20481": "Spiritcaller Lair",  # Black Flame Ritual - S 5h -88v
    # region147 - Stargazers' Ruins basement
    # landmark1 - Stargazers' Ruins
    "1051560900": "Stargazers' Vault",  # Primal Glintstone Blade - ENE 80h -10v
    # region148 - Stillwater Cave
    # landmark1 - Stillwater Cave
    "20360": "Stillwater Lair",  # Winged Sword Insignia - SSE 153h -38v
    # region150 - Stormfoot Catacombs
    # landmark1 - Stormhill Evergaol
    "20020": "Stormfoot Tomb",  # Noble Sorcerer Ashes - WNW 92h -64v
    # region155 - Stormveil Castle
    # landmark1 - Godrick the Grafted
    "10010": "Stormveil Courtyard",  # Godrick's Great Rune - NW 4h 0v
    "10011": "Stormveil Courtyard",  # Remembrance of the Grafted - NW 4h 0v
    # landmark2 - Margit, the Fell Omen
    "10000": "Stormveil Gate",  # Talisman Pouch - E 10h -1v
    # landmark12 - Lake-Facing Cliffs
    "10000850": "Stormveil Throne",  # Shabriri Grape - ESE 83h 0v
    # region156 - Stranded Graveyard
    # landmark2 - Cave of Knowledge
    "18000070": "Passage of Knowledge",  # Haligdrake Talisman - ESE 63h 23v
    # region162 - Tombsward Catacombs
    # landmark1 - Tombsward Catacombs
    "20000": "Tombsward Tomb",  # Lhutel the Headless - ESE 106h -19v
    # region163 - Tombsward Cave
    # landmark2 - Witchbane Ruins
    "20300": "Tombsward Lair",  # Viridian Amber Medallion - WSW 106h -38v
    # region167 - Uhl Palace Ruins in Ainsel River Main
    # landmark1 - Uhl Palace Ruins
    "12010500": "Uhl Palace Ruins in Ainsel Main",  # Golden Rune [7] - NE 47h 1v
    "12010510": "Uhl Palace Ruins in Ainsel Main",  # Human Bone Shard 3x - ENE 63h 2v
    "12010530": "Uhl Palace Ruins in Ainsel Main",  # Smithing Stone [4] - E 34h 1v
    "12010580": "Uhl Palace Ruins in Ainsel Main",  # Stonesword Key - ESE 76h 1v
    "12010590": "Uhl Palace Ruins in Ainsel Main",  # Golden Rune [7] - ESE 22h 0v
    "12010710": "Uhl Palace Ruins in Ainsel Main",  # Clayman Ashes - SE 98h 1v
    "12015995": "Uhl Palace Ruins in Ainsel Main",  # Somber Smithing Stone [7] - SW 7h 0v
    # region168 - Unsightly Catacombs
    # landmark1 - Perfumer's Ruins
    "20110": "Unsightly Tomb",  # Perfumer Tricia - NNE 121h -54v
    # region170 - Volcano Cave
    # landmark1 - Volcano Cave
    "20400": "Volcano Lair",  # Jar Cannon - SSE 15h -20v
    # region171 - Volcano Manor
    # landmark1 - Rykard, Lord of Blasphemy
    "10221": "Serpent's Lair",  # Rykard's Great Rune - ESE 1h 0v
    "10220": "Serpent's Lair",  # Remembrance of the Blasphemous - ESE 1h 0v
    "16000730": "Serpent's Lair",  # Eye Surcoat - W 20h 0v
    "16000950": "Serpent's Lair",  # Aspects of the Crucible: Breath - SW 9h 0v
    # landmark2 - Temple of Eiglay
    "16000450": "Caldera Hall",  # Missionary's Cookbook [6] - NE 34h 2v
    "10210": "Eiglay Temple",  # Godskin Stitcher - ESE 4h 0v
    "10211": "Eiglay Temple",  # Noble Presence - ESE 4h 0v
    "40592": "Caldera Hall",  # Somber Smithing Stone [5] - NNW 72h 27v
    "16000270": "Prison Town",  # Smoldering Butterfly 6x - W 33h -61v
    "16000280": "Prison Town",  # Smithing Stone [7] - NW 62h -61v
    "16000290": "Prison Town",  # Somber Smithing Stone [5] - WSW 50h -10v
    "16000310": "Prison Town",  # Smoldering Butterfly 5x - NW 72h -43v
    "16000320": "Eiglay Temple",  # Golden Rune [9] - NW 40h 14v
    "16000390": "Caldera Hall",  # Smoldering Butterfly 4x - ENE 35h 8v
    "16000400": "Caldera Hall",  # Golden Rune [12] - ESE 32h 2v
    "16000410": "Caldera Hall",  # Furlcalling Finger Remedy - E 82h 17v
    "16000440": "Caldera Hall",  # Drawstring Fire Grease 4x - NNE 41h 11v
    "16000480": "Caldera Hall",  # Crimson Tear Scarab - NNE 38h 23v
    "16000490": "Caldera Hall",  # Stonesword Key - NNW 66h 29v
    "16000710": "Eiglay Temple",  # Serpent's Amnion - ESE 13h 2v
    "16002000": "Prison Town",  # Dragon Heart - NW 46h -61v
    # landmark4 - Abductor Virgin
    "10290": "Inquisitor's Lair",  # Inquisitor's Girandole - W 38h 0v
    # landmark5 - Prison Town Church
    "40590": "Prison Town",  # Somber Smithing Stone [5] - W 65h -14v
    "16000050": "Prison Town",  # Golden Rune [9] - W 75h -3v
    "16000060": "Prison Town",  # Golden Rune [5] - WSW 49h -17v
    "16000080": "Prison Town",  # Furlcalling Finger Remedy - NNW 26h -6v
    "16000100": "Manor Attic",  # Somber Smithing Stone [7] - E 40h 18v
    "16000120": "Prison Town",  # Smithing Stone [6] - WNW 44h -1v
    "16000130": "Prison Town",  # Erdtree Seal - NW 33h -23v
    "16000140": "Prison Town",  # Drawstring Fire Grease 3x - W 57h -25v
    "16000150": "Prison Town",  # Golden Rune [6] - W 48h -25v
    "16000160": "Prison Town",  # Fire Arrow 10x - W 89h -15v
    "16000350": "Prison Town",  # Smithing Stone [6] 2x - W 53h -45v
    "16000360": "Prison Town",  # Golden Rune [9] - WNW 56h -41v
    "16000380": "Prison Town",  # Smithing Stone [5] - W 69h -21v
    "16000500": "Manor Attic",  # Rune Arc - NNE 64h 39v
    "16000610": "Prison Town",  # Smoldering Shield - WNW 48h -43v
    "16000620": "Manor Attic",  # Dagger Talisman - NNE 59h 54v
    "16000700": "Manor Attic",  # Seedbed Curse - N 47h 9v
    "449038002": "Prison Town",  # Raw Meat Dumpling - WNW 50h -44v
    "449038001": "Prison Town",  # Living Jar Shard - WNW 50h -44v
    "482000600": "Prison Town",  # Great Omenkiller Cleaver - W 55h -25v
    # landmark6 - Volcano Manor
    "16000020": "Manor Attic",  # Ash of War: Royal Knight's Resolve - NW 52h -4v
    "16000510": "Caldera Hall",  # Commoner's Headband - SSW 42h 33v
    "16000520": "Caldera Hall",  # Man-Serpent Ashes - NNW 27h 35v
    "16000530": "Caldera Hall",  # Somber Smithing Stone [6] - W 44h 29v
    # landmark7 - Guest Hall
    "16000070": "Prison Town",  # Stonesword Key - N 60h -4v
    "16000170": "Prison Town",  # Golden Rune [9] - SW 34h 0v
    "16000190": "Prison Town",  # Explosive Greatbolt 5x - NW 31h -1v
    "16000200": "Prison Town",  # Golden Rune [9] - ENE 37h -11v
    "16000210": "Prison Town",  # Somber Smithing Stone [6] - E 26h -3v
    "16000220": "Prison Town",  # Fireproof Dried Liver 2x - SSE 22h -11v
    "16000230": "Prison Town",  # Albinauric Bloodclot - NNW 25h 15v
    "16000240": "Prison Town",  # Smithing Stone [4] - W 27h 14v
    "16000250": "Prison Town",  # Smithing Stone [6] 2x - NE 44h -6v
    "16000330": "Prison Town",  # Golden Rune [10] - SSE 9h 24v
    "16000420": "Prison Town",  # Beast Blood 2x - W 23h 15v
    "16000430": "Prison Town",  # Albinauric Staff - NW 13h 8v
    "16000431": "Prison Town",  # Albinauric Mask - NW 13h 8v
    "16000540": "Prison Town",  # Crimson Amber Medallion +1 - NW 92h 22v
    "482000700": "Prison Town",  # Great Omenkiller Cleaver - N 12h 7v
    # landmark8 - Subterranean Inquisition Chamber
    "16000550": "Prison Town",  # Smithing Stone [6] - SSW 52h -9v
    "16000560": "Prison Town",  # Smithing Stone [4] - S 21h -8v
    # region172 - Volcano Manor Drawing Rooms
    # landmark2 - Volcano Manor
    "16000720": "Drawing Rooms",  # Recusant Finger - SW 38h 0v
    "16000110": "Drawing Rooms",  # Perfume Bottle - WNW 27h -1v
    "16000090": "Drawing Rooms",  # Nomadic Warrior's Cookbook [21] - SSW 20h -1v
    "100730": "Drawing Rooms",  # Letter from Volcano Manor (Istvan) - SW 38h 0v
    "100740": "Drawing Rooms",  # Letter from Volcano Manor (Rileigh) - SW 38h 0v
    "100750": "Drawing Rooms",  # Red Letter - SW 38h 0v
    "102900": "Drawing Rooms",  # Letter to Bernahl - SW 40h -1v
    "16000010": "Drawing Rooms",  # Depraved Perfumer Carmaan - WSW 19h -1v
    "16000030": "Drawing Rooms",  # Budding Horn 3x - WSW 50h -1v
    # landmark3 - Prison Town Church
    "16000040": "Drawing Rooms",  # Fireproof Dried Liver - NE 15h -1v
    "429000700": "Drawing Rooms",  # Bloodhound Claws - NNE 14h -1v
    # region173 - Volcano Manor Entrance Hall
    # landmark2 - Volcano Manor
    "16000000": "Volcano Manor",  # Smithing Stone [6] - NW 35h 11v
    "16000940": "Volcano Manor",  # Ghiza's Wheel - NW 32h 11v
    # region177 - West Windmill Pasture
    # landmark2 - Road of Iniquity Side Path
    "370400704": "Windmill Village",  # Battlemage Robe - NNW 74h 31v
    "370400705": "Windmill Village",  # Battlemage Manchettes - NNW 74h 31v
    "370400706": "Windmill Village",  # Battlemage Legwraps - NNW 74h 31v
    # region181 - Writheblood Ruins
    # landmark1 - Writheblood Ruins
    "1040530010": "Writheblood Vault",  # Bloody Helice - WNW 38h -12v
    # region182 - Wyndham Catacombs
    # landmark2 - Gelmir Hero's Grave
    "20120": "Wyndham Tomb",  # Glovewort Picker's Bell Bearing [1] - SSE 52h -82v
    # region184 - Yelough Anix Ruins
    # landmark1 - Yelough Anix Ruins
    "1047550010": "Anix Ruins",  # Rimed Rowa 8x - W 12h -3v
    "1047550020": "Anix Ruins",  # Golden Rune [13] - SE 11h 0v
    "1047550030": "Anix Ruins",  # Stonesword Key - NNW 86h -7v
    "1047550900": "Anix Ruins",  # Unendurable Frenzy - SE 16h -15v
    # region185 - Yelough Anix Tunnel
    # landmark1 - Yelough Anix Ruins
    "20680": "Anix Lair",  # Meteorite of Astel - N 132h -70v
    "32110000": "Anix Tunnel",  # Freezing Grease 3x - WNW 19h -83v
    "32110020": "Anix Tunnel",  # Golden Rune [10] - ESE 30h -91v
    "32110030": "Anix Tunnel",  # Ancient Dragon Smithing Stone - E 25h -102v
    "32110040": "Anix Tunnel",  # Rune Arc - ESE 42h -101v
    "32110060": "Anix Tunnel",  # Explosive Stone Clump 6x - NE 40h -90v
    "32110080": "Anix Tunnel",  # Hero's Rune [5] - NNE 42h -67v
    "360000020": "Anix Tunnel",  # Alabaster Lord's Sword - SE 19h -102v
    # region186 - Zamor Ruins
    # landmark1 - Zamor Ruins
    "1049530700": "the western Mountaintops",  # Map: Mountaintops of the Giants, West - SW 59h -5v
    # region187 - eastern Limgrave
    # landmark3 - Waypoint Ruins Cellar
    "944360200": "western Limgrave",  # Greataxe - WSW 44h 4v
    # region189 - northern Caelid
    # landmark5 - Fort Gael North
    "446040011": "Fort Gael",  # Smoldering Butterfly 5x - ESE 47h 1v
    # landmark9 - Caelem Ruins
    "446040031": "Caelem Ruins",  # Smoldering Butterfly 5x - S 101h -18v
    "446040051": "Caelem Ruins",  # Smoldering Butterfly 5x - SSE 107h -14v
    "446040041": "Caelem Ruins",  # Smoldering Butterfly 5x - SSE 70h -9v
    # region190 - southern Caelid
    # landmark3 - Aeonia Swamp Shore
    "1048380011": "Street of Sages Ruins",  # Traveler's Hat - WSW 46h -1v
    "1048380012": "Street of Sages Ruins",  # Perfumer's Traveling Garb - WSW 46h -1v
    "1048380013": "Street of Sages Ruins",  # Traveler's Gloves - WSW 46h -1v
    "1048380014": "Street of Sages Ruins",  # Traveler's Slops - WSW 46h -1v
    # landmark6 - Gowry's Shack
    "103121": "Gowry's Shack",  # Gowry's Bell Bearing - E 2h 0v
    # region191 - the Academy of Raya Lucaria
    # landmark1 - Raya Lucaria Grand Library
    "14000960": "Academy Library",  # Dark Moon Ring - NNE 11h 0v
    "10181": "Academy Library",  # Great Rune of the Unborn - ESE 10h 0v
    "10180": "Academy Library",  # Remembrance of the Full Moon Queen - ESE 10h 0v
    "14000440": "Academy Courtyard",  # Golden Rune [2] - SE 88h -40v
    "14000450": "Academy Courtyard",  # Golden Rune [4] - SE 71h -40v
    "14000560": "Academy Courtyard",  # Golden Rune [7] - ESE 127h -20v
    "14000910": "Academy Courtyard",  # Glintstone Scarab - ESE 120h -16v
    "14000980": "Academy Courtyard",  # Carian Knight's Shield - ESE 93h -25v
    # landmark2 - Debate Parlor
    "10170": "Academy Parlor",  # Memory Stone - W 6h 0v
    "14000780": "Academy Courtyard",  # Cracked Pot - N 22h 9v
    "14000900": "Lucaria Academy",  # Ritual Pot - WSW 63h -11v
    "14000950": "Lucaria Academy",  # Glintstone Craftsman's Cookbook [5] - NNE 13h -15v
    "14000360": "Lucaria Academy",  # Conspectus Scroll - NNE 22h -15v
    "14000370": "Lucaria Academy",  # Smithing Stone [4] - NE 22h -15v
    "14000410": "Academy Courtyard",  # Living Jar Shard 3x - N 31h 9v
    "14000460": "Academy Courtyard",  # Crystal Bud 5x - SW 15h 15v
    "14000890": "Lucaria Academy",  # Graven-School Talisman - WSW 37h -10v
    "14000940": "Academy Courtyard",  # Radagon Icon - NW 15h 15v
    # landmark3 - Schoolhouse Classroom
    "14000500": "Academy Courtyard",  # Glintstone Whetblade - NNW 48h 26v
    "14000015": "Lucaria Academy",  # Olivinus Glintstone Crown - N 23h -1v
    "14000035": "Academy Courtyard",  # Karolos Glintstone Crown - NW 71h 16v
    "14000190": "Lucaria Academy",  # Magic Grease 2x - NNW 91h -42v
    "14000220": "Lucaria Academy",  # Mushroom 5x - N 94h -39v
    "14000250": "Lucaria Academy",  # Golden Rune [4] - NNW 64h -47v
    "14000320": "Lucaria Academy",  # Longtail Cat Talisman - NW 37h -139v
    "14000330": "Lucaria Academy",  # Crystal Dart 5x - W 29h -3v
    "14000350": "Lucaria Academy",  # Golden Rune [4] - NW 33h 4v
    "14000380": "Lucaria Academy",  # Stonesword Key - SW 31h 17v
    "14000390": "Lucaria Academy",  # Furlcalling Finger Remedy - SW 90h 12v
    "14000420": "Academy Courtyard",  # Stonesword Key - N 42h 22v
    "14000430": "Academy Courtyard",  # Glintstone Firefly 5x - N 81h 19v
    "14000470": "Academy Courtyard",  # Golden Rune [4] - SW 16h 33v
    "14000480": "Academy Courtyard",  # Smithing Stone [5] - NE 58h 13v
    "14000490": "Academy Courtyard",  # Golden Rune [2] - W 21h 29v
    "14000510": "Academy Rooftops",  # Golden Rune [3] - WNW 66h 31v
    "14000520": "Academy Courtyard",  # Crystal Dart 8x - NNE 86h 20v
    "14000530": "Academy Courtyard",  # Golden Rune [4] - N 106h 33v
    "14000540": "Academy Courtyard",  # Furlcalling Finger Remedy - NNE 103h 27v
    "14000600": "Academy Rooftops",  # Golden Rune [4] - WSW 98h 27v
    "14000620": "Academy Rooftops",  # Crystal Dart 5x - W 120h 38v
    "14000860": "Lucaria Academy",  # Somber Smithing Stone [3] - SW 13h -33v
    "14000880": "Lucaria Academy",  # Comet - SW 35h 16v
    "14000990": "Academy Courtyard",  # Golden Seed - NNW 88h 19v
    "360000010": "Lucaria Academy",  # Gravity Well - SW 19h -34v
    "449024002": "Lucaria Academy",  # Raw Meat Dumpling - SW 50h 5v
    "449024001": "Lucaria Academy",  # Living Jar Shard - SW 50h 5v
    "101610": "Academy Gate",  # Smithing Stone [5] - Yura, Hunter of Bloody Fingers
    # landmark5 - Church of the Cuckoo
    "40272": "Lucaria Academy",  # Ash of War: Spectral Lance - ENE 120h -16v
    "14000000": "Academy Gate",  # Magic Grease - NW 54h -13v
    "14000005": "Academy Rooftops",  # Twinsage Glintstone Crown - S 34h 12v
    "14000020": "Lucaria Academy",  # Rune Arc - W 43h 0v
    "14000025": "Academy Rooftops",  # Lazuli Glintstone Crown - SSW 51h 34v
    "14000030": "Lucaria Academy",  # Golden Rune [2] - SW 45h 0v
    "14000040": "Lucaria Academy",  # Somber Smithing Stone [3] - SSW 40h 0v
    "14000070": "Lucaria Academy",  # Grace Mimic 3x - N 17h -4v
    "14000090": "Lucaria Academy",  # Smithing Stone [4] - SSE 44h -13v
    "14000120": "Lucaria Academy",  # Spellproof Dried Liver - ENE 27h -17v
    "14000160": "Lucaria Academy",  # Silver-Pickled Fowl Foot - ENE 88h -21v
    "14000200": "Lucaria Academy",  # Golden Rune [4] - E 104h -21v
    "14000280": "Lucaria Academy",  # Golden Rune [3] - E 71h -49v
    "14000290": "Lucaria Academy",  # Avionette Soldier Ashes - E 65h -49v
    "14000300": "Lucaria Academy",  # Smithing Stone [5] - ESE 109h -108v
    "14000630": "Academy Rooftops",  # Imbued Sword Key - S 63h 33v
    "14000660": "Academy Rooftops",  # Meteor Bolt 5x - S 97h 70v
    "14000670": "Academy Rooftops",  # Smithing Stone [4] - S 82h 71v
    "14000710": "Academy Rooftops",  # Golden Rune [4] - SW 75h 43v
    "14000720": "Academy Rooftops",  # Smithing Stone [3] 2x - SSE 48h 33v
    "14000740": "Academy Rooftops",  # Magic Grease 2x - WSW 44h 25v
    "14000750": "Academy Rooftops",  # Golden Rune [3] - SW 21h 29v
    "14000760": "Academy Rooftops",  # Somber Smithing Stone [4] - SSW 56h 13v
    "14000770": "Academy Rooftops",  # Shattering Crystal - W 26h 12v
    "14000840": "Academy Rooftops",  # Azur's Glintstone Staff - E 48h 12v
    "14000850": "Lucaria Academy",  # Carian Knight Helm - ESE 84h -18v
    "14000851": "Lucaria Academy",  # Carian Knight Armor - ESE 84h -18v
    "14000852": "Lucaria Academy",  # Carian Knight Gauntlets - ESE 84h -18v
    "14000853": "Lucaria Academy",  # Carian Knight Greaves - ESE 84h -18v
    "14000870": "Lucaria Academy",  # Lost Ashes of War - SE 66h -96v
    "14000930": "Academy Rooftops",  # Academy Glintstone Key (Thops) - SW 23h 21v
    "14000970": "Academy Rooftops",  # Full Moon Crossbow - S 101h 83v
    # landmark6 - Academy of Raya Lucaria
    "14000150": "Lucaria Academy",  # Marionette Soldier Ashes - ESE 85h -6v
    # landmark7 - South Raya Lucaria Gate
    "1035450000": "Academy Gate",  # Celestial Dew - NNE 28h 4v
    "1035450030": "Academy Gate",  # Strip of White Flesh 2x - N 58h 9v
    # landmark8 - East Gate Bridge Trestle
    "1035460100": "Academy Gate",  # Golden Seed - SSW 44h 75v
    # landmark9 - Main Academy Gate
    "1035460700": "Academy Gate",  # Ash of War: Raptor of the Mists - SSW 17h 0v
    # region194 - the Capital Outskirts east gate
    # landmark1 - East Capital Rampart
    "34140020": "Leyndell East Lift",  # Flamedrake Talisman +1 - ESE 260h 15v
    # region195 - the Caria Estate
    # landmark1 - Seluvis's Rise
    "101481": "Seluvis's Rise",  # Preceptor's Big Hat - ENE 0h 3v
    "101482": "Seluvis's Rise",  # Preceptor's Long Gown - ENE 0h 3v
    "101483": "Seluvis's Rise",  # Preceptor's Gloves - ENE 0h 3v
    "101484": "Seluvis's Rise",  # Preceptor's Trousers - ENE 0h 3v
    "101480": "Seluvis's Rise",  # Seluvis's Bell Bearing - ENE 0h 3v
    "1034500090": "Seluvis's Rise",  # Black Wolf Mask - SSE 14h 12v
    # region198 - the Cave of the Forlorn
    # landmark1 - Cave of the Forlorn
    "20470": "Forlorn Lair",  # Golden Order Greatsword - NNE 84h -61v
    "31120000": "Forlorn Cave",  # Golden Rune [7] - NE 38h -9v
    "31120010": "Forlorn Cave",  # Freezing Grease - NE 108h -9v
    "31120020": "Forlorn Cave",  # Hero's Rune [2] - ENE 142h -3v
    "31120030": "Forlorn Cave",  # Rune Arc - NE 214h -17v
    "31120040": "Forlorn Cave",  # Miquella's Lily 3x - ENE 61h -26v
    "31120050": "Forlorn Cave",  # Nascent Butterfly - ENE 97h -9v
    "31120060": "Forlorn Cave",  # Thawfrost Boluses 3x - NE 49h -24v
    "31120070": "Forlorn Cave",  # Crystal Dart 8x - ENE 58h -26v
    "31120080": "Forlorn Cave",  # Thawfrost Boluses 2x - ENE 62h -26v
    "31120090": "Forlorn Cave",  # Freezing Grease 6x - NE 40h -48v
    "31120100": "Forlorn Cave",  # Freezing Grease 4x - NE 55h -9v
    "31120110": "Forlorn Cave",  # Golden Rune [10] - ENE 86h -9v
    "31120120": "Forlorn Cave",  # Spiritflame Arrow 10x - NE 213h -17v
    # region199 - the Chapel of Anticipation
    # landmark1 - Church of Irith
    "10030": "Chapel Courtyard",  # Ornamental Straight Sword - SSW 267h 3v
    "10031": "Chapel Courtyard",  # Golden Beast Crest Shield - SSW 267h 3v
    # landmark2 - Rampart Tower
    "10010010": "Chapel of Anticipation",  # The Stormhawk King - WSW 301h -27v
    "10010900": "Chapel of Anticipation",  # Stormhawk Deenh - WSW 306h -25v
    # region200 - the Church of Dragon Communion
    # landmark1 - Church of Dragon Communion
    "40144": "Dragon Church",  # Somber Smithing Stone [1] - SSW 102h -7v
    "1041350000": "Dragon Church",  # Great Dragonfly Head 4x - WSW 79h 7v
    "1041350010": "Dragon Church",  # Smithing Stone [2] - SSE 105h -21v
    "1041350020": "Dragon Church",  # Exalted Flesh - SSW 74h 18v
    # region208 - the Consecrated Snowfield
    # landmark1 - Apostate Derelict
    "1046570300": "Snowfield",  # Golden Rune [1] 6x - SW 375h 4v
    "1046570800": "Snowfield",  # Smithing Stone [7] 3x - SW 369h -19v
    "1046570801": "Snowfield",  # Smithing Stone [8] - SW 369h -19v
    "1047570300": "Snowfield",  # Golden Rune [7] - SSE 145h -24v
    "1047570310": "Snowfield",  # Golden Rune [12] - SSE 138h -24v
    "1047580000": "Snowfield",  # Somber Smithing Stone [9] - ENE 114h 2v
    "1048570700": "Snowfield",  # Explosive Ghostflame - SE 148h -36v
    "1048580300": "Snowfield",  # Golden Rune [13] - E 105h -16v
    # landmark2 - Yelough Anix Tunnel
    "1047550000": "Snowfield",  # Smithing Stone [7] - ESE 71h 16v
    "1048550600": "Snowfield",  # Stalwart Horn Charm +1 - E 156h 0v
    # landmark3 - Yelough Anix Ruins
    "1047560300": "Snowfield",  # Hero's Rune [2] - NW 282h 8v
    "1047560310": "Snowfield",  # Smithing Stone [8] - NNW 183h -2v
    "1047560320": "Snowfield",  # Thawfrost Boluses 2x - NNW 290h 2v
    "1047560330": "Snowfield",  # Crystal Dart 4x - N 225h -9v
    "1047560700": "Snowfield",  # Sanguine Noble Hood - NNW 240h -6v
    "1047560701": "Snowfield",  # Sanguine Noble Robe - NNW 240h -6v
    "1047560702": "Snowfield",  # Sanguine Noble Waistcloth - NNW 240h -6v
    "1048550300": "Snowfield",  # Golden Rune [13] - ESE 148h -10v
    "1048560300": "Snowfield",  # Stonesword Key - NE 216h -6v
    # landmark4 - Consecrated Snowfield
    "1048540800": "Snowfield",  # Golden Rune [1] - WNW 85h -9v
    "1048540810": "Snowfield",  # Golden Rune [3] - WNW 94h -8v
    "1048540820": "Snowfield",  # Golden Rune [6] - W 97h -9v
    "1048540830": "Snowfield",  # Golden Rune [9] - WNW 84h -9v
    "1048540840": "Snowfield",  # Golden Rune [11] - WNW 92h -8v
    "340051300": "Snowfield",  # Rotten Battle Hammer - W 99h -9v
    "340051301": "Snowfield",  # Rotten Duelist Helm - W 99h -9v
    "1049540800": "Snowfield",  # Nomadic Warrior's Cookbook [23] - NNE 67h -6v
    "1049540700": "Snowfield",  # Somber Smithing Stone [8] - NE 89h 1v
    "1049540900": "Snowfield",  # St. Trina's Torch - NNE 48h -4v
    "1049550800": "Snowfield",  # Golden Seed - NNE 194h -4v
    # landmark5 - Inner Consecrated Snowfield
    "1048550700": "Snowfield",  # Ancient Dragon Smithing Stone - SSW 165h 21v
    "1048550710": "Snowfield",  # Night's Cavalry Helm - SSW 165h 21v
    "1048550711": "Snowfield",  # Night's Cavalry Armor - SSW 165h 21v
    "1048550712": "Snowfield",  # Night's Cavalry Gauntlets - SSW 165h 21v
    "1048550713": "Snowfield",  # Night's Cavalry Greaves - SSW 165h 21v
    "1048550900": "Snowfield",  # Flowing Curved Sword - S 138h 19v
    "1048560700": "Snowfield",  # Map: Consecrated Snowfield - NNW 186h 0v
    "40524": "Snowfield",  # Ash of War: White Shadow's Lure - NW 211h -5v
    "1048560800": "Snowfield",  # Somber Ancient Dragon Smithing Stone - WNW 200h -12v
    "430052443": "Snowfield",  # Golden Rune [13] - SSE 117h 26v
    "1049550300": "Snowfield",  # Somber Smithing Stone [9] - SSE 157h 41v
    "1049550700": "Snowfield",  # Larval Tear - SE 140h 31v
    # landmark6 - Ordina, Liturgical Town
    "1048570800": "Snowfield",  # Golden Seed - WSW 122h -22v
    "340052100": "Ordina",  # Rotten Duelist Greaves - NNW 146h 4v
    "1049560350": "Snowfield",  # Smithing Stone [8] - SSE 184h -9v
    # landmark7 - Hidden Path to the Haligtree
    "1049540300": "Snowfield",  # Golden Rune [13] - NE 69h 5v
    "1049540310": "Snowfield",  # Golden Rune [11] - NE 73h 16v
    # landmark8 - Consecrated Snowfield Catacombs
    "430052433": "Snowfield",  # Golden Rune [13] - W 123h -36v
    "1049550310": "Snowfield",  # Old Fang 2x - W 92h -27v
    "1049550320": "Snowfield",  # Fire Blossom 6x - NNW 131h -31v
    "1049550810": "Snowfield",  # Golden Rune [11] - W 178h -46v
    "1050550300": "Snowfield",  # Hefty Beast Bone 2x - N 126h -9v
    "1050550320": "Snowfield",  # Lump of Flesh 4x - NW 35h -7v
    # landmark9 - Albinauric Rise
    "1049550330": "Snowfield",  # Miquella's Lily 3x - SW 109h -7v
    "1049560360": "Snowfield",  # Glintstone Craftsman's Cookbook [8] - SW 54h -5v
    "1049560310": "Snowfield",  # Old Fang 3x - WNW 42h -44v
    "1049560320": "Snowfield",  # Strip of White Flesh 2x - NW 82h -68v
    "1050550310": "Snowfield",  # Golden Rune [9] - SSE 120h 31v
    "1050550800": "Snowfield",  # Somber Smithing Stone [8] - S 85h 68v
    "1050550900": "Snowfield",  # Rune Arc - SSE 24h 22v
    # landmark10 - Cave of the Forlorn
    "1049560300": "Snowfield",  # Albinauric Bloodclot 2x - WSW 93h 35v
    "30550": "Snowfield",  # Dragon Heart 3x - ESE 74h 0v
    "1050560600": "Snowfield",  # Ancient Dragon Smithing Stone - E 68h 11v
    "1050560800": "Snowfield",  # Smithing Stone [8] 3x - SW 69h -2v
    # landmark11 - Minor Erdtree
    "1049560330": "Snowfield",  # Dragonwound Grease 2x - WNW 69h -34v
    "1049560340": "Snowfield",  # Nascent Butterfly 3x - SW 103h -63v
    "1049570700": "Snowfield",  # Somber Smithing Stone [7] - W 115h -49v
    "1049570710": "Snowfield",  # Somber Smithing Stone [8] - W 123h -42v
    "1049570720": "Snowfield",  # Somber Smithing Stone [9] - W 94h -24v
    # region209 - the Consecrated Snowfield Catacombs
    # landmark1 - Consecrated Snowfield Catacombs
    "20191": "Snowfield Tomb",  # Rotten Gravekeeper Cloak - ESE 159h 15v
    "20190": "Snowfield Tomb",  # Great Grave Glovewort 2x - ESE 159h 15v
    "30190000": "Snowfield Catacombs",  # Golden Rune [12] - SSE 140h 35v
    "30190010": "Snowfield Catacombs",  # Rejuvenating Boluses - SE 90h 25v
    "30190020": "Snowfield Catacombs",  # Root Resin 4x - SE 133h 25v
    "30190030": "Snowfield Catacombs",  # Human Bone Shard 8x - S 152h 30v
    "30190040": "Snowfield Catacombs",  # Imp Head (Elder) - S 167h 30v
    # region212 - the Divine Tower of Caelid
    # landmark1 - Divine Tower of Caelid: Basement
    "10730": "Caelid Tower Chamber",  # Godskin Apostle Hood - S 72h -11v
    "10731": "Caelid Tower Chamber",  # Godskin Apostle Robe - S 72h -11v
    "10732": "Caelid Tower Chamber",  # Godskin Apostle Bracelets - S 72h -11v
    "10733": "Caelid Tower Chamber",  # Godskin Apostle Trousers - S 72h -11v
    "34130900": "Caelid Tower Vault",  # Godslayer's Greatsword - S 117h -13v
    # landmark2 - Divine Tower of Caelid
    "34130000": "Dragonbarrow",  # Stonesword Key - SSW 42h -65v
    # landmark3 - Divine Tower of Caelid: Center
    "34130010": "Caelid Tower",  # Rune Arc - SE 38h -49v
    "34130020": "Caelid Tower",  # Golden Rune [12] - SE 38h -68v
    "1049410100": "Dragonbarrow",  # Numen's Rune - ENE 21h -28v
    # region213 - the Divine Tower of Limgrave
    # landmark1 - Stormhill Shack
    "34100000": "Stormveil Bridge",  # Warming Stone - N 166h 106v
    # landmark2 - Limgrave Colosseum
    "34100010": "Stormveil Bridge",  # Soft Cotton - SSW 198h 86v
    "34100110": "Stormveil Bridge",  # Ash-of-War Scarab - SSW 188h 84v
    # landmark3 - Highroad Cave
    "34100070": "Limgrave Tower",  # Stormhawk Feather 5x - N 124h 225v
    "34100080": "Limgrave Tower",  # Silver-Pickled Fowl Foot - NNE 149h 224v
    "34100090": "Limgrave Tower",  # Golden Rune [2] - NNE 164h 226v
    # landmark4 - Limgrave Tower Bridge
    "34100100": "Stormveil Bridge",  # Boltdrake Talisman - ENE 44h 8v
    # region214 - the Divine Tower of Liurnia
    # landmark1 - Liurnia Tower Bridge
    "34110400": "Liurnia Tower",  # Godskin Noble Hood - E 156h 0v
    "34110401": "Liurnia Tower",  # Godskin Noble Robe - E 156h 0v
    "34110402": "Liurnia Tower",  # Godskin Noble Bracelets - E 156h 0v
    "34110403": "Liurnia Tower",  # Godskin Noble Trousers - E 156h 0v
    # landmark2 - Divine Tower of Liurnia
    "34110501": "Liurnia Tower",  # Stargazer Heirloom - W 26h 9v
    "34110500": "Liurnia Tower",  # Cursemark of Death - W 26h 9v
    # region218 - the Grand Lift of Rold
    # landmark1 - Zamor Ruins
    "1049530300": "the western Mountaintops",  # Beast Blood 2x - SSW 188h 8v
    # region219 - the Great Lake of Liurnia
    "446002001": "Academy Gate Town",  # Smoldering Butterfly 5x - S 120h -10v
    # landmark22 - Ravine-Veiled Village
    "1037500001": "UNREACHABLE",  # Stanching Boluses 5x - WNW 30h -3v
    "1037500002": "UNREACHABLE",  # Noble Sorcerer Ashes - WNW 30h -3v
    # region220 - the Hidden Path to the Haligtree
    # landmark1 - Hidden Path to the Haligtree
    "20200": "Hidden Tomb",  # Blackflame Monk Amon - S 178h -62v
    "30200000": "Hidden Path",  # Warming Stone 2x - E 87h -24v
    "30200010": "Hidden Path",  # Sacramental Bud 3x - ESE 59h -30v
    "30200020": "Hidden Path",  # Hero's Rune [1] - SSE 44h -45v
    "30200030": "Hidden Path",  # Old Fang 6x - SSE 36h -50v
    "30200040": "Hidden Path",  # Root Resin 4x - SSE 34h -55v
    "30200050": "Hidden Path",  # Freezing Grease 5x - SSE 42h -13v
    "30200060": "Hidden Path",  # Spelldrake Talisman +2 - S 49h -5v
    "30200900": "Hidden Path",  # Silver Scarab - SE 65h -30v
    "30200910": "Hidden Tomb",  # Deathroot - S 152h -59v
    # region221 - the Lake of Rot
    # landmark1 - Lake of Rot Shoreside
    "101590": "Ainsel Main",  # Discarded Palace Key - N 89h 28v
    "30600": "Lake of Rot",  # Dragonscale Blade - SSE 267h -9v
    "12010090": "Lake of Rot",  # Somber Smithing Stone [9] - S 228h 15v
    "12010110": "Lake of Rot",  # Rot Grease - SSW 64h -8v
    "12010120": "Lake of Rot",  # Black-Key Bolt 10x - SW 115h -8v
    "12010130": "Lake of Rot",  # Warming Stone - S 157h -8v
    "12010370": "Lake of Rot",  # Aeonian Butterfly - E 27h -8v
    "12010380": "Lake of Rot",  # Somber Smithing Stone [7] - ESE 142h -8v
    "12010450": "Lake of Rot",  # Golden Rune [9] - SE 202h -5v
    "12010480": "Lake of Rot",  # Golden Rune [7] - SSE 260h -9v
    "12010490": "Lake of Rot",  # Golden Rune [10] - SSE 255h -9v
    "12010880": "Lake of Rot",  # Somber Smithing Stone [8] - NNE 59h -8v
    "12010890": "Lake of Rot",  # Somber Smithing Stone [7] - WSW 129h -8v
    "336000707": "Lake of Rot",  # Immunizing Horn Charm +1 - SSE 157h -9v
    # landmark2 - Grand Cloister
    "12010020": "Lake of Rot",  # Nomadic Warrior's Cookbook [22] - NW 179h 14v
    "40600": "Lake of Rot",  # Somber Smithing Stone [6] - NE 147h 12v
    "12010030": "Lake of Rot",  # Somber Smithing Stone [8] - ENE 325h 20v
    "12010140": "Lake of Rot",  # Lightningproof Dried Liver - NE 260h 12v
    "12010460": "Lake of Rot",  # Mushroom Crown - ENE 291h 20v
    "360062000": "Lake of Rot",  # Alabaster Lord's Sword - NNE 222h 36v
    # region222 - the Lake of Rot Basin
    # landmark1 - Astel, Naturalborn of the Void
    "10080": "Ainsel Lair",  # Remembrance of the Naturalborn - SSW 66h 0v
    # region224 - the Minor Erdtree in Greyoll's Dragonbarrow
    # landmark1 - Minor Erdtree
    "30415": "the Minor Erdtree in Dragonbarrow",  # Opaline Hardtear - NNE 39h -1v
    "30416": "the Minor Erdtree in Dragonbarrow",  # Stonebarb Cracked Tear - NNE 39h -1v
    "80360": "the Minor Erdtree in Dragonbarrow",  # Ash of War: Rain of Arrows - SSE 82h -98v
    # region230 - the Minor Erdtree in the Consecrated Snowfield
    # landmark1 - Minor Erdtree
    "1050560300": "the Minor Erdtree in Snowfield",  # Tarnished Golden Sunflower 3x - S 31h -1v
    "30555": "the Minor Erdtree in Snowfield",  # Thorny Cracked Tear - NNE 84h 11v
    "30556": "the Minor Erdtree in Snowfield",  # Ruptured Crystal Tear - NNE 84h 11v
    "1050570300": "the Minor Erdtree in Snowfield",  # Warming Stone 4x - NW 22h -5v
    # region232 - the Minor Erdtree in the western Mountaintops of the Giants
    # landmark1 - Minor Erdtree
    "30525": "the Minor Erdtree in the western Mountaintops",  # Cerulean Crystal Tear - SW 3h 1v
    "30526": "the Minor Erdtree in the western Mountaintops",  # Crimson Bubbletear - SW 3h 1v
    "1052560310": "the Minor Erdtree in the western Mountaintops",  # Rune Arc - W 86h -6v
    # region235 - the Sealed Tunnel
    # landmark1 - Divine Tower of West Altus: Gate
    "34120160": "Sealed Depths",  # Golden Rune [9] - N 118h 7v
    "20640": "the Sealed Lair",  # Onyx Lord's Greatsword - N 42h 7v
    # region239 - the Shaded Castle
    # landmark3 - Castellan's Hall
    "10820": "Castellan's Hall",  # Marais Executioner's Sword - W 7h 0v
    "10821": "Castellan's Hall",  # Briar Greatshield - W 7h 0v
    # region240 - the Subterranean Shunning-Grounds
    # landmark1 - Underground Roadside
    "35000610": "the Capital Sewer",  # Ritual Pot - E 75h -40v
    # TODO: This lot is in both the sewer and in Leyndell Catacombs, which are
    #   distinct areas in the fog randomizer. As it's possible to reach these
    #   reach these locations in any order, item hints for this lot are going
    #   to leave one or the other out. Currently defaulting to the sewer since
    #   it has more entry points, but maybe a hint that can give two locations
    #   for an item could be constructed.
    "35000040": "the Capital Sewer",  # Golden Rune [11] - E 36h 0v
    "35000050": "the Capital Sewer",  # Bloodsoaked Manchettes - ENE 42h 0v
    "35000051": "the Capital Sewer",  # Bloodsoaked Mask - ENE 42h 0v
    "35000080": "the Capital Sewer",  # Preserving Boluses - ENE 62h -5v
    "35000090": "the Capital Sewer",  # Furlcalling Finger Remedy - N 61h -5v
    "35000120": "the Capital Sewer",  # Rune Arc - NW 33h 10v
    "35000130": "the Capital Sewer",  # Lost Ashes of War - NW 46h 10v
    "35000240": "the Capital Sewer",  # Grace Mimic - E 90h -12v
    "35000250": "the Capital Sewer",  # String - E 89h -20v
    "35000260": "the Capital Sewer",  # Fire Grease 2x - E 129h -25v
    "35000270": "the Capital Sewer",  # Nomad Ashes - E 114h -35v
    "35000350": "the Capital Sewer",  # Poisoned Stone 3x - SE 41h 0v
    "35000370": "the Capital Sewer",  # Freezing Grease - E 45h -10v
    "35000380": "the Capital Sewer",  # Serpent Arrow 10x - ESE 42h -11v
    "35000530": "the Capital Sewer",  # Warming Stone - SSE 40h -10v
    "35000540": "the Capital Sewer",  # Smithing Stone [8] - E 49h -20v
    "35000730": "the Capital Sewer",  # Warming Stone - E 78h -20v
    "35000740": "the Capital Sewer",  # Poisoned Stone 8x - E 144h -35v
    "35000970": "the Capital Sewer",  # Somber Smithing Stone [6] - ENE 98h -10v
    "424035000": "the Capital Sewer",  # Somber Smithing Stone [7] - NW 48h 10v
    "449035002": "the Capital Sewer",  # Raw Meat Dumpling - E 76h -40v
    "449035001": "the Capital Sewer",  # Living Jar Shard - E 76h -40v
    # landmark3 - Cathedral of the Forsaken
    "10250": "Forsaken Cathedral",  # Bloodflame Talons - SW 0h 0v
    "35000630": "Capital Sewer",  # Smithing Stone [6] - SW 62h 5v
    "35000700": "Forsaken Cathedral",  # Erdtree's Favor +1 - ENE 7h 1v
    # landmark4 - Subterranean Shunning-Grounds
    "35000000": "Sewer Entrance",  # Poisonbone Dart 6x - NNW 12h 0v
    "35000400": "the Capital Sewer",  # Somber Smithing Stone [6] - ESE 30h -21v
    "35000410": "the Capital Sewer",  # Smithing Stone [7] - SSE 33h -15v
    "35000420": "the Capital Sewer",  # Shadow Bait - SSW 33h -10v
    "35000550": "the Capital Sewer",  # Eye of Yelough - ESE 31h -25v
    "35000570": "the Capital Sewer",  # Smithing Stone [7] 4x - SE 42h -9v
    # landmark5 - Leyndell, Capital of Ash
    "35000150": "the Capital Sewer",  # Glass Shard - N 51h -72v
    "35000160": "the Capital Sewer",  # Stonesword Key - N 81h -77v
    "35000170": "the Capital Sewer",  # Rainbow Stone Arrow (Fletched) 10x - NNE 75h -67v
    "35000200": "the Capital Sewer",  # Fireproof Dried Liver - NE 76h -66v
    "35000210": "the Capital Sewer",  # Somber Smithing Stone [8] - ENE 71h -72v
    "35000220": "the Capital Sewer",  # Smithing Stone [7] - E 85h -66v
    # landmark6 - Capital Rampart
    "35000180": "the Capital Sewer",  # Grave Violet 5x - SSW 111h -49v
    "35000190": "the Capital Sewer",  # Smithing Stone [7] - SSW 103h -49v
    "402035001": "the Capital Sewer",  # Ghost Glovewort [6] - SSW 103h -49v
    # landmark7 - Leyndell Catacombs
    "35000280": "the Capital Sewer",  # Preserving Boluses - ENE 111h 20v
    "35000300": "the Capital Sewer",  # Glass Shard - ENE 49h 30v
    "35000310": "the Capital Sewer",  # Mohg's Shackle - ESE 40h 5v
    "35000320": "the Capital Sewer",  # Dappled White Cured Meat - NE 56h 30v
    "35000330": "the Capital Sewer",  # Glass Shard 3x - NE 43h 31v
    "35000340": "the Capital Sewer",  # Golden Centipede 2x - NE 48h 30v
    "35000390": "the Capital Sewer",  # Fire Grease 5x - NE 21h 39v
    "35000430": "the Capital Sewer",  # Golden Rune [10] - ENE 32h 45v
    "35000450": "the Capital Sewer",  # Somber Smithing Stone [7] - NNE 41h 5v
    "35000460": "the Capital Sewer",  # Smithing Stone [7] 2x - NNE 62h 5v
    "35000470": "the Capital Sewer",  # Glass Shard 5x - NNE 27h 5v
    "35000480": "the Capital Sewer",  # Smithing Stone [7] 2x - E 29h 5v
    "35000560": "the Capital Sewer",  # Golden Rune [8] - ENE 20h 46v
    "35000590": "the Capital Sewer",  # Golden Rune [11] - E 80h 36v
    "35000600": "the Capital Sewer",  # Smithing Stone [5] - ENE 82h 26v
    "35000950": "the Capital Sewer",  # Haligdrake Talisman +1 - SW 40h 30v
    "35000980": "the Capital Sewer",  # Somber Smithing Stone [7] - NE 32h 5v
    "214000991": "the Capital Sewer",  # Omen Bairn - NE 47h 30v
    # landmark8 - Lower Capital Church
    "35000510": "the Capital Sewer",  # Golden Rune [11] - SE 43h -39v
    # region246 - the War-Dead Catacombs
    # landmark1 - War-Dead Catacombs
    "20161": "the War-Dead Tomb",  # Golden Seed - WNW 175h -30v
    "20160": "the War-Dead Tomb",  # Redmane Knight Ogha - WNW 175h -30v
    # region248 - the bridge to the Forbidden Lands
    # landmark1 - Forbidden Lands
    "10740": "The Darkness",  # Omenkiller Rollo - SSE 192h -287v
    "34140000": "Leyndell Tower",  # Invigorating White Cured Meat - W 251h 112v
    "34140010": "Leyndell Tower",  # Official's Attire - SW 80h 20v
    "34140720": "Leyndell Tower",  # Somber Smithing Stone [6] - W 195h 113v
    "34140800": "The Darkness",  # Golden Rune [9] - SSE 206h -287v
    "34140810": "Leyndell Tower",  # Blade of Calling - SW 91h 21v
    # region249 - the eastern Mountaintops of the Giants
    # landmark1 - Whiteridge Road
    "1052560300": "the eastern Mountaintops",  # Explosive Greatbolt 5x - NNE 121h -6v
    # landmark2 - Lord Contender's Evergaol
    "30516": "Contender's Evergaol",  # Fingerprint Helm - SW 9h 1v
    "30517": "Contender's Evergaol",  # Fingerprint Armor - SW 9h 1v
    "30518": "Contender's Evergaol",  # Fingerprint Gauntlets - SW 9h 1v
    "30519": "Contender's Evergaol",  # Fingerprint Greaves - SW 9h 1v
    "1053560300": "the eastern Mountaintops",  # Somber Smithing Stone [8] - ENE 112h -47v
    "1053560310": "the eastern Mountaintops",  # Golden Rune [10] - E 83h -26v
    "1053560800": "the eastern Mountaintops",  # Golden Rune [7] - E 67h -24v
    "1053560810": "the eastern Mountaintops",  # Golden Rune [7] - E 81h -26v
    # landmark3 - Spiritcaller Cave
    "1053560700": "the eastern Mountaintops",  # Golden Rune [12] - S 38h 41v
    "1053560720": "the eastern Mountaintops",  # Golden Rune [12] - SW 121h 29v
    "1053570300": "the eastern Mountaintops",  # Golden Rune [11] - NNE 271h 12v
    "30510": "the eastern Mountaintops",  # Dragon Heart - ENE 173h -6v
    # landmark4 - Heretical Rise
    "1053560710": "the eastern Mountaintops",  # Golden Rune [12] - S 78h 1v
    # landmark5 - Freezing Lake
    "40510": "the eastern Mountaintops",  # Ash of War: Seppuku - E 192h -6v
    # landmark6 - First Church of Marika
    "1054550000": "the eastern Mountaintops",  # Smithing Stone [7] 3x - ENE 42h 16v
    # region251 - the inverted Carian Study Hall
    # landmark1 - Carian Study Hall
    "34110100": "the inverted Study Hall",  # Mask of Confidence - ENE 29h -37v
    "34110110": "the inverted Study Hall",  # Holyproof Dried Liver 2x - WSW 21h -79v
    "34110120": "the inverted Study Hall",  # Glintstone Firefly 8x - NNE 6h -79v
    "34110710": "the inverted Study Hall",  # Lucidity - SSE 2h -38v
    # region252 - the outskirts of Farum Azula
    # landmark1 - Dragon Temple Lift
    "13000830": "Azula Outskirts",  # Pearldrake Talisman - W 365h 122v
    # region253 - the rafters of the Shunning-Grounds
    # landmark1 - Subterranean Shunning-Grounds
    "35000030": "the rafters of the Capital Sewer",  # Crimson Amber Medallion +2 - SSE 13h 4v
    # region255 - the western Mountaintops of the Giants
    # landmark1 - Zamor Ruins
    "1049530000": "the western Mountaintops",  # Sliver of Meat 2x - S 96h 17v
    "1049530020": "the western Mountaintops",  # Golden Rune [10] - SW 91h 17v
    # landmark2 - Giants' Mountaintop Catacombs
    "1050530300": "the western Mountaintops",  # Smoldering Butterfly 4x - SSW 40h 21v
    "1050530700": "the western Mountaintops",  # Somber Smithing Stone [7] - SW 136h 3v
    "1050540800": "the western Mountaintops",  # Arteria Leaf 3x - NNW 65h 0v
    "1050540810": "the western Mountaintops",  # Briars of Punishment - NNW 85h 2v
    # landmark3 - Consecrated Snowfield Catacombs
    "1050540000": "the western Mountaintops",  # Lost Ashes of War - SE 135h 183v
    "1051550300": "the western Mountaintops",  # Golden Rune [7] - E 209h 185v
    # landmark4 - Shack of the Lofty
    "80330": "the western Mountaintops",  # Greathood - E 79h 44v
    "1050560500": "the western Mountaintops",  # Warming Stone 3x - SE 38h 2v
    "1050560510": "the western Mountaintops",  # Invigorating White Cured Meat - SE 45h 3v
    "1050560520": "the western Mountaintops",  # Smithing Stone [7] - SE 45h -2v
    "1050560621": "the Shack of the Lofty",  # Traveling Maiden Robe - W 3h 0v
    "1050560622": "the Shack of the Lofty",  # Traveling Maiden Gloves - W 3h 0v
    "1050560623": "the Shack of the Lofty",  # Traveling Maiden Boots - W 3h 0v
    "1050560700": "the western Mountaintops",  # Hoslow's Petal Whip - E 6h 0v
    "1050560701": "the western Mountaintops",  # Hoslow's Helm - E 6h 0v
    "1050560702": "the western Mountaintops",  # Hoslow's Armor - E 6h 0v
    "1050560703": "the western Mountaintops",  # Hoslow's Gauntlets - E 6h 0v
    "1050560704": "the western Mountaintops",  # Hoslow's Greaves - E 6h 0v
    "30530": "the western Mountaintops",  # Death Ritual Spear - N 84h 27v
    "1050570800": "the western Mountaintops",  # Starlight Shards - N 129h 31v
    # landmark5 - Ancient Snow Valley Ruins
    "1051550310": "the western Mountaintops",  # Drawstring Holy Grease 2x - SSW 262h -69v
    "1051550320": "the western Mountaintops",  # Rainbow Stone 4x - SSW 265h -69v
    "1051550330": "the western Mountaintops",  # Golden Rune [13] - SW 159h -41v
    "1051560020": "the western Mountaintops",  # Somber Smithing Stone [9] - E 20h 63v
    "1051560300": "the western Mountaintops",  # Formic Rock 2x - SE 99h -2v
    "1051560310": "the western Mountaintops",  # Soft Cotton 6x - SSE 81h -36v
    "1051560320": "the western Mountaintops",  # Golden Rune [10] - ESE 103h 56v
    "1051560700": "the western Mountaintops",  # Somber Smithing Stone [8] - SSW 78h -38v
    # landmark6 - Castle Sol Main Gate
    "1051570120": "the western Mountaintops",  # Golden Rune [10] - SSW 107h 63v
    "1051570130": "the western Mountaintops",  # Human Bone Shard 5x - SSW 134h 56v
    "1051570720": "the western Mountaintops",  # Helphen's Steeple - S 73h 62v
    "1051570721": "the western Mountaintops",  # Deathroot - S 73h 62v
    # landmark7 - Stargazers' Ruins
    "1051570140": "the western Mountaintops",  # Golden Rune [11] - N 151h -7v
    # landmark8 - Snow Valley Ruins Overlook
    "1051570230": "the western Mountaintops",  # Golden Rune [10] - W 98h 3v
    # landmark9 - Freezing Lake
    "1052570000": "the western Mountaintops",  # Stimulating Boluses 3x - WSW 106h 51v
    "1052570810": "the western Mountaintops",  # Smithing Stone [7] 3x - SSE 91h -26v
    # landmark10 - Heretical Rise
    "1052570800": "the western Mountaintops",  # Golden Seed - SW 94h -66v
}

fogShopRegionHints = {
    # region262 - Caria Manor
    # landmark1 - No landmark
    "100338": "the Caria Estate",  # Ripple Blade - Pidia, Carian Servant
    "100339": "the Caria Estate",  # Black Leather Shield - Pidia, Carian Servant
    "100335": "the Caria Estate",  # Celestial Dew - Pidia, Carian Servant
    "100336": "the Caria Estate",  # Larval Tear - Pidia, Carian Servant
    "100340": "the Caria Estate",  # Weathered Map - Pidia, Carian Servant
    "100325": "the Caria Estate",  # Glintstone Craftsman's Cookbook [7] - Pidia, Carian Servant
    "100326": "the Caria Estate",  # Ritual Pot - Pidia, Carian Servant
    "100329": "the Caria Estate",  # Old Fang 3x - Pidia, Carian Servant
    "100337": "the Caria Estate",  # Budding Horn 2x - Pidia, Carian Servant
    "100330": "the Caria Estate",  # Slumbering Egg 2x - Pidia, Carian Servant
    "100334": "the Caria Estate",  # Ash of War: Carian Retaliation - Pidia, Carian Servant
    # region264 - Isolated Merchant's Shack in Greyoll's Dragonbarrow
    # landmark1 - Table of Lost Grace
    "100888": "Isolated Merchant's Shack in Dragonbarrow",  # Spiked Caestus - Isolated Merchant - NNE 24h -3v
    "100889": "Isolated Merchant's Shack in Dragonbarrow",  # Beast-Repellent Torch - Isolated Merchant - NNE 24h -3v
    "100882": "Isolated Merchant's Shack in Dragonbarrow",  # Land of Reeds Helm - Isolated Merchant - NNE 24h -3v
    "100883": "Isolated Merchant's Shack in Dragonbarrow",  # Land of Reeds Armor - Isolated Merchant - NNE 24h -3v
    "100884": "Isolated Merchant's Shack in Dragonbarrow",  # Land of Reeds Gauntlets - Isolated Merchant - NNE 24h -3v
    "100885": "Isolated Merchant's Shack in Dragonbarrow",  # Land of Reeds Greaves - Isolated Merchant - NNE 24h -3v
    "100880": "Isolated Merchant's Shack in Dragonbarrow",  # Sacrificial Twig 3x - Isolated Merchant - NNE 24h -3v
    "100893": "Isolated Merchant's Shack in Dragonbarrow",  # Festering Bloody Finger 8x - Isolated Merchant - NNE 24h -3v
    "100887": "Isolated Merchant's Shack in Dragonbarrow",  # Dragonwound Grease 2x - Isolated Merchant - NNE 24h -3v
    "100875": "Isolated Merchant's Shack in Dragonbarrow",  # Note: Hidden Cave - Isolated Merchant - NNE 24h -3v
    "100886": "Isolated Merchant's Shack in Dragonbarrow",  # Note: Gateway - Isolated Merchant - NNE 24h -3v
    "100876": "Isolated Merchant's Shack in Dragonbarrow",  # Ritual Pot - Isolated Merchant - NNE 24h -3v
    "100877": "Isolated Merchant's Shack in Dragonbarrow",  # Lost Ashes of War 2x - Isolated Merchant - NNE 24h -3v
    "100878": "Isolated Merchant's Shack in Dragonbarrow",  # Gravel Stone 10x - Isolated Merchant - NNE 24h -3v
    "100890": "Isolated Merchant's Shack in Dragonbarrow",  # Arrow - Isolated Merchant - NNE 24h -3v
    "100891": "Isolated Merchant's Shack in Dragonbarrow",  # Serpent Arrow - Isolated Merchant - NNE 24h -3v
    "100892": "Isolated Merchant's Shack in Dragonbarrow",  # Bolt - Isolated Merchant - NNE 24h -3v
    # region276 - the Academy of Raya Lucaria
    # landmark1 - Table of Lost Grace
    "100689": "Academy Gate",  # St. Trina's Arrow 20x - Isolated Merchant - NNE 24h -3v
    "100691": "Academy Gate",  # Blue Cloth Cowl - Isolated Merchant - NNE 24h -3v
    "100692": "Academy Gate",  # Blue Cloth Vest - Isolated Merchant - NNE 24h -3v
    "100693": "Academy Gate",  # Warrior Gauntlets - Isolated Merchant - NNE 24h -3v
    "100694": "Academy Gate",  # Warrior Greaves - Isolated Merchant - NNE 24h -3v
    "100682": "Academy Gate",  # Sacrificial Twig 3x - Isolated Merchant - NNE 24h -3v
    "100695": "Academy Gate",  # Festering Bloody Finger 8x - Isolated Merchant - NNE 24h -3v
    "100680": "Academy Gate",  # Stonesword Key 3x - Isolated Merchant - NNE 24h -3v
    "100696": "Academy Gate",  # Note: The Preceptor's Secret - Isolated Merchant - NNE 24h -3v
    "100686": "Academy Gate",  # Note: Revenants - Isolated Merchant - NNE 24h -3v
    "100687": "Academy Gate",  # Note: Frenzied Flame Village - Isolated Merchant - NNE 24h -3v
    "100675": "Academy Gate",  # Fevor's Cookbook [2] - Isolated Merchant - NNE 24h -3v
    "100681": "Academy Gate",  # Lost Ashes of War - Isolated Merchant - NNE 24h -3v
    "100676": "Academy Gate",  # Trina's Lily 3x - Isolated Merchant - NNE 24h -3v
    "100678": "Academy Gate",  # Eye of Yelough - Isolated Merchant - NNE 24h -3v
    "100688": "Academy Gate",  # Fanged Imp Ashes - Isolated Merchant - NNE 24h -3v
    "100690": "Academy Gate",  # Meteor Bolt - Isolated Merchant - NNE 24h -3v
    # region277 - the Capital Outskirts
    # landmark1 - Table of Lost Grace
    "100727": "Hermit Merchant's Shack",  # Sentry's Torch - Hermit Merchant - NNE 24h -3v
    "100730": "Hermit Merchant's Shack",  # Distinguished Greatshield - Hermit Merchant - NNE 24h -3v
    "100739": "Hermit Merchant's Shack",  # Prophet Blindfold - Hermit Merchant - NNE 24h -3v
    "100740": "Hermit Merchant's Shack",  # Prophet Trousers - Hermit Merchant - NNE 24h -3v
    "100741": "Hermit Merchant's Shack",  # Prophet Robe - Hermit Merchant - NNE 24h -3v
    "100738": "Hermit Merchant's Shack",  # Consort's Trousers - Hermit Merchant - NNE 24h -3v
    "100737": "Hermit Merchant's Shack",  # Upper-Class Robe - Hermit Merchant - NNE 24h -3v
    "100728": "Hermit Merchant's Shack",  # Rune Arc 3x - Hermit Merchant - NNE 24h -3v
    "100743": "Hermit Merchant's Shack",  # Note: Below the Capital - Hermit Merchant - NNE 24h -3v
    "100725": "Hermit Merchant's Shack",  # Perfume Bottle - Hermit Merchant - NNE 24h -3v
    "100729": "Hermit Merchant's Shack",  # Golden Sunflower 10x - Hermit Merchant - NNE 24h -3v
    "100731": "Hermit Merchant's Shack",  # Arrow - Hermit Merchant - NNE 24h -3v
    "100732": "Hermit Merchant's Shack",  # Golden Arrow - Hermit Merchant - NNE 24h -3v
    "100735": "Hermit Merchant's Shack",  # Great Arrow - Hermit Merchant - NNE 24h -3v
    "100726": "Hermit Merchant's Shack",  # Golden Great Arrow - Hermit Merchant - NNE 24h -3v
    "100733": "Hermit Merchant's Shack",  # Bolt - Hermit Merchant - NNE 24h -3v
    "100734": "Hermit Merchant's Shack",  # Golden Bolt - Hermit Merchant - NNE 24h -3v
    "100736": "Hermit Merchant's Shack",  # Ballista Bolt - Hermit Merchant - NNE 24h -3v
    "100742": "Hermit Merchant's Shack",  # Festering Bloody Finger - Hermit Merchant - NNE 24h -3v
    # region283 - the Weeping Peninsula
    # landmark1 - No landmark
    "100660": "Isolated Merchant's Shack in the Weeping Peninsula",  # Zweihander - Isolated Merchant
    "100663": "Isolated Merchant's Shack in the Weeping Peninsula",  # Great Arrow 15x - Isolated Merchant
    "100656": "Isolated Merchant's Shack in the Weeping Peninsula",  # Ballista Bolt 15x - Isolated Merchant
    "100657": "Isolated Merchant's Shack in the Weeping Peninsula",  # Sacrificial Twig 3x - Isolated Merchant
    "100664": "Isolated Merchant's Shack in the Weeping Peninsula",  # Festering Bloody Finger 5x - Isolated Merchant
    "100658": "Isolated Merchant's Shack in the Weeping Peninsula",  # Lantern - Isolated Merchant
    "100652": "Isolated Merchant's Shack in the Weeping Peninsula",  # Stonesword Key 3x - Isolated Merchant
    "100650": "Isolated Merchant's Shack in the Weeping Peninsula",  # Note: Wandering Mausoleum - Isolated Merchant
    "100659": "Isolated Merchant's Shack in the Weeping Peninsula",  # Lost Ashes of War - Isolated Merchant
    "100665": "Isolated Merchant's Shack in the Weeping Peninsula",  # Smithing Stone [2] 3x - Isolated Merchant
    "100654": "Isolated Merchant's Shack in the Weeping Peninsula",  # Arteria Leaf 5x - Isolated Merchant
    "100661": "Isolated Merchant's Shack in the Weeping Peninsula",  # Arrow - Isolated Merchant
    "100662": "Isolated Merchant's Shack in the Weeping Peninsula",  # Bolt - Isolated Merchant
    # region284 - the western Mountaintops of the Giants
    # landmark1 - Table of Lost Grace
    "100915": "the western Mountaintops",  # Vagabond Knight Helm - Hermit Merchant - NNE 24h -3v
    "100916": "the western Mountaintops",  # Vagabond Knight Armor - Hermit Merchant - NNE 24h -3v
    "100917": "the western Mountaintops",  # Vagabond Knight Gauntlets - Hermit Merchant - NNE 24h -3v
    "100918": "the western Mountaintops",  # Vagabond Knight Greaves - Hermit Merchant - NNE 24h -3v
    "100909": "the western Mountaintops",  # Rune Arc 3x - Hermit Merchant - NNE 24h -3v
    "100903": "the western Mountaintops",  # Thawfrost Boluses 10x - Hermit Merchant - NNE 24h -3v
    "100901": "the western Mountaintops",  # Stonesword Key 3x - Hermit Merchant - NNE 24h -3v
    "100900": "the western Mountaintops",  # Missionary's Cookbook [7] - Hermit Merchant - NNE 24h -3v
    "100910": "the western Mountaintops",  # Arrow - Hermit Merchant - NNE 24h -3v
    "100912": "the western Mountaintops",  # Great Arrow - Hermit Merchant - NNE 24h -3v
    "100911": "the western Mountaintops",  # Bolt - Hermit Merchant - NNE 24h -3v
    "100913": "the western Mountaintops",  # Ballista Bolt - Hermit Merchant - NNE 24h -3v
    "100914": "the western Mountaintops",  # Lightning Greatbolt - Hermit Merchant - NNE 24h -3v
}
