# Copyright (c) 2023 The Old Man and the C
#
# This file is part of Elden Ring Randomizer Hints.
#
# Elden Ring Randomizer Hints is free software: you can redistribute it and/or
# modify it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Elden Ring Randomizer Hints is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
# or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License
# for more details.
#
# You should have received a copy of the GNU Affero General Public License along
# with Elden Ring Randomizer Hints. If not, see <https://www.gnu.org/licenses/>.

# * indicates lots that appear in both Leyndell and Ashen Leyndell
fogGateLots = {
    "bellum|liurnia|liurnia_manor": {
        "using the 2nd Belfry labeled Precipice of Anticipation": {
            "hintName": "Anticipation gate",
            "lotIDs": [
                "1033470020",  # The Four Belfries chest
                "1033470900",  # chest in camp W and below The Four Belfries
                "1033470010",  # chest in camp W and below The Four Belfries
                "1033470910",  # chest in camp E/NE and below The Four Belfries
                "1033470030",  # camp E/NE and below The Four Belfries
                "1033470000",  # NE and below The Four Belfries
                "1033460030",  # SW and below The Four Belfries
                "1033460040",  # SW and below The Four Belfries
            ],
            "ownerGroups": [
                "GROUP_MAGIC",
            ],
            "hintRegion": "western Liurnia",
            "hintArea": "Liurnia",
        },
        "using the 3rd Belfry labeled Night Sky Unceasing": {
            "hintName": "Night Sky gate",
            "lotIDs": [
                "1033470020",  # The Four Belfries chest
                "1033470900",  # chest in camp W and below The Four Belfries
                "1033470010",  # chest in camp W and below The Four Belfries
                "1033470910",  # chest in camp E/NE and below The Four Belfries
                "1033470030",  # camp E/NE and below The Four Belfries
                "1033470000",  # NE and below The Four Belfries
                "1033460030",  # SW and below The Four Belfries
                "1033460040",  # SW and below The Four Belfries
            ],
            "ownerGroups": [
                "GROUP_MAGIC",
            ],
            "hintRegion": "western Liurnia",
            "hintArea": "Liurnia",
        },
        "using the 1st Belfry labeled Crumbling Lands": {
            "hintName": "Crumbling gate",
            "lotIDs": [
                "1033470020",  # The Four Belfries chest
                "1033470900",  # chest in camp W and below The Four Belfries
                "1033470010",  # chest in camp W and below The Four Belfries
                "1033470910",  # chest in camp E/NE and below The Four Belfries
                "1033470030",  # camp E/NE and below The Four Belfries
                "1033470000",  # NE and below The Four Belfries
                "1033460030",  # SW and below The Four Belfries
                "1033460040",  # SW and below The Four Belfries
            ],
            "ownerGroups": [
                "GROUP_MAGIC",
            ],
            "hintRegion": "western Liurnia",
            "hintArea": "Liurnia",
        },
        "entering Cuckoo's Evergaol": {
            "hintName": "Cuckoo's seal",
            "lotIDs": [
                "40264",  # teleporting enemy E of Cuckoo's Evergaol
                "1033460000",  # shore E of Foot of the Four Belfries
                "30210",  # boss E/NE of Cuckoo's Evergaol
                "1034450100",  # near boss E/NE of Cuckoo's Evergaol
                "1034450010",  # near boss E/NE of Cuckoo's Evergaol
                "1034450020",  # near boss E/NE of Cuckoo's Evergaol
                "1034440000",  # SE of Temple Quarter
                "1034440900",  # SE of Temple Quarter
            ],
            "ownerGroups": [
                "GROUP_MAGIC",
            ],
            "hintRegion": "western Liurnia",
            "hintArea": "Liurnia",
        },
        "using the sending gate from the gazebo straight east of Raya Lucaria "
        "South Entrance": {
            "hintName": "lake gazebo gate",
            "lotIDs": [
                "1037450100",  # gazebo E of gate
                "1036450400",  # night boss S of Gate Town North
                "1036450020",  # SW of gate
                "1038440030",  # woods E/SE of gate
                "1036450110",  # chest E and below South Raya Lucaria Gate
                "1037440010",  # N of Academy Gate Town
                "1036440300",  # golden tree NE of Fallen Ruins of the Lake
                "1036440000",  # NW of Academy Gate Town
                "1036440010",  # NW of Academy Gate Town
                "1036440100",  # chest NW of Academy Gate Town
            ],
            "ownerGroups": [
                "GROUP_MAGIC",
            ],
            "hintRegion": "the Great Lake of Liurnia",
            "hintArea": "Liurnia",
        },
        "using the sending gate in Laskyar Ruins or Purified Ruins": {
            "hintName": "ruins gate",
            "lotIDs": [
                "1037420000",  # Laskyar Ruins
                "1037420100",  # Laskyar Ruins
                "1037420010",  # Laskyar Ruins near gate
                "1038410000",  # Laskyar Ruins near grace
                "1037420900",  # Laskyar Ruins chest
                "1039410000",  # Purified Ruins
                "1039410010",  # Purified Ruins
                "1039410100",  # Purified Ruins chest
                "1039410200",  # Purified Ruins in chamber
                "1039420000",  # Purified Ruins near gate
            ],
            "ownerGroups": [
                "GROUP_MAGIC",
            ],
            "hintRegion": "eastern Liurnia",
            "hintArea": "Liurnia",
        },
        "using South Raya Lucaria Gate": {
            "hintName": "Academy gate",
            "lotIDs": [
                "1035450100",  # next to gate
                "1036440060",  # SE of gate
                "1036440050",  # SE of gate
                "1035440000",  # S of gate
                "1035440120",  # SW of gate
            ],
            "ownerGroups": [
                "GROUP_MAGIC",
            ],
            "hintRegion": "the Great Lake of Liurnia",
            "hintArea": "Liurnia",
        },
        "using East Raya Lucaria Gate": {
            "hintName": "Academy gate",
            "lotIDs": [
                "1036480400",  # Bellum Highway night boss
                "1036490000",  # Bellum Church item
                "1036480000",  # by ruin blocking road
                "1037480000",  # on ridge E and above road
                "1036470000",  # S and below East Raya Lucaria Gate
                "1035480030",  # NW and below East Raya Lucaria Gate
            ],
            "ownerGroups": [
                "GROUP_MAGIC",
            ],
            "hintRegion": "Bellum Highway",
            "hintArea": "Bellum Highway",
        },
        "entering Malefactor's Evergaol": {
            "hintName": "Malefactor's seal",
            "lotIDs": [
                "1038410010",  # on gravestone SE of gate
                "1037410010",  # in road W of gate
                "1036410010",  # camp W of gate
                "1036410000",  # camp W of gate
            ],
            "ownerGroups": [
                "GROUP_MAGIC",
            ],
            "hintRegion": "eastern Liurnia",
            "hintArea": "Liurnia",
        },
        "using the Dectus Medallion in Bellum Highway": {
            "hintName": "Dectus lift",
            "lotIDs": [
                "1037490000",  # camp NW of road
                "1038500010",  # lift staircase
                "1037490200",  # camp SE of road
                "1038490000",  # NW and below Frenzy Flaming Tower
                "1038490010",  # NW and below Frenzy Flaming Tower
                "1038490040",  # NW and below Frenzy Flaming Tower
            ],
            "ownerGroups": [
                "GROUP_MAGIC",
            ],
            "hintRegion": "Bellum Highway",
            "hintArea": "Bellum Highway",
        },
        "before Loretta's arena": {
            "hintName": "Moongazing fog",
            "lotIDs": [
                "1035500230",  # stair SE of gate
                "1035500170",  # terrace SE of gate
                "1035500220",  # ledge SW of stair leading to gate
                "1035500080",  # terrace NE of stair leading to gate
                "1035500240",  # near base of stair leading to gate
                "1035500300",  # golden tree NW of Manor Upper Level
            ],
            "ownerGroups": [
                "GROUP_MAGIC",
                "GROUP_KNIGHT"
            ],
            "hintRegion": "western Liurnia",
            "hintArea": "Caria Manor",
        },
        "at the Stormveil Castle rear exit": {
            "hintName": "Stormveil fog",
            "lotIDs": [
                "1039400000",  # graveyard W of gate
                "1038390000",  # graveyard W/SW of gate
                "1039390000",  # church SW of gate
                "1038400010",  # camp S of Liurnia Lake Shore
                "1038400000",  # camp S of Liurnia Lake Shore
            ],
            "ownerGroups": [
                "GROUP_MAGIC",
                "GROUP_KNIGHT"
            ],
            "hintRegion": "eastern Liurnia",
            "hintArea": "Liurnia",
        },
        "at the entrance to Raya Lucaria Crystal Tunnel": {
            "hintName": "tunnel fog",
            "lotIDs": [
                "1036470000",  # S and below East Raya Lucaria Gate
                "40210",  # teleporting enemy NE of East Gate Bridge Trestle
                "1035460020",  # under academy gate south bridge
                "1036450400",  # night boss S of Gate Town North
            ],
            "ownerGroups": [
                "GROUP_MAGIC",
            ],
            "hintRegion": "eastern Liurnia",
            "hintArea": "Liurnia",
        },
        "at the entrance to Carian Study Hall": {
            "hintName": "Study Hall fog",
            "lotIDs": [
                "1038470030",  # N of Ainsel River Well
                "1037450100",  # gazebo W/NW of Eastern Liurnia Lake Shore
                "1038440030",  # SW of Eastern Liurnia Lake Shore
                "1038460000",  # NW of Eastern Tableland
                "1038450000",  # camp SW of Eastern Tableland
                "1038450010",  # camp SW of Eastern Tableland
            ],
            "ownerGroups": [
                "GROUP_MAGIC",
            ],
            "hintRegion": "eastern Liurnia",
            "hintArea": "Liurnia",
        },
        "at the Ainsel River Well": {
            "hintName": "Ainsel well",
            "lotIDs": [
                "1038470030",  # N of Ainsel River Well
                "1038460000",  # NW of Eastern Tableland
                "1038450000",  # camp SW of Eastern Tableland
                "1038450010",  # camp SW of Eastern Tableland
            ],
            "ownerGroups": [
                "GROUP_MAGIC",
            ],
            "hintRegion": "eastern Liurnia",
            "hintArea": "Liurnia",
        },
        "before Royal Revenant's arena in Kingsrealm Ruins": {
            "hintName": "Kingsrealm fog",
            "lotIDs": [
                "1034480000",  # Kingsrealm Ruins
                "1034480010",  # Kingsrealm Ruins
                "1035490000",  # basin NE and below Road to the Manor
                "1035480020",  # ruin E of Kingsrealm Ruins
                "1035480010",  # ruin SE of Kingsrealm Ruins
            ],
            "ownerGroups": [
                "GROUP_MAGIC",
            ],
            "hintRegion": "western Liurnia",
            "hintArea": "Kingsrealm Ruins",
        },
        "at the Ruin-Strewn Precipice entrance": {
            "hintName": "Precipice fog",
            "lotIDs": [
                "40224",  # enemy NW of Ravine-Veiled Village
                "1038500000",  # shack near Ravine-Veiled Village
                "1037500100",  # golden tree SW of Ravine-Veiled Village
                "1035490020",  # W of The Ravine
                "1035480020",  # ruin E of Kingsrealm Ruins
                "1035480030",  # NW and below East Raya Lucaria Gate
            ],
            "ownerGroups": [
                "GROUP_MAGIC",
            ],
            "hintRegion": "eastern Liurnia",
            "hintArea": "Liurnia",
        },
        "along the side path from Stormhill": {
            "hintName": "Stormhill fog",
            "lotIDs": [
                "1039400000",  # graveyard W of Lake-Facing Cliffs
                "1038390000",  # graveyard W/SW of Lake-Facing Cliffs
                "1039390000",  # church W of gate
                "1038400010",  # camp S of Liurnia Lake Shore
                "1038400000",  # camp S of Liurnia Lake Shore
            ],
            "ownerGroups": [
                "GROUP_MAGIC",
            ],
            "hintRegion": "eastern Liurnia",
            "hintArea": "Liurnia",
            "newGate": True
        },
        "at the entrance to Road's End Catacombs": {
            "hintName": "Road's End fog",
            "lotIDs": [
                "40238",  # enemy N of gate
                "1034430100",  # Converted Tower chest
                "1034430000",  # Converted Tower
                "1034430300",  # Converted Tower
                "30205",  # Minor Erdtree boss
            ],
            "ownerGroups": [
                "GROUP_MAGIC",
            ],
            "hintRegion": "western Liurnia",
            "hintArea": "Liurnia",
        },
        "at the entrance to Academy Crystal Cave, with Stonesword Key": {
            "hintName": "Academy Cave fog",
            "lotIDs": [
                "30210",  # boss SW of gate
                "1034450100",  # near boss SW of gate
                "1034450010",  # near boss SW of gate
                "1034450020",  # near boss SW of gate
                "1034460100",  # gazebo N of Crystalline Woods
            ],
            "ownerGroups": [
                "GROUP_MAGIC",
            ],
            "hintRegion": "the Great Lake of Liurnia",
            "hintArea": "Liurnia",
        },
        "at the entrance to Lakeside Crystal Cave": {
            "hintName": "Lakeside fog",
            "lotIDs": [
                "1036420000",  # basin on island NW of Scenic Isle
                "1037420400",  # night boss N of Scenic Isle
                "1037420030",  # island N of gate
                "1037420000",  # Laskyar Ruins
                "1037420100",  # Laskyar Ruins
                "1037420010",  # Laskyar Ruins near gazebo
                "1037420900",  # Laskyar Ruins chest
            ],
            "ownerGroups": [
                "GROUP_MAGIC",
            ],
            "hintRegion": "eastern Liurnia",
            "hintArea": "Liurnia",
        },
        "at the entrance to Stillwater Cave": {
            "hintName": "Stillwater fog",
            "lotIDs": [
                "1038410010",  # on gravestone NW of Liurnia Lake Shore
                "1038400010",  # camp S of Liurnia Lake Shore
                "1038400000",  # camp S of Liurnia Lake Shore
                "1039400000",  # graveyard W of Lake-Facing Cliffs
                "1038390000",  # graveyard W/SW of Lake-Facing Cliffs
            ],
            "ownerGroups": [
                "GROUP_MAGIC",
            ],
            "hintRegion": "eastern Liurnia",
            "hintArea": "Liurnia",
        },
        "at the entrance to Cliffbottom Catacombs": {
            "hintName": "Cliffbottom fog",
            "lotIDs": [
                "1039410020",  # S of gate
                "1039410000",  # Purified Ruins
                "1039410010",  # Purified Ruins
                "1039410100",  # Purified Ruins chest
                "1039410200",  # Purified Ruins in chamber
                "1039420000",  # Purified Ruins
                "1039410030",  # W and above gate
            ],
            "ownerGroups": [
                "GROUP_MAGIC",
            ],
            "hintRegion": "eastern Liurnia",
            "hintArea": "Liurnia",
        },
        "at the entrance to Black Knife Catacombs": {
            "hintName": "Black Knife fog",
            "lotIDs": [
                "1038470030",  # N of Ainsel River Well
                "1038460000",  # NW of Eastern Tableland
                "1038470010",  # SE of Ruined Labyrinth
                "1037470030",  # W of Ruined Labyrinth
            ],
            "ownerGroups": [
                "GROUP_MAGIC",
            ],
            "hintRegion": "eastern Liurnia",
            "hintArea": "Liurnia",
        }
    },
    "caelid|caelid_redmane|dragonbarrow|limgrave|peninsula|peninsula_morne|"
    "stormhill": {
        "opening the transporter chest atop the Tower of Return": {
            "hintName": "Return trap",
            "lotIDs": [
                "1041320000",  # coffin W of gate
                "1041320010",  # coffin W of gate
                "1041320020",  # coffin W of gate
                "1041320030",  # coffin W of gate
                "1041320040",  # coffin W of gate
                "1041320050",  # coffin W of gate
                "1042320000",  # NE of gate
                "1042320020",  # E of gate
            ],
            "hintRegion": "the Weeping Peninsula",
            "hintArea": "Weeping Peninsula",
        },
        "opening the transporter chest in Dragon-Burnt Ruins in Agheel Lake": {
            "hintName": "ruins trap",
            "lotIDs": [
                "1043360010",  # Dragon-Burnt Ruins
                "1043360020",  # Dragon-Burnt Ruins
                "1043360040",  # Dragon-Burnt Ruins
                "1043361010",  # Dragon-Burnt Ruins chest
                "30110",  # Agheel Lake boss
                "1042360050",  # W of Dragon-Burnt Ruins
                "1043350010",  # S of Dragon-Burnt Ruins
                "1043350030",  # S/SE of Dragon-Burnt Ruins on top of ruin
                "1043360070",  # NE of Dragon-Burnt Ruins
            ],
            "ownerGroups": [
                "GROUP_FIRE",
                "GROUP_DRAGON"
            ],
            "hintRegion": "Agheel Lake",
            "hintArea": "Dragon-Burnt Ruins",
        },
        "entering Weeping Evergaol": {
            "hintName": "Weeping seal",
            "lotIDs": [
                "40132",  # enemy on ruin E of Weeping Evergaol
                "1042340010",  # Tombsward Ruins
                "1042340100",  # Tombsward Ruins chest
                "1041330200",  # Fourth Church of Marika
                "1042340020",  # beach N of Weeping Evergaol
                "1041330030",  # Witchbane Ruins
                "1041330100",  # Witchbane Ruins chamber
                "1041330000",  # beach W of Witchbane Ruins
                "1041330010",  # beach W of Witchbane Ruins
            ],
            "hintRegion": "the Weeping Peninsula",
            "hintArea": "Weeping Peninsula",
        },
        "entering Stormhill Evergaol": {
            "hintName": "Stormhill seal",
            "lotIDs": [
                "1042380140",  # Stormgate
                "1042380010",  # Stormgate
                "1042382000",  # Stormgate on N ridge above
                "1042380120",  # Stormgate on ruin above
                "1042371300",  # Stormgate chest
                "1041370020",  # half basin SW and above Stormfoot Catacombs
                "1041380100",  # golden tree S of Stormhill Shack
                "1041380030",  # SE of Stormhill Shack
            ],
            "hintRegion": "Stormhill",
            "hintArea": "Stormhill",
        },
        "entering Forlorn Hound Evergaol": {
            "hintName": "Hound seal",
            "lotIDs": [
                "1044340080",  # S and below Forlorn Hound Evergaol
                "1044340050",  # S/SW and below Forlorn Hound Evergaol
                "1043350000",  # S of Seaside Ruins
                "1044350000",  # N of Forlorn Hound Evergaol
                "1044350030",  # W of Agheel Lake South
                "1044350010",  # camp E of Agheel Lake South
                "1044350060",  # camp E of Agheel Lake South
                "1044350900",  # chest in camp E of Agheel Lake South
                "1044350020",  # cliff NE of Forlorn Hound Evergaol
                "1044350070",  # half basin NE of Forlorn Hound Evergaol
            ],
            "hintRegion": "western Limgrave",
            "hintArea": "Limgrave",
        },
        "entering Sellia Evergaol": {
            "hintName": "Sellia seal",
            "lotIDs": [
                "1049400040",  # statue SE and above Deep Siofra Well
                "1049400010",  # N and above Sellia Crystal Tunnel
                "1049400000",  # N and above Sellia Crystal Tunnel
                "1049400020",  # E of Dragonbarrow West
            ],
            "ownerGroups": [
                "GROUP_DRAGON",
            ],
            "hintRegion": "Greyoll's Dragonbarrow",
            "hintArea": "Dragonbarrow",
        },
        "using the sending gate in Redmane Castle": {
            "hintName": "stair gate",
            # only using lots that aren't cut off during festival
            "lotIDs": [
                "1051360120",  # S room with one way door to outside
                "1051360080",  # S room with one way door to outside
                "1051360040",  # in bailey
                "1051360090",  # on top of central building
                "1051360000",  # in wooden structure south of large tree
            ],
            "ownerGroups": [
                "GROUP_KNIGHT",
            ],
            "hintRegion": "southern Caelid",
            "hintArea": "Redmane Castle",
        },
        "using the sending gate atop Fort Gael": {
            "hintName": "fort gate",
            "lotIDs": [
                "1047380700",  # enemy in Fort Gael courtyard
                "1047380920",  # chest in Fort Gael room
                "1047380900",  # chest on top of Fort Gael
                "1047380110",  # catwalk on N side of Fort Gael
                "1047380080",  # beam over Fort Gael courtyard
                "1047380070",  # Fort Gael courtyard
            ],
            "hintRegion": "northern Caelid",
            "hintArea": "Fort Gael",
        },
        "using either sending gate in Impassable Greatbridge": {
            "hintName": "bridge gate",
            "lotIDs": [
                "1051360020",  # on siege tower in front of Redmane Castle
                "1051360030",  # under siege tower in front of Redmane Castle
                "1050360900",  # in siege tower near Impassable Greatbridge
                "1050360000",  # camp near Impassable Greatbridge
                "1049360000",  # battleground NW of Impassable Greatbridge
            ],
            "hintRegion": "southern Caelid",
            "hintArea": "Caelid",
        },
        "using the sending gate north of Third Church of Marika": {
            "hintName": "church gate",
            "lotIDs": [
                "1046380300",  # basin in Third Church of Marika
                "1046380100",  # Third Church of Marika
                "1046380010",  # W/NW of Third Church of Marika
                "1045390040",  # W end of the stream by Third Church of Marika
                "1045380000",  # under ruin NE of Mistwood Outskirts
                "1046370000",  # beach E of Siofra River Well
            ],
            "hintRegion": "eastern Limgrave",
            "hintArea": "Limgrave",
        },
        "before Nox Duo's arena in Sellia Chair-Crypt": {
            "hintName": "Chair-Crypt fog",
            "lotIDs": [
                "1049390000",  # roof bridge over main street in Sellia
                "1049390010",  # roof S of Sellia Under-Stair
                "1049390030",  # balcony above chest in Sellia
                "1049390040",  # ruined building N/NW of Sellia Under-Stair
                "1049390910",  # chest in Sellia
                "1050390900",  # chest in Sellia
                "1050390910",  # chest in Sellia
                "1050390070",  # roof E of Sellia Under-Stair
                "1050390100",  # golden tree S of Sellia Backstreets
                "1050390000",  # at top of stair in Sellia
                "1050390010",  # roof E/SE of Sellia Under-Stair
                "80060",  # Sellia painting
            ],
            "ownerGroups": [
                "GROUP_MAGIC",
                "GROUP_ROT"
            ],
            "hintRegion": "the Swamp of Aeonia",
            "hintArea": "Caelid",
        },
        "before Margit's arena": {
            "hintName": "Castleward fog",
            "lotIDs": [
                "40104",  # enemy N of Castleward Tunnel
                "1041380040",  # Stormhill Shack
                "1041380010",  # graveyard S/SE of Castleward Tunnel
                "1041380050",  # graveyard S/SE of Castleward Tunnel
                "1041382000",  # graveyard S/SE of Castleward Tunnel
                "1040380000",  # graveyard W/SW of Castleward Tunnel
                "1041390000",  # under Stormveil Bridge N of Castleward Tunnel
                "1041380100",  # golden tree S of Stormhill Shack
                "1041380030",  # SE of Stormhill Shack
            ],
            "ownerGroups": [
                "GROUP_KNIGHT",
            ],
            "hintRegion": "Stormhill",
            "hintArea": "Stormhill",
        },
        "before Mad Pumpkin Heads' arena in Caelem Ruins": {
            "hintName": "Caelem fog",
            "lotIDs": [
                "1047400040",  # camp N/NW of Caelem Ruins
                "1047400900",  # chest in camp N/NW of Caelem Ruins
                "1047400920",  # cart chest NW of Caelem Ruins
                "1047400070",  # Caelem Ruins
                "1047400080",  # Caelem Ruins
                "1048390040",  # Caelem Ruins
                "1048400010",  # coffin E of Caelem Ruins
                "1048400020",  # coffin E of Caelem Ruins
                "1048400030",  # coffin E of Caelem Ruins
                "1048400050",  # SE of Caelem Ruins
                "1048400040",  # NE of Smoldering Wall
                "1047390040",  # NW of Smoldering Wall
                "1047390080",  # chest SW of Smoldering Wall
                "1047390000",  # SE of Forsaken Ruins
            ],
            "hintRegion": "northern Caelid",
            "hintArea": "Caelid",
        },
        "at the entrance to Caelid Catacombs": {
            "hintName": "Caelid Catacombs fog",
            "lotIDs": [
                "1050360900",  # in siege tower near Impassable Greatbridge
                "1050360000",  # camp near Impassable Greatbridge
                "1049360000",  # battleground NW of Impassable Greatbridge
                "1049360010",  # W of Caelid Catacombs
                "1049370020",  # NW of Caelid Catacombs
                "1049370000",  # basin S of Southern Aeonia Swamp Bank
                "1049370010",  # S/SE of Southern Aeonia Swamp Bank
                "1049370050",  # S/SE of Southern Aeonia Swamp Bank
                "1049370100",  # boss W/SW of Southern Aeonia Swamp Bank
            ],
            "hintRegion": "southern Caelid",
            "hintArea": "Caelid",
        },
        "at the entrance to Groveside Cave": {
            "hintName": "Groveside fog",
            "lotIDs": [
                "1042370010",  # W/SW of Groveside Cave
                "1042370000",  # Gatefront Ruins
                "942370060",  # Gatefront Ruins cart
                "942370070",  # Gatefront Ruins cart
                "1042371011",  # Gatefront Ruins chest
                "1042360060",  # anvil in Church of Elleh
                "1042360040",  # E of Church of Elleh
                "1042360030",  # near Church of Elleh
                "30100",  # boss SE of Church of Elleh
            ],
            "hintRegion": "western Limgrave",
            "hintArea": "Limgrave",
        },
        "at the entrance to Limgrave Tunnels": {
            "hintName": "tunnels fog",
            "lotIDs": [
                "1043360010",  # Dragon-Burnt ruins
                "1043360020",  # Dragon-Burnt ruins
                "1043360040",  # Dragon-Burnt ruins
                "1043361010",  # Dragon-Burnt ruins chest
                "30110",  # Agheel Lake boss
                "1042360050",  # W of Dragon-Burnt Ruins
                "1043360070",  # NE of Dragon-Burnt Ruins
            ],
            "hintRegion": "Agheel Lake",
            "hintArea": "Limgrave",
        },
        "at the entrance to Gael Tunnel Start": {
            "hintName": "Gael fog",
            "lotIDs": [
                "1047390040",  # NW of Smoldering Wall
                "1047390080",  # chest SW of Smoldering Wall
                "1047390000",  # SE of Forsaken Ruins
                "1047400000",  # Forsaken Ruins
                "1047400020",  # Forsaken Ruins
                "1047400910",  # Forsaken Ruins chest
                "1046390000",  # coffin above Gael Tunnel
                "1046390010",  # coffin above Gael Tunnel
                "1046390020",  # coffin above Gael Tunnel
            ],
            "hintRegion": "northern Caelid",
            "hintArea": "Caelid",
        },
        "at the entrance to Stormfoot Catacombs": {
            "hintName": "Stormfoot fog",
            "lotIDs": [
                "1042370010",  # W/SW of Groveside Cave
                "1042360060",  # anvil in Church of Elleh
                "1042360040",  # E of Church of Elleh
                "1042360030",  # near Church of Elleh
                "30100",  # boss SE of Church of Elleh
            ],
            "hintRegion": "western Limgrave",
            "hintArea": "Limgrave",
        },
        "at the entrance to Morne Tunnel": {
            "hintName": "tunnel fog",
            "lotIDs": [
                "1043330010",  # NW and below Ailing Village
                "1044340040",  # W/SW of Earthbore Cave
                "1043340000",  # Demi-Human Forest Ruins
                "1043340100",  # Demi-Human Forest Ruins chest
                "1043340400",  # Demi-Human Forest Ruins boss
                "1043340040",  # SE of Demi-Human Forest Ruins
                "1043340050",  # SE of Demi-Human Forest Ruins
            ],
            "hintRegion": "the Weeping Peninsula",
            "hintArea": "Weeping Peninsula",
        },
        "at the entrance to Murkwater Catacombs": {
            "hintName": "Murkwater Catacombs fog",
            "lotIDs": [
                "80000",  # Artist's Shack painting
                "1044380010",  # Artist's Shack
                "1044380040",  # NE and below Murkwater Coast
                "1043380020",  # W/NW of Murkwater Coast
                "1043380000",  # camp SW of Murkwater Coast
                "1042370700",  # invader S and below Murkwater Coast
            ],
            "hintRegion": "western Limgrave",
            "hintArea": "Limgrave",
        },
        "at the entrance to Deathtouched Catacombs": {
            "hintName": "Deathtouched fog",
            "lotIDs": [
                "1042390900",  # chest in camp S of Deathtouched Catacombs
                "1043390010",  # camp S of Deathtouched Catacombs
                "1043392000",  # N and above Saintsbridge
                "1043390020",  # E of Saintsbridge
                "1043400010",  # N and above Highroad Cave
            ],
            "hintRegion": "Stormhill",
            "hintArea": "Stormhill",
        },
        "at the entrance to Impaler's Catacombs": {
            "hintName": "Impaler's fog",
            "lotIDs": [
                "1045330100",  # chest in Oridys's Rise
                "1045330000",  # half basin E of Oridys's Rise
                "1045340000",  # N and above Impaler's Catacombs
                "1044320040",  # turret SE of Castle Morne Rampart
                "1044320030",  # turret SE of Castle Morne Rampart
            ],
            "hintRegion": "the Weeping Peninsula",
            "hintArea": "Weeping Peninsula",
        },
        "at the entrance to Sellia Crystal Tunnel": {
            "hintName": "Sellia Tunnel fog",
            "lotIDs": [
                "1049390000",  # roof bridge over main street in Sellia
                "1049390010",  # roof S of Sellia Under-Stair
                "1049390030",  # balcony above chest in Sellia
                "1049390040",  # ruined building N/NW of Sellia Under-Stair
                "1049390910",  # chest in Sellia
                "1050390900",  # chest in Sellia
                "1050390910",  # chest in Sellia
                "1050390070",  # roof E of Sellia Under-Stair
                "1050390100",  # golden tree S of Sellia Backstreets
                "1050390000",  # at top of stair in Sellia
                "1050390010",  # roof E/SE of Sellia Under-Stair
                "80060",  # Sellia painting
                "1049390020",  # island W of Sellia Under-Stair
                "1048390010",  # crystals in canyon N of swamp
            ],
            "ownerGroups": [
                "GROUP_ROT",
            ],
            "hintRegion": "the Swamp of Aeonia",
            "hintArea": "Caelid",
        },
        "at the right entrance to Divine Tower of Caelid": {
            "hintName": "tower right fog",
            "lotIDs": [
                "1049400010",  # N and above Sellia Crystal Tunnel
                "1049400000",  # N and above Sellia Crystal Tunnel
                "1049400020",  # E of Dragonbarrow West
                "1049410040",  # at base of Caelid Tower
                "1049410070",  # at base of Caelid Tower
                "1049410080",  # at base of Caelid Tower
                "1049410090",  # at base of Caelid Tower
                "1049410100",  # ledge on N side of Caelid Tower
                "34130000",  # ledge on S side of Caelid Tower
            ],
            "ownerGroups": [
                "GROUP_DRAGON",
            ],
            "hintRegion": "Greyoll's Dragonbarrow",
            "hintArea": "Dragonbarrow",
        },
        "at the entrance from Stranded Graveyard": {
            "hintName": "Stranded fog",
            "lotIDs": [
                "1042370010",  # W/SW of Groveside Cave
                "1042360060",  # anvil in Church of Elleh
                "1042360040",  # E of Church of Elleh
                "1042360030",  # near Church of Elleh
                "30100",  # boss SE of Church of Elleh
                "1042360010",  # ledge SE of Stranded Graveyard entrance
            ],
            "hintRegion": "western Limgrave",
            "hintArea": "Limgrave",
        },
        "at the entrance to Minor Erdtree Catacombs": {
            "hintName": "Minor Erdtree fog",
            "lotIDs": [
                "1046400030",  # Smoldering Church
                "1046400050",  # Smoldering Church
                "1046400700",  # invader in Smoldering Church
                "1046400060",  # SE of Smoldering Church
                "1046400000",  # Shack of the Rotting
                "1046400020",  # Shack of the Rotting
                "1046400040",  # Shack of the Rotting
                "1046400010",  # branch W and above Minor Erdtree
                "1047400010",  # branch N of Minor Erdtree
            ],
            "hintRegion": "northern Caelid",
            "hintArea": "Caelid",
        },
        "at the rear exit to Limgrave after the one-way door": {
            "hintName": "Gael rear fog",
            "lotIDs": [
                "1046380300",  # basin in Third Church of Marika
                "1046380100",  # Third Church of Marika
                "1046380010",  # W/NW of Third Church of Marika
                "1045390040",  # W end of the stream by Third Church of Marika
                "1045390050",  # coffin SE and below Summonwater Village
                "1045390060",  # coffin SE and below Summonwater Village
                "1045390070",  # coffin SE and below Summonwater Village
                "1045390080",  # coffin SE and below Summonwater Village
                "1045390090",  # coffin SE and below Summonwater Village
                "1045390100",  # coffin SE and below Summonwater Village
                "1045390110",  # coffin SE and below Summonwater Village
            ],
            "hintRegion": "eastern Limgrave",
            "hintArea": "Limgrave",
        },
        "at the entrance to Tombsward Catacombs": {
            "hintName": "Tombsward Catacombs fog",
            "lotIDs": [
                "1042340000",  # Church of Pilgrimage graveyard
                "1042340030",  # Church of Pilgrimage graveyard
                "1043350100",  # Church of Pilgrimage
                "1042350020",  # ledge NW and below Church of Pilgrimage
                "1042350030",  # ledge NW and below Church of Pilgrimage
                "30185",  # Minor Erdtree boss
                "1043320010",  # S of Minor Erdtree
                "1042330000",  # ledge NW of Minor Erdtree
            ],
            "hintRegion": "the Weeping Peninsula",
            "hintArea": "Weeping Peninsula",
        },
        "at the Siofra River Well": {
            "hintName": "Siofra well",
            "lotIDs": [
                "1046370000",  # beach E of Siofra River Well
                "1045370030",  # W of Siofra River Well
                "1045370300",  # basin near Minor Erdtree
                "1045370000",  # Mistwood Ruins
                "1045370010",  # Mistwood Ruins chest
                "1045371000",  # Mistwood Ruins chamber chest
                "1045370050",  # N of Mistwood Ruins
                "1045370060",  # W of Mistwood Ruins
                "1045370070",  # pond SE of Mistwood Outskirts
                "1045370080",  # pond SE of Mistwood Outskirts
                "1045370090",  # pond SE of Mistwood Outskirts
            ],
            "hintRegion": "Mistwood",
            "hintArea": "Limgrave",
        },
        "at the middle entrance to Divine Tower of Caelid": {
            "hintName": "tower center fog",
            "lotIDs": [
                "1049400010",  # N and above Sellia Crystal Tunnel
                "1049400000",  # N and above Sellia Crystal Tunnel
                "1049400020",  # E of Dragonbarrow West
                "1049410040",  # at base of Caelid Tower
                "1049410070",  # at base of Caelid Tower
                "1049410080",  # at base of Caelid Tower
                "1049410090",  # at base of Caelid Tower
                "1049410100",  # ledge on N side of Caelid Tower
                "34130000",  # ledge on S side of Caelid Tower
            ],
            "ownerGroups": [
                "GROUP_DRAGON",
            ],
            "hintRegion": "Greyoll's Dragonbarrow",
            "hintArea": "Dragonbarrow",
        },
        "before Mad Pumpkin Head's arena in Waypoint Ruins": {
            "hintName": "Waypoint fog",
            "lotIDs": [
                "1043370400",  # night boss on bridge NW of Waypoint Ruins
                "1043380010",  # bridge NW of Waypoint Ruins
                "1044372000",  # N/NW of Waypoint Ruins
                "1044360040",  # W/NW of Waypoint Ruins
                "1044360030",  # S/SW of Waypoint Ruins
                "1044370010",  # N of Waypoint Ruins
                "1044360000",  # Waypoint Ruins
                "1044360010",  # Waypoint Ruins
                "1044360020",  # Waypoint Ruins
                "1044360100",  # Waypoint Ruins
                "1044360300",  # coffin S of Waypoint Ruins
                "1044360310",  # coffin S of Waypoint Ruins
                "1044360320",  # coffin S of Waypoint Ruins
                "1044360330",  # coffin S of Waypoint Ruins
                "1044360340",  # coffin S of Waypoint Ruins
            ],
            "hintRegion": "western Limgrave",
            "hintArea": "Waypoint Ruins",
        },
        "before Redmane Castle Plaza": {
            "hintName": "plaza fog",
            # only using lots that aren't cut off during festival
            "lotIDs": [
                "1051360120",  # S room with one way door to outside
                "1051360080",  # S room with one way door to outside
                "1051360040",  # in bailey
                "1051360090",  # on top of central building
                "1051360000",  # in wooden structure south of large tree
            ],
            "ownerGroups": [
                "GROUP_KNIGHT",
            ],
            "hintRegion": "southern Caelid",
            "hintArea": "Redmane Castle",
        },
        "at the start of Nokron from Limgrave": {
            "hintName": "Starfall fog",
            # special case: crater does not appear until after beating the boss
            # in Wailing Dunes, so put it in the boss drop lot
            # it's only a 9 slot lot, so it's possible this might not happen
            "lotIDs": [
                "10300",  # Wailing Dunes boss
            ],
            "ownerGroups": [
                "GROUP_GRAVITY",
            ],
            "hintRegion": "Mistwood",
            "hintArea": "Limgrave",
        },
        "at the back entrance to Stranded Graveyard from the Seaside Ruins "
        "beach": {
            "hintName": "beach fog",
            "lotIDs": [
                "1043360010",  # Dragon-Burnt ruins
                "1043360020",  # Dragon-Burnt ruins
                "1043360040",  # Dragon-Burnt ruins
                "1043361010",  # Dragon-Burnt ruins chest
                "1042360050",  # W of Dragon-Burnt ruins
                "1043350010",  # S of Dragon-Burnt ruins
                "1043350030",  # S/SE of Dragon-Burnt ruins on top of ruin
                "1043350000",  # S of Seaside Ruins
                "1042350000",  # W and below Seaside Ruins
                "1044350030",  # W of Agheel Lake South
            ],
            "hintRegion": "western Limgrave",
            "hintArea": "Limgrave",
        },
        "at the entrance to Limgrave Colosseum": {
            "hintName": "colosseum fog",
            "lotIDs": [
                "1042390010",  # ruin above camp NE of Warmaster's Shack
                "1042390700",  # invader near Limgrave Colosseum
                "1042400000",  # near Limgrave Colosseum
                "1042390000",  # basin NW of Warmaster's Shack
                "40146",  # enemy on ruin W and above Deathtouched Catacombs
                "1042390900",  # chest in camp S of Deathtouched Catacombs
                "1043390010",  # camp S of Deathtouched Catacombs
                "1043400000",  # trestle N and above Deathtouched Catacombs
            ],
            "ownerGroups": [
                "GROUP_OFFENSE",
            ],
            "hintRegion": "Stormhill",
            "hintArea": "Stormhill",
        },
        "along the side path to Liurnia. go backwards by double-jumping to a "
        "Torrent-sized nook to the left of the ruined bridge pillar": {
            "hintName": "Liurnia fog",
            "lotIDs": [
                "40100",  # enemy E and below Secluded Cell
                "1040390000",  # E/NE of Secluded Cell
                "40104",  # enemy N of Castleward Tunnel
                "1041390000",  # under Stormveil Bridge N of Castleward Tunnel
                "1041380040",  # Stormhill Shack
                "1042390000",  # basin NW of Warmaster's Shack
            ],
            "hintRegion": "Stormhill",
            "hintArea": "Stormhill",
            "newGate": True
        },
        "at the entrance to Tombsward Cave": {
            "hintName": "Tombsward Cave fog",
            "lotIDs": [
                "40132",  # enemy on ruin E of Weeping Evergaol
                "1042340010",  # Tombsward Ruins
                "1042340100",  # Tombsward Ruins chest
                "1041330200",  # Fourth Church of Marika
                "1042340020",  # beach N of Weeping Evergaol
                "1041330030",  # Witchbane Ruins
                "1041330100",  # Witchbane Ruins chamber
                "1041330000",  # beach W of Witchbane Ruins
                "1041330010",  # beach W of Witchbane Ruins
            ],
            "hintRegion": "the Weeping Peninsula",
            "hintArea": "Weeping Peninsula",
        },
        "at the entrance to Coastal Cave": {
            "hintName": "Coastal fog",
            "lotIDs": [
                "1042350010",  # beach S and below Stranded Graveyard entrance
                "40120",  # invisible enemy SW and below Stormfoot Catacombs
                "1041360000",  # NW of Coastal Cave
                "1041370000",  # W/NW and below Stormfoot Catacombs
            ],
            "hintRegion": "western Limgrave",
            "hintArea": "Limgrave",
        },
        "at the entrance to Murkwater Cave": {
            "hintName": "Murkwater Cave fog",
            "lotIDs": [
                "1044380040",  # NE and below Murkwater Coast
                "1042370700",  # invader S and below Murkwater Coast
                "1043370010",  # under bridge S/SE of Murkwater Cave
                "1043360070",  # NE of Dragon-Burnt Ruins
                "30110",  # Agheel Lake boss
            ],
            "hintRegion": "western Limgrave",
            "hintArea": "Limgrave",
        },
        "at the entrance to Highroad Cave": {
            "hintName": "Highroad fog",
            "lotIDs": [
                "1043390030",  # NE of Highroad Cave
                "1043380010",  # W and above Murkwater Catacombs
                "1043392000",  # N and above Saintsbridge
                "1043390020",  # E of Saintsbridge
            ],
            "hintRegion": "western Limgrave",
            "hintArea": "Limgrave",
        },
        "at the entrance to Earthbore Cave": {
            "hintName": "Earthbore fog",
            "lotIDs": [
                "1043330010",  # NW and below Ailing Village
                "1044340040",  # W/SW of Earthbore Cave
                "1043340000",  # Demi-Human Forest Ruins
                "1043340100",  # Demi-Human Forest Ruins chest
                "1043340400",  # Demi-Human Forest Ruins boss
                "1043340040",  # SE of Demi-Human Forest Ruins
                "1043340050",  # SE of Demi-Human Forest Ruins
                "1043340020",  # basin N of Demi-Human Forest Ruins
            ],
            "hintRegion": "the Weeping Peninsula",
            "hintArea": "Weeping Peninsula",
        },
        "at the entrance to Gaol Cave, with Stonesword Key": {
            "hintName": "Gaol fog",
            "lotIDs": [
                "1047380910",  # Caelid Waypoint Ruins chest
                "1047370040",  # Caelid Waypoint Ruins
                "1047380030",  # Caelid Waypoint Ruins
                "1047380040",  # Caelid Waypoint Ruins
                "1047380020",  # NE of Gaol Cave
                "1047390080",  # chest SW of Smoldering Wall
                "1047370050",  # half basin W of Caelid Highway South
            ],
            "ownerGroups": [
                "GROUP_ROT",
            ],
            "hintRegion": "northern Caelid",
            "hintArea": "Caelid",
        },
        "at the entrance to Abandoned Cave": {
            "hintName": "Abandoned fog",
            "lotIDs": [
                "1047400070",  # Caelem Ruins
                "1047400080",  # Caelem Ruins
                "1048390040",  # Caelem Ruins
                "1048400010",  # coffin E of Caelem Ruins
                "1048400020",  # coffin E of Caelem Ruins
                "1048400030",  # coffin E of Caelem Ruins
                "1048400050",  # SE of Caelem Ruins
                "1048400040",  # NE of Smoldering Wall
                "1047390040",  # NW of Smoldering Wall
                "1047390080",  # chest SW of Smoldering Wall
            ],
            "hintRegion": "northern Caelid",
            "hintArea": "Caelid",
        },
        "at the entrance to Sellia Hideaway": {
            "hintName": "Hideaway fog",
            "lotIDs": [
                "1050380020",  # Church of the Plague
                "1050390060",  # half basin NE of Church of the Plague
                "1050390090",  # grave near Sellia Hideaway entrance
                "1050390020",  # giant skull W of Sellia Hideaway
                "1050390030",  # giant skull W of Sellia Hideaway
                "1050390040",  # giant skull W of Sellia Hideaway
                "1050390050",  # giant skull W of Sellia Hideaway
                "1051390040",  # Fort Faroth
                "1051390050",  # Fort Faroth
                "1051390060",  # Fort Faroth
                "1051390900",  # Fort Faroth chest
            ],
            "hintRegion": "southern Caelid",
            "hintArea": "Caelid",
        },
        "at the entrance to Dragonbarrow Cave": {
            "hintName": "cave fog",
            "lotIDs": [
                "1051390040",  # Fort Faroth
                "1051390050",  # Fort Faroth
                "1051390060",  # Fort Faroth
                "1051390900",  # Fort Faroth chest
                "1049400010",  # N and above Sellia Crystal Tunnel
                "1049400000",  # N and above Sellia Crystal Tunnel
                "1049400020",  # E of Dragonbarrow West
                "30415",  # Minor Erdtree boss
                "1052410900",  # Lenne's Rise chest
                "1052410000",  # coffin S and above Lenne's Rise
                "1052410010",  # coffin S and above Lenne's Rise
                "1052410020",  # coffin S and above Lenne's Rise
                "1052410030",  # coffin S and above Lenne's Rise
            ],
            "ownerGroups": [
                "GROUP_DRAGON",
            ],
            "hintRegion": "Greyoll's Dragonbarrow",
            "hintArea": "Dragonbarrow",
        },
        "at the left entrance to Divine Tower of Caelid": {
            "hintName": "tower left fog",
            "lotIDs": [
                "1049400010",  # N and above Sellia Crystal Tunnel
                "1049400000",  # N and above Sellia Crystal Tunnel
                "1049400020",  # E of Dragonbarrow West
                "1049410040",  # at base of Caelid Tower
                "1049410070",  # at base of Caelid Tower
                "1049410080",  # at base of Caelid Tower
                "1049410090",  # at base of Caelid Tower
                "1049410100",  # ledge on N side of Caelid Tower
                "34130000",  # ledge on S side of Caelid Tower
            ],
            "ownerGroups": [
                "GROUP_DRAGON",
            ],
            "hintRegion": "Greyoll's Dragonbarrow",
            "hintArea": "Dragonbarrow",
        }
    },
    "liurnia_postmanor": {
        # not randomized
        # "using the sending gate atop Renna's Rise": {
        #     "hintName": "",
        #     "lotIDs": [],
        #     "ownerGroups": [
        #         "GROUP_MAGIC",
        #     ],
        #     "hintRegion": "the Caria Estate",
        # },
        "entering Royal Grave Evergaol": {
            "hintName": "Royal seal",
            "lotIDs": [
                "1036500010",  # S/SW of Royal Grave Evergaol
                "1036500020",  # W/SW of Royal Grave Evergaol
                "1036500030",  # SW of Royal Grave Evergaol
                "1034500090",  # Seluvis's Rise
            ],
            "ownerGroups": [
                "GROUP_MAGIC",
            ],
            "hintRegion": "the Caria Estate",
        },
        "after Loretta's arena": {
            "hintName": "Moongazing fog",
            "lotIDs": [
                "1036500010",  # S/SW of Royal Grave Evergaol
                "1036500020",  # W/SW of Royal Grave Evergaol
                "1036500030",  # SW of Royal Grave Evergaol
                "1034500090",  # Seluvis's Rise
            ],
            "ownerGroups": [
                "GROUP_MAGIC",
                "GROUP_KNIGHT"
            ],
            "hintRegion": "the Caria Estate",
        }
    },
    "deeproot": {
        "resting in the coffin by the Nameless Eternal City grace": {
            "hintName": "falls coffin",
            "lotIDs": [
                "12030420",  # W of The Nameless Eternal City
                "12030400",  # W of The Nameless Eternal City
                "12030410",  # W of The Nameless Eternal City
                "12030430",  # W of The Nameless Eternal City
                "12030440",  # W of The Nameless Eternal City
                "12030450",  # W of The Nameless Eternal City
                "12030460",  # W of The Nameless Eternal City
                "12030470",  # W of The Nameless Eternal City
            ],
            "ownerGroups": [
                "GROUP_DEATH",
            ],
            "hintRegion": "Deeproot Depths",
        },
        "before the Deeproot Depths boss arena": {
            "hintName": "Godwyn's fog",
            "lotIDs": [
                "12030200",  # branch SW of Across the Roots
                "12030210",  # branch S of Across the Roots
                "12030220",  # roof SW of Across the Roots
                "12030180",  # roof W/NW of Across the Roots
                "12030170",  # branch E of The Nameless Eternal City
                "12030190",  # branch NE of The Nameless Eternal City
            ],
            "ownerGroups": [
                "GROUP_DEATH",
            ],
            "hintRegion": "Deeproot Depths",
        }
    },
    "siofra": {
        "using the sending gate after the Siofra River Bank grace": {
            "hintName": "island gate",
            "lotIDs": [
                "12020100",  # W of Siofra River Bank
                "12020130",  # W of Siofra River Bank
                "12020120",  # SW of Siofra River Bank
                "12020030",  # SW of Siofra River Bank
                "12020140",  # SW and above Siofra River Bank
                "12020160",  # S and above Siofra River Bank
                "12020150",  # NE of Siofra River Bank
                "12020480",  # N of Siofra River Bank
                "12020260",  # NE of Siofra River Bank
                "12020280",  # N/NE of Siofra River Bank
                "12020290",  # N/NE of Siofra River Bank
                "12020270",  # W/SW of Worshippers' Woods
                "12020420",  # under Hallowhorn Grounds stair
                "12020320",  # under Hallowhorn Grounds stair
                "12020370",  # N of Hallowhorn Grounds
                "12020250",  # N/NE of Hallowhorn Grounds
            ],
            "ownerGroups": [
                "GROUP_SPIRIT_TUNER",
            ],
            "hintRegion": "Siofra River",
        },
        "using the sending gate after the Worshippers' Woods grace": {
            "hintName": "woods gate",
            "lotIDs": [
                "12020210",  # near ruin gate
                "12020330",  # wood platform SW of Worshippers' Woods
                "12020340",  # wood platform SW of Worshippers' Woods
                "12020350",  # wood platform SW of Worshippers' Woods
                "12020360",  # wood building SW of Worshippers' Woods
                "12020220",  # ruin S/SE of Worshippers' Woods
                "12020400",  # NW of Worshippers' Woods
                "12020410",  # N of Worshippers' Woods
                "12020040",  # golden tree SW of Below the Well
                "12020430",  # S of Below the Well
                "12020440",  # SE of Below the Well
                "12020450",  # SW of Below the Well
            ],
            "ownerGroups": [
                "GROUP_SPIRIT_TUNER",
            ],
            "hintRegion": "Siofra River",
        },
        "using the sending gate atop rubble before the Worshippers' Woods "
        "grace": {
            "hintName": "pillar gate",
            "lotIDs": [
                "12020170",  # S/SW of Worshippers' Woods
                "12020180",  # S/SW of Worshippers' Woods
                "12020190",  # S of Worshippers' Woods
                "12020200",  # fallen column S of Worshippers' Woods
                "12020240",  # fallen column S of Worshippers' Woods
                "12020220",  # ruin S/SE of Worshippers' Woods
                "12020230",  # S of Worshippers' Woods
                "12020210",  # near ruin gate
                "12020270",  # W/SW of Worshippers' Woods
                "12020300",  # building W of Worshippers' Woods
                "12020310",  # building W of Worshippers' Woods
                "12020330",  # wood platform SW of Worshippers' Woods
                "12020340",  # wood platform SW of Worshippers' Woods
                "12020350",  # wood platform SW of Worshippers' Woods
                "12020360",  # wood building SW of Worshippers' Woods
                "12020250",  # N/NE of Hallowhorn Grounds
                "12020280",  # N/NE of Siofra River Bank
                "12020290",  # N/NE of Siofra River Bank
            ],
            "ownerGroups": [
                "GROUP_SPIRIT_TUNER",
            ],
            "hintRegion": "Siofra River",
        },
        "using Horned Remains in Siofra": {
            "hintName": "horned remains",
            "lotIDs": [
                "12020100",  # W of Siofra River Bank
                "12020130",  # W of Siofra River Bank
                "12020120",  # SW of Siofra River Bank
                "12020030",  # SW of Siofra River Bank
                "12020140",  # SW and above Siofra River Bank
                "12020160",  # S and above Siofra River Bank
                "12020150",  # NE of Siofra River Bank
                "12020480",  # N of Siofra River Bank
                "12020260",  # NE of Siofra River Bank
                "12020280",  # N/NE of Siofra River Bank
                "12020290",  # N/NE of Siofra River Bank
                "12020270",  # W/SW of Worshippers' Woods
                "12020420",  # under Hallowhorn Grounds stair
                "12020320",  # under Hallowhorn Grounds stair
                "12020370",  # N of Hallowhorn Grounds
                "12020250",  # N/NE of Hallowhorn Grounds
            ],
            "ownerGroups": [
                "GROUP_SPIRIT_TUNER",
            ],
            "hintRegion": "Siofra River",
        },
        "at the top of the Deep Siofra Well": {
            "hintName": "Canyon lift",
            "lotIDs": [
                "12020400",  # NW of Worshippers' Woods
                "12020410",  # N of Worshippers' Woods
                "12020040",  # golden tree SW of Below the Well
                "12020430",  # S of Below the Well
                "12020440",  # SE of Below the Well
                "12020450",  # SW of Below the Well
                "12020460",  # cave N and far below Siofra Aqueduct
            ],
            "ownerGroups": [
                "GROUP_SPIRIT_TUNER",
            ],
            "hintRegion": "Siofra River",
        },
        "at the top of the Siofra River Well": {
            "hintName": "Mistwood lift",
            "lotIDs": [
                "40652",  # enemy on pillar E/NE of Siofra River Well Depths
                "12070180",  # pillar E/NE of Siofra River Well Depths
                "12070010",  # E/NE of Siofra River Well Depths
                "12070020",  # NE of Siofra River Well Depths
                "12070030",  # NE of Siofra River Well Depths
                "12070040",  # ledge NE of Siofra River Well Depths
                "12070050",  # NE of Siofra River Well Depths
                "12070060",  # NE of Siofra River Well Depths
                "12070070",  # NE of Siofra River Well Depths
                "12070080",  # NE of Siofra River Well Depths
                "12070090",  # NE of Siofra River Well Depths
                "12070110",  # wall NE of Siofra River Well Depths
                "12070120",  # upper floor NE of Siofra River Well Depths
                "12070000",  # E/SE of Siofra River Well Depths
            ],
            "ownerGroups": [
                "GROUP_SPIRIT_TUNER",
            ],
            "hintRegion": "Siofra River",
        }
    },
    "siofra_nokron_gargoyles": {
        # boss room, only one lot, may not be able to generate all hints
        "resting in the coffin after defeating the boss": {
            "hintName": "waterfall coffin",
            "lotIDs": [
                "10100"  # boss
            ],
            "ownerGroups": [
                "GROUP_OFFENSE",
            ],
            "hintRegion": "Nokron, Eternal City",
        },
        "at the main entrance of Valiant Gargoyles' arena": {
            "hintName": "Aqueduct fog",
            "lotIDs": [
                "10100"  # boss
            ],
            "ownerGroups": [
                "GROUP_OFFENSE",
            ],
            "hintRegion": "Nokron, Eternal City",
        },
        "at the side entrance to Valiant Gargoyles' arena, next to the main "
        "entrance": {
            "hintName": "spill fog",
            "lotIDs": [
                "10100"  # boss
            ],
            "ownerGroups": [
                "GROUP_OFFENSE",
            ],
            "hintRegion": "Nokron, Eternal City",
        }
    },
    "ainsel|lakeofrot": {
        "resting in the coffin at the bottom of the Grand Cloister": {
            "hintName": "Cloister coffin",
            "lotIDs": [
                "12010820",  # ledge W of Grand Cloister
                "12010830",  # stair W/SW and below Grand Cloister
                "12010840",  # stair W/SW and below Grand Cloister
                "12010850",  # SW and below Grand Cloister
                "12010860",  # N of Grand Cloister
                "12010870",  # N of Grand Cloister
                "12010920",  # chest W/SW of Grand Cloister
            ],
            "ownerGroups": [
                "GROUP_ROT",
            ],
            "hintRegion": "the Lake of Rot",
            "hintArea": "Grand Cloister",
        },
        "in the tunnel leading to Ainsel River Downstream": {
            "hintName": "ledge fog",
            "lotIDs": [
                "12010560",  # SE of Nokstella, Eternal City
                "12010550",  # SE of Nokstella, Eternal City
                "12010540",  # SW of Uhl Palace Ruins
                "12010500",  # Uhl Palace Ruins
                "12010510",  # Uhl Palace Ruins
                "12010530",  # Uhl Palace Ruins
                "12010580",  # Uhl Palace Ruins
                "12010590",  # Uhl Palace Ruins
                "12010710",  # Uhl Palace Ruins
                "12010620",  # N/NW of Nokstella, Eternal City
                "12010740",  # N/NW of Nokstella, Eternal City
                "12010730",  # near Nokstella, Eternal City
                "12010610",  # W/NW of Nokstella, Eternal City
            ],
            "hintRegion": "Ainsel River Main",
        }
    },
    "snowfield": {
        "using the sending gate on the west cliffside": {
            "hintName": "west gate",
            "lotIDs": [
                "1047550010",  # Yelough Anix Ruins
                "1047550020",  # Yelough Anix Ruins
                "1047550030",  # Yelough Anix Ruins
                "1047550900",  # Yelough Anix Ruins chest
                "1047560300",  # NW of Yelough Anix Ruins
                "1047560310",  # N of Yelough Anix Ruins
                "1047560320",  # N of Yelough Anix Ruins
                "1047560330",  # N of Yelough Anix Ruins
                "1047560700",  # invader N of Yelough Anix Ruins
                "1048560300",  # ridge NE of Yelough Anix Ruins
                "1046570300",  # SW of Apostate Derelict
                "1046570800",  # statue SW of Apostate Derelict
            ],
            "ownerGroups": [
                "GROUP_FROST",
            ],
            "hintRegion": "the Consecrated Snowfield",
        },
        "using the Sending Gate in Ordina": {
            "hintName": "Ordina gate",
            "lotIDs": [
                "1048570000",  # balcony E of Ordina, Liturgical Town
                "1048570020",  # under balcony E of Ordina, Liturgical Town
                "1048570010",  # roof N of Ordina, Liturgical Town
                "1048570030",  # N of Ordina, Liturgical Town
                "1048570070",  # N of Ordina, Liturgical Town
                "1048570040",  # N/NW of Ordina, Liturgical Town
                "1048570050",  # roof E of Ordina, Liturgical Town
                "1048570060",  # NW of Ordina, Liturgical Town
                "1048570080",  # roof NE of Ordina, Liturgical Town
                "1048570090",  # roof NW of Ordina, Liturgical Town
                "1048570300",  # stair NE of Ordina, Liturgical Town
                "1048570310",  # NE of Ordina, Liturgical Town
            ],
            "ownerGroups": [
                "GROUP_FROST",
            ],
            "hintRegion": "the Consecrated Snowfield",
            "hintArea": "Ordina",
        },
        "entering Ordina Evergaol": {
            "hintName": "Ordina seal",
            "lotIDs": [
                "1048570000",  # balcony E of Ordina, Liturgical Town
                "1048570020",  # under balcony E of Ordina, Liturgical Town
                "1048570010",  # roof N of Ordina, Liturgical Town
                "1048570030",  # N of Ordina, Liturgical Town
                "1048570070",  # N of Ordina, Liturgical Town
                "1048570040",  # N/NW of Ordina, Liturgical Town
                "1048570050",  # roof E of Ordina, Liturgical Town
                "1048570060",  # NW of Ordina, Liturgical Town
                "1048570080",  # roof NE of Ordina, Liturgical Town
                "1048570090",  # roof NW of Ordina, Liturgical Town
                "1048570300",  # stair NE of Ordina, Liturgical Town
                "1048570310",  # NE of Ordina, Liturgical Town
            ],
            "ownerGroups": [
                "GROUP_FROST",
            ],
            "hintRegion": "the Consecrated Snowfield",
        },
        "using the sending gate in the blizzard area, above Albinauric Rise": {
            "hintName": "east gate",
            "lotIDs": [
                "1049560360",  # SW of Albinauric Rise
                "1049550320",  # NW of Consecrated Snowfield Catacombs
                "1049550330",  # SW of Albinauric Rise
                "1049560310",  # W/NW and below Albinauric Rise
                "1050550310",  # S of Albinauric Rise
                "1050550800",  # peak S of Albinauric Rise
                "1050550900",  # chest S of Albinauric Rise
                "1050550300",  # N of Consecrated Snowfield Catacombs
            ],
            "ownerGroups": [
                "GROUP_FROST",
            ],
            "hintRegion": "the Consecrated Snowfield",
        },
        "at the entrance to Consecrated Snowfield Catacombs": {
            "hintName": "catacombs fog",
            "lotIDs": [
                "1049540700",  # enemy NE of Consecrated Snowfield
                "1049550300",  # outcrop S/SE of Inner Consecrated Snowfield
                "1049550310",  # W of Consecrated Snowfield Catacombs
                "1049550320",  # NW of Consecrated Snowfield Catacombs
                "1049550330",  # SW of Albinauric Rise
                "1049550800",  # golden tree N of Consecrated Snowfield
                "1049550810",  # coffin W of Consecrated Snowfield Catacombs
                "1050550310",  # S of Albinauric Rise
                "1050550800",  # peak S of Albinauric Rise
                "1050550320",  # NW of Consecrated Snowfield Catacombs
                "1050550300",  # N of Consecrated Snowfield Catacombs
            ],
            "ownerGroups": [
                "GROUP_FROST",
            ],
            "hintRegion": "the Consecrated Snowfield",
        },
        "at the entrance to Yelough Anix Tunnel": {
            "hintName": "tunnel fog",
            "lotIDs": [
                "1048550300",  # E/SE of Yelough Anix Ruins
                "1048550600",  # SE of Yelough Anix Ruins
                "1047550000",  # E of Yelough Anix Tunnel
                "1047550010",  # Yelough Anix Ruins
                "1047550020",  # Yelough Anix Ruins
                "1047550030",  # Yelough Anix Ruins
                "1047550900",  # Yelough Anix Ruins chest
            ],
            "ownerGroups": [
                "GROUP_FROST",
            ],
            "hintRegion": "the Consecrated Snowfield",
        },
        "at Hidden Path to Haligtree dungeon exit": {
            "hintName": "Hidden Path fog",
            "lotIDs": [
                "1049540700",  # enemy NE of Consecrated Snowfield
                "1049540800",  # N/NE of Consecrated Snowfield
                "1049540300",  # NW of Hidden Path to the Haligtree
                "1049540310",  # NW of Hidden Path to the Haligtree
                "1048540800",  # coffin NW of Consecrated Snowfield
                "1048540810",  # coffin W/NW of Consecrated Snowfield
                "1048540820",  # coffin W of Consecrated Snowfield
                "1048540830",  # coffin W of Consecrated Snowfield
                "1048540840",  # coffin NW of Consecrated Snowfield
            ],
            "ownerGroups": [
                "GROUP_FROST",
            ],
            "hintRegion": "the Consecrated Snowfield",
        },
        "at the entrance to Cave of the Forlorn, with Stonesword Key": {
            "hintName": "cave fog",
            "lotIDs": [
                "1049560300",  # W and above Cave of the Forlorn
                "1049560310",  # W/NW and below Albinauric Rise
                "1049560320",  # NW and below Albinauric Rise
                "1050560800",  # statue SW of Cave of the Forlorn
                "30550",  # boss SE of Cave of the Forlorn
                "1050560600",  # E of Cave of the Forlorn
            ],
            "ownerGroups": [
                "GROUP_FROST",
            ],
            "hintRegion": "the Consecrated Snowfield",
        }
    },
    # not actually a node, but the start point, so we need hints
    "chapel_start": {
        "before Grafted Scion's arena": {
            "hintName": "courtyard fog",
            "lotIDs": [
                "10010010",  # Chapel of Anticipation behind door
                "10010010",  # Chapel of Anticipation behind door
                "10010900",  # Chapel of Anticipation chest
            ],
            "hintRegion": "the Chapel of Anticipation"
        }
    },
    "siofra_nokron": {
        "using Horned Remains in Nokron": {
            "hintName": "horned remains",
            "lotIDs": [
                "12020630",  # ledge S of Aqueduct-Facing Cliffs
                "12020620",  # ledge above Hallowhorn Grounds
                "12020640",  # NW of Hallowhorn Grounds
                "12020650",  # N of Ancestral Woods
                "12020660",  # N of Ancestral Woods
                "12020670",  # N/NW of Ancestral Woods
                "12020520",  # E/SE of Ancestral Woods
                "12020680",  # NW of Ancestral Woods
                "12020530",  # road E/NE of Ancestral Woods
                "12020540",  # road NE of Ancestral Woods
                "12020550",  # road NE of Ancestral Woods
                "12020570",  # stair N/NE of Ancestral Woods
                "12020590",  # S of Hallowhorn Grounds
                "12020600",  # base of stair SW of Hallowhorn Grounds
                "12020610",  # base of pillar S of Hallowhorn Grounds
            ],
            "ownerGroups": [
                "GROUP_SPIRIT_TUNER",
            ],
            "hintRegion": "Nokron, Eternal City",
        },
        "after Mimic Tear's arena": {
            "hintName": "temple fog",
            "lotIDs": [
                "12020500",  # N of Mimic Tear
                "12020510",  # SE of Ancestral Woods
                "12020520",  # E/SE of Ancestral Woods
                "12020530",  # road E/NE of Ancestral Woods
                "12020540",  # road NE of Ancestral Woods
                "12020550",  # road NE of Ancestral Woods
                "12020570",  # stair N/NE of Ancestral Woods
                "12020590",  # S of Hallowhorn Grounds
                "12020600",  # base of stair SW of Hallowhorn Grounds
                "12020610",  # base of pillar S of Hallowhorn Grounds
            ],
            "ownerGroups": [
                "GROUP_SPIRIT_TUNER",
            ],
            "hintRegion": "Nokron, Eternal City",
        }
    },
    "farumazula": {
        "lying down in front of the tempest below the great bridge": {
            "hintName": "Tempest coffin",
            "lotIDs": [
                "13000005",  # gazebo NW and below Maliketh, the Black Blade
                "13000710",  # plaza SE and below Beside the Great Bridge
                "13000720",  # plaza SE and below Beside the Great Bridge
                "13000730",  # ruin E and below Beside the Great Bridge
                "13000740",  # patio SE and below Dragon Temple Rooftop
                "13000760",  # window S and below Dragon Temple Rooftop
                "13000770",  # S and below Beside the Great Bridge
                "13000940",  # chest SE and below Dragon Temple Rooftop
                "13000980",  # golden tree E and below Beside the Great Bridge
                "13000790",  # altar near and below Beside the Great Bridge
            ],
            "ownerGroups": [
                "GROUP_BEAST",
            ],
            "hintRegion": "Crumbling Farum Azula",
        },
        "before Maliketh's arena": {
            "hintName": "rotunda fog",
            "lotIDs": [
                "13000790",  # altar near and below Beside the Great Bridge
                "13000800",  # bridge E of Dragon Temple Altar
                "13000810",  # bridge NE of Dragon Temple Altar
                "13000820",  # balcony above Dragon Temple Rooftop
                "13000950",  # chest SE of Dragon Temple Rooftop
                "13002095",  # enemy on bridge E of Dragon Temple Transept
                "13000770",  # S and below Beside the Great Bridge
                "13000005",  # gazebo NW and below Maliketh, the Black Blade
                "13000710",  # plaza SE and below Beside the Great Bridge
                "13000720",  # plaza SE and below Beside the Great Bridge
            ],
            "ownerGroups": [
                "GROUP_BEAST",
            ],
            "hintRegion": "Crumbling Farum Azula",
        },
        "at the Imp Seal leading up to the Dragon Temple Lift grace": {
            "hintName": "lift fog",
            "lotIDs": [
                "13000420",  # ledge E/SE and below Dragon Temple Lift
                "13000430",  # collapsed floor SE and below Dragon Temple Lift
                "13000440",  # ledge S/SE and below Dragon Temple Lift
                "13000450",  # NE and below Dragon Temple Lift
                "13000460",  # behind wall near and below Dragon Temple Lift
                "13000470",  # N and below Dragon Temple Lift
                "13000480",  # upper ledge S/SE and below Dragon Temple Lift
                "13000490",  # floating floor W/NW of Beside the Great Bridge
                "13000500",  # floating floor NW of Beside the Great Bridge
                "13000510",  # corridor SW of Dragon Temple Rooftop
                "13000520",  # floating floor NW of Dragon Temple Rooftop
            ],
            "ownerGroups": [
                "GROUP_BEAST",
            ],
            "hintRegion": "Crumbling Farum Azula",
        },
        "after Godskin Duo arena": {
            "hintName": "temple fog",
            "lotIDs": [
                "13000420",  # ledge E/SE and below Dragon Temple Lift
                "13000430",  # collapsed floor SE and below Dragon Temple Lift
                "13000440",  # ledge S/SE and below Dragon Temple Lift
                "13000450",  # NE and below Dragon Temple Lift
                "13000460",  # behind wall near and below Dragon Temple Lift
                "13000470",  # N and below Dragon Temple Lift
                "13000480",  # upper ledge S/SE and below Dragon Temple Lift
                "13000490",  # floating floor W/NW of Beside the Great Bridge
                "13000500",  # floating floor NW of Beside the Great Bridge
                "13000510",  # corridor SW of Dragon Temple Rooftop
                "13000520",  # floating floor NW of Dragon Temple Rooftop
            ],
            "ownerGroups": [
                "GROUP_BEAST",
            ],
            "hintRegion": "Crumbling Farum Azula",
        }
    },
    "flamepeak_firegiant": {
        # boss is only lot, may miss hints
        "burning the erdtree at the Forge of the Giants, or repeating the warp "
        "using the grace": {
            "hintName": "Giants' Forge",
            "lotIDs": [
                "10310",  # boss
            ],
            "ownerGroups": [
                "GROUP_OFFENSE",
                "GROUP_FIRE",
            ],
            "hintRegion": "Flame Peak"
        },
        "in the left front of Fire Giant's arena, closer to the forge": {
            "hintName": "north fog",
            "lotIDs": [
                "10310",  # boss
            ],
            "ownerGroups": [
                "GROUP_OFFENSE",
            ],
            "hintRegion": "Flame Peak"
        },
        "in the right front of Fire Giant's arena, farther from the forge": {
            "hintName": "south fog",
            "lotIDs": [
                "10310",  # boss
            ],
            "ownerGroups": [
                "GROUP_OFFENSE",
            ],
            "hintRegion": "Flame Peak"
        }
    },
    "academy": {
        "getting abducted at the bottom of the elevator. this requires dying "
        "in the bottom 30 meters, not above that": {
            "hintName": "Academy sacrifice",
            "lotIDs": [
                "14000290",  # E and below Church of the Cuckoo
                "14000280",  # E and below Church of the Cuckoo
                "14000300",  # SE and below Church of the Cuckoo
                "14000870",  # mausoleum SE and below Church of the Cuckoo
                "14000320",  # NW and below Schoolhouse Classroom
            ],
            "ownerGroups": [
                "GROUP_MAGIC",
            ],
            "hintRegion": "the Academy of Raya Lucaria",
        },
        "before Red Wolf's arena": {
            "hintName": "parlor fog",
            "lotIDs": [
                "14000900",  # chest W/SW and below Debate Parlor
                "14000950",  # chest in room SE of Schoolhouse Classroom
                "14000015",  # ledge N of Schoolhouse Classroom
                "14000360",  # room SE of Schoolhouse Classroom
                "14000370",  # hidden balcony SE of Schoolhouse Classroom
                "14000380",  # hidden room SW of Schoolhouse Classroom
                "14000390",  # balcony SW of Schoolhouse Classroom
                "14000880",  # chest in hidden room SW of Schoolhouse Classroom
                "14000890",  # crystal room W/SW and below Debate Parlor
            ],
            "ownerGroups": [
                "GROUP_MAGIC",
            ],
            "hintRegion": "the Academy of Raya Lucaria",
        }
    },
    "volcano_posttemple|volcano_sendinggate": {
        "using the Sending Gate after Volcano Manor temple": {
            "hintName": "Praetor's gate",
            "lotIDs": [
                "16000520",  # Praetor's throne room
                "16000530",  # lava room W of Volcano Manor
                "16000510",  # snake statue S/SW of Volcano Manor
                "16000490",  # room N and above Temple of Eiglay
                "16000480",  # ledge N and above Temple of Eiglay
                "16000440",  # ladder N/NE and above Temple of Eiglay
                # "16000410", # E of Temple of Eiglay
                # "16000400", # under balcony E of Temple of Eiglay
                # "16000390", # lava pool NE of Temple of Eiglay
                "16000450",  # basement NE of Temple of Eiglay
                "40592",  # enemy near lava N and above Temple of Eiglay
            ],
            "ownerGroups": [
                "GROUP_FIRE",
                "GROUP_RECUSANT",
            ],
            "hintRegion": "Volcano Manor",
        },
        "on the doorway on the second story opposite the Sending Gate": {
            "hintName": "attic fog",
            "lotIDs": [
                "16000520",  # Praetor's throne room
                "16000530",  # lava room W of Volcano Manor
                "16000510",  # snake statue S/SW of Volcano Manor
                "16000490",  # room N and above Temple of Eiglay
                "16000480",  # ledge N and above Temple of Eiglay
                "16000440",  # ladder N/NE and above Temple of Eiglay
                # "16000410", # E of Temple of Eiglay
                # "16000400", # under balcony E of Temple of Eiglay
                # "16000390", # lava pool NE of Temple of Eiglay
                "16000450",  # basement NE of Temple of Eiglay
                "40592",  # enemy near lava N and above Temple of Eiglay
            ],
            "ownerGroups": [
                "GROUP_FIRE",
                "GROUP_RECUSANT",
            ],
            "hintRegion": "Volcano Manor",
        }
    },
    "outskirts_sidetomb_hallway": {
        # no lots here
        "using the chest before the main hallway": {
            "hintName": "room trap",
            "hintRegion": "the Capital Outskirts"
        },
        "using the chest at the end of the main hallway": {
            "hintName": "hallway trap",
            "hintRegion": "the Capital Outskirts"
        },
        "using the chest behind the illusory wall": {
            "hintName": "hidden trap",
            "hintRegion": "the Capital Outskirts"
        }
    },
    "outskirts_sidetomb": {
        # no lots here
        "using the chest in the actual entrance": {
            "hintName": "room trap",
            "hintRegion": "the Capital Outskirts"
        },
        "at the entrance from Capital Outskirts": {
            "hintName": "entrance fog",
            "hintRegion": "the Capital Outskirts"
        },
        "before Grave Warden Duelist's arena": {
            "hintName": "tomb fog",
            "hintRegion": "the Capital Outskirts"
        },
        # duplicate?
        # "at the entrance from Ashen Capital Outskirts": {
        #     "hintName": "",
        #     "hintRegion": "the Capital Outskirts",
        # },
    },
    "outskirts_sidetomb_upper": {
        # no lots here
        "using the chest overlooking the main hallway": {
            "hintName": "gallery trap",
            "hintRegion": "the Capital Outskirts"
        },
        "using the chest up the ladder from the main second floor": {
            "hintName": "room trap",
            "hintRegion": "the Capital Outskirts"
        }
    },
    "leyndell_tower": {
        # don't use the item on the bridge to the tower here since it can't be
        # reached before triggering the warp
        "approaching the Divine Tower of East Altus gate, or using the grace "
        "menu": {
            "hintName": "bridge warp",
            "lotIDs": [
                "34140000",  # near elden throne door
                # does not always appear?
                # "34140720", # enemy near elden throne door
                "34140010",  # isolated room in elevator shaft
                "34140810",  # isolated room in elevator shaft
            ],
            "ownerGroups": [
                "GROUP_HOLY",
            ],
            "hintRegion": "Leyndell, Royal Capital",
        },
        "at the exit to Forbidden Lands": {
            "hintName": "Forbidden fog",
            "lotIDs": [
                "34140000",  # near elden throne door
                # does not always appear?
                # "34140720",  # enemy near elden throne door
                "34140010",  # isolated room in elevator shaft
                "34140810",  # isolated room in elevator shaft
            ],
            "ownerGroups": [
                "GROUP_HOLY",
            ],
            "hintRegion": "Leyndell, Royal Capital",
        },
        # this is a preexisting map transition, not sure why it's here
        # handle the fog at the other side of this door in special cases
        # "at the Morgott the Grace-Given gate coming from Forbidden Lands": {
        #     "hintName": "",
        #     "lotIDs": []
        # }
    },
    "academy_entrance": {
        "using South-facing gate at Raya Lucaria Main Entrance": {
            "hintName": "south gate",
            "lotIDs": [
                "14000000",  # NW of Church of the Cuckoo
                "1035450030",  # causeway N of South Raya Lucaria Gate
                "1035450000",  # causeway N of South Raya Lucaria Gate
                "1035460100",  # golden tree N/NE of Main Academy Gate
            ],
            "ownerGroups": [
                "GROUP_MAGIC",
            ],
            "hintRegion": "the Academy of Raya Lucaria",
        },
        "using East-facing gate at Raya Lucaria Main Entrance": {
            "hintName": "east gate",
            "lotIDs": [
                "14000000",  # NW of Church of the Cuckoo
                "1035450030",  # causeway N of South Raya Lucaria Gate
                "1035450000",  # causeway N of South Raya Lucaria Gate
                "1035460100",  # golden tree N/NE of Main Academy Gate
            ],
            "ownerGroups": [
                "GROUP_MAGIC",
            ],
            "hintRegion": "the Academy of Raya Lucaria",
        }
    },
    "academy_courtyard": {
        "using the sending gate before the elevator to Grand Library": {
            "hintName": "balcony gate",
            "lotIDs": [
                "14000480",  # end of ramp NE and above Schoolhouse Classroom
                "14000520",  # buttress N/NE and above Schoolhouse Classroom
                "14000540",  # ramp N/NE and above Schoolhouse Classroom
                "14000980",  # enemy E/SE and below Raya Lucaria Grand Library
                "14000560",  # roof W/SW and below Raya Lucaria Grand Library
                "14000910",  # chest E/SE and below Raya Lucaria Grand Library
                "14000530",  # patio N and above Schoolhouse Classroom
            ],
            "ownerGroups": [
                "GROUP_MAGIC",
            ],
            "hintRegion": "the Academy of Raya Lucaria",
        },
        "before Rennala's arena": {
            "hintName": "library fog",
            "lotIDs": [
                "14000480",  # end of ramp NE and above Schoolhouse Classroom
                "14000520",  # buttress N/NE and above Schoolhouse Classroom
                "14000540",  # ramp N/NE and above Schoolhouse Classroom
                "14000980",  # enemy E/SE and below Raya Lucaria Grand Library
                "14000560",  # roof W/SW and below Raya Lucaria Grand Library
                "14000910",  # chest E/SE and below Raya Lucaria Grand Library
                "14000530",  # patio N and above Schoolhouse Classroom
            ],
            "ownerGroups": [
                "GROUP_MAGIC",
            ],
            "hintRegion": "the Academy of Raya Lucaria",
        },
        "on the steps to Raya Lucaria rooftops section": {
            "hintName": "rooftops fog",
            "lotIDs": [
                "14000430",  # N and above Schoolhouse Classroom
                "14000035",  # enemy NW and above Schoolhouse Classroom
                "14000440",  # SE and below Raya Lucaria Grand Library
                "14000450",  # SE and below Raya Lucaria Grand Library
                "14000990",  # golden tree N/NW and above Schoolhouse Classroom
                "14000500",  # window N and above Schoolhouse Classroom
                "14000420",  # fountain N and above Schoolhouse Classroom
                "14000490",  # W and above Schoolhouse Classroom
                "14000780",  # patio N and above Debate Parlor
                "14000410",  # patio N and above Debate Parlor
            ],
            "ownerGroups": [
                "GROUP_MAGIC",
            ],
            "hintRegion": "the Academy of Raya Lucaria",
        },
        "after Red Wolf's arena": {
            "hintName": "parlor fog",
            "lotIDs": [
                "14000430",  # N and above Schoolhouse Classroom
                "14000035",  # enemy NW and above Schoolhouse Classroom
                "14000440",  # SE and below Raya Lucaria Grand Library
                "14000450",  # SE and below Raya Lucaria Grand Library
                "14000990",  # golden tree N/NW and above Schoolhouse Classroom
                "14000500",  # window N and above Schoolhouse Classroom
                "14000420",  # fountain N and above Schoolhouse Classroom
                "14000490",  # W and above Schoolhouse Classroom
                "14000780",  # patio N and above Debate Parlor
                "14000410",  # patio N and above Debate Parlor
            ],
            "ownerGroups": [
                "GROUP_MAGIC",
            ],
            "hintRegion": "the Academy of Raya Lucaria",
        }
    },
    "altus|altus_shaded|gelmir|outskirts": {
        "using the Dectus Medallion in Altus Plateau": {
            "hintName": "Dectus lift",
            "lotIDs": [
                "1038510010",  # N of Altus Plateau
                "1038510020",  # NW of Altus Plateau
                "1039500010",  # N/NE and above Golden Lineage Evergaol
                "1039500020",  # S/SW of Altus Highway Junction
                "1039510200",  # night boss SW of Altus Highway Junction
                "1038510070",  # Lux Ruins
                "1038510080",  # Lux Ruins
            ],
            "ownerGroups": [
                "GROUP_PERFUMER",
                "GROUP_HOLY",
            ],
            "hintRegion": "Altus Plateau",
            "hintArea": "Altus Plateau",
        },
        "entering Golden Lineage Evergaol": {
            "hintName": "Golden seal",
            "lotIDs": [
                "1039500000",  # tunnel E/SE and below Altus Plateau
                "1038510030",  # cart in camp E of Lux Ruins
                "1038510060",  # camp E/SE of Erdtree-Gazing Hill
                "1038510090",  # cart in camp E/SE of Erdtree-Gazing Hill
                "1039510010",  # camp W/SW of Altus Highway Junction
                "1039510030",  # camp W of Altus Highway Junction
                "1039510020",  # chest in camp W/NW of Altus Highway Junction
            ],
            "ownerGroups": [
                "GROUP_PERFUMER",
                "GROUP_HOLY",
            ],
            "hintRegion": "Altus Plateau",
            "hintArea": "Altus Plateau",
        },
        "using the sending gate by the Forest-Spanning Greatbridge grace": {
            "hintName": "bridge gate",
            "lotIDs": [
                "1040530040",  # bridge segment N of Forest-Spanning Greatbridge
                "1041520070",  # SW of Forest-Spanning Greatbridge
                "1039510400",  # golden tree N of Altus Highway Junction
                "1039510040",  # camp NW of Altus Highway Junction
                "1039510000",  # camp N/NW of Altus Highway Junction
                "1040510010",  # ruin E of Altus Highway Junction
            ],
            "ownerGroups": [
                "GROUP_PERFUMER",
                "GROUP_HOLY",
            ],
            "hintRegion": "Altus Plateau",
            "hintArea": "Altus Plateau",
        },
        "before Elemer of the Briar's arena": {
            "hintName": "Castellan's fog",
            "lotIDs": [
                "1039540190",  # roof N of Castellan's Hall
                "1039540180",  # battlement NE of Castellan's Hall
                "1039540200",  # plaza E/NE of Castellan's Hall
                "1039540210",  # room E/NE of Castellan's Hall
                "1039540230",  # battlement E/SE of Shaded Castle Inner Gate
                "1039540140",  # battlement W of Shaded Castle Inner Gate
                "1039540250",  # near Shaded Castle Inner Gate
                "1039540300",  # chest W/NW of Shaded Castle Inner Gate
                "1039540000",  # NE and below Shaded Castle Inner Gate
                "1039540040",  # battlement NW and above Shaded Castle Ramparts
                "1039540160",  # tree S and below Shaded Castle Inner Gate
                "1039540260",  # E/SE and below Shaded Castle Inner Gate
            ],
            "ownerGroups": [
                "GROUP_POISON",
                "GROUP_KNIGHT",
            ],
            "hintRegion": "Altus Plateau",
            "hintArea": "Shaded Castle",
        },
        "at the entrance to Volcano Manor": {
            "hintName": "Manor fog",
            "lotIDs": [
                "40334",  # enemy NW and above Road of Iniquity
                "1035540000",  # W and above Road of Iniquity
                "1035540010",  # W/NW and above Road of Iniquity
                "1036540010",  # N/NW and above Road of Iniquity
                "1036540020",  # N and above Road of Iniquity
                "1036540030",  # NW and above Road of Iniquity
                "1036540400",  # golden tree NW and above Road of Iniquity
                "1036540000",  # W/SW and above Ninth Mt. Gelmir Campsite
            ],
            "ownerGroups": [
                "GROUP_FIRE",
                "GROUP_RECUSANT",
            ],
            "hintRegion": "Mt. Gelmir",
            "hintArea": "Mt. Gelmir",
        },
        "at the entrance to Sainted Hero's Grave": {
            "hintName": "Sainted fog",
            "lotIDs": [
                "1040510020",  # chest in Stormcaller Church
                "1040510040",  # Stormcaller Church
                "1040510400",  # Stormcaller Church
                "30350",  # boss near Sainted Hero's Grave
                "1040520010",  # coffin NE of Stormcaller Church
                "1040520020",  # coffin NE of Stormcaller Church
                "1040520050",  # coffin NE of Stormcaller Church
                "1040520030",  # coffin S of Sainted Hero's Grave
                "1040520040",  # coffin S of Sainted Hero's Grave
                "1041520090",  # S and above Altus Tunnel
            ],
            "ownerGroups": [
                "GROUP_PERFUMER",
                "GROUP_HOLY",
            ],
            "hintRegion": "Altus Plateau",
            "hintArea": "Altus Plateau",
        },
        "at the entrance to Gelmir Hero's Grave": {
            "hintName": "Gelmir Grave fog",
            "lotIDs": [
                "1038530000",  # coffin S of First Mt. Gelmir Campsite
                "1038530010",  # coffin SE of First Mt. Gelmir Campsite
                "1038530040",  # coffin SE of First Mt. Gelmir Campsite
                "1038530020",  # coffin SE of First Mt. Gelmir Campsite
                "1038530030",  # coffin SE of First Mt. Gelmir Campsite
                "1038530050",  # SE of First Mt. Gelmir Campsite
                "1038540080",  # S and above Corpse-Stench Shack
                "1038540030",  # siege tower S and above Corpse-Stench Shack
                "1038540110",  # siege tower S and above Corpse-Stench Shack
                "1037540100",  # S/SW and above Corpse-Stench Shack
                "1037530000",  # N of Gelmir Hero's Grave
            ],
            "ownerGroups": [
                "GROUP_FIRE",
            ],
            "hintRegion": "Mt. Gelmir",
            "hintArea": "Mt. Gelmir",
        },
        "at the entrance to Auriza Hero's Grave": {
            "hintName": "Auriza Grave fog",
            "lotIDs": [
                "1045520020",  # statue N/NW of Auriza Hero's Grave
                "1045520010",  # ledge N/NE of Capital Rampart
                "1045520000",  # N/NW and below Capital Rampart
                "1045520030",  # N/NW of Capital Rampart
                "1044520000",  # NW of Capital Rampart
                "1044520010",  # W/NW and below Capital Rampart
                "1044530200",  # basin S of Minor Erdtree
                "30315",  # boss NE of Capital Rampart
            ],
            "ownerGroups": [
                "GROUP_PERFUMER",
                "GROUP_HOLY",
            ],
            "hintRegion": "the Capital Outskirts",
            "hintArea": "Capital Outskirts",
        },
        "at the entrance to Unsightly Catacombs": {
            "hintName": "Unsightly fog",
            "lotIDs": [
                "1036510020",  # Perfumer's Ruins
                "1036510010",  # Perfumer's Ruins chest
                "1036510000",  # Perfumer's Ruins
                "1036520070",  # Perfumer's Ruins
                "1036520010",  # Perfumer's Ruins chamber chest
                "1036520020",  # Perfumer's Ruins
                "1036520030",  # Perfumer's Ruins
                "1037510000",  # NE of Abandoned Coffin
                "1037510010",  # E of Abandoned Coffin
                "1037510020",  # E/NE of Abandoned Coffin
                "1037520060",  # W of Sage's Cave
            ],
            "ownerGroups": [
                "GROUP_PERFUMER",
                "GROUP_HOLY",
            ],
            "hintRegion": "Altus Plateau",
            "hintArea": "Altus Plateau",
        },
        "at the entrance to Old Altus Tunnel, with Stonesword Key": {
            "hintName": "Old Altus fog",
            "lotIDs": [
                "1039530020",  # pinnacle E of Old Altus Tunnel
                "1039520000",  # Second Church of Marika
                "1039520400",  # Second Church of Marika
                "1039520020",  # graveyard N/NW of Second Church of Marika
                "1038510400",  # NE of Erdtree-Gazing Hill
                "1038510030",  # cart in camp E of Lux Ruins
                "1038510060",  # camp E/SE of Erdtree-Gazing Hill
                "1038510090",  # cart in camp E/SE of Erdtree-Gazing Hill
            ],
            "hintRegion": "Altus Plateau",
            "hintArea": "Altus Plateau",
        },
        "at the entrance to Altus Tunnel": {
            "hintName": "Altus Tunnel fog",
            "lotIDs": [
                "1040530030",  # ledge N and below Forest-Spanning Greatbridge
                "1040530060",  # under bridge SW of Minor Erdtree
                "1040530050",  # W/NW of Minor Erdtree
                "1041540400",  # golden tree N of Minor Erdtree
                "30320",  # Minor Erdtree boss
                "1041530050",  # Woodfolk Ruins near Minor Erdtree
                "1041530040",  # Woodfolk Ruins near Minor Erdtree
                "1041530060",  # Woodfolk Ruins NE of Minor Erdtree
                "1041530080",  # Woodfolk Ruins NE of Minor Erdtree
                "1041530030",  # Woodfolk Ruins E of Minor Erdtree
                "1041530070",  # Woodfolk Ruins E of Minor Erdtree
                "1041530010",  # Woodfolk Ruins SE of Minor Erdtree
                "1041530020",  # Woodfolk Ruins chest
            ],
            "ownerGroups": [
                "GROUP_PERFUMER",
                "GROUP_HOLY",
            ],
            "hintRegion": "Altus Plateau",
            "hintArea": "Altus Plateau",
        },
        "at the entrance to Sealed Tunnel": {
            "hintName": "Sealed fog",
            "lotIDs": [
                "1042500000",  # cart S of Outer Wall Phantom Tree
                "1042510000",  # ruin SE of Outer Wall Phantom Tree
                "1043500030",  # Minor Erdtree Church
                "1043500000",  # Minor Erdtree Church
                "1043500010",  # grave E and above Sealed Tunnel
                "30335",  # boss on stair SE of Perfumer's Grotto
                "1042510400",  # golden tree near Outer Wall Phantom Tree
                "1042510410",  # golden tree near Outer Wall Phantom Tree
            ],
            "ownerGroups": [
                "GROUP_PERFUMER",
                "GROUP_HOLY",
            ],
            "hintRegion": "the Capital Outskirts",
            "hintArea": "Capital Outskirts",
        },
        "at the entrance to Auriza Side Tomb": {
            "hintName": "Auriza Side fog",
            "lotIDs": [
                "1045520020",  # statue N/NW of Auriza Hero's Grave
                "1045520010",  # ledge N/NE of Capital Rampart
                "1045520000",  # N/NW and below Capital Rampart
                "1045520030",  # N/NW of Capital Rampart
                "1044520000",  # NW of Capital Rampart
                "1044520010",  # W/NW and below Capital Rampart
                "1044530200",  # basin S of Minor Erdtree
                "30315",  # boss NE of Capital Rampart
            ],
            "ownerGroups": [
                "GROUP_PERFUMER",
                "GROUP_HOLY",
            ],
            "hintRegion": "the Capital Outskirts",
            "hintArea": "Capital Outskirts",
        },
        "at the entrance to Wyndham Catacombs": {
            "hintName": "Wyndham fog",
            "lotIDs": [
                "1037520020",  # NE of Seethewater River
                "30385",  # Wyndham Ruins boss
                "1038520000",  # Wyndham Ruins vault chest
                "1038520010",  # Wyndham Ruins SW of lake
                "1038520020",  # Wyndham Ruins center of lake
                "1038520070",  # Wyndham Ruins center of lake
                "1038520030",  # Wyndham Ruins NE of lake
                "1038520050",  # Wyndham Ruins NE of lake
                "1038520040",  # Wyndham Ruins N of lake
                "1038520060",  # Wyndham Ruins N of lake
            ],
            "ownerGroups": [
                "GROUP_PERFUMER",
                "GROUP_HOLY",
            ],
            "hintRegion": "Altus Plateau",
            "hintArea": "Wyndham Ruins",
        },
        "before Demi-Human Queen Gilika's arena in Lux Ruins": {
            "hintName": "Lux fog",
            "lotIDs": [
                "1038510010",  # N of Altus Plateau
                "1038510020",  # NW of Altus Plateau
                "1038510040",  # W of Erdtree-Gazing Hill
                "1038510070",  # Lux Ruins
                "1038510080",  # Lux Ruins
                "1038510400",  # NE of Erdtree-Gazing Hill
                "1038510030",  # cart in camp E of Lux Ruins
                "1038510060",  # camp E/SE of Erdtree-Gazing Hill
                "1038510090",  # cart in camp E/SE of Erdtree-Gazing Hill
            ],
            "ownerGroups": [
                "GROUP_PERFUMER",
                "GROUP_HOLY",
            ],
            "hintRegion": "Altus Plateau",
            "hintArea": "Lux Ruins",
        },
        "before Sanguine Noble's arena in Writheblood Ruins": {
            "hintName": "Writheblood fog",
            "lotIDs": [
                "1040530000",  # Writheblood Ruins
                "1040540090",  # crumbled bridge S of Road of Iniquity Side Path
                "1040540030",  # crumbled bridge S of Road of Iniquity Side Path
                "1040540010",  # grave NE and above Shaded Castle Ramparts
                # "1040540000", # troll cart SW of Road of Iniquity Side Path
                "1039530010",  # E of Bridge of Iniquity
                "1039530000",  # E/NE of Bridge of Iniquity
            ],
            "ownerGroups": [
                "GROUP_PERFUMER",
                "GROUP_HOLY",
                "GROUP_BLOOD",
            ],
            "hintRegion": "Altus Plateau",
            "hintArea": "Altus Plateau",
        },
        "up the stairs behind Draconic Tree Sentinel": {
            "hintName": "rampart fog",
            "lotIDs": [
                "1045520020",  # statue N/NW of Auriza Hero's Grave
                "1045520010",  # ledge N/NE of Capital Rampart
                "1045520000",  # N/NW and below Capital Rampart
                "1045520030",  # N/NW of Capital Rampart
                "1044520000",  # NW of Capital Rampart
                "1044520010",  # W/NW and below Capital Rampart
                "1044530200",  # basin S of Minor Erdtree
                "30315",  # boss NE of Capital Rampart
            ],
            "ownerGroups": [
                "GROUP_PERFUMER",
                "GROUP_HOLY",
                "GROUP_GOLDEN_ORDER"
            ],
            "hintRegion": "the Capital Outskirts",
            "hintArea": "Capital Outskirts",
        },
        "at the entrance to Sage's Cave": {
            "hintName": "Sage's fog",
            "lotIDs": [
                "1036510020",  # Perfumer's Ruins
                "1036510010",  # Perfumer's Ruins chest
                "1036510000",  # Perfumer's Ruins
                "1036520070",  # Perfumer's Ruins
                "1036520010",  # Perfumer's Ruins chamber chest
                "1036520020",  # Perfumer's Ruins
                "1036520030",  # Perfumer's Ruins
                "1037510000",  # NE of Abandoned Coffin
                "1037510010",  # E of Abandoned Coffin
                "1037510020",  # E/NE of Abandoned Coffin
                "1037520060",  # W of Sage's Cave
            ],
            "ownerGroups": [
                "GROUP_PERFUMER",
                "GROUP_HOLY",
            ],
            "hintRegion": "Altus Plateau",
            "hintArea": "Altus Plateau",
        },
        "at the entrance to Seethewater Cave, with Stonesword Key": {
            "hintName": "Seethewater fog",
            "lotIDs": [
                "1037520020",  # NE of Seethewater River
                "1037530400",  # N/NE and below Primeval Sorcerer Azur
                "1037530020",  # S/SE of Seethewater Cave
                "1037540030",  # W of Seethewater Cave
                "1037540060",  # E of Seethewater Cave
                "1037540080",  # E of Seethewater Cave
                "1037540090",  # E of Seethewater Cave
                "1037540070",  # NE of Seethewater Cave
                "1036540050",  # SW and below Road of Iniquity
                "1036530000",  # NE of Seethewater Terminus
            ],
            "ownerGroups": [
                "GROUP_FIRE",
            ],
            "hintRegion": "Mt. Gelmir",
            "hintArea": "Mt. Gelmir",
        },
        "at the entrance to Volcano Cave": {
            "hintName": "Volcano fog",
            "lotIDs": [
                "30375",  # boss S and above Ninth Mt. Gelmir Campsite
                "1036540040",  # S and above Ninth Mt. Gelmir Campsite
                "1037540040",  # E/NE of Ninth Mt. Gelmir Campsite
                "1037540020",  # NW and above Corpse-Stench Shack
                "1037540150",  # NW and above Corpse-Stench Shack
                "1037540110",  # N and above Minor Erdtree
                "1037550000",  # SE of Volcano Cave
            ],
            "ownerGroups": [
                "GROUP_FIRE",
            ],
            "hintRegion": "Mt. Gelmir",
            "hintArea": "Mt. Gelmir",
        },
        "at the entrance to Perfumer's Grotto": {
            "hintName": "Perfumer's fog",
            "lotIDs": [
                "1040510010",  # ruin E of Altus Highway Junction
                "1040510030",  # SE of Altus Highway Junction
                "1040520000",  # St. Trina's Hideaway
                "1040500000",  # S/SE and below Stormcaller Church
                "1041510030",  # SW of Perfumer's Grotto
                "30335",  # boss on stair SE of Perfumer's Grotto
                "30310",  # boss S of Perfumer's Grotto
                "1042510400",  # golden tree near Outer Wall Phantom Tree
                "1042510410",  # golden tree near Outer Wall Phantom Tree
            ],
            "ownerGroups": [
                "GROUP_PERFUMER",
                "GROUP_HOLY",
            ],
            "hintRegion": "Altus Plateau",
            "hintArea": "Altus Plateau",
        },
        # duplicate
        # "at the Ashen entrance to Auriza Side Tomb": {
        #     "hintName": "",
        #     "ownerGroups": [
        #         "GROUP_PERFUMER",
        #         "GROUP_HOLY",
        #     ],
        #     "hintRegion": "the Capital Outskirts"
        # }
    },
    "mountaintops_start": {
        "using the Rold Medallion at Forbidden Lands": {
            "hintName": "Rold lift",
            "lotIDs": [
                "1048510000",  # giant skull S of Grand Lift of Rold
                "30505",  # boss S of Grand Lift of Rold
                "1049520000",  # SW of Grand Lift of Rold
                "1049520800",  # golden tree S/SW of Grand Lift of Rold
                "1048510700",  # boss E/NE of Forbidden Lands
                "1047510000",  # W of Forbidden Lands
                "1047510010",  # E of Forbidden Lands
                "1047510300",  # E/NE of Forbidden Lands
            ],
            "hintRegion": "the Forbidden Lands",
        },
        "using the Haligtree secret medallions at Forbidden Lands": {
            "hintName": "hidden lift",
            "lotIDs": [
                "1048510000",  # giant skull S of Grand Lift of Rold
                "30505",  # boss S of Grand Lift of Rold
                "1049520000",  # SW of Grand Lift of Rold
                "1049520800",  # golden tree S/SW of Grand Lift of Rold
                "1048510700",  # boss E/NE of Forbidden Lands
                "1047510000",  # W of Forbidden Lands
                "1047510010",  # E of Forbidden Lands
                "1047510300",  # E/NE of Forbidden Lands
            ],
            "hintRegion": "the Forbidden Lands",
        },
        "at the exit from Divine Tower of East Altus": {
            "hintName": "tower fog",
            "lotIDs": [
                "1048510000",  # giant skull S of Grand Lift of Rold
                "30505",  # boss S of Grand Lift of Rold
                "1049520000",  # SW of Grand Lift of Rold
                "1049520800",  # golden tree S/SW of Grand Lift of Rold
                "1048510700",  # boss E/NE of Forbidden Lands
                "1047510000",  # W of Forbidden Lands
                "1047510010",  # E of Forbidden Lands
                "1047510300",  # E/NE of Forbidden Lands
            ],
            "hintRegion": "the Forbidden Lands",
        }
    },
    "flamepeak|mountaintops|mountaintops_sol": {
        "using the Rold Medallion at Mountaintops of the Giants": {
            "hintName": "Rold lift",
            "lotIDs": [
                "1049530300",  # lift W of Zamor Ruins
                "1049530010",  # Zamor Ruins
                "1049530030",  # Zamor Ruins
                "1049530900",  # Zamor Ruins chest
                "1049530000",  # S of Zamor Ruins
                "1049530020",  # cliff SW of Zamor Ruins
                "1050530700",  # enemy SW of Giants' Mountaintop Catacombs
                "1050530300",  # S of Giants' Mountaintop Catacombs
                "1050540810",  # N/NW of Giants' Mountaintop Catacombs
                "1050540800",  # N of Giants' Mountaintop Catacombs
            ],
            "ownerGroups": [
                "GROUP_FROST",
            ],
            "hintRegion": "the western Mountaintops of the Giants"
        },
        "entering Lord Contender's Evergaol": {
            "hintName": "Contender's seal",
            "lotIDs": [
                "1053560800",  # coffin E and below Lord Contender's Evergaol
                "1053560810",  # coffin E and below Lord Contender's Evergaol
                "1053560310",  # E and below Lord Contender's Evergaol
                "1052570900",  # Heretical Rise chest
                "1052570310",  # Heretical Rise
                "1052570300",  # Heretical Rise
                "1052560300",  # NE of Whiteridge Road
                "40516",  # enemy S of Guardians' Garrison
                "1052550300",  # SE of Guardians' Garrison
                "1052550310",  # E/SE of Guardians' Garrison
                "1052550010",  # Guardians' Garrison awning
                "1052550030",  # Guardians' Garrison
                "1052550020",  # Guardians' Garrison cliff platform
                "1052550700",  # Guardians' Garrison tower enemy
                "1052550900",  # Guardians' Garrison chest
                "1052550000",  # Guardians' Garrison wall platform
                "1052550800",  # Guardians' Garrison battlement
            ],
            "ownerGroups": [
                "GROUP_FROST",
            ],
            "hintRegion": "the eastern Mountaintops of the Giants",
        },
        "before Commander Niall's arena": {
            "hintName": "Sol Rooftop fog",
            "lotIDs": [
                "1051570010",  # grave E of Castle Sol Main Gate
                "1051570020",  # SW and below Church of the Eclipse
                "1051570000",  # platform NE of Castle Sol Main Gate
                "1051570150",  # W of Church of the Eclipse
                "1051570160",  # under platform N/NW of Church of the Eclipse
                "1051570060",  # by ladder NW of Church of the Eclipse
                "1051570030",  # battlement NW of Church of the Eclipse
                "1051570040",  # battlement N of Castle Sol Main Gate
                "1051570170",  # roof W of Church of the Eclipse
                "1051570220",  # awning W of Church of the Eclipse
                "80030",  # Castle Sol painting
                "1051570180",  # wall N of Church of the Eclipse
                "1051570090",  # ledge SE of Church of the Eclipse
                "1051570200",  # S/SW and below Castle Sol Rooftop
                "1051570050",  # W/SW and below Castle Sol Rooftop
                "1051570300",  # battlement W of Castle Sol Rooftop
                "1051570600",  # altar S of Church of the Eclipse
                "1051570100",  # building E of Church of the Eclipse
                "1051570190",  # ledge W of Church of the Eclipse
                "1051570210",  # S of Church of the Eclipse
                "1051570080",  # building E of Castle Sol Main Gate
                "1051570070",  # platform E of Castle Sol Main Gate
            ],
            "ownerGroups": [
                "GROUP_FROST",
            ],
            "hintRegion": "the western Mountaintops of the Giants",
            "hintArea": "Castle Sol",
        },
        "at the entrance to Giants' Mountaintop Catacombs": {
            "hintName": "Giants' fog",
            "lotIDs": [
                "1049530010",  # Zamor Ruins
                "1049530030",  # Zamor Ruins
                "1049530900",  # Zamor Ruins chest
                "1049530000",  # S of Zamor Ruins
                "1049530020",  # cliff SW of Zamor Ruins
                "1050530700",  # enemy SW of Giants' Mountaintop Catacombs
                "1050530300",  # S of Giants' Mountaintop Catacombs
                "1050540810",  # N/NW of Giants' Mountaintop Catacombs
                "1050540800",  # N of Giants' Mountaintop Catacombs
                "1050540000",  # ridge N of Giants' Mountaintop Catacombs
            ],
            "ownerGroups": [
                "GROUP_FROST",
            ],
            "hintRegion": "the western Mountaintops of the Giants"
        },
        "at the entrance to Giant-Conquering Hero's Grave": {
            "hintName": "Conquering fog",
            "lotIDs": [
                "1051540000",  # E/NE and above Giants' Mountaintop Catacombs
                "1051530300",  # E and above Giants' Mountaintop Catacombs
                "1050530000",  # SE and above Giants' Mountaintop Catacombs
                "1051530000",  # giant skull mouth SE of Church of Repose
                "1051530600",  # giant skull SE of Church of Repose
                "1051530010",  # N/NW of Foot of the Forge
                "1051530500",  # Church of Repose invader
                "1051530700",  # enemy W/NW of Foot of the Forge
                "1051530800",  # Church of Repose
                "1051530810",  # N/NW of Foot of the Forge
                "1051540800",  # N/NW of Foot of the Forge
                "1052530000",  # N of Foot of the Forge
            ],
            "ownerGroups": [
                "GROUP_FROST",
            ],
            "hintRegion": "the western Mountaintops of the Giants",
            "hintArea": "Flame Peak",
        },
        "at the entrance to Spiritcaller Cave, with Stonesword Key": {
            "hintName": "cave fog",
            "lotIDs": [
                "30510",  # freezing lake boss
                "1054550310",  # First Church of Marika
                "1054550800",  # First Church of Marika
                "1054550000",  # E of First Church of Marika
                "1053570300",  # NE of Spiritcaller Cave
                "1053560800",  # coffin E and below Lord Contender's Evergaol
                "1053560810",  # coffin E and below Lord Contender's Evergaol
                "1053560310",  # E and below Lord Contender's Evergaol
                "1053560300",  # E/NE and below Lord Contender's Evergaol
                "1052570810",  # statue S and below Freezing Lake
            ],
            "ownerGroups": [
                "GROUP_FROST",
            ],
            "hintRegion": "the eastern Mountaintops of the Giants",
        },
        "before Fire Giant, at the left entrance with lower elevation": {
            "hintName": "Forge north fog",
            "lotIDs": [
                "1051530000",  # giant skull mouth SE of Church of Repose
                "1051530600",  # giant skull SE of Church of Repose
                "1051530010",  # N/NW of Foot of the Forge
                "1051530500",  # Church of Repose invader
                "1051530700",  # enemy W/NW of Foot of the Forge
                "1051530800",  # Church of Repose
                "1051530810",  # N/NW of Foot of the Forge
                "1051540800",  # N/NW of Foot of the Forge
                "1052530000",  # N of Foot of the Forge
                "1052530800",  # golden tree NW of Foot of the Forge
                "1052540790",  # basin E/SE and above Giants' Gravepost
                "1052540000",  # S/SE and above Giants' Gravepost
                "1052540010",  # S and above Giants' Gravepost
                "1052540020",  # SW and above Giants' Gravepost
                "1052540800",  # half basin SW and above Giants' Gravepost
            ],
            "ownerGroups": [
                "GROUP_FROST",
            ],
            "hintRegion": "the eastern Mountaintops of the Giants",
            "hintArea": "Flame Peak",
        },
        "before Fire Giant, at the right entrance with higher elevation": {
            "hintName": "Forge south fog",
            "lotIDs": [
                "1051530000",  # giant skull mouth SE of Church of Repose
                "1051530600",  # giant skull SE of Church of Repose
                "1051530010",  # N/NW of Foot of the Forge
                "1051530500",  # Church of Repose invader
                "1051530700",  # enemy W/NW of Foot of the Forge
                "1051530800",  # Church of Repose
                "1051530810",  # N/NW of Foot of the Forge
                "1051540800",  # N/NW of Foot of the Forge
                "1052530000",  # N of Foot of the Forge
                "1052530800",  # golden tree NW of Foot of the Forge
                "1052540790",  # basin E/SE and above Giants' Gravepost
                "1052540000",  # S/SE and above Giants' Gravepost
                "1052540010",  # S and above Giants' Gravepost
                "1052540020",  # SW and above Giants' Gravepost
                "1052540800",  # half basin SW and above Giants' Gravepost
            ],
            "ownerGroups": [
                "GROUP_FROST",
            ],
            "hintRegion": "the eastern Mountaintops of the Giants",
            "hintArea": "Flame Peak",
        }
    },
    "stormveil|stormveil_start": {
        "before Godrick's arena": {
            "hintName": "courtyard fog",
            "lotIDs": [
                "10000720",  # S of Secluded Cell
                "10000730",  # golden tree S/SE of Secluded Cell
                "10000740",  # alley SE of Secluded Cell
                "10000790",  # catwalk SW of Secluded Cell
                "10000800",  # platform SW of Secluded Cell
                "10000810",  # redoubt S of Secluded Cell
                "10000820",  # N and above Liftside Chamber
                "10000830",  # N and above Liftside Chamber
                "10000840",  # turret NW and above Liftside Chamber
                "10000770",  # dead end N and above Liftside Chamber
                "10000775",  # dead end N and above Liftside Chamber
                "10000090",  # room NW and above Liftside Chamber
                "10000640",  # ledge S of Liftside Chamber
                "10000710",  # walkway E of Liftside Chamber
                "10000750",  # room E/SE of Liftside Chamber
                "10000630",  # stair E/SE of Liftside Chamber
            ],
            "ownerGroups": [
                "GROUP_KNIGHT",
            ],
            "hintRegion": "Stormveil Castle"
        },
        "after Margit's arena": {
            "hintName": "gate fog",
            "lotIDs": [
                "10000030",  # ledge N of Stormveil Main Gate
                "10000040",  # tunnel S of Stormveil Main Gate
                "10000110",  # S of Gateside Chamber
                "10000140",  # ledge W/SW of Gateside Chamber
                "10000560",  # E/SE of Gateside Chamber
                "10000580",  # near Gateside Chamber
                "10000540",  # N of Gateside Chamber
                "10000520",  # NE of Gateside Chamber
                "10000530",  # NE of Gateside Chamber
                "10000590",  # NW of Gateside Chamber
                "10001085",  # enemy SW of Limgrave Tower Bridge
                "10000550",  # redoubt W of Limgrave Tower Bridge
                "10000510",  # N/NE of Stormveil Cliffside
                "10000950",  # gate NE and below Rampart Tower
            ],
            "ownerGroups": [
                "GROUP_KNIGHT",
            ],
            "hintRegion": "Stormveil Castle"
        },
        "at the side path to Limgrave Divine Tower": {
            "hintName": "bridge fog",
            "lotIDs": [
                "10000030",  # ledge N of Stormveil Main Gate
                "10000040",  # tunnel S of Stormveil Main Gate
                "10000110",  # S of Gateside Chamber
                "10000140",  # ledge W/SW of Gateside Chamber
                "10000560",  # E/SE of Gateside Chamber
                "10000580",  # near Gateside Chamber
                "10000540",  # N of Gateside Chamber
                "10000520",  # NE of Gateside Chamber
                "10000530",  # NE of Gateside Chamber
                "10000590",  # NW of Gateside Chamber
                "10001085",  # enemy SW of Limgrave Tower Bridge
                "10000550",  # redoubt W of Limgrave Tower Bridge
                "10000510",  # N/NE of Stormveil Cliffside
                "10000950",  # gate NE and below Rampart Tower
            ],
            "ownerGroups": [
                "GROUP_KNIGHT",
            ],
            "hintRegion": "Stormveil Castle"
        }
    },
    "leyndell_sanctuaryback": {
        # only one lot here shared with ashen leyndell, may miss some hints
        "outside of Godfrey's arena at the center back exit": {
            "hintName": "center fog",
            "lotIDs": [
                "11000930",  # cupola SE of Erdtree Sanctuary*
            ],
            "ownerGroups": [
                "GROUP_GOLDEN_ORDER",
            ],
            "hintRegion": "Leyndell, Royal Capital"
        },
        "outside of Godfrey's arena at the leftmost back exit, the one without "
        "the branch": {
            "hintName": "left fog",
            "lotIDs": [
                "11000930",  # cupola SE of Erdtree Sanctuary*
            ],
            "ownerGroups": [
                "GROUP_GOLDEN_ORDER",
            ],
            "hintRegion": "Leyndell, Royal Capital"
        },
        "outside of Godfrey's arena at the rightmost back exit, the one with "
        "the branch": {
            "hintName": "right fog",
            "lotIDs": [
                "11000930",  # cupola SE of Erdtree Sanctuary*
            ],
            "ownerGroups": [
                "GROUP_GOLDEN_ORDER",
            ],
            "hintRegion": "Leyndell, Royal Capital"
        }
    },
    "leyndell_sanctuary": {
        # boss is only lot, will almost certainly miss some hints
        "in Godfrey's arena at the center East exit": {
            "hintName": "balcony center fog",
            "lotIDs": [
                "10050",  # Erdtree Sanctuary boss
            ],
            "ownerGroups": [
                "GROUP_GOLDEN_ORDER",
            ],
            "hintRegion": "Leyndell, Royal Capital"
        },
        "in Godfrey's arena at the normal South entrance from the branches": {
            "hintName": "portico fog",
            "lotIDs": [
                "10050",  # Erdtree Sanctuary boss
            ],
            "ownerGroups": [
                "GROUP_GOLDEN_ORDER",
            ],
            "hintRegion": "Leyndell, Royal Capital"
        },
        "in Godfrey's arena at the West entrance to the Marika statue": {
            "hintName": "lift fog",
            "lotIDs": [
                "10050",  # Erdtree Sanctuary boss
            ],
            "ownerGroups": [
                "GROUP_GOLDEN_ORDER",
            ],
            "hintRegion": "Leyndell, Royal Capital"
        },
        "in Godfrey's arena at the rightmost East exit, the one without the "
        "branch": {
            "hintName": "balcony right fog",
            "lotIDs": [
                "10050",  # Erdtree Sanctuary boss
            ],
            "ownerGroups": [
                "GROUP_GOLDEN_ORDER",
            ],
            "hintRegion": "Leyndell, Royal Capital"
        },
        "in Godfrey's arena at the leftmost East exit, the one with the "
        "branch": {
            "hintName": "balcony left fog",
            "lotIDs": [
                "10050",  # Erdtree Sanctuary boss
            ],
            "ownerGroups": [
                "GROUP_GOLDEN_ORDER",
            ],
            "hintRegion": "Leyndell, Royal Capital"
        },
        "in Godfrey's arena at the Southwest exit with a shortcut ladder "
        "behind it": {
            "hintName": "bedchamber fog",
            "lotIDs": [
                "10050",  # Erdtree Sanctuary boss
            ],
            "ownerGroups": [
                "GROUP_GOLDEN_ORDER",
            ],
            "hintRegion": "Leyndell, Royal Capital"
        },
        "in Godfrey's arena at the Southeast exit with treasure behind it": {
            "hintName": "alcove fog",
            "lotIDs": [
                "10050",  # Erdtree Sanctuary boss
            ],
            "ownerGroups": [
                "GROUP_GOLDEN_ORDER",
            ],
            "hintRegion": "Leyndell, Royal Capital"
        }
    },
    "leyndell2_sanctuaryback": {
        # only one lot here shared with leyndell, may miss some hints
        "outside of Gideon's arena at the center back exit": {
            "hintName": "center fog",
            "lotIDs": [
                "11000930",  # cupola SE of Erdtree Sanctuary*
            ],
            "ownerGroups": [
                "GROUP_GOLDEN_ORDER",
            ],
            "hintRegion": "Leyndell, Ashen Capital"
        },
        "outside of Gideon's arena at the leftmost back exit, the one without "
        "the branch": {
            "hintName": "left fog",
            "lotIDs": [
                "11000930",  # cupola SE of Erdtree Sanctuary*
            ],
            "ownerGroups": [
                "GROUP_GOLDEN_ORDER",
            ],
            "hintRegion": "Leyndell, Ashen Capital"
        },
        "outside of Gideon's arena at the rightmost back exit, the one with "
        "the branch": {
            "hintName": "right fog",
            "lotIDs": [
                "11000930",  # cupola SE of Erdtree Sanctuary*
            ],
            "ownerGroups": [
                "GROUP_GOLDEN_ORDER",
            ],
            "hintRegion": "Leyndell, Ashen Capital"
        }
    },
    "leyndell2_sanctuary": {
        # boss is only lot, will almost certainly miss some hints
        "in Gideon's arena at the center East exit": {
            "hintName": "balcony center fog",
            "lotIDs": [
                "10060",  # Ashen Sanctuary boss
            ],
            "ownerGroups": [
                "GENERIC_OWNER",
            ],
            "hintRegion": "Leyndell, Ashen Capital"
        },
        "at the front of Gideon's arena": {
            "hintName": "lift fog",
            "lotIDs": [
                "10060",  # Ashen Sanctuary boss
            ],
            "ownerGroups": [
                "GENERIC_OWNER",
            ],
            "hintRegion": "Leyndell, Ashen Capital"
        },
        "in Gideon's arena at the South entrance by the branches": {
            "hintName": "portico fog",
            "lotIDs": [
                "10060",  # Ashen Sanctuary boss
            ],
            "ownerGroups": [
                "GENERIC_OWNER",
            ],
            "hintRegion": "Leyndell, Ashen Capital"
        },
        "in Gideon's arena at the rightmost East exit, the one without the "
        "branch": {
            "hintName": "balcony right fog",
            "lotIDs": [
                "10060",  # Ashen Sanctuary boss
            ],
            "ownerGroups": [
                "GENERIC_OWNER",
            ],
            "hintRegion": "Leyndell, Ashen Capital"
        },
        "in Gideon's arena at the leftmost East exit, the one with the "
        "branch": {
            "hintName": "balcony left fog",
            "lotIDs": [
                "10060",  # Ashen Sanctuary boss
            ],
            "ownerGroups": [
                "GENERIC_OWNER",
            ],
            "hintRegion": "Leyndell, Ashen Capital"
        },
        "in Gideon's arena at the Southwest exit with a shortcut ladder "
        "behind it": {
            "hintName": "bedchamber fog",
            "lotIDs": [
                "10060",  # Ashen Sanctuary boss
            ],
            "ownerGroups": [
                "GENERIC_OWNER",
            ],
            "hintRegion": "Leyndell, Ashen Capital"
        },
        "in Gideon's arena at the Southeast exit with treasure behind it": {
            "hintName": "alcove fog",
            "lotIDs": [
                "10060",  # Ashen Sanctuary boss
            ],
            "ownerGroups": [
                "GENERIC_OWNER",
            ],
            "hintRegion": "Leyndell, Ashen Capital"
        }
    },
    "ainsel_start": {
        "before Dragonkin of Nokstella's arena": {
            "hintName": "falls fog",
            "lotIDs": [
                "12010330",  # NW of Ainsel River Downstream
                "12010180",  # W/SW of Ainsel River Downstream
                "12010280",  # W/SW of Ainsel River Downstream
                "12010290",  # W/SW of Ainsel River Downstream
                "12010300",  # W/SW of Ainsel River Downstream
                "12010310",  # alcove W/SW of Ainsel River Downstream
                "12010320",  # ledge W/SW of Ainsel River Downstream
                "12010260",  # ledge NE of Ainsel River Downstream
                "12010240",  # NE of Ainsel River Downstream
                "12010220",  # stair E of Ainsel River Downstream
                "12010410",  # stair E of Ainsel River Downstream
                "12010420",  # stair E of Ainsel River Downstream
                "12010430",  # stair E of Ainsel River Downstream
                "12010250",  # E/NE of Ainsel River Downstream
                "12010340",  # fallen pillar NE of Ainsel River Downstream
                "12010400",  # stair NE of Ainsel River Downstream
                # "12010440", # ledge E/NE of Ainsel River Downstream
                # "12010230", # colonnade NE of Ainsel River Downstream
            ],
            "hintRegion": "Ainsel River",
        },
        "at the top of the Ainsel River Well": {
            "hintName": "Ainsel well",
            "lotIDs": [
                "12010070",  # N/NW of Ainsel River Well Depths
                "12010360",  # NW of Ainsel River Well Depths
                "12010170",  # W/SW of Ainsel River Well Depths
                "12010190",  # S/SW of Ainsel River Well Depths
                "12010200",  # E/NE of Ainsel River Sluice Gate
                "12010390",  # E/NE of Ainsel River Sluice Gate
                "12010150",  # E of Ainsel River Sluice Gate
                "12010105",  # enemy SE of Ainsel River Sluice Gate
                "12010210",  # NE and below Ainsel River Sluice Gate
                "12010160",  # N and below Ainsel River Sluice Gate
                "12010040",  # N/NW and below Ainsel River Sluice Gate
                "12010050",  # NW and below Ainsel River Sluice Gate
                "12010270",  # colonnade W/NW of Ainsel River Sluice Gate
                "12010350",  # ledge W/NW and below Ainsel River Sluice Gate
                "12010060",  # W/NW and below Ainsel River Sluice Gate
                "12010080",  # W/NW and below Ainsel River Sluice Gate
            ],
            "hintRegion": "Ainsel River",
        }
    },
    "mohgwyn_boss": {
        # boss is only lot, may miss some hints
        "at the front of Mohg's arena": {
            "hintName": "palace fog",
            "lotIDs": [
                "10120",  # Mohgwyn Throne boss
            ],
            "ownerGroups": [
                "GROUP_BLOOD",
            ],
            "hintRegion": "Mohgwyn Palace",
        },
        "at the back right of Mohg's arena": {
            "hintName": "balcony right fog",
            "lotIDs": [
                "10120",  # Mohgwyn Throne boss
            ],
            "ownerGroups": [
                "GROUP_BLOOD",
            ],
            "hintRegion": "Mohgwyn Palace",
        },
        "at the back left of Mohg's arena": {
            "hintName": "balcony left fog",
            "lotIDs": [
                "10120",  # Mohgwyn Throne boss
            ],
            "ownerGroups": [
                "GROUP_BLOOD",
            ],
            "hintRegion": "Mohgwyn Palace",
        }
    },
    "volcano_town": {
        "before Abductor Virgins' arena. it can be reached from main town "
        "dropping down outside Temple of Eiglay": {
            "hintName": "Inquisitor fog",
            "lotIDs": [
                "16000550",  # S of Subterranean Inquisition Chamber
                "16000560",  # S of Subterranean Inquisition Chamber
                "16000310",  # NW and below Temple of Eiglay
                "16000290",  # ledge W/SW of Temple of Eiglay
                "16002000",  # enemy NW and below Temple of Eiglay
                "16000280",  # NW and below Temple of Eiglay
                "16000270",  # W and below Temple of Eiglay
                "16000220",  # S and below Guest Hall
                "16000200",  # fountain E/NE and below Guest Hall
                "16000210",  # roof E of Guest Hall
                "16000250",  # roof NE of Guest Hall
                "16000170",  # under stair SW of Guest Hall
                "16000190",  # balcony NW of Guest Hall
                "16000230",  # roof N/NW and above Guest Hall
                "16000240",  # terrace W and above Guest Hall
                "16000330",  # railing near and above Guest Hall
                "16000420",  # room W and above Guest Hall
                "16000430",  # torture rack W and above Guest Hall
            ],
            "ownerGroups": [
                "GROUP_FIRE",
                "GROUP_RECUSANT",
            ],
            "hintRegion": "Volcano Manor",
        },
        "before Godskin Noble's arena": {
            "hintName": "temple fog",
            "lotIDs": [
                "16000290",  # ledge W/SW of Temple of Eiglay
                "16002000",  # enemy NW and below Temple of Eiglay
                "16000280",  # NW and below Temple of Eiglay
                "16000270",  # W and below Temple of Eiglay
                "16000220",  # S and below Guest Hall
                "16000200",  # fountain E/NE and below Guest Hall
                "16000210",  # roof E of Guest Hall
                "16000250",  # roof NE of Guest Hall
                "16000050",  # roof W of Prison Town Church
                "16000060",  # wood bridge W/SW of Prison Town Church
                "16000080",  # alley NW of Prison Town Church
                "16000120",  # roof W/NW of Prison Town Church
                "16000130",  # cell NW and below Prison Town Church
                "16000140",  # courtyard W and below Prison Town Church
                "16000150",  # bonfire W and below Prison Town Church
                "16000380",  # awning W and below Prison Town Church
                "16000160",  # stair W/NW of Prison Town Church
            ],
            "ownerGroups": [
                "GROUP_FIRE",
                "GROUP_RECUSANT",
            ],
            "hintRegion": "Volcano Manor",
        }
    },
    "outskirts_rampart": {
        # no lots here, only lot is on the leyndell_start side of the Great
        # Runes door so use that
        # # preexisting transition
        # "to Capital Rampart after acquiring enough Great Runes": {
        #     "hintName": "",
        # },
        "after Draconic Tree Sentinel": {
            "hintName": "outskirts fog",
            "lotIDs": [
                "11000000",  # N of East Capital Rampart
            ],
            "ownerGroups": [
                "GROUP_GOLDEN_ORDER",
            ],
            "hintRegion": "the Capital Outskirts"
        }
    },
    "leyndell2": {
        "at the Ashen Capital entrance from Capital Rampart": {
            "hintName": "lift fog",
            "lotIDs": [
                "35000030",  # sewer rafters
                "11050010",  # near fortified manor
                "11050020",  # archway SW of Leyndell, Capital of Ash
                "11050030",  # near building S of Leyndell, Capital of Ash
                "11050040",  # near statue SW of Leyndell, Capital of Ash
                "11050050",  # roof S/SW of Leyndell, Capital of Ash
                # rampart
                "11000010",  # altar N/NE of East Capital Rampart*
                "11000215",  # S/SE of East Capital Rampart*
                "11000030",  # room S of East Capital Rampart*
                "11000040",  # base of stair S of East Capital Rampart*
            ],
            "ownerGroups": [
                "GENERIC_OWNER",
            ],
            "hintRegion": "Leyndell, Ashen Capital"
        },
        "at the front entrance to Gideon's arena": {
            "hintName": "sanctuary fog",
            "lotIDs": [
                "35000030",  # sewer rafters
                "11050010",  # near fortified manor
                "11050020",  # archway SW of Leyndell, Capital of Ash
                "11050030",  # near building S of Leyndell, Capital of Ash
                "11050040",  # near statue SW of Leyndell, Capital of Ash
                "11050050",  # roof S/SW of Leyndell, Capital of Ash
                # West Capital Rampart
                "11000950",  # crumbled wall NW of West Capital Rampart*
                "11000840",  # ledge N/NW of West Capital Rampart*
                "11000245",  # corridor NW of West Capital Rampart*
                "11000830",  # near lever N and below West Capital Rampart*
                "11000115",  # room SE of West Capital Rampart*
                "11000820",  # ledge S of West Capital Rampart*
                "11000990"  # golden tree S of West Capital Rampart*
            ],
            "ownerGroups": [
                "GENERIC_OWNER",
            ],
            "hintRegion": "Leyndell, Ashen Capital"
        },
        "at the entrance to Royal Colosseum": {
            "hintName": "colosseum fog",
            "lotIDs": [
                "35000030",  # sewer rafters
                "11050010",  # near fortified manor
                "11050020",  # archway SW of Leyndell, Capital of Ash
                "11050030",  # near building S of Leyndell, Capital of Ash
                "11050040",  # near statue SW of Leyndell, Capital of Ash
                "11050050",  # roof S/SW of Leyndell, Capital of Ash
                # Royal Colosseum
                "11000860",  # E/SE of Royal Colosseum*
                "11000870",  # N of Royal Colosseum*
                "11000880",  # SE of Royal Colosseum*
                "11001030",  # stair N of Royal Colosseum*
                # West Capital Rampart
                "11000950",  # crumbled wall NW of West Capital Rampart*
                "11000840",  # ledge N/NW of West Capital Rampart*
                "11000245",  # corridor NW of West Capital Rampart*
                "11000830",  # near lever N and below West Capital Rampart*
                "11000115",  # room SE of West Capital Rampart*
                "11000820",  # ledge S of West Capital Rampart*
                "11000990"  # golden tree S of West Capital Rampart*
            ],
            "ownerGroups": [
                "GENERIC_OWNER",
                "GROUP_OFFENSE"
            ],
            "hintRegion": "Leyndell, Ashen Capital"
        }
    },
    "graveyard_cave": {
        # no lots here
        "at the door to Stranded Graveyard": {
            "hintName": "graveyard fog",
            "hintRegion": "western Limgrave",
        },
        "before Soldier of Godrick's arena": {
            "hintName": "lair fog",
            "hintRegion": "western Limgrave",
        }
    },
    "graveyard": {
        # only one lot
        "at the door from Cave of Knowledge": {
            "hintName": "cave fog",
            "lotIDs": [
                "18000080",  # Stranded Graveyard
            ],
            "hintRegion": "western Limgrave",
        },
        "at the exit to Limgrave": {
            "hintName": "entrance fog",
            "lotIDs": [
                "18000080",  # Stranded Graveyard
            ],
            "hintRegion": "western Limgrave",
        }
    },
    "caelid_tower": {
        # only two lots
        "up the stairs to Caelid Divine Tower's Two Fingers": {
            "hintName": "apex fog",
            "lotIDs": [
                "34130010",  # SE and below Divine Tower of Caelid: Center
                "34130020",  # ledge SE and below Divine Tower of Caelid: Center
            ],
            "hintRegion": "Greyoll's Dragonbarrow",
        },
        "at the left exit to Dragonbarrow, facing north": {
            "hintName": "left fog",
            "lotIDs": [
                "34130010",  # SE and below Divine Tower of Caelid: Center
                "34130020",  # ledge SE and below Divine Tower of Caelid: Center
            ],
            "hintRegion": "Greyoll's Dragonbarrow",
        },
        "at the middle exit to Dragonbarrow": {
            "hintName": "center fog",
            "lotIDs": [
                "34130010",  # SE and below Divine Tower of Caelid: Center
                "34130020",  # ledge SE and below Divine Tower of Caelid: Center
            ],
            "hintRegion": "Greyoll's Dragonbarrow",
        },
        "before Godskin Apostle's arena": {
            "hintName": "chamber fog",
            "lotIDs": [
                "34130010",  # SE and below Divine Tower of Caelid: Center
                "34130020",  # ledge SE and below Divine Tower of Caelid: Center
            ],
            "hintRegion": "Greyoll's Dragonbarrow",
        },
        "at the right exit to Dragonbarrow, facing north": {
            "hintName": "right fog",
            "lotIDs": [
                "34130010",  # SE and below Divine Tower of Caelid: Center
                "34130020",  # ledge SE and below Divine Tower of Caelid: Center
            ],
            "hintRegion": "Greyoll's Dragonbarrow",
        }
    },
    "leyndell": {
        "at the entrance to Subterranean Shunning-Grounds": {
            "hintName": "sewer fog",
            "lotIDs": [
                # gutter
                "11000590",  # sewer NW of Lower Capital Church
                "11000730",  # sewer NW of Lower Capital Church
                "11000810",  # sewer NW of Lower Capital Church
                "11000070",  # sewer NW of Lower Capital Church
                "11000570",  # sewer SE of Lower Capital Church
                "11000600",  # sewer SW of Lower Capital Church
                "11000095",  # sewer N and below Avenue Balcony
                "11000020",  # sewer NW and below Avenue Balcony
                "11000550",  # sewer NW and below Avenue Balcony
                # Lower Capital Church area
                "40372",  # enemy NW of Lower Capital Church
                "11000035",  # bed near Lower Capital Church
                "11000045",  # bed near Lower Capital Church
                "11000650",  # NE of Lower Capital Church
                # well area
                "11000610",  # W/NW of Avenue Balcony
                "11000630",  # ledge NW of Lower Capital Church
                "11000640",  # tunnel NW of Avenue Balcony
                "11000620",  # near well W/NW of Avenue Balcony
                "11000580",  # tunnel W/NW and below Avenue Balcony
                # avenue
                "11000350",  # W of Avenue Balcony
                "11000660",  # rail NW of Avenue Balcony
                "11000680",  # portcullis NW of Avenue Balcony
            ],
            "ownerGroups": [
                "GROUP_GOLDEN_ORDER",
            ],
            "hintRegion": "Leyndell, Royal Capital"
        },
        "before Godfrey's arena from the branches": {
            "hintName": "sanctuary fog",
            "lotIDs": [
                "11000890",  # roof W/SW of Erdtree Sanctuary*
                # West Capital Rampart
                "11000950",  # crumbled wall NW of West Capital Rampart*
                "11000840",  # ledge N/NW of West Capital Rampart*
                "11000245",  # corridor NW of West Capital Rampart*
                "11000830",  # near lever N and below West Capital Rampart*
                "11000115",  # room SE of West Capital Rampart*
                "11000820",  # ledge S of West Capital Rampart*
                "11000990"  # golden tree S of West Capital Rampart*
                "11001187",  # enemy S of West Capital Rampart
                # Fortified Manor Courtyard
                # "11000105", # courtyard N of Fortified Manor, First Floor
                # "11000790", # courtyard NW of Fortified Manor, First Floor
                # "11000145", # arcade NW of Fortified Manor, First Floor
                # Fortified Manor, First Floor
                "80050",  # painting near Fortified Manor, First Floor
                "11000700",  # weapon racks E of Fortified Manor, First Floor
                "11000005",  # in hall SE of Fortified Manor, First Floor
                "11000125",  # room S/SE of Fortified Manor, First Floor
                "11000690",  # fireplace S/SE of Fortified Manor, First Floor
                # Fortified Manor, Second Floor
                "11000720",  # stair SE and above Fortified Manor, First Floor
                "11001010",
                # corridor SE and above Fortified Manor, First Floor
                "11000055",
                # corridor SE and above Fortified Manor, First Floor
                "11000075",  # bed SE and above Fortified Manor, First Floor
                "11000065",  # table S and above Fortified Manor, First Floor
                "11000970",  # throne SW and above Fortified Manor, First Floor
                "11000760",  # rail S/SE and above Fortified Manor, First Floor
                "11000740",  # room above Fortified Manor, First Floor
                "11000850",  # room W/NW and above Fortified Manor, First Floor
                # Fortified Manor bailey
                "11000750",  # N/NE of Fortified Manor, First Floor
                "11000770",  # shack W of Lower Capital Church
                "11000780",  # shack NE of Fortified Manor, First Floor
                "11000800",  # shack NE of Fortified Manor, First Floor
                "11000710",  # roof SW of West Capital Rampart
            ],
            "ownerGroups": [
                "GROUP_GOLDEN_ORDER",
            ],
            "hintRegion": "Leyndell, Royal Capital"
        },
        "at the entrance to Royal Colosseum": {
            "hintName": "colosseum fog",
            "lotIDs": [
                # Royal Colosseum
                "11000860",  # E/SE of Royal Colosseum*
                "11000870",  # N of Royal Colosseum*
                "11000880",  # SE of Royal Colosseum*
                "11001030",  # stair N of Royal Colosseum*
                # West Capital Rampart
                "11000950",  # crumbled wall NW of West Capital Rampart*
                "11000840",  # ledge N/NW of West Capital Rampart*
                "11000245",  # corridor NW of West Capital Rampart*
                "11000830",  # near lever N and below West Capital Rampart*
                "11000115",  # room SE of West Capital Rampart*
                "11000820",  # ledge S of West Capital Rampart*
                "11000990"  # golden tree S of West Capital Rampart*
                "11001187",  # enemy S of West Capital Rampart
                # Fortified Manor Courtyard
                # "11000105", # courtyard N of Fortified Manor, First Floor
                # "11000790", # courtyard NW of Fortified Manor, First Floor
                # "11000145", # arcade NW of Fortified Manor, First Floor
                # Fortified Manor, First Floor
                "80050",  # painting near Fortified Manor, First Floor
                "11000700",  # weapon racks E of Fortified Manor, First Floor
                "11000005",  # in hall SE of Fortified Manor, First Floor
                "11000125",  # room S/SE of Fortified Manor, First Floor
                "11000690",  # fireplace S/SE of Fortified Manor, First Floor
                # Fortified Manor, Second Floor
                "11000720",  # stair SE and above Fortified Manor, First Floor
                "11001010",
                # corridor SE and above Fortified Manor, First Floor
                "11000055",
                # corridor SE and above Fortified Manor, First Floor
                "11000075",  # bed SE and above Fortified Manor, First Floor
                "11000065",  # table S and above Fortified Manor, First Floor
                "11000970",  # throne SW and above Fortified Manor, First Floor
                "11000760",  # rail S/SE and above Fortified Manor, First Floor
                "11000740",  # room above Fortified Manor, First Floor
                "11000850",  # room W/NW and above Fortified Manor, First Floor
                # Fortified Manor bailey
                "11000750",  # N/NE of Fortified Manor, First Floor
                "11000770",  # shack W of Lower Capital Church
                "11000780",  # shack NE of Fortified Manor, First Floor
                "11000800",  # shack NE of Fortified Manor, First Floor
                "11000710",  # roof SW of West Capital Rampart
            ],
            "ownerGroups": [
                "GROUP_GOLDEN_ORDER",
                "GROUP_OFFENSE",
            ],
            "hintRegion": "Leyndell, Royal Capital"
        },
        "at the Leyndell entrance from Capital Rampart": {
            "hintName": "lift fog",
            "lotIDs": [
                # rampart
                "11000010",  # altar N/NE of East Capital Rampart*
                "11000215",  # S/SE of East Capital Rampart*
                "11000030",  # room S of East Capital Rampart*
                "11000040",  # base of stair S of East Capital Rampart*
                "11000050",  # room N/NE of Queen's Bedchamber
                # avenue
                "11000155",  # rotunda SW and below East Capital Rampart
                "11000330",  # rotunda SW and below East Capital Rampart
                "11000150",  # E/NE of Avenue Balcony
                "11000160",  # cart E/SE of Avenue Balcony
                "11001198"  # enemy SE of Avenue Balcony
                "11000280",  # cart E/NE and above Underground Roadside
                # roofs
                "11000380",  # roof SW and below East Capital Rampart
                "11000390",  # roof S/SW and below East Capital Rampart
                "11000370",  # roof E/SE of Avenue Balcony
                "11000360",  # roof E/SE of Underground Roadside
                # terrace
                "11000300",  # rail S and below East Capital Rampart
                "11000290",  # planter E and above Underground Roadside
                # streets
                "11000320",  # below rail S and below East Capital Rampart
                "11000310",  # E and above Underground Roadside
                "11000140",  # SW and above Underground Roadside
                "11000180",  # SW and above Underground Roadside
                # building
                "11000130",  # chest N and below Queen's Bedchamber
                "11000080",  # terrace N and below Queen's Bedchamber
                "11000090",  # corridor N and below Queen's Bedchamber
                "11000110",  # room N and below Queen's Bedchamber
                "11000060",  # room N/NE and below Queen's Bedchamber
                "11000100",  # plaza S/SE and above Underground Roadside
                "11000120",  # room SW and above Underground Roadside
                "11000340",  # room SW and above Underground Roadside
            ],
            "ownerGroups": [
                "GROUP_GOLDEN_ORDER",
            ],
            "hintRegion": "Leyndell, Royal Capital"
        }
    },
    "caelid_greatjar": {
        # only two lots plus the Great-Jar's duel reward
        "at the Deep Siofra Well": {
            "hintName": "Siofra well",
            "lotIDs": [
                "1048400060",  # N and below Caelem Ruins
                "1048390050",  # N/NW and below Abandoned Cave
                "104700",  # Great-Jar reward
            ],
            "hintRegion": "Greyoll's Dragonbarrow",
        },
        "at the entrance to Caelid Colosseum": {
            "hintName": "colosseum fog",
            "lotIDs": [
                "1048400060",  # N and below Caelem Ruins
                "1048390050",  # N/NW and below Abandoned Cave
                "104700",  # Great-Jar reward
            ],
            "ownerGroups": [
                "GROUP_OFFENSE",
            ],
            "hintRegion": "Greyoll's Dragonbarrow",
        }
    },
    "leyndell_bedchamber": {
        "before Morgott's arena": {
            "hintName": "throne fog",
            "lotIDs": [
                # if the ashen version of this lot is picked up first, the
                # normal version won't appear
                # "11001000",  # bed near Queen's Bedchamber
                "11000015",  # chest W and above Erdtree Sanctuary*
                "11000025",  # ledge W/SW and above Erdtree Sanctuary*
                "11000910",  # chair near and above Erdtree Sanctuary*
            ],
            "ownerGroups": [
                "GROUP_GOLDEN_ORDER",
            ],
            "hintRegion": "Leyndell, Royal Capital"
        },
        "outside of Godfrey's arena at the base of a shortcut ladder, "
        "accessed from an open window on a second-floor rooftop": {
            "hintName": "sanctuary fog",
            "lotIDs": [
                # if the ashen version of this lot is picked up first, the
                # normal version won't appear
                # "11001000",  # bed near Queen's Bedchamber
                "11000015",  # chest W and above Erdtree Sanctuary*
                "11000025",  # ledge W/SW and above Erdtree Sanctuary*
                "11000910",  # chair near and above Erdtree Sanctuary*
            ],
            "ownerGroups": [
                "GROUP_GOLDEN_ORDER",
            ],
            "hintRegion": "Leyndell, Royal Capital"
        }
    },
    "farumazula_temple": {
        "before back right of Godskin Duo arena, down Dragon Temple stairs": {
            "hintName": "south fog",
            "lotIDs": [
                "13000025",  # coffin W and above Dragon Temple
                "13000290",  # W of Dragon Temple
                "13000320",  # corridor ledge SE of Dragon Temple
                "13000330",  # N of Dragon Temple
                "13000870",  # W of Dragon Temple
                "13000015",  # corridor ledge W/NW of Dragon Temple Altar
                "13000350",  # rear corridor E/NE of Dragon Temple Altar
                "13000360",  # crumbled stair NW of Dragon Temple Altar
            ],
            "ownerGroups": [
                "GROUP_BEAST",
                "GROUP_DRAGON",
                "GROUP_HOLY",
            ],
            "hintRegion": "Crumbling Farum Azula",
        },
        "before back left of Godskin Duo arena, by the crumbled stairs": {
            "hintName": "north fog",
            "lotIDs": [
                "13000025",  # coffin W and above Dragon Temple
                "13000290",  # W of Dragon Temple
                "13000320",  # corridor ledge SE of Dragon Temple
                "13000330",  # N of Dragon Temple
                "13000870",  # W of Dragon Temple
                "13000015",  # corridor ledge W/NW of Dragon Temple Altar
                "13000350",  # rear corridor E/NE of Dragon Temple Altar
                "13000360",  # crumbled stair NW of Dragon Temple Altar
            ],
            "ownerGroups": [
                "GROUP_BEAST",
                "GROUP_DRAGON",
                "GROUP_HOLY",
            ],
            "hintRegion": "Crumbling Farum Azula",
        },
        "outside the balcony above Godskin Duo's arena": {
            "hintName": "balcony fog",
            "lotIDs": [
                "13000025",  # coffin W and above Dragon Temple
                "13000290",  # W of Dragon Temple
                "13000320",  # corridor ledge SE of Dragon Temple
                "13000330",  # N of Dragon Temple
                "13000870",  # W of Dragon Temple
                "13000015",  # corridor ledge W/NW of Dragon Temple Altar
                "13000350",  # rear corridor E/NE of Dragon Temple Altar
                "13000360",  # crumbled stair NW of Dragon Temple Altar
            ],
            "ownerGroups": [
                "GROUP_BEAST",
                "GROUP_DRAGON",
                "GROUP_HOLY",
            ],
            "hintRegion": "Crumbling Farum Azula",
        }
    },
    "farumazula_godskinduo": {
        # boss is only lot, may miss some hints
        "at the back right of Godskin Duo's arena": {
            "hintName": "southwest fog",
            "lotIDs": [
                "10140",  # boss
            ],
            "ownerGroups": [
                "GROUP_BEAST",
                "GROUP_DRAGON",
                "GROUP_HOLY",
            ],
            "hintRegion": "Crumbling Farum Azula",
        },
        "at the front left of Godskin Duo's arena": {
            "hintName": "northeast fog",
            "lotIDs": [
                "10140",  # boss
            ],
            "ownerGroups": [
                "GROUP_BEAST",
                "GROUP_DRAGON",
                "GROUP_HOLY",
            ],
            "hintRegion": "Crumbling Farum Azula",
        },
        "at the back left of Godskin Duo's arena": {
            "hintName": "northwest fog",
            "lotIDs": [
                "10140",  # boss
            ],
            "ownerGroups": [
                "GROUP_BEAST",
                "GROUP_DRAGON",
                "GROUP_HOLY",
            ],
            "hintRegion": "Crumbling Farum Azula",
        },
        "at the front right of Godskin Duo's arena": {
            "hintName": "southeast fog",
            "lotIDs": [
                "10140",  # boss
            ],
            "ownerGroups": [
                "GROUP_BEAST",
                "GROUP_DRAGON",
                "GROUP_HOLY",
            ],
            "hintRegion": "Crumbling Farum Azula",
        }
    },
    "liurnia_blackknifecatacombs": {
        "before Cemetery Shade's arena": {
            "hintName": "tomb fog",
            "lotIDs": [
                "30050000",  # locked room E/SE of Black Knife Catacombs
                "30050010",  # SW and below Frenzied Flame Village Outskirts
                "30050040",  # E and below Frenzied Flame Village Outskirts
            ],
            "ownerGroups": [
                "GROUP_STEALTH",
            ],
            "hintRegion": "eastern Liurnia",
        },
        "before Black Knife Assassin's arena": {
            "hintName": "secret fog",
            "lotIDs": [
                "30050000",  # locked room E/SE of Black Knife Catacombs
                "30050010",  # SW and below Frenzied Flame Village Outskirts
                "30050040",  # E and below Frenzied Flame Village Outskirts
            ],
            "ownerGroups": [
                "GROUP_STEALTH",
            ],
            "hintRegion": "eastern Liurnia",
        },
        "at the entrance from Liurnia": {
            "hintName": "entrance fog",
            "lotIDs": [
                "30050000",  # locked room E/SE of Black Knife Catacombs
                "30050010",  # SW and below Frenzied Flame Village Outskirts
                "30050040",  # E and below Frenzied Flame Village Outskirts
            ],
            "ownerGroups": [
                "GROUP_STEALTH",
            ],
            "hintRegion": "eastern Liurnia",
        }
    },
    "snowfield_hiddenpath": {
        "before Stray Mimic Tear's arena": {
            "hintName": "tomb fog",
            "lotIDs": [
                "30200000",  # room E/NE of Hidden Path to the Haligtree
                "30200050",  # stair SE of Hidden Path to the Haligtree
                "30200900",  # hidden chest SW of Hidden Path to the Haligtree
                "30200010",  # room E of Hidden Path to the Haligtree
                "30200020",  # balcony SE of Hidden Path to the Haligtree
                "30200030",  # SE of Hidden Path to the Haligtree
                "30200040",  # SE of Hidden Path to the Haligtree
                "30200060",  # near elevator S of Hidden Path to the Haligtree
            ],
            "hintRegion": "the Consecrated Snowfield",
        },
        "at exit to Consecrated Snowfield": {
            "hintName": "snowfield fog",
            "lotIDs": [
                "30200000",  # room E/NE of Hidden Path to the Haligtree
                "30200050",  # stair SE of Hidden Path to the Haligtree
                "30200900",  # hidden chest SW of Hidden Path to the Haligtree
                "30200010",  # room E of Hidden Path to the Haligtree
                "30200020",  # balcony SE of Hidden Path to the Haligtree
                "30200030",  # SE of Hidden Path to the Haligtree
                "30200040",  # SE of Hidden Path to the Haligtree
                "30200060",  # near elevator S of Hidden Path to the Haligtree
            ],
            "hintRegion": "the Consecrated Snowfield",
        }
    },
    "altus_sagescave": {
        "before Black Knife Assassin's arena": {
            "hintName": "lair fog",
            "lotIDs": [
                "31190000",  # chest S of Sage's Cave
                "31190010",  # chest S of Sage's Cave
                "31190200",  # S of Sage's Cave
                "31190210",  # S of Sage's Cave
                "31190030",  # hidden chest S/SE of Sage's Cave
                "31190040",  # hidden chest S/SE of Sage's Cave
                "31190050",  # hidden chest S/SE of Sage's Cave
                "31190060",  # hidden chest S/SE of Sage's Cave
                "31190080",  # hidden chest S/SE of Sage's Cave
                "31190090",  # chest SE of Sage's Cave
                "31190100",  # chest SE of Sage's Cave
                "31190110",  # chest S/SE of Sage's Cave
                "31190120",  # hidden chest S of Sage's Cave
                "31190130",  # hidden chest S of Sage's Cave
            ],
            "ownerGroups": [
                "GROUP_MAGIC",
            ],
            "hintRegion": "Altus Plateau"
        },
        "before Necromancer Garris' arena": {
            "hintName": "secret fog",
            "lotIDs": [
                "31190000",  # chest S of Sage's Cave
                "31190010",  # chest S of Sage's Cave
                "31190200",  # S of Sage's Cave
                "31190210",  # S of Sage's Cave
                "31190030",  # hidden chest S/SE of Sage's Cave
                "31190040",  # hidden chest S/SE of Sage's Cave
                "31190050",  # hidden chest S/SE of Sage's Cave
                "31190060",  # hidden chest S/SE of Sage's Cave
                "31190080",  # hidden chest S/SE of Sage's Cave
                "31190090",  # chest SE of Sage's Cave
                "31190100",  # chest SE of Sage's Cave
                "31190110",  # chest S/SE of Sage's Cave
                "31190120",  # hidden chest S of Sage's Cave
                "31190130",  # hidden chest S of Sage's Cave
            ],
            "ownerGroups": [
                "GROUP_MAGIC",
            ],
            "hintRegion": "Altus Plateau"
        },
        "at the entrance from Altus Plateau": {
            "hintName": "entrance fog",
            "lotIDs": [
                "31190000",  # chest S of Sage's Cave
                "31190010",  # chest S of Sage's Cave
                "31190200",  # S of Sage's Cave
                "31190210",  # S of Sage's Cave
                "31190030",  # hidden chest S/SE of Sage's Cave
                "31190040",  # hidden chest S/SE of Sage's Cave
                "31190050",  # hidden chest S/SE of Sage's Cave
                "31190060",  # hidden chest S/SE of Sage's Cave
                "31190080",  # hidden chest S/SE of Sage's Cave
                "31190090",  # chest SE of Sage's Cave
                "31190100",  # chest SE of Sage's Cave
                "31190110",  # chest S/SE of Sage's Cave
                "31190120",  # hidden chest S of Sage's Cave
                "31190130",  # hidden chest S of Sage's Cave
            ],
            "ownerGroups": [
                "GROUP_MAGIC",
            ],
            "hintRegion": "Altus Plateau"
        }
    },
    "caelid_gaeltunnel": {
        "before Magma Wyrm's arena": {
            "hintName": "lair fog",
            "lotIDs": [
                "32070010",  # SW and below Shack of the Rotting
                "32070020",  # cavern SW and below Forsaken Ruins
                "32070030",  # N of Gael Tunnel
                "32070060",  # NE of Rear Gael Tunnel Entrance
                "32070070",  # NE of Rear Gael Tunnel Entrance
            ],
            "ownerGroups": [
                "GROUP_SMITH",
            ],
            "hintRegion": "northern Caelid",
        }
    },
    "sewer": {
        "before Mohg's arena": {
            "hintName": "Forsaken fog",
            "lotIDs": [
                "35000610",  # room W/SW and above Forsaken Depths
                "35000630",  # SW of Cathedral of the Forsaken
                "35000600",  # pipe E/NE and above Leyndell Catacombs
                "35000560",  # pipe NE and above Leyndell Catacombs
                "35000570",  # pipe N/NE and above Leyndell Catacombs
                "35000540",  # end of pipe E and below Underground Roadside
                "35000590",  # pipe E/NE and above Leyndell Catacombs
                "35000550",  # end of pipe S/SE and below Underground Roadside
                "35000530",  # end of pipe SE and below Underground Roadside
            ],
            "hintRegion": "the Subterranean Shunning-Grounds",
        },
        "at the entrance to Leyndell Catacombs at the bottom of the room with "
        "the pipes": {
            "hintName": "catacombs fog",
            "lotIDs": [
                "35000310",  # E/SE of Leyndell Catacombs
                "35000470",  # NE of Leyndell Catacombs
                "35000450",  # N/NE of Leyndell Catacombs
                "35000460",  # NE of Leyndell Catacombs
                "35000480",  # E of Leyndell Catacombs
                "35000980",  # enemy NE of Leyndell Catacombs
                "35000950",  # hidden alcove SW and above Leyndell Catacombs
                "35000510",  # SE and below Lower Capital Church
                # "35000420", # E and below Lower Capital Church
            ],
            "hintRegion": "the Subterranean Shunning-Grounds",
        }
    },
    "leyndell2_bedchamber": {
        "before Hoarah Loux's arena": {
            "hintName": "throne fog",
            "lotIDs": [
                # if the ashen version of this lot is picked up first, the
                # normal version won't appear
                # "11050000",  # bed near Queen's Bedchamber
                "11000015",  # chest W and above Erdtree Sanctuary*
                "11000025",  # ledge W/SW and above Erdtree Sanctuary*
                "11000910",  # chair near and above Erdtree Sanctuary*
            ],
            "ownerGroups": [
                "GENERIC_OWNER",
            ],
            "hintRegion": "Leyndell, Ashen Capital"
        },
        "outside of Gideon's arena at the base of a shortcut ladder, accessed "
        "from an open window on a second-floor rooftop": {
            "hintName": "sanctuary fog",
            "lotIDs": [
                # if the ashen version of this lot is picked up first, the
                # normal version won't appear
                # "11050000",  # bed near Queen's Bedchamber
                "11000015",  # chest W and above Erdtree Sanctuary*
                "11000025",  # ledge W/SW and above Erdtree Sanctuary*
                "11000910",  # chair near and above Erdtree Sanctuary*
            ],
            "ownerGroups": [
                "GENERIC_OWNER",
            ],
            "hintRegion": "Leyndell, Ashen Capital"
        }
    },
    "caelid_redmane_postboss": {
        # only two lots
        "after Redmane Castle Plaza": {
            "hintName": "plaza fog",
            "lotIDs": [
                "1051360100",  # chapel N/NW of Redmane Castle Plaza
                "1051360110",  # N of Redmane Castle Plaza
            ],
            "ownerGroups": [
                "GROUP_KNIGHT",
                "GROUP_HOLY",
            ],
            "hintRegion": "southern Caelid",
        },
        "at the bottom of the elevator before the Radahn warp": {
            "hintName": "beach fog",
            "lotIDs": [
                "1051360100",  # chapel N/NW of Redmane Castle Plaza
                "1051360110",  # N of Redmane Castle Plaza
            ],
            "ownerGroups": [
                "GROUP_KNIGHT",
                "GROUP_HOLY",
            ],
            "hintRegion": "southern Caelid",
        }
    },
    "roundtable": {
        # only lots are behind locked doors
        "in Roundtable Hold in the main room": {
            "hintName": "balcony fog",
            "lotIDs": [
                "11100700",  # chest in kitchen SE of Roundtable Hold
                "11100710",  # chest in dining room SE of Roundtable Hold
            ],
            "hintRegion": "Roundtable Hold"
        }
    },
    # can only come in through this fog, so no need for hints
    # "academy_rooftops": {
    #     "at the top of the steps before Raya Lucaria rooftops section": {
    #         "hintName": "",
    #         "lotIDs": [],
    #         "ownerGroups": [
    #             "GROUP_MAGIC",
    #         ],
    #         "hintRegion": "the Academy of Raya Lucaria",
    #     }
    # },
    # can only come in through this fog, so no need for hints
    # "volcano_hallway": {
    #     "in the hallway towards the Imp Seal back to main Volcano Manor": {
    #         "hintName": "",
    #         "lotIDs": [],
    #         "ownerGroups": [
    #             "GROUP_FIRE",
    #             "GROUP_RECUSANT",
    #             "GROUP_HOLY",
    #         ],
    #         "hintRegion": "Volcano Manor",
    #     }
    # },
    "volcano_temple": {
        "at the front of Godskin Noble's arena": {
            "hintName": "entrance fog",
            "lotIDs": [
                "16000710",  # altar near Temple of Eiglay
                "10210",  # Eiglay Temple boss
                "16000320",  # gallery NW and above Temple of Eiglay
            ],
            "ownerGroups": [
                "GROUP_FIRE",
                "GROUP_RECUSANT",
                "GROUP_HOLY",
            ],
            "hintRegion": "Volcano Manor",
        },
        "at the back left of Godskin Noble's arena": {
            "hintName": "lift fog",
            "lotIDs": [
                "16000710",  # altar near Temple of Eiglay
                "10210",  # Eiglay Temple boss
                "16000320",  # gallery NW and above Temple of Eiglay
            ],
            "ownerGroups": [
                "GROUP_FIRE",
                "GROUP_RECUSANT",
                "GROUP_HOLY",
            ],
            "hintRegion": "Volcano Manor",
        }
    },
    # special cases:
    # need to handle this not within the network
    "pureblood": {
        "using the Pureblood Knight's Medal from anywhere": {
            # can be found anywhere, so put the hint with Varre
            "hintName": "Pureblood Medal",
            "lotIDs": [
                "100320",  # Varre quest reward
            ]
        }
    },
    # need hint for castle morne rear as part of the lands between
    "peninsula_postmorne": {
        "before Leonine Misbegotten's arena": {
            "hintName": "Moangrave fog",
            "lotIDs": [
                "1043300000",  # water SW of Beside the Rampart Gaol
                "1043300010",  # alcove NW of Beside the Rampart Gaol
                "1043310220",  # promontory NW and above Beside the Rampart Gaol
                "1043310240",  # rafter NW and above Beside the Rampart Gaol
                "1043310280",  # SW of Beside the Rampart Gaol
                "1043310370",  # room N/NW of Beside the Rampart Gaol
                "1043310900",  # tower chest NW of Behind the Castle
                "1043310140",  # room W/NW and below Behind the Castle
                "1043310170",  # platform W/SW and below Behind the Castle
            ],
            "ownerGroups": [
                "GROUP_KNIGHT",
            ],
            "hintRegion": "Castle Morne's Ramparts",
        },
    },
    # need hint for the elevator gate as part of leyndell
    "leyndell_pretower": {
        "at the base of the elevator to the Divine Tower of East Altus": {
            "hintName": "lift fog",
            "lotIDs": [
                "11000410",  # stair SE and below East Capital Rampart*
                "11000420",  # ledge E/SE and below East Capital Rampart*
                "11000430",  # E and below East Capital Rampart*
                "11000440",  # statue E and below East Capital Rampart*
                "11000400",  # SE and below East Capital Rampart
                "11000450",  # SE and below East Capital Rampart
                "11000460",  # SE and below East Capital Rampart
                "11000470",  # E/NE and below Queen's Bedchamber
                "11000155",  # rotunda SW and below East Capital Rampart
                "11000330",  # rotunda SW and below East Capital Rampart
                "11000280",  # cart E/NE and above Underground Roadside
                "11000320",  # below rail S and below East Capital Rampart
                "11000310",  # E and above Underground Roadside
                "11000140",  # SW and above Underground Roadside
                "11000180",  # SW and above Underground Roadside
            ],
            "ownerGroups": [
                "GROUP_GOLDEN_ORDER",
            ],
            "hintRegion": "Leyndell, Royal Capital"
        },
    },
    # need hint for the elevator gate as part of leyndell tower
    # note: this has both leyndell and ashen versions
    "leyndell_tower_start": {
        "at the elevator to the Divine Tower of East Altus": {
            "hintName": "Leyndell fog",
            # don't use the lot on the west side of the door so that all
            # hints are on the node side
            "lotIDs": [
                "34140000",  # near elden throne door
                # does not always appear?
                # "34140720",  # enemy near elden throne door
                "34140010",  # isolated room in elevator shaft
                "34140810",  # isolated room in elevator shaft
            ],
            "ownerGroups": [
                "GROUP_GOLDEN_ORDER",
            ],
            "hintRegion": "Leyndell, Royal Capital"
        },
    },
    # need hint for the fringefolk grave boss fog as part of stranded graveyard
    "graveyard_grave": {
        "before Ulcerated Tree Spirit's arena": {
            "hintName": "tomb fog",
            "lotIDs": [
                # "18000080", # Stranded Graveyard
                "18000000",  # ramp N/NE of Stranded Graveyard
                "18000010",  # ledge NE of Stranded Graveyard
                "18000020",  # alcove N/NE of Stranded Graveyard
                "18000030",  # room NW of Stranded Graveyard
                "18000040",  # room NE of Stranded Graveyard
                "18000050",  # large room NE of Stranded Graveyard
                "18000060",  # ramp NE of Stranded Graveyard
                "18000900",  # Merciless Chariot
            ],
            "hintRegion": "western Limgrave",
        }
    },
    # need hint for night's sacred ground warp as part of nokron woods
    "siofra_nokron_grounds": {
        "using the sending gate before the Fingerslayer Blade chest": {
            "hintName": "Night's gate",
            # don't use the Fingerslayer Blade chest since it requires Ranni's
            # quest progression to open
            "lotIDs": [
                "12020010",  # altar NE of Night's Sacred Ground
                "12020880",  # chest E/NE of Night's Sacred Ground
                "12020900",  # room E/NE of Night's Sacred Ground
                "12020910",  # rafter E/NE of Night's Sacred Ground
                "12020920",  # N/NE of Night's Sacred Ground
                "12020930",  # N/NE of Night's Sacred Ground
                "12020940",  # N/NE of Night's Sacred Ground
            ],
            "ownerGroups": [
                "GROUP_DEATH",
            ],
            "hintRegion": "Nokron, Eternal City",
        },
    },
    # need hint for the ashen sanctuary side door as part of ashen leyndell
    "leyndell2_sanctuaryside": {
        "at the side entrance to Gideon's arena from the branches": {
            "hintName": "sanctuary fog",
            "lotIDs": [
                "11000890",  # roof W/SW of Erdtree Sanctuary*
                "35000030",  # sewer rafters
                "11050010",  # near fortified manor
                "11050020",  # archway SW of Leyndell, Capital of Ash
                "11050030",  # near building S of Leyndell, Capital of Ash
                "11050040",  # near statue SW of Leyndell, Capital of Ash
                "11050050",  # roof S/SW of Leyndell, Capital of Ash
                # West Capital Rampart
                "11000950",  # crumbled wall NW of West Capital Rampart*
                "11000840",  # ledge N/NW of West Capital Rampart*
                "11000245",  # corridor NW of West Capital Rampart*
                "11000830",  # near lever N and below West Capital Rampart*
                "11000115",  # room SE of West Capital Rampart*
                "11000820",  # ledge S of West Capital Rampart*
                "11000990"  # golden tree S of West Capital Rampart*
            ],
            "ownerGroups": [
                "GENERIC_OWNER",
            ],
            "hintRegion": "Leyndell, Ashen Capital"
        },
    },
    # need hint for leyndell start as part of capital rampart
    "leyndell_start": {
        "at the Leyndell entrance from Capital Rampart": {
            "hintName": "lift fog",
            "lotIDs": [
                "11000000",  # N of East Capital Rampart
            ],
            "ownerGroups": [
                "GROUP_GOLDEN_ORDER",
            ],
            "hintRegion": "Leyndell, Royal Capital"
        }
    },
    # need hint for dragon temple transept as part of dragon temple
    # no lots there so put them in dragon temple
    "farumazula_transept": {
        "up the stairs from Dragon Temple Transept": {
            "hintName": "altar fog",
            "lotIDs": [
                "13000320",  # corridor ledge SE of Dragon Temple
                "13000330",  # N of Dragon Temple
                "13000300",  # corridor ledge SW and below Dragon Temple
                "13000310",  # W and below Dragon Temple
                "13000380",  # N and below Dragon Temple
                "13000390",  # S and below Dragon Temple
                "13000890",  # W of Dragon Temple Transept
            ],
            "ownerGroups": [
                "GROUP_DRAGON",
                "GROUP_BEAST",
                "GROUP_HOLY",
            ],
            "hintRegion": "Crumbling Farum Azula",
        },
    },
    # need hint for eiglay side elevator as part of caldera hall
    # no lots there so put them in caldera hall
    "volcano_posttemple_elevator": {
        "after Godskin Noble's arena to the back left, down the shortcut "
        "elevator": {
            "hintName": "temple fog",
            "lotIDs": [
                # "16000520", # Praetor's throne room
                # "16000530", # lava room W of Volcano Manor
                # "16000510", # snake statue S/SW of Volcano Manor
                "16000490",  # room N and above Temple of Eiglay
                "16000480",  # ledge N and above Temple of Eiglay
                "16000440",  # ladder N/NE and above Temple of Eiglay
                "16000410",  # E of Temple of Eiglay
                "16000400",  # under balcony E of Temple of Eiglay
                "16000390",  # lava pool NE of Temple of Eiglay
                "16000450",  # basement NE of Temple of Eiglay
                "40592",  # enemy near lava N and above Temple of Eiglay
            ],
            "ownerGroups": [
                "GROUP_FIRE",
                "GROUP_RECUSANT",
            ],
            "hintRegion": "Volcano Manor",
        },
    },
    # need hint for gael tunnel rear as part of gael tunnel
    # no lots there so put in gael tunnel
    "caelid_gaeltunnel_rear": {
        "at the Gael Tunnel rear exit, North of the Third Church of Marika": {
            "hintName": "exit fog",
            "lotIDs": [
                "32070010",  # SW and below Shack of the Rotting
                "32070020",  # cavern SW and below Forsaken Ruins
                "32070030",  # N of Gael Tunnel
                "32070060",  # NE of Rear Gael Tunnel Entrance
                "32070070",  # NE of Rear Gael Tunnel Entrance
            ],
            "hintRegion": "eastern Limgrave",
        },
    },
    # drop in corridors that are dropped in from nodes, not technically nodes
    # themselves but put the hints for each gate in the node you drop in from
    # drop from siofra_nokron
    "siofra_nokron_aqueduct": {
        "before Valiant Gargoyles' arena": {
            "hintName": "waterfall fog",
            "lotIDs": [
                "12020760",  # near Aqueduct-Facing Cliffs
                "12020630",  # ledge S of Aqueduct-Facing Cliffs
                "12020750",  # ledge N of Hallowhorn Grounds
                "12020620",  # ledge above Hallowhorn Grounds
                "12020640",  # NW of Hallowhorn Grounds
                "12020650",  # N of Ancestral Woods
                "12020660",  # N of Ancestral Woods
                "12020670",  # N/NW of Ancestral Woods
                "12020530",  # road E/NE of Ancestral Woods
                "12020540",  # road NE of Ancestral Woods
                "12020550",  # road NE of Ancestral Woods
                "12020570",  # stair N/NE of Ancestral Woods
                "12020590",  # S of Hallowhorn Grounds
                "12020600",  # base of stair SW of Hallowhorn Grounds
                "12020610",  # base of pillar S of Hallowhorn Grounds
            ],
            "hintRegion": "Nokron, Eternal City",
        },
    },
    # drop from leyndell
    "leyndell_divinebridge": {
        "using the sending gate after unlocking the elevator in Leyndell or "
        "unlocking Ashen Divine Bridge": {
            "hintName": "Divine gate",
            "lotIDs": [
                # Fortified Manor Courtyard
                # "11000105", # courtyard N of Fortified Manor, First Floor
                # "11000790", # courtyard NW of Fortified Manor, First Floor
                # "11000145", # arcade NW of Fortified Manor, First Floor
                # Fortified Manor, First Floor
                "80050",  # painting near Fortified Manor, First Floor
                "11000700",  # weapon racks E of Fortified Manor, First Floor
                "11000005",  # in hall SE of Fortified Manor, First Floor
                "11000125",  # room S/SE of Fortified Manor, First Floor
                "11000690",  # fireplace S/SE of Fortified Manor, First Floor
                # Fortified Manor, Second Floor
                "11000720",  # stair SE and above Fortified Manor, First Floor
                "11001010",
                # corridor SE and above Fortified Manor, First Floor
                "11000055",
                # corridor SE and above Fortified Manor, First Floor
                "11000075",  # bed SE and above Fortified Manor, First Floor
                "11000065",  # table S and above Fortified Manor, First Floor
                "11000970",  # throne SW and above Fortified Manor, First Floor
                "11000760",  # rail S/SE and above Fortified Manor, First Floor
                "11000740",  # room above Fortified Manor, First Floor
                "11000850",  # room W/NW and above Fortified Manor, First Floor
                # Fortified Manor bailey
                "11000750",  # N/NE of Fortified Manor, First Floor
                "11000770",  # shack W of Lower Capital Church
                "11000780",  # shack NE of Fortified Manor, First Floor
                "11000800",  # shack NE of Fortified Manor, First Floor
                "11000710",  # roof SW of West Capital Rampart
            ],
            "ownerGroups": [
                "GROUP_GOLDEN_ORDER",
            ],
            "hintRegion": "Leyndell, Royal Capital",
            "hintArea": "Divine Bridge",
        },
    },
    # drop from caelid_redmane_postboss
    "caelid_redmane_boss": {
        "at the front of Redmane Castle Plaza": {
            "hintName": "castle fog",
            "lotIDs": [
                "1051360100",  # chapel N/NW of Redmane Castle Plaza
                "1051360110",  # N of Redmane Castle Plaza
            ],
            "ownerGroups": [
                "GROUP_KNIGHT",
            ],
            "hintRegion": "southern Caelid",
        },
        "at the back of Redmane Castle Plaza": {
            "hintName": "chapel fog",
            "lotIDs": [
                "1051360100",  # chapel N/NW of Redmane Castle Plaza
                "1051360110",  # N of Redmane Castle Plaza
            ],
            "ownerGroups": [
                "GROUP_KNIGHT",
            ],
            "hintRegion": "southern Caelid",
        },
    },
    # drop from academy_courtyard
    "academy_redwolf": {
        "at the front of Red Wolf's arena": {
            "hintName": "classroom fog",
            "lotIDs": [
                "14000500",  # window N and above Schoolhouse Classroom
                "14000420",  # fountain N and above Schoolhouse Classroom
                "14000490",  # W and above Schoolhouse Classroom
                "14000780",  # patio N and above Debate Parlor
                "14000410",  # patio N and above Debate Parlor
                "14000470",  # patio SW and above Schoolhouse Classroom
                "14000460",  # SW and above Debate Parlor
                "14000940",  # chest NW and above Debate Parlor
            ],
            "ownerGroups": [
                "GROUP_MAGIC",
            ],
            "hintRegion": "the Academy of Raya Lucaria",
        },
        "at the back left of Red Wolf's arena": {
            "hintName": "courtyard fog",
            "lotIDs": [
                "14000500",  # window N and above Schoolhouse Classroom
                "14000420",  # fountain N and above Schoolhouse Classroom
                "14000490",  # W and above Schoolhouse Classroom
                "14000780",  # patio N and above Debate Parlor
                "14000410",  # patio N and above Debate Parlor
                "14000470",  # patio SW and above Schoolhouse Classroom
                "14000460",  # SW and above Debate Parlor
                "14000940",  # chest NW and above Debate Parlor
            ],
            "ownerGroups": [
                "GROUP_MAGIC",
            ],
            "hintRegion": "the Academy of Raya Lucaria",
        },
    },
    # drop from leyndell_bedchamber
    "leyndell_sanctuaryfront": {
        "outside of Godfrey's arena at the stairs which go down to the Marika "
        "statue": {
            "hintName": "sanctuary fog",
            "lotIDs": [
                "11001000",  # bed near Queen's Bedchamber
                "11000015",  # chest W and above Erdtree Sanctuary*
                "11000025",  # ledge W/SW and above Erdtree Sanctuary*
                "11000910",  # chair near and above Erdtree Sanctuary*
            ],
            "ownerGroups": [
                "GROUP_GOLDEN_ORDER",
            ],
            "hintRegion": "Leyndell, Royal Capital"
        },
    },
    # technically a drop in corridor where the areas dropped in from
    # (outskirts_sidetomb_dupeentrance and outskirts_sidetomb_dupeupper)
    # are not nodes, so a traversal from them would have to branch, so treat it
    # as a node
    "outskirts_sidetomb_dupehallway": {
        "using the chest at the end of the duplicate hallway": {
            "hintName": "hallway trap",
            "lotIDs": [
                "30130040",  # upper room NW of Auriza Side Tomb
                "30130140",  # upper room NW of Auriza Side Tomb
            ],
            "hintRegion": "the Capital Outskirts"
        },
        "using the chest behind the illusory wall": {
            "hintName": "room trap",
            "lotIDs": [
                "30130040",  # upper room NW of Auriza Side Tomb
                "30130140",  # upper room NW of Auriza Side Tomb
            ],
            "hintRegion": "the Capital Outskirts"
        }
    },
    # warp in corridor, can come from anywhere so traversal would have to
    # branch, treat it as a node
    "caelid_selliatunnel": {
        "at the entrance from Caelid": {
            "hintName": "entrance fog",
            "lotIDs": [
                "32080000",  # W/NW of Sellia Crystal Tunnel
                "32080020",  # shack N and above Sellia Crystal Tunnel
                "32080030",  # shack roof N and above Sellia Crystal Tunnel
                "32080900",  # shack chest N/NE and above Sellia Crystal Tunnel
                "32080050",  # catwalk N and above Sellia Crystal Tunnel
                "32080060",  # beam N/NE and above Sellia Crystal Tunnel
                "32080070",  # platform N/NE and above Sellia Crystal Tunnel
                "32080910",  # shack chest N/NE and above Sellia Crystal Tunnel
                "32080100",  # by ladder N and above Sellia Crystal Tunnel
            ],
            "ownerGroups": [
                "GROUP_SMITH",
            ],
            "hintRegion": "southern Caelid",
        },
        "before Fallingstar Beast's arena": {
            "hintName": "lair fog",
            "lotIDs": [
                "32080110",  # E of Deep Siofra Well
                "32080120",  # platform E of Deep Siofra Well
                "32080020",  # shack N and above Sellia Crystal Tunnel
                "32080030",  # shack roof N and above Sellia Crystal Tunnel
                "32080900",  # shack chest N/NE and above Sellia Crystal Tunnel
                "32080050",  # catwalk N and above Sellia Crystal Tunnel
                "32080060",  # beam N/NE and above Sellia Crystal Tunnel
                "32080070",  # platform N/NE and above Sellia Crystal Tunnel
                "32080910",  # shack chest N/NE and above Sellia Crystal Tunnel
                "32080100",  # by ladder N and above Sellia Crystal Tunnel
            ],
            "ownerGroups": [
                "GROUP_SMITH",
            ],
            "hintRegion": "southern Caelid",
        }
    },
    # possible to reach volcano manor from the attic for the first time
    # need a hint to the prison town church fog somewhere
    # this is stretching things a bit since the fog is two areas past the attic
    # and needs the drawing room key anyway
    # drop from volcano_hallway
    "volcano_drawingroom": {
        "at the end of the dark hallway leading to Prison Town": {
            "hintName": "church fog",
            "lotIDs": [
                "16000620",  # ledge N/NE and above Prison Town Church
                "16000500",  # platform N/NE and above Prison Town Church
                "16000020",  # fireplace NW of Volcano Manor
                "16000700",  # room N of Prison Town Church
                "16000100",  # ledge E of Prison Town Church
            ],
            "ownerGroups": [
                "GROUP_FIRE",
                "GROUP_RECUSANT",
            ],
            "hintRegion": "Volcano Manor",
        }
    },
    # special case where having the coupledwarp option on makes it a corridor
    # but off makes it a node
    "snowfield_prehiddenpath|snowfield_rold": {
        "using the Haligtree secret medallions at Hidden Path to the "
        "Haligtree": {
            "hintName": "hidden lift",
            "lotIDs": [
                "30200000",  # room E/NE of Hidden Path to the Haligtree
                "30200050",  # stair SE of Hidden Path to the Haligtree
                "30200900",  # hidden chest SW of Hidden Path to the Haligtree
                "30200010",  # room E of Hidden Path to the Haligtree
                "30200020",  # balcony SE of Hidden Path to the Haligtree
                "30200030",  # SE of Hidden Path to the Haligtree
                "30200040",  # SE of Hidden Path to the Haligtree
                "30200060",  # near elevator S of Hidden Path to the Haligtree
            ],
            "hintRegion": "the Consecrated Snowfield",
        }
    }
}
