# Copyright (c) 2023 The Old Man and the C
#
# This file is part of Elden Ring Randomizer Hints.
#
# Elden Ring Randomizer Hints is free software: you can redistribute it and/or
# modify it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Elden Ring Randomizer Hints is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
# or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License
# for more details.
#
# You should have received a copy of the GNU Affero General Public License along
# with Elden Ring Randomizer Hints. If not, see <https://www.gnu.org/licenses/>.

defaultCategories = {
    "Lord": {
        "Celestial Dew": {},
        "Godrick's Great Rune": {},
        "Great Rune of the Unborn": {},
        "Larval Tear": {},
        "Malenia's Great Rune": {},
        "Memory Stone": {},
        "Mohg's Great Rune": {},
        "Morgott's Great Rune": {},
        "Radahn's Great Rune": {},
        "Rold Medallion": {},
        "Rune Arc": {'drop': True},
        "Rykard's Great Rune": {},
        "Talisman Pouch": {},
    },
    "Exploring": {
        "Academy Glintstone Key": {},
        "Carian Inverted Statue": {},
        "Dark Moon Ring": {},
        "Dectus Medallion (Left)": {},
        "Dectus Medallion (Right)": {},
        "Discarded Palace Key": {},
        "Drawing-Room Key": {},
        "Haligtree Secret Medallion (Left)": {},
        "Haligtree Secret Medallion (Right)": {},
        "Imbued Sword Key": {},
        "Pureblood Knight's Medal": {},
        "Rold Medallion": {},
        "Rusty Key": {},
        "Sellian Sealbreaker": {},
        "Spirit Jellyfish Ashes": {},
        "Starlight": {},
        "Stonesword Key": {},
        "Torch": {},
        "Beast-Repellent Torch": {},
        "Steel-Wire Torch": {},
        "Sentry's Torch": {},
        "Ghostflame Torch": {},
        "St. Trina's Torch": {},
        "Telescope": {},
    },
    "Smithing": {
        "Ancient Dragon Smithing Stone": {},
        "Black Whetblade": {},
        "Glintstone Whetblade": {},
        "Iron Whetblade": {},
        "Red-Hot Whetblade": {},
        "Sanctified Whetblade": {},
        "Smithing Stone [1]": {'drop': True},
        "Smithing Stone [2]": {'drop': True},
        "Smithing Stone [3]": {'drop': True},
        "Smithing Stone [4]": {'drop': True},
        "Smithing Stone [5]": {'drop': True},
        "Smithing Stone [6]": {'drop': True},
        "Smithing Stone [7]": {'drop': True},
        "Smithing Stone [8]": {'drop': True},
        "Smithing-Stone Miner's Bell Bearing [1]": {},
        "Smithing-Stone Miner's Bell Bearing [2]": {},
        "Smithing-Stone Miner's Bell Bearing [3]": {},
        "Smithing-Stone Miner's Bell Bearing [4]": {},
        "Somber Ancient Dragon Smithing Stone": {},
        "Somber Smithing Stone [1]": {'drop': True},
        "Somber Smithing Stone [2]": {'drop': True},
        "Somber Smithing Stone [3]": {'drop': True},
        "Somber Smithing Stone [4]": {'drop': True},
        "Somber Smithing Stone [5]": {'drop': True},
        "Somber Smithing Stone [6]": {'drop': True},
        "Somber Smithing Stone [7]": {'drop': True},
        "Somber Smithing Stone [8]": {'drop': True},
        "Somber Smithing Stone [9]": {'drop': True},
        "Somberstone Miner's Bell Bearing [1]": {},
        "Somberstone Miner's Bell Bearing [2]": {},
        "Somberstone Miner's Bell Bearing [3]": {},
        "Somberstone Miner's Bell Bearing [4]": {},
        "Somberstone Miner's Bell Bearing [5]": {},
    },
    "Spirits": {
        "Albinauric Ashes": {},
        "Ancestral Follower Ashes": {},
        "Ancient Dragon Knight Kristoff": {},
        "Archer Ashes": {},
        "Avionette Soldier Ashes": {},
        "Azula Beastman Ashes": {},
        "Banished Knight Engvall": {},
        "Banished Knight Oleg": {},
        "Battlemage Hugues": {},
        "Beast Blood": {'drop': True},
        "Black Knife Tiche": {},
        "Blackflame Monk Amon": {},
        "Bloodhound Knight Floh": {},
        "Bloodrose": {'drop': True},
        "Clayman Ashes": {},
        "Cleanrot Knight Finlay": {},
        "Crystalian Ashes": {},
        "Demi-Human Ashes": {},
        "Depraved Perfumer Carmaan": {},
        "Dolores the Sleeping Arrow Puppet": {},
        "Duelist Greaves": {},
        "Duelist Helm": {},
        "Dung Eater Puppet": {},
        "Fanged Imp Ashes": {},
        "Finger Maiden Therolina Puppet": {},
        "Fire Monk Ashes": {},
        "Ghost Glovewort [1]": {'drop': True},
        "Ghost Glovewort [2]": {'drop': True},
        "Ghost Glovewort [3]": {'drop': True},
        "Ghost Glovewort [4]": {'drop': True},
        "Ghost Glovewort [5]": {'drop': True},
        "Ghost Glovewort [6]": {'drop': True},
        "Ghost Glovewort [7]": {'drop': True},
        "Ghost Glovewort [8]": {'drop': True},
        "Ghost Glovewort [9]": {'drop': True},
        "Ghost-Glovewort Picker's Bell Bearing [1]": {},
        "Ghost-Glovewort Picker's Bell Bearing [2]": {},
        "Ghost-Glovewort Picker's Bell Bearing [3]": {},
        "Giant Rat Ashes": {},
        "Glintstone Sorcerer Ashes": {},
        "Glovewort Picker's Bell Bearing [1]": {},
        "Glovewort Picker's Bell Bearing [2]": {},
        "Glovewort Picker's Bell Bearing [3]": {},
        "Godrick Soldier Ashes": {},
        "Grave Glovewort [1]": {'drop': True},
        "Grave Glovewort [2]": {'drop': True},
        "Grave Glovewort [3]": {'drop': True},
        "Grave Glovewort [4]": {'drop': True},
        "Grave Glovewort [5]": {'drop': True},
        "Grave Glovewort [6]": {'drop': True},
        "Grave Glovewort [7]": {'drop': True},
        "Grave Glovewort [8]": {'drop': True},
        "Grave Glovewort [9]": {'drop': True},
        "Gravekeeper Cloak": {},
        "Great Ghost Glovewort": {},
        "Great Grave Glovewort": {},
        "Greatshield Soldier Ashes": {},
        "Haligtree Soldier Ashes": {},
        "Jarwight Puppet": {},
        "Kaiden Sellsword Ashes": {},
        "Kindred of Rot Ashes": {},
        "Land Squirt Ashes": {},
        "Latenna the Albinauric": {},
        "Leyndell Soldier Ashes": {},
        "Lhutel the Headless": {},
        "Lone Wolf Ashes": {},
        "Mad Pumpkin Head Ashes": {},
        "Man-Serpent Ashes": {},
        "Marionette Soldier Ashes": {},
        "Mausoleum Soldier Ashes": {},
        "Mimic Tear Ashes": {},
        "Miranda Sprout Ashes": {},
        "Mushroom": {'drop': True},
        "Nepheli Loux Puppet": {},
        "Nightmaiden & Swordstress Puppets": {},
        "Noble Sorcerer Ashes": {},
        "Nomad Ashes": {},
        "Nomadic Warrior's Cookbook [12]": {},
        "Omenkiller Rollo": {},
        "Oracle Envoy Ashes": {},
        "Page Ashes": {},
        "Perfumer Tricia": {},
        "Putrid Corpse Ashes": {},
        "Radahn Soldier Ashes": {},
        "Raya Lucaria Soldier Ashes": {},
        "Redmane Knight Ogha": {},
        "Rotten Duelist Greaves": {},
        "Rotten Duelist Helm": {},
        "Rotten Gravekeeper Cloak": {},
        "Rotten Stray Ashes": {},
        "Shabriri's Woe": {},
        "Skeletal Bandit Ashes": {},
        "Skeletal Militiaman Ashes": {},
        "Soldjars of Fortune Ashes": {},
        "Spirit Jellyfish Ashes": {},
        "Stormhawk Deenh": {},
        "Tibia's Summons": {},
        "Twinsage Sorcerer Ashes": {},
        "Vulgar Militia Ashes": {},
        "Wandering Noble Ashes": {},
        "Warhawk Ashes": {},
        "Winged Misbegotten Ashes": {},
    },
    "Recovery": {
        "Ancestral Spirit's Horn": {},
        "Armorer's Cookbook [2]": {},
        "Armorer's Cookbook [6]": {},
        "Ash of War: Blood Tax": {},
        "Ash of War: Holy Ground": {},
        "Ash of War: Lifesteal Fist": {},
        "Ash of War: Prayerful Strike": {},
        "Ash-of-War Scarab": {},
        "Assassin's Cerulean Dagger": {},
        "Assassin's Crimson Dagger": {},
        "Bestial Constitution": {},
        "Bestial Vitality": {},
        "Blasphemous Blade": {},
        "Blessed Dew Talisman": {},
        "Blessing of the Erdtree": {},
        "Blessing's Boon": {},
        "Carian Filigreed Crest": {},
        "Cave Moss": {'drop': True},
        "Cerulean Crystal Tear": {},
        "Cerulean Hidden Tear": {},
        "Cerulean Seed Talisman": {},
        "Cerulean Tear Scarab": {},
        "Crab Eggs": {'drop': True},
        "Crimson Bubbletear": {},
        "Crimson Crystal Tear": {},
        "Crimson Seed Talisman": {},
        "Crimson Tear Scarab": {},
        "Crimsonburst Crystal Tear": {},
        "Crimsonwhorl Bubbletear": {},
        "Crystal Cave Moss": {'drop': True},
        "Cure Poison": {},
        "Deathbed Dress": {},
        "Dewkissed Herba": {'drop': True},
        "Erdleaf Flower": {'drop': True},
        "Erdtree Heal": {},
        "Eye of Yelough": {'drop': True},
        "Flame, Cleanse Me": {},
        "Frenzied's Cookbook [1]": {},
        "Frenzied's Cookbook [2]": {},
        "Glintstone Scarab": {},
        "Godskin Swaddling Cloth": {},
        "Golden Centipede": {'drop': True},
        "Golden Seed": {},
        "Great Dragonfly Head": {'drop': True},
        "Great Heal": {},
        "Great Stars": {},
        "Great Turtle Shell": {},
        "Greathorn Hammer": {},
        "Green Turtle Talisman": {},
        "Greenburst Crystal Tear": {},
        "Guardian Garb (Full Bloom)": {},
        "Heal": {},
        "Herba": {'drop': True},
        "Icon Shield": {},
        "Incantation Scarab": {},
        "Land Octopus Ovary": {'drop': True},
        "Law of Regression": {},
        "Lord's Aid": {},
        "Lord's Heal": {},
        "Lucidity": {},
        "Melted Mushroom": {'drop': True},
        "Missionary's Cookbook [7]": {},
        "Nomadic Warrior's Cookbook [16]": {},
        "Nomadic Warrior's Cookbook [17]": {},
        "Nomadic Warrior's Cookbook [19]": {},
        "Nomadic Warrior's Cookbook [23]": {},
        "Nomadic Warrior's Cookbook [3]": {},
        "Nomadic Warrior's Cookbook [7]": {},
        "Old Lord's Talisman": {},
        "Order Healing": {},
        "Purifying Crystal Tear": {},
        "Raw Meat Dumpling": {},
        "Rimed Rowa": {'drop': True},
        "Rowa Fruit": {'drop': True},
        "Royal Remains Armor": {},
        "Royal Remains Gauntlets": {},
        "Royal Remains Greaves": {},
        "Royal Remains Helm": {},
        "Sacramental Bud": {'drop': True},
        "Sacred Butchering Knife": {},
        "Sacred Tear": {},
        "Sacrificial Axe": {},
        "Sanctuary Stone": {'drop': True},
        "Serpent-God's Curved Sword": {},
        "Slumbering Egg": {'drop': True},
        "Smoldering Butterfly": {'drop': True},
        "Speckled Hardtear": {},
        "Sword of Milos": {},
        "Taker's Cameo": {},
        "Turtle Neck Meat": {'drop': True},
        "Urgent Heal": {},
        "Yellow Ember": {'drop': True},
    },
    "Offense": {
        "Aeonian Butterfly": {'drop': True},
        "Albinauric Bloodclot": {'drop': True},
        "Altus Bloom": {'drop': True},
        "Ancient Dragon Apostle's Cookbook [1]": {},
        "Ancient Dragon Apostle's Cookbook [3]": {},
        "Ant's Skull Plate": {},
        "Armorer's Cookbook [1]": {},
        "Armorer's Cookbook [3]": {},
        "Arteria Leaf": {'drop': True},
        "Ash of War: Barbaric Roar": {},
        "Ash of War: Chilling Mist": {},
        "Ash of War: Cragblade": {},
        "Ash of War: Determination": {},
        "Ash of War: Flaming Strike": {},
        "Ash of War: Golden Vow": {},
        "Ash of War: Lightning Slash": {},
        "Ash of War: Poisonous Mist": {},
        "Ash of War: Royal Knight's Resolve": {},
        "Ash of War: Sacred Blade": {},
        "Ash of War: Sacred Order": {},
        "Ash of War: Seppuku": {},
        "Ash of War: Shared Order": {},
        "Ash of War: War Cry": {},
        "Axe Talisman": {},
        "Beast Blood": {'drop': True},
        "Black Flame Blade": {},
        "Bloodflame Blade": {},
        "Bloodrose": {'drop': True},
        "Blue Dancer Charm": {},
        "Briar Armor": {},
        "Briar Gauntlets": {},
        "Briar Greaves": {},
        "Briar Helm": {},
        "Budding Cave Moss": {'drop': True},
        "Cipher Pata": {},
        "Claw Talisman": {},
        "Coded Sword": {},
        "Coil Shield": {},
        "Cracked Crystal": {'drop': True},
        "Crystal Bud": {'drop': True},
        "Curved Sword Talisman": {},
        "Dagger Talisman": {},
        "Electrify Armament": {},
        "Explosive Stone": {'drop': True},
        "Explosive Stone Clump": {'drop': True},
        "Fan Daggers": {'drop': True},
        "Fevor's Cookbook [2]": {},
        "Fevor's Cookbook [3]": {},
        "Fire Scorpion Charm": {},
        "Flame-Shrouding Cracked Tear": {},
        "Flame, Grant Me Strength": {},
        "Fulgurbloom": {'drop': True},
        "Glintstone Craftsman's Cookbook [2]": {},
        "Glintstone Craftsman's Cookbook [3]": {},
        "Glintstone Craftsman's Cookbook [5]": {},
        "Glintstone Craftsman's Cookbook [6]": {},
        "Godfrey Icon": {},
        "Golden Epitaph": {},
        "Golden Order Greatsword": {},
        "Golden Sunflower": {'drop': True},
        "Golden Vow": {},
        "Gravel Stone": {'drop': True},
        "Gravity Stone Chunk": {'drop': True},
        "Gravity Stone Fan": {'drop': True},
        "Greyoll's Roar": {},
        "Hammer Talisman": {},
        "Hefty Beast Bone": {'drop': True},
        "Holy-Shrouding Cracked Tear": {},
        "Kindred of Rot's Exultation": {},
        "Kukri": {'drop': True},
        "Land Octopus Ovary": {'drop': True},
        "Lightning Scorpion Charm": {},
        "Lightning-Shrouding Cracked Tear": {},
        "Lord of Blood's Exultation": {},
        "Lump of Flesh": {'drop': True},
        "Magic Scorpion Charm": {},
        "Magic-Shrouding Cracked Tear": {},
        "Margit's Shackle": {},
        "Millicent's Prosthesis": {},
        "Miquella's Lily": {'drop': True},
        "Missionary's Cookbook [4]": {},
        "Mohg's Shackle": {},
        "Mushroom": {'drop': True},
        "Mushroom Crown": {},
        "Nomadic Warrior's Cookbook [11]": {},
        "Nomadic Warrior's Cookbook [14]": {},
        "Nomadic Warrior's Cookbook [22]": {},
        "Nomadic Warrior's Cookbook [6]": {},
        "Nomadic Warrior's Cookbook [8]": {},
        "Perfumer's Cookbook [1]": {},
        "Perfumer's Cookbook [2]": {},
        "Poison Armament": {},
        "Poisonbloom": {'drop': True},
        "Poisoned Stone": {'drop': True},
        "Poisoned Stone Clump": {'drop': True},
        "Raptor's Black Feathers": {},
        "Red-Feathered Branchsword": {},
        "Rimed Crystal Bud": {'drop': True},
        "Ritual Sword Talisman": {},
        "Root Resin": {'drop': True},
        "Rotten Winged Sword Insignia": {},
        "Rowa Fruit": {'drop': True},
        "Ruptured Crystal Tear": {},
        "Sacramental Bud": {'drop': True},
        "Shard of Alexander": {},
        "Shield of the Guilty": {},
        "Silver Tear Husk": {'drop': True},
        "Smoldering Butterfly": {'drop': True},
        "Spiked Cracked Tear": {},
        "Stonebarb Cracked Tear": {},
        "String": {'drop': True},
        "Thin Beast Bones": {'drop': True},
        "Thorny Cracked Tear": {},
        "Throwing Dagger": {'drop': True},
        "Trina's Lily": {'drop': True},
        "Twinblade Talisman": {},
        "Vyke's Dragonbolt": {},
        "Warrior Jar Shard": {},
        "White Mask": {},
        "Winged Sword Insignia": {},
    },
    "Defense": {
        "Altus Bloom": {'drop': True},
        "Ancient Dragon Apostle's Cookbook [4]": {},
        "Ant's Skull Plate": {},
        "Armorer's Cookbook [1]": {},
        "Armorer's Cookbook [5]": {},
        "Arteria Leaf": {'drop': True},
        "Ash of War: Barricade Shield": {},
        "Ash of War: Carian Retaliation": {},
        "Ash of War: Endure": {},
        "Ash of War: Golden Parry": {},
        "Ash of War: Golden Vow": {},
        "Ash of War: Holy Ground": {},
        "Ash of War: Parry": {},
        "Ash of War: Storm Wall": {},
        "Ash of War: Thops's Barrier": {},
        "Ash of War: Vow of the Indomitable": {},
        "Banished Knight Armor": {},
        "Banished Knight Armor (Altered)": {},
        "Banished Knight Gauntlets": {},
        "Banished Knight Greaves": {},
        "Banished Knight Helm": {},
        "Banished Knight Helm (Altered)": {},
        "Beast Liver": {'drop': True},
        "Black Flame's Protection": {},
        "Blue-Feathered Branchsword": {},
        "Boiled Crab": {'drop': True},
        "Boiled Prawn": {'drop': True},
        "Boltdrake Talisman": {},
        "Boltdrake Talisman +1": {},
        "Boltdrake Talisman +2": {},
        "Budding Cave Moss": {'drop': True},
        "Budding Horn": {'drop': True},
        "Bull-Goat Armor": {},
        "Bull-Goat Gauntlets": {},
        "Bull-Goat Greaves": {},
        "Bull-Goat Helm": {},
        "Bull-Goat's Talisman": {},
        "Carian Retaliation": {},
        "Clarifying Horn Charm": {},
        "Clarifying Horn Charm +1": {},
        "Cleanrot Spear": {},
        "Coil Shield": {},
        "Crab Eggs": {'drop': True},
        "Crimson Amber Medallion": {},
        "Crimson Amber Medallion +1": {},
        "Crimson Amber Medallion +2": {},
        "Crimsonspill Crystal Tear": {},
        "Crucible Feather Talisman": {},
        "Crucible Knot Talisman": {},
        "Crucible Scale Talisman": {},
        "Crystal Bud": {'drop': True},
        "Divine Fortification": {},
        "Dragonbolt Blessing": {},
        "Dragoncrest Greatshield Talisman": {},
        "Dragoncrest Shield Talisman": {},
        "Dragoncrest Shield Talisman +1": {},
        "Dragoncrest Shield Talisman +2": {},
        "Eclipse Crest Greatshield": {},
        "Erdtree's Favor": {},
        "Erdtree's Favor +1": {},
        "Erdtree's Favor +2": {},
        "Eternal Darkness": {},
        "Eye of Yelough": {'drop': True},
        "Flame Fortification": {},
        "Flame, Protect Me": {},
        "Flamedrake Talisman": {},
        "Flamedrake Talisman +1": {},
        "Flamedrake Talisman +2": {},
        "Formic Rock": {'drop': True},
        "Fulgurbloom": {'drop': True},
        "Glintstone Craftsman's Cookbook [4]": {},
        "Glintstone Firefly": {'drop': True},
        "Golden Lightning Fortification": {},
        "Golden Sunflower": {'drop': True},
        "Golden Tailoring Tools": {},
        "Golden Vow": {},
        "Great Dragonfly Head": {'drop': True},
        "Greatshield Talisman": {},
        "Haligdrake Talisman": {},
        "Haligdrake Talisman +1": {},
        "Haligdrake Talisman +2": {},
        "Ice Crest Shield": {},
        "Immunizing Horn Charm": {},
        "Immunizing Horn Charm +1": {},
        "Immutable Shield": {},
        "Land Octopus Ovary": {'drop': True},
        "Leaden Hardtear": {},
        "Lightning Fortification": {},
        "Living Jar Shard": {'drop': True},
        "Lord's Divine Fortification": {},
        "Magic Fortification": {},
        "Miranda Powder": {'drop': True},
        "Missionary's Cookbook [6]": {},
        "Mottled Necklace": {},
        "Mottled Necklace +1": {},
        "Mushroom Arms": {},
        "Mushroom Body": {},
        "Mushroom Crown": {},
        "Mushroom Head": {},
        "Mushroom Legs": {},
        "Nascent Butterfly": {'drop': True},
        "Nomadic Warrior's Cookbook [11]": {},
        "Nomadic Warrior's Cookbook [18]": {},
        "Nomadic Warrior's Cookbook [2]": {},
        "Nomadic Warrior's Cookbook [23]": {},
        "Opaline Bubbletear": {},
        "Opaline Hardtear": {},
        "Pearldrake Talisman": {},
        "Pearldrake Talisman +1": {},
        "Pearldrake Talisman +2": {},
        "Perfumer's Cookbook [1]": {},
        "Perfumer's Cookbook [3]": {},
        "Perfumer's Cookbook [4]": {},
        "Perfumer's Shield": {},
        "Pest's Glaive": {},
        "Pillory Shield": {},
        "Prince of Death's Cyst": {},
        "Prince of Death's Pustule": {},
        "Protection of the Erdtree": {},
        "Pumpkin Helm": {},
        "Rift Shield": {},
        "Rimed Rowa": {'drop': True},
        "Ritual Shield Talisman": {},
        "Root Resin": {'drop': True},
        "Rowa Fruit": {'drop': True},
        "Scholar's Shield": {},
        "Shield of the Guilty": {},
        "Silver Tear Husk": {'drop': True},
        "Sliver of Meat": {'drop': True},
        "Slumbering Egg": {'drop': True},
        "Smoldering Butterfly": {'drop': True},
        "Smoldering Shield": {},
        "Speckled Hardtear": {},
        "Spelldrake Talisman": {},
        "Spelldrake Talisman +1": {},
        "Spelldrake Talisman +2": {},
        "Spiralhorn Shield": {},
        "Stalwart Horn Charm": {},
        "Stalwart Horn Charm +1": {},
        "Strip of White Flesh": {'drop': True},
        "Tailoring Tools": {},
        "Thin Beast Bones": {'drop': True},
        "Thops's Barrier": {},
        "Twinbird Kite Shield": {},
        "Vyke's Dragonbolt": {},
        "Windy Crystal Tear": {},
    },
    "Stats": {
        "Arsenal Charm": {},
        "Arsenal Charm +1": {},
        "Cerulean Amber Medallion": {},
        "Cerulean Amber Medallion +1": {},
        "Cerulean Amber Medallion +2": {},
        "Commoner's Garb": {},
        "Commoner's Simple Garb": {},
        "Consort's Mask": {},
        "Crimson Hood": {},
        "Dexterity-knot Crystal Tear": {},
        "Erdtree's Favor": {},
        "Erdtree's Favor +1": {},
        "Erdtree's Favor +2": {},
        "Great-Jar's Arsenal": {},
        "Greathood": {},
        "Greenspill Crystal Tear": {},
        "Haima Glintstone Crown": {},
        "Haligtree Helm": {},
        "Haligtree Knight Helm": {},
        "Hierodas Glintstone Crown": {},
        "Imp Head (Cat)": {},
        "Imp Head (Corpse)": {},
        "Imp Head (Elder)": {},
        "Imp Head (Fanged)": {},
        "Imp Head (Long-Tongued)": {},
        "Imp Head (Wolf)": {},
        "Intelligence-knot Crystal Tear": {},
        "Karolos Glintstone Crown": {},
        "Lazuli Glintstone Crown": {},
        "Marais Mask": {},
        "Mask of Confidence": {},
        "Millicent's Prosthesis": {},
        "Navy Hood": {},
        "Okina Mask": {},
        "Olivinus Glintstone Crown": {},
        "Omensmirk Mask": {},
        "Preceptor's Big Hat": {},
        "Prosthesis-Wearer Heirloom": {},
        "Queen's Crescent Crown": {},
        "Radagon's Scarseal": {},
        "Radagon's Soreseal": {},
        "Ruler's Mask": {},
        "Sacred Crown Helm": {},
        "Silver Tear Mask": {},
        "Starscourge Heirloom": {},
        "Strength-knot Crystal Tear": {},
        "Twinsage Glintstone Crown": {},
        "Viridian Amber Medallion": {},
        "Viridian Amber Medallion +1": {},
        "Viridian Amber Medallion +2": {},
        "Vyke's Dragonbolt": {},
        "Winged Crystal Tear": {},
        "Witch's Glintstone Crown": {},
    },
    "Stealth": {
        "Albinauric Bloodclot": {'drop': True},
        "Ash of War: Assassin's Gambit": {},
        "Ash of War: White Shadow's Lure": {},
        "Assassin's Approach": {},
        "Beast Blood": {'drop': True},
        "Beast-Repellent Torch": {},
        "Black Knife Armor": {},
        "Concealing Veil": {},
        "Cracked Crystal": {'drop': True},
        "Crepus's Vial": {},
        "Dagger Talisman": {},
        "Darkness": {},
        "Fevor's Cookbook [3]": {},
        "Freezing Mist": {},
        "Hefty Beast Bone": {'drop': True},
        "Human Bone Shard": {'drop': True},
        "Longtail Cat Talisman": {},
        "Miquella's Lily": {'drop': True},
        "Nomadic Warrior's Cookbook [11]": {},
        "Nomadic Warrior's Cookbook [21]": {},
        "Nomadic Warrior's Cookbook [5]": {},
        "Nomadic Warrior's Cookbook [7]": {},
        "Old Lord's Talisman": {},
        "Rowa Fruit": {'drop': True},
        "Sacramental Bud": {'drop': True},
        "Sentry's Torch": {},
        "Shadow Bait": {},
        "Smoldering Butterfly": {'drop': True},
        "Staff of Loss": {},
        "Telescope": {},
        "Thin Beast Bones": {'drop': True},
        "Unseen Form": {},
    },
    "Greed": {
        "Albinauric Mask": {},
        "Celebrant's Cleaver": {},
        "Celebrant's Rib-Rake": {},
        "Celebrant's Sickle": {},
        "Celebrant's Skull": {},
        "Dragon Heart": {},
        "Four-Toed Fowl Foot": {'drop': True},
        "Gold Firefly": {'drop': True},
        "Gold Scarab": {},
        "Gold-Pickled Fowl Foot": {},
        "Imp Head (Elder)": {},
        "Marais Mask": {},
        "Marika's Scarseal": {},
        "Marika's Soreseal": {},
        "Mask of Confidence": {},
        "Missionary's Cookbook [2]": {},
        "Missionary's Cookbook [3]": {},
        "Rowa Fruit": {'drop': True},
        "Sacrificial Twig": {},
        "Silver Firefly": {'drop': True},
        "Silver Scarab": {},
        "Silver Tear Mask": {},
        "Silver-Pickled Fowl Foot": {},
        "Twiggy Cracked Tear": {},
        "Witch's Glintstone Crown": {},
    },
    "Blood": {
        "Alberich's Bracers": {},
        "Alberich's Pointed Hat": {},
        "Alberich's Robe": {},
        "Alberich's Trousers": {},
        "Albinauric Staff": {},
        "Ash of War: Blood Blade": {},
        "Ash of War: Bloody Slash": {},
        "Ash of War: Seppuku": {},
        "Black Whetblade": {},
        "Blood-Tainted Excrement": {'drop': True},
        "Bloodboon": {},
        "Bloodflame Blade": {},
        "Bloodflame Talons": {},
        "Bloodhound Claws": {},
        "Bloodhound's Fang": {},
        "Bloodrose": {'drop': True},
        "Bloodstained Dagger": {},
        "Bloody Helice": {},
        "Briar Greatshield": {},
        "Briars of Punishment": {},
        "Briars of Sin": {},
        "Chainlink Flail": {},
        "Cross-Naginata": {},
        "Eleonora's Poleblade": {},
        "Fire Scorpion Charm": {},
        "Flail": {},
        "Flamberge": {},
        "Flight Pinion": {'drop': True},
        "Forked Greatsword": {},
        "Forked Hatchet": {},
        "Ghiza's Wheel": {},
        "Grave Scythe": {},
        "Great Knife": {},
        "Great Omenkiller Cleaver": {},
        "Great Stars": {},
        "Halo Scythe": {},
        "Hand of Malenia": {},
        "Hookclaws": {},
        "Hoslow's Petal Whip": {},
        "Inquisitor's Girandole": {},
        "Lord of Blood's Exultation": {},
        "Marred Leather Shield": {},
        "Marred Wooden Shield": {},
        "Meteoric Ore Blade": {},
        "Mohgwyn's Sacred Spear": {},
        "Moonveil": {},
        "Morgott's Cursed Sword": {},
        "Morning Star": {},
        "Mushroom": {'drop': True},
        "Nightrider Flail": {},
        "Nomadic Warrior's Cookbook [24]": {},
        "Nomadic Warrior's Cookbook [6]": {},
        "Radagon Icon": {},
        "Raptor Talons": {},
        "Reduvia": {},
        "Rivers of Blood": {},
        "Root Resin": {'drop': True},
        "Scavenger's Curved Sword": {},
        "Scythe": {},
        "Shield of the Guilty": {},
        "Spiked Caestus": {},
        "Spiked Club": {},
        "Spiked Palisade Shield": {},
        "Spiked Spear": {},
        "Spiralhorn Shield": {},
        "Staff of the Guilty": {},
        "Star Fist": {},
        "String": {'drop': True},
        "Swarm of Flies": {},
        "Sword of Milos": {},
        "Thin Beast Bones": {'drop': True},
        "Thorned Whip": {},
        "Uchigatana": {},
        "Varré's Bouquet": {},
        "Vulgar Militia Saw": {},
        "Wakizashi": {},
        "White Mask": {},
        "Winged Scythe": {},
    },
    "Death": {
        "Ancient Death Rancor": {},
        "Explosive Ghostflame": {},
        "Prince of Death's Staff": {},
        "Rancorcall": {},
        "Tibia's Summons": {},
    },
    "Frenzy": {
        "Black Dumpling": {},
        "Cerulean Hidden Tear": {},
        "Fingerprint Stone Shield": {},
        "Fire Scorpion Charm": {},
        "Frenzied Burst": {},
        "Frenzied Flame Seal": {},
        "Frenzied's Cookbook [2]": {},
        "Godfrey Icon": {},
        "Howl of Shabriri": {},
        "Inescapable Frenzy": {},
        "Miquella's Needle": {},
        "Radagon Icon": {},
        "Sanctuary Stone": {'drop': True},
        "The Flame of Frenzy": {},
        "Unendurable Frenzy": {},
        "Vyke's War Spear": {},
        "Yellow Ember": {'drop': True},
    },
    "Frost": {
        "Adula's Moonblade": {},
        "Ash of War: Chilling Mist": {},
        "Ash of War: Hoarfrost Stomp": {},
        "Ash of War: Ice Spear": {},
        "Borealis's Mist": {},
        "Carian Glintstone Staff": {},
        "Carian Regal Scepter": {},
        "Dark Moon Greatsword": {},
        "Death's Poker": {},
        "Dragonice": {},
        "Flight Pinion": {'drop': True},
        "Freezing Mist": {},
        "Frozen Armament": {},
        "Frozen Lightning Spear": {},
        "Frozen Needle": {},
        "Ghostflame Torch": {},
        "Glintstone Craftsman's Cookbook [2]": {},
        "Glintstone Craftsman's Cookbook [6]": {},
        "Glintstone Craftsman's Cookbook [7]": {},
        "Glintstone Icecrag": {},
        "Glintstone Whetblade": {},
        "Icerind Hatchet": {},
        "Radagon Icon": {},
        "Ranni's Dark Moon": {},
        "Rimed Crystal Bud": {'drop': True},
        "Root Resin": {'drop': True},
        "Snow Witch Hat": {},
        "Thin Beast Bones": {'drop': True},
        "Zamor Curved Sword": {},
        "Zamor Ice Storm": {},
    },
    "Poison": {
        "Altus Bloom": {'drop': True},
        "Ant's Skull Plate": {},
        "Ash of War: Poison Moth Flight": {},
        "Ash of War: Poisonous Mist": {},
        "Black Whetblade": {},
        "Coil Shield": {},
        "Flight Pinion": {'drop': True},
        "Gold-Tinged Excrement": {'drop': True},
        "Kindred of Rot's Exultation": {},
        "Miranda Powder": {'drop': True},
        "Mushroom": {'drop': True},
        "Mushroom Crown": {},
        "Nomadic Warrior's Cookbook [14]": {},
        "Nomadic Warrior's Cookbook [3]": {},
        "Nomadic Warrior's Cookbook [4]": {},
        "Nomadic Warrior's Cookbook [8]": {},
        "Perfumer's Cookbook [2]": {},
        "Poison Armament": {},
        "Poison Mist": {},
        "Poisonbloom": {'drop': True},
        "Radagon Icon": {},
        "Root Resin": {'drop': True},
        "Serpent Bow": {},
        "Serpentbone Blade": {},
        "String": {'drop': True},
        "Thin Beast Bones": {'drop': True},
        "Toxic Mushroom": {'drop': True},
        "Venomous Fang": {},
    },
    "Rot": {
        "Aeonian Butterfly": {'drop': True},
        "Antspur Rapier": {},
        "Ekzykes's Decay": {},
        "Faded Erdleaf Flower": {'drop': True},
        "Flight Pinion": {'drop': True},
        "Kindred of Rot's Exultation": {},
        "Mushroom Crown": {},
        "Nomadic Warrior's Cookbook [15]": {},
        "Nomadic Warrior's Cookbook [22]": {},
        "Radagon Icon": {},
        "Root Resin": {'drop': True},
        "Rotten Battle Hammer": {},
        "Rotten Breath": {},
        "Rotten Crystal Spear": {},
        "Rotten Crystal Staff": {},
        "Rotten Crystal Sword": {},
        "Rotten Greataxe": {},
        "Rotten Staff": {},
        "Scarlet Aeonia": {},
        "Scorpion's Stinger": {},
        "String": {'drop': True},
        "Thin Beast Bones": {'drop': True},
        "Toxic Mushroom": {'drop': True},
    },
    "Sleep": {
        "Fevor's Cookbook [1]": {},
        "Fevor's Cookbook [2]": {},
        "Flight Pinion": {'drop': True},
        "Mushroom": {'drop': True},
        "Radagon Icon": {},
        "Root Resin": {'drop': True},
        "St. Trina's Torch": {},
        "String": {'drop': True},
        "Sword of St. Trina": {},
        "Thin Beast Bones": {'drop': True},
        "Trina's Lily": {'drop': True},
    },
    "Fire": {
        "Agheel's Flame": {},
        "Altus Bloom": {'drop': True},
        "Armorer's Cookbook [1]": {},
        "Armorer's Cookbook [2]": {},
        "Armorer's Cookbook [4]": {},
        "Armorer's Cookbook [7]": {},
        "Ash of War: Black Flame Tornado": {},
        "Ash of War: Eruption": {},
        "Ash of War: Flame of the Redmanes": {},
        "Ash of War: Flaming Strike": {},
        "Ash of War: Prelate's Charge": {},
        "Aspects of the Crucible: Breath": {},
        "Beast-Repellent Torch": {},
        "Black Flame": {},
        "Black Flame Blade": {},
        "Black Flame Ritual": {},
        "Blasphemous Blade": {},
        "Bloodboon": {},
        "Bloodflame Blade": {},
        "Bloodflame Talons": {},
        "Burn, O Flame!": {},
        "Catch Flame": {},
        "Cerulean Hidden Tear": {},
        "Cranial Vessel Candlestand": {},
        "Devourer's Scepter": {},
        "Dragon Communion Seal": {},
        "Dragonfire": {},
        "Eleonora's Poleblade": {},
        "Explosive Stone": {'drop': True},
        "Explosive Stone Clump": {'drop': True},
        "Fire Arrow": {'drop': True},
        "Fire Blossom": {'drop': True},
        "Fire Scorpion Charm": {},
        "Fire's Deadly Sin": {},
        "Flame, Fall Upon Them": {},
        "Flame of the Fell God": {},
        "Flame Sling": {},
        "Flame-Shrouding Cracked Tear": {},
        "Flight Pinion": {'drop': True},
        "Frenzied Burst": {},
        "Gelmir Glintstone Staff": {},
        "Gelmir's Fury": {},
        "Giant's Red Braid": {},
        "Giant's Seal": {},
        "Giantsflame Take Thee": {},
        "Glintstone Whetblade": {},
        "Godfrey Icon": {},
        "Godslayer's Greatsword": {},
        "Godslayer's Seal": {},
        "Grafted Dragon": {},
        "Howl of Shabriri": {},
        "Inescapable Frenzy": {},
        "Inquisitor's Girandole": {},
        "Magma Blade": {},
        "Magma Breath": {},
        "Magma Shot": {},
        "Magma Whip Candlestick": {},
        "Magma Wyrm's Scalesword": {},
        "Melted Mushroom": {'drop': True},
        "Miranda Powder": {'drop': True},
        "Mohgwyn's Sacred Spear": {},
        "Mushroom": {'drop': True},
        "Noble Presence": {},
        "Nomadic Warrior's Cookbook [17]": {},
        "Nomadic Warrior's Cookbook [20]": {},
        "O, Flame!": {},
        "Old Fang": {'drop': True},
        "Perfumer's Bolt": {'drop': True},
        "Perfumer's Cookbook [1]": {},
        "Placidusax's Ruin": {},
        "Radagon Icon": {},
        "Red-Hot Whetblade": {},
        "Rivers of Blood": {},
        "Roiling Magma": {},
        "Root Resin": {'drop': True},
        "Rykard's Rancor": {},
        "Scouring Black Flame": {},
        "Smoldering Butterfly": {'drop': True},
        "St. Trina's Torch": {},
        "Steel-Wire Torch": {},
        "String": {'drop': True},
        "Surge, O Flame!": {},
        "Sword of Night and Flame": {},
        "The Flame of Frenzy": {},
        "Theodorix's Magma": {},
        "Thin Beast Bones": {'drop': True},
        "Torch": {},
        "Torchpole": {},
        "Troll's Hammer": {},
        "Unendurable Frenzy": {},
        "Volcanic Stone": {'drop': True},
        "Vyke's War Spear": {},
        "Whirl, O Flame!": {},
    },
    "Holy": {
        "Ash of War: Golden Land": {},
        "Ash of War: Golden Slam": {},
        "Ash of War: Sacred Blade": {},
        "Ash of War: Sacred Order": {},
        "Ash of War: Sacred Ring of Light": {},
        "Ash of War: Shared Order": {},
        "Black Blade": {},
        "Black Knife": {},
        "Blade of Calling": {},
        "Cipher Pata": {},
        "Coded Sword": {},
        "Discus of Light": {},
        "Eclipse Shotel": {},
        "Elden Stars": {},
        "Envoy's Greathorn": {},
        "Envoy's Horn": {},
        "Envoy's Long Horn": {},
        "Erdtree Bow": {},
        "Erdtree Greatbow": {},
        "Erdtree Greatshield": {},
        "Erdtree Seal": {},
        "Gargoyle's Black Axe": {},
        "Gargoyle's Black Blades": {},
        "Gargoyle's Black Halberd": {},
        "Gargoyle's Blackblade": {},
        "Golden Centipede": {'drop': True},
        "Golden Epitaph": {},
        "Golden Halberd": {},
        "Golden Order Greatsword": {},
        "Golden Sunflower": {'drop': True},
        "Halo Scythe": {},
        "Inseparable Sword": {},
        "Law of Causality": {},
        "Litany of Proper Death": {},
        "Maliketh's Black Blade": {},
        "Marika's Hammer": {},
        "Miquellan Knight's Sword": {},
        "Missionary's Cookbook [1]": {},
        "Missionary's Cookbook [4]": {},
        "Mushroom": {'drop': True},
        "Omen Bairn": {},
        "Order's Blade": {},
        "Ordovis's Greatsword": {},
        "Radagon's Rings of Light": {},
        "Regal Omen Bairn": {},
        "Root Resin": {'drop': True},
        "Sacred Relic Sword": {},
        "Sanctified Whetblade": {},
        "Sentry's Torch": {},
        "Siluria's Tree": {},
        "Staff of the Avatar": {},
        "String": {'drop': True},
        "Tarnished Golden Sunflower": {'drop': True},
        "Treespear": {},
        "Triple Rings of Light": {},
        "Winged Scythe": {},
        "Wrath of Gold": {},
    },
    "Magic": {
        "Academy Glintstone Staff": {},
        "Adula's Moonblade": {},
        "Alabaster Lord's Sword": {},
        "Alberich's Bracers": {},
        "Alberich's Pointed Hat": {},
        "Alberich's Robe": {},
        "Alberich's Trousers": {},
        "Albinauric Staff": {},
        "Ambush Shard": {},
        "Ancient Death Rancor": {},
        "Ash of War: Carian Grandeur": {},
        "Ash of War: Carian Greatsword": {},
        "Ash of War: Carian Retaliation": {},
        "Ash of War: Glintstone Pebble": {},
        "Ash of War: Gravitas": {},
        "Ash of War: Hoarfrost Stomp": {},
        "Ash of War: Ice Spear": {},
        "Ash of War: Loretta's Slash": {},
        "Ash of War: Spinning Weapon": {},
        "Ash of War: Waves of Darkness": {},
        "Astrologer's Staff": {},
        "Azur's Glintstone Crown": {},
        "Azur's Glintstone Staff": {},
        "Bastard's Stars": {},
        "Cannon of Haima": {},
        "Carian Glintblade Staff": {},
        "Carian Glintstone Staff": {},
        "Carian Greatsword": {},
        "Carian Knight's Sword": {},
        "Carian Phalanx": {},
        "Carian Piercer": {},
        "Carian Regal Scepter": {},
        "Carian Retaliation": {},
        "Carian Slicer": {},
        "Cerulean Hidden Tear": {},
        "Clinging Bone": {},
        "Collapsing Stars": {},
        "Comet": {},
        "Comet Azur": {},
        "Cracked Crystal": {'drop': True},
        "Crystal Barrage": {},
        "Crystal Bud": {'drop': True},
        "Crystal Burst": {},
        "Crystal Knife": {},
        "Crystal Release": {},
        "Crystal Spear": {},
        "Crystal Staff": {},
        "Crystal Sword": {},
        "Crystal Torrent": {},
        "Dark Moon Greatsword": {},
        "Death Ritual Spear": {},
        "Death's Poker": {},
        "Demi-Human Queen's Staff": {},
        "Digger's Staff": {},
        "Explosive Ghostflame": {},
        "Fallingstar Beast Jaw": {},
        "Family Heads": {},
        "Flight Pinion": {'drop': True},
        "Founding Rain of Stars": {},
        "Full Moon Crossbow": {},
        "Gavel of Haima": {},
        "Gelmir Glintstone Staff": {},
        "Ghostflame Torch": {},
        "Glintblade Phalanx": {},
        "Glintstone Arc": {},
        "Glintstone Cometshard": {},
        "Glintstone Craftsman's Cookbook [1]": {},
        "Glintstone Craftsman's Cookbook [4]": {},
        "Glintstone Craftsman's Cookbook [5]": {},
        "Glintstone Craftsman's Cookbook [8]": {},
        "Glintstone Firefly": {'drop': True},
        "Glintstone Icecrag": {},
        "Glintstone Kris": {},
        "Glintstone Pebble": {},
        "Glintstone Scrap": {'drop': True},
        "Glintstone Staff": {},
        "Glintstone Stars": {},
        "Glintstone Whetblade": {},
        "Graven-Mass Talisman": {},
        "Graven-School Talisman": {},
        "Grave Violet": {'drop': True},
        "Gravity Well": {},
        "Greatblade Phalanx": {},
        "Great Glintstone Shard": {},
        "Great Oracular Bubble": {},
        "Helphen's Steeple": {},
        "Human Bone Shard": {'drop': True},
        "Ivory Sickle": {},
        "Large Glintstone Scrap": {'drop': True},
        "Lazuli Glintstone Sword": {},
        "Loretta's Greatbow": {},
        "Loretta's Mastery": {},
        "Loretta's War Sickle": {},
        "Lusat's Glintstone Crown": {},
        "Lusat's Glintstone Staff": {},
        "Magic Downpour": {},
        "Magic Glintblade": {},
        "Magic Scorpion Charm": {},
        "Magic-Shrouding Cracked Tear": {},
        "Marais Executioner's Sword": {},
        "Meteoric Ore Blade": {},
        "Meteorite": {},
        "Meteorite of Astel": {},
        "Meteorite Staff": {},
        "Moonveil": {},
        "Night Comet": {},
        "Night Shard": {},
        "Nomadic Warrior's Cookbook [11]": {},
        "Nomadic Warrior's Cookbook [9]": {},
        "Old Fang": {'drop': True},
        "Oracle Bubbles": {},
        "Prince of Death's Staff": {},
        "Rancorcall": {},
        "Ranni's Dark Moon": {},
        "Regalia of Eochaid": {},
        "Rennala's Full Moon": {},
        "Rock Blaster": {},
        "Rock Sling": {},
        "Root Resin": {'drop': True},
        "Rosus' Axe": {},
        "Rotten Crystal Staff": {},
        "Rotten Crystal Sword": {},
        "Royal Greatsword": {},
        "Ruins Greatsword": {},
        "Scepter of the All-Knowing": {},
        "Scholar's Armament": {},
        "Shard Spiral": {},
        "Shatter Earth": {},
        "Shattering Crystal": {},
        "Snow Witch Hat": {},
        "Spellblade's Gloves": {},
        "Spellblade's Pointed Hat": {},
        "Spellblade's Traveling Attire": {},
        "Spellblade's Trousers": {},
        "Staff of Loss": {},
        "Staff of the Guilty": {},
        "Starscourge Greatsword": {},
        "Star Shower": {},
        "Stars of Ruin": {},
        "String": {'drop': True},
        "Swift Glintstone Shard": {},
        "Sword of Milos": {},
        "Sword of Night and Flame": {},
        "Sword of St. Trina": {},
        "Terra Magica": {},
        "Thin Beast Bones": {'drop': True},
        "Tibia's Summons": {},
        "Troll Knight's Sword": {},
        "Wing of Astel": {},
        "Zamor Ice Storm": {},
    },
    "Lightning": {
        "Ancient Dragon Apostle's Cookbook [1]": {},
        "Ancient Dragon Apostle's Cookbook [2]": {},
        "Ancient Dragon Apostle's Cookbook [4]": {},
        "Ancient Dragons' Lightning Spear": {},
        "Ancient Dragons' Lightning Strike": {},
        "Ash of War: Lightning Ram": {},
        "Ash of War: Lightning Slash": {},
        "Ash of War: Thunderbolt": {},
        "Bolt of Gransax": {},
        "Cerulean Hidden Tear": {},
        "Death Lightning": {},
        "Dragon Greatclaw": {},
        "Dragon King's Cragblade": {},
        "Dragonclaw Shield": {},
        "Electrify Armament": {},
        "Flight Pinion": {'drop': True},
        "Fortissax's Lightning Spear": {},
        "Frozen Lightning Spear": {},
        "Fulgurbloom": {'drop': True},
        "Godfrey Icon": {},
        "Gravel Stone": {'drop': True},
        "Gravel Stone Seal": {},
        "Honed Bolt": {},
        "Lansseax's Glaive": {},
        "Lightning Scorpion Charm": {},
        "Lightning Spear": {},
        "Lightning Strike": {},
        "Lightning-Shrouding Cracked Tear": {},
        "Mushroom": {'drop': True},
        "Placidusax's Ruin": {},
        "Radagon Icon": {},
        "Root Resin": {'drop': True},
        "Sanctified Whetblade": {},
        "String": {'drop': True},
        "Thin Beast Bones": {'drop': True},
        "Veteran's Prosthesis": {},
        "Vyke's Dragonbolt": {},
    },
    "Perfume": {
        "Altus Bloom": {'drop': True},
        "Arteria Leaf": {'drop': True},
        "Budding Cave Moss": {'drop': True},
        "Formic Rock": {'drop': True},
        "Land Octopus Ovary": {'drop': True},
        "Living Jar Shard": {'drop': True},
        "Miranda Powder": {'drop': True},
        "Perfume Bottle": {},
        "Perfumer's Cookbook [1]": {},
        "Perfumer's Cookbook [2]": {},
        "Perfumer's Cookbook [3]": {},
        "Perfumer's Cookbook [4]": {},
        "Perfumer's Talisman": {},
        "Poisonbloom": {'drop': True},
        "Silver Tear Husk": {'drop': True},
    },
    "Pots": {
        "Aeonian Butterfly": {'drop': True},
        "Albinauric Bloodclot": {'drop': True},
        "Ancient Dragon Apostle's Cookbook [2]": {},
        "Ancient Dragon Apostle's Cookbook [4]": {},
        "Armorer's Cookbook [4]": {},
        "Armorer's Cookbook [7]": {},
        "Beast Blood": {'drop': True},
        "Blood-Tainted Excrement": {'drop': True},
        "Bloodrose": {'drop': True},
        "Companion Jar": {},
        "Cracked Pot": {},
        "Faded Erdleaf Flower": {'drop': True},
        "Fevor's Cookbook [1]": {},
        "Fire Blossom": {'drop': True},
        "Fulgurbloom": {'drop': True},
        "Glintstone Craftsman's Cookbook [3]": {},
        "Glintstone Craftsman's Cookbook [4]": {},
        "Glintstone Craftsman's Cookbook [6]": {},
        "Glintstone Craftsman's Cookbook [8]": {},
        "Glintstone Firefly": {'drop': True},
        "Gold-Tinged Excrement": {'drop': True},
        "Golden Centipede": {'drop': True},
        "Golden Sunflower": {'drop': True},
        "Grave Violet": {'drop': True},
        "Gravel Stone": {'drop': True},
        "Hefty Beast Bone": {'drop': True},
        "Human Bone Shard": {'drop': True},
        "Jar": {},
        "Melted Mushroom": {'drop': True},
        "Missionary's Cookbook [1]": {},
        "Missionary's Cookbook [5]": {},
        "Mushroom": {'drop': True},
        "Nomadic Warrior's Cookbook [12]": {},
        "Nomadic Warrior's Cookbook [14]": {},
        "Nomadic Warrior's Cookbook [17]": {},
        "Nomadic Warrior's Cookbook [20]": {},
        "Nomadic Warrior's Cookbook [21]": {},
        "Nomadic Warrior's Cookbook [22]": {},
        "Nomadic Warrior's Cookbook [24]": {},
        "Nomadic Warrior's Cookbook [4]": {},
        "Nomadic Warrior's Cookbook [5]": {},
        "Nomadic Warrior's Cookbook [9]": {},
        "Old Fang": {'drop': True},
        "Poisonbloom": {'drop': True},
        "Rimed Crystal Bud": {'drop': True},
        "Ritual Pot": {},
        "Smoldering Butterfly": {'drop': True},
        "String": {'drop': True},
        "Tarnished Golden Sunflower": {'drop': True},
        "Toxic Mushroom": {'drop': True},
        "Trina's Lily": {'drop': True},
        "Volcanic Stone": {'drop': True},
    },
    "Beast": {
        "Agheel's Flame": {},
        "Aspects of the Crucible: Breath": {},
        "Aspects of the Crucible: Horns": {},
        "Aspects of the Crucible: Tail": {},
        "Beast Claw": {},
        "Bestial Constitution": {},
        "Bestial Sling": {},
        "Bestial Vitality": {},
        "Borealis's Mist": {},
        "Cerulean Hidden Tear": {},
        "Cinquedea": {},
        "Clawmark Seal": {},
        "Crucible Axe Armor": {},
        "Crucible Axe Helm": {},
        "Crucible Gauntlets": {},
        "Crucible Greaves": {},
        "Crucible Tree Armor": {},
        "Crucible Tree Helm": {},
        "Dragon Communion Seal": {},
        "Dragonclaw": {},
        "Dragonfire": {},
        "Dragonice": {},
        "Dragonmaw": {},
        "Ekzykes's Decay": {},
        "Faithful's Canvas Talisman": {},
        "Fire Scorpion Charm": {},
        "Flame-Shrouding Cracked Tear": {},
        "Flock's Canvas Talisman": {},
        "Glintstone Breath": {},
        "Godfrey Icon": {},
        "Greyoll's Roar": {},
        "Gurranq's Beast Claw": {},
        "Magma Breath": {},
        "Old Lord's Talisman": {},
        "Placidusax's Ruin": {},
        "Radagon Icon": {},
        "Rotten Breath": {},
        "Smarag's Glintstone Breath": {},
        "Stone of Gurranq": {},
        "Stonebarb Cracked Tear": {},
        "Theodorix's Magma": {},
    },
    "Golden Order": {
        "Discus of Light": {},
        "Golden Order Seal": {},
        "Holy-Shrouding Cracked Tear": {},
        "Immutable Shield": {},
        "Law of Causality": {},
        "Law of Regression": {},
        "Litany of Proper Death": {},
        "Order Healing": {},
        "Order's Blade": {},
        "Radagon's Rings of Light": {},
        "Radiant Gold Mask": {},
        "Sacred Scorpion Charm": {},
        "Triple Rings of Light": {},
    },
    "Gravity": {
        "Ash of War: Cragblade": {},
        "Ash of War: Gravitas": {},
        "Ash of War: Waves of Darkness": {},
        "Cerulean Hidden Tear": {},
        "Collapsing Stars": {},
        "Godfrey Icon": {},
        "Gravity Stone Chunk": {'drop': True},
        "Gravity Stone Fan": {'drop': True},
        "Gravity Well": {},
        "Meteorite": {},
        "Meteorite of Astel": {},
        "Meteorite Staff": {},
        "Radagon Icon": {},
        "Rock Sling": {},
        "Wing of Astel": {},
    },
    "Roar": {
        "Ash of War: Barbaric Roar": {},
        "Ash of War: Beast's Roar": {},
        "Ash of War: Troll's Roar": {},
        "Ash of War: War Cry": {},
        "Axe of Godfrey": {},
        "Axe Talisman": {},
        "Battle Hammer": {},
        "Carian Filigreed Crest": {},
        "Club": {},
        "Curved Great Club": {},
        "Greataxe": {},
        "Hammer Talisman": {},
        "Highland Axe": {},
        "Roar Medallion": {},
        "Rusted Anchor": {},
        "Sacred Butchering Knife": {},
        "Shard of Alexander": {},
        "Spiked Club": {},
        "Spiked Cracked Tear": {},
        "Starscourge Greatsword": {},
        "Sword of Milos": {},
        "Troll Knight's Sword": {},
        "Troll's Golden Sword": {},
        "Troll's Hammer": {},
        "Warped Axe": {},
        "Warrior Jar Shard": {},
    },
    "Axes": {
        "Hand Axe": {},
        "Forked Hatchet": {},
        "Battle Axe": {},
        "Warped Axe": {},
        "Jawbone Axe": {},
        "Iron Cleaver": {},
        "Highland Axe": {},
        "Celebrant's Cleaver": {},
        "Sacrificial Axe": {},
        "Icerind Hatchet": {},
        "Ripple Blade": {},
        "Stormhawk Axe": {},
        "Rosus' Axe": {},
    },
    "Axe Ashes": {
        "Ash of War: Barbaric Roar": {},
        "Ash of War: Chilling Mist": {},
        "Ash of War: Cragblade": {},
        "Ash of War: Flaming Strike": {},
        "Ash of War: Gravitas": {},
        "Ash of War: Lightning Slash": {},
        "Ash of War: Lion's Claw": {},
        "Ash of War: Poisonous Mist": {},
        "Ash of War: Prayerful Strike": {},
        "Ash of War: Spinning Weapon": {},
        "Ash of War: Stamp (Sweep)": {},
        "Ash of War: Stamp (Upward Cut)": {},
        "Ash of War: Stormcaller": {},
        "Ash of War: Sword Dance": {},
        "Ash of War: Vacuum Slice": {},
        "Ash of War: War Cry": {},
        "Ash of War: Wild Strikes": {},
    },
    "Claws": {
        "Hookclaws": {},
        "Bloodhound Claws": {},
        "Venomous Fang": {},
        "Raptor Talons": {},
    },
    "Claw Ashes": {
        "Ash of War: Barbaric Roar": {},
        "Ash of War: Cragblade": {},
        "Ash of War: Flaming Strike": {},
        "Ash of War: Impaling Thrust": {},
        "Ash of War: Lifesteal Fist": {},
        "Ash of War: Parry": {},
        "Ash of War: War Cry": {},
    },
    "Colossal Swords": {
        "Zweihander": {},
        "Greatsword": {},
        "Watchdog's Greatsword": {},
        "Troll's Golden Sword": {},
        "Troll Knight's Sword": {},
        "Royal Greatsword": {},
        "Grafted Blade Greatsword": {},
        "Ruins Greatsword": {},
        "Starscourge Greatsword": {},
        "Godslayer's Greatsword": {},
        "Maliketh's Black Blade": {},
    },
    "Colossal Sword Ashes": {
        "Ash of War: Barbaric Roar": {},
        "Ash of War: Chilling Mist": {},
        "Ash of War: Cragblade": {},
        "Ash of War: Earthshaker": {},
        "Ash of War: Eruption": {},
        "Ash of War: Giant Hunt": {},
        "Ash of War: Golden Land": {},
        "Ash of War: Gravitas": {},
        "Ash of War: Lightning Slash": {},
        "Ash of War: Lion's Claw": {},
        "Ash of War: Poisonous Mist": {},
        "Ash of War: Stamp (Sweep)": {},
        "Ash of War: Stamp (Upward Cut)": {},
        "Ash of War: Troll's Roar": {},
        "Ash of War: Vacuum Slice": {},
        "Ash of War: War Cry": {},
        "Ash of War: Waves of Darkness": {},
    },
    "Colossal Weapons": {
        "Duelist Greataxe": {},
        "Rotten Greataxe": {},
        "Golem's Halberd": {},
        "Giant-Crusher": {},
        "Prelate's Inferno Crozier": {},
        "Great Club": {},
        "Troll's Hammer": {},
        "Dragon Greatclaw": {},
        "Watchdog's Staff": {},
        "Staff of the Avatar": {},
        "Rotten Staff": {},
        "Envoy's Greathorn": {},
        "Ghiza's Wheel": {},
        "Fallingstar Beast Jaw": {},
        "Axe of Godfrey": {},
    },
    "Colossal Weapon Ashes": {
        "Ash of War: Barbaric Roar": {},
        "Ash of War: Chilling Mist": {},
        "Ash of War: Cragblade": {},
        "Ash of War: Earthshaker": {},
        "Ash of War: Eruption": {},
        "Ash of War: Golden Land": {},
        "Ash of War: Gravitas": {},
        "Ash of War: Lightning Slash": {},
        "Ash of War: Lion's Claw": {},
        "Ash of War: Poisonous Mist": {},
        "Ash of War: Prayerful Strike": {},
        "Ash of War: Prelate's Charge": {},
        "Ash of War: Stamp (Sweep)": {},
        "Ash of War: Stamp (Upward Cut)": {},
        "Ash of War: Troll's Roar": {},
        "Ash of War: War Cry": {},
        "Ash of War: Waves of Darkness": {},
    },
    "Curved Greatswords": {
        "Dismounter": {},
        "Omen Cleaver": {},
        "Monk's Flameblade": {},
        "Beastman's Cleaver": {},
        "Bloodhound's Fang": {},
        "Onyx Lord's Greatsword": {},
        "Zamor Curved Sword": {},
        "Magma Wyrm's Scalesword": {},
        "Morgott's Cursed Sword": {},
    },
    "Curved Greatsword Ashes": {
        "Ash of War: Barbaric Roar": {},
        "Ash of War: Bloody Slash": {},
        "Ash of War: Carian Grandeur": {},
        "Ash of War: Carian Greatsword": {},
        "Ash of War: Chilling Mist": {},
        "Ash of War: Cragblade": {},
        "Ash of War: Double Slash": {},
        "Ash of War: Eruption": {},
        "Ash of War: Flaming Strike": {},
        "Ash of War: Glintstone Pebble": {},
        "Ash of War: Gravitas": {},
        "Ash of War: Lightning Slash": {},
        "Ash of War: Lion's Claw": {},
        "Ash of War: Poisonous Mist": {},
        "Ash of War: Seppuku": {},
        "Ash of War: Stamp (Sweep)": {},
        "Ash of War: Stamp (Upward Cut)": {},
        "Ash of War: Storm Blade": {},
        "Ash of War: Stormcaller": {},
        "Ash of War: Sword Dance": {},
        "Ash of War: Troll's Roar": {},
        "Ash of War: Vacuum Slice": {},
        "Ash of War: War Cry": {},
        "Ash of War: Wild Strikes": {},
    },
    "Curved Swords": {
        "Scimitar": {},
        "Falchion": {},
        "Shamshir": {},
        "Grossmesser": {},
        "Bandit's Curved Sword": {},
        "Shotel": {},
        "Scavenger's Curved Sword": {},
        "Mantis Blade": {},
        "Beastman's Curved Sword": {},
        "Flowing Curved Sword": {},
        "Serpent-God's Curved Sword": {},
        "Magma Blade": {},
        "Nox Flowing Sword": {},
        "Wing of Astel": {},
        "Eclipse Shotel": {},
    },
    "Curved Sword Ashes": {
        "Ash of War: Barbaric Roar": {},
        "Ash of War: Blood Blade": {},
        "Ash of War: Bloody Slash": {},
        "Ash of War: Carian Grandeur": {},
        "Ash of War: Carian Greatsword": {},
        "Ash of War: Chilling Mist": {},
        "Ash of War: Cragblade": {},
        "Ash of War: Double Slash": {},
        "Ash of War: Flaming Strike": {},
        "Ash of War: Glintstone Pebble": {},
        "Ash of War: Gravitas": {},
        "Ash of War: Lightning Slash": {},
        "Ash of War: Lion's Claw": {},
        "Ash of War: Parry": {},
        "Ash of War: Poison Moth Flight": {},
        "Ash of War: Poisonous Mist": {},
        "Ash of War: Seppuku": {},
        "Ash of War: Spinning Weapon": {},
        "Ash of War: Storm Blade": {},
        "Ash of War: Stormcaller": {},
        "Ash of War: Sword Dance": {},
        "Ash of War: Vacuum Slice": {},
        "Ash of War: War Cry": {},
        "Ash of War: Wild Strikes": {},
    },
    "Daggers": {
        "Dagger": {},
        "Parrying Dagger": {},
        "Miséricorde": {},
        "Great Knife": {},
        "Bloodstained Dagger": {},
        "Erdsteel Dagger": {},
        "Wakizashi": {},
        "Celebrant's Sickle": {},
        "Ivory Sickle": {},
        "Crystal Knife": {},
        "Scorpion's Stinger": {},
        "Cinquedea": {},
        "Glintstone Kris": {},
        "Reduvia": {},
        "Blade of Calling": {},
        "Black Knife": {},
    },
    "Dagger Ashes": {
        "Ash of War: Assassin's Gambit": {},
        "Ash of War: Blood Blade": {},
        "Ash of War: Blood Tax": {},
        "Ash of War: Bloody Slash": {},
        "Ash of War: Carian Grandeur": {},
        "Ash of War: Carian Greatsword": {},
        "Ash of War: Chilling Mist": {},
        "Ash of War: Cragblade": {},
        "Ash of War: Double Slash": {},
        "Ash of War: Flaming Strike": {},
        "Ash of War: Glintstone Pebble": {},
        "Ash of War: Impaling Thrust": {},
        "Ash of War: Lightning Slash": {},
        "Ash of War: Parry": {},
        "Ash of War: Poison Moth Flight": {},
        "Ash of War: Poisonous Mist": {},
        "Ash of War: Repeating Thrust": {},
        "Ash of War: Spinning Weapon": {},
        "Ash of War: Storm Blade": {},
        "Ash of War: Sword Dance": {},
        "Ash of War: Vacuum Slice": {},
    },
    "Fists": {
        "Caestus": {},
        "Spiked Caestus": {},
        "Katar": {},
        "Star Fist": {},
        "Clinging Bone": {},
        "Veteran's Prosthesis": {},
        "Cipher Pata": {},
        "Grafted Dragon": {},
    },
    "Fist Ashes": {
        "Ash of War: Barbaric Roar": {},
        "Ash of War: Cragblade": {},
        "Ash of War: Flaming Strike": {},
        "Ash of War: Lifesteal Fist": {},
        "Ash of War: Parry": {},
        "Ash of War: War Cry": {},
    },
    "Flails": {
        "Flail": {},
        "Nightrider Flail": {},
        "Chainlink Flail": {},
        "Family Heads": {},
        "Bastard's Stars": {},
    },
    "Flail Ashes": {
        "Ash of War: Barbaric Roar": {},
        "Ash of War: Chilling Mist": {},
        "Ash of War: Cragblade": {},
        "Ash of War: Flaming Strike": {},
        "Ash of War: Gravitas": {},
        "Ash of War: Lightning Slash": {},
        "Ash of War: Lion's Claw": {},
        "Ash of War: Poisonous Mist": {},
        "Ash of War: Prayerful Strike": {},
        "Ash of War: Spinning Weapon": {},
        "Ash of War: Stamp (Sweep)": {},
        "Ash of War: Stamp (Upward Cut)": {},
        "Ash of War: Stormcaller": {},
        "Ash of War: War Cry": {},
        "Ash of War: Wild Strikes": {},
    },
    "Greataxes": {
        "Axe of Godrick": {},
        "Crescent Moon Axe": {},
        "Executioner's Greataxe": {},
        "Gargoyle's Black Axe": {},
        "Gargoyle's Great Axe": {},
        "Great Omenkiller Cleaver": {},
        "Greataxe": {},
        "Longhaft Axe": {},
        "Rusted Anchor": {},
        "Sacred Butchering Knife": {},
        "Winged Greathorn": {},
    },
    "Greataxe Ashes": {
        "Ash of War: Barbaric Roar": {},
        "Ash of War: Chilling Mist": {},
        "Ash of War: Cragblade": {},
        "Ash of War: Earthshaker": {},
        "Ash of War: Eruption": {},
        "Ash of War: Flaming Strike": {},
        "Ash of War: Golden Land": {},
        "Ash of War: Gravitas": {},
        "Ash of War: Lightning Slash": {},
        "Ash of War: Lion's Claw": {},
        "Ash of War: Poisonous Mist": {},
        "Ash of War: Prayerful Strike": {},
        "Ash of War: Prelate's Charge": {},
        "Ash of War: Stamp (Sweep)": {},
        "Ash of War: Stamp (Upward Cut)": {},
        "Ash of War: Stormcaller": {},
        "Ash of War: Sword Dance": {},
        "Ash of War: Troll's Roar": {},
        "Ash of War: Vacuum Slice": {},
        "Ash of War: War Cry": {},
        "Ash of War: Waves of Darkness": {},
        "Ash of War: Wild Strikes": {},
    },
    "Great Hammers": {
        "Large Club": {},
        "Curved Great Club": {},
        "Great Mace": {},
        "Pickaxe": {},
        "Brick Hammer": {},
        "Battle Hammer": {},
        "Rotten Battle Hammer": {},
        "Celebrant's Skull": {},
        "Great Stars": {},
        "Greathorn Hammer": {},
        "Envoy's Long Horn": {},
        "Cranial Vessel Candlestand": {},
        "Beastclaw Greathammer": {},
        "Devourer's Scepter": {},
    },
    "Great Hammer Ashes": {
        "Ash of War: Barbaric Roar": {},
        "Ash of War: Chilling Mist": {},
        "Ash of War: Cragblade": {},
        "Ash of War: Earthshaker": {},
        "Ash of War: Eruption": {},
        "Ash of War: Flaming Strike": {},
        "Ash of War: Golden Land": {},
        "Ash of War: Gravitas": {},
        "Ash of War: Lightning Slash": {},
        "Ash of War: Lion's Claw": {},
        "Ash of War: Poisonous Mist": {},
        "Ash of War: Prayerful Strike": {},
        "Ash of War: Prelate's Charge": {},
        "Ash of War: Stamp (Sweep)": {},
        "Ash of War: Stamp (Upward Cut)": {},
        "Ash of War: Stormcaller": {},
        "Ash of War: Troll's Roar": {},
        "Ash of War: War Cry": {},
        "Ash of War: Waves of Darkness": {},
        "Ash of War: Wild Strikes": {},
    },
    "Great Spears": {
        "Lance": {},
        "Treespear": {},
        "Siluria's Tree": {},
        "Vyke's War Spear": {},
        "Mohgwyn's Sacred Spear": {},
    },
    "Great Spear Ashes": {
        "Ash of War: Barbaric Roar": {},
        "Ash of War: Black Flame Tornado": {},
        "Ash of War: Blood Tax": {},
        "Ash of War: Charge Forth": {},
        "Ash of War: Chilling Mist": {},
        "Ash of War: Cragblade": {},
        "Ash of War: Earthshaker": {},
        "Ash of War: Flaming Strike": {},
        "Ash of War: Giant Hunt": {},
        "Ash of War: Glintstone Pebble": {},
        "Ash of War: Golden Land": {},
        "Ash of War: Gravitas": {},
        "Ash of War: Ice Spear": {},
        "Ash of War: Impaling Thrust": {},
        "Ash of War: Loretta's Slash": {},
        "Ash of War: Phantom Slash": {},
        "Ash of War: Poisonous Mist": {},
        "Ash of War: Repeating Thrust": {},
        "Ash of War: Seppuku": {},
        "Ash of War: Spectral Lance": {},
        "Ash of War: Storm Assault": {},
        "Ash of War: Stormcaller": {},
        "Ash of War: War Cry": {},
        "Ash of War: Waves of Darkness": {},
    },
    "Greatswords": {
        "Bastard Sword": {},
        "Claymore": {},
        "Iron Greatsword": {},
        "Lordsworn's Greatsword": {},
        "Knight's Greatsword": {},
        "Banished Knight's Greatsword": {},
        "Forked Greatsword": {},
        "Flamberge": {},
        "Gargoyle's Greatsword": {},
        "Gargoyle's Blackblade": {},
        "Inseparable Sword": {},
        "Sword of Milos": {},
        "Marais Executioner's Sword": {},
        "Ordovis's Greatsword": {},
        "Alabaster Lord's Sword": {},
        "Death's Poker": {},
        "Helphen's Steeple": {},
        "Blasphemous Blade": {},
        "Golden Order Greatsword": {},
        "Dark Moon Greatsword": {},
        "Sacred Relic Sword": {},
    },
    "Greatsword Ashes": {
        "Ash of War: Barbaric Roar": {},
        "Ash of War: Blood Tax": {},
        "Ash of War: Bloody Slash": {},
        "Ash of War: Carian Grandeur": {},
        "Ash of War: Carian Greatsword": {},
        "Ash of War: Chilling Mist": {},
        "Ash of War: Cragblade": {},
        "Ash of War: Double Slash": {},
        "Ash of War: Eruption": {},
        "Ash of War: Flaming Strike": {},
        "Ash of War: Giant Hunt": {},
        "Ash of War: Glintstone Pebble": {},
        "Ash of War: Gravitas": {},
        "Ash of War: Impaling Thrust": {},
        "Ash of War: Lightning Slash": {},
        "Ash of War: Lion's Claw": {},
        "Ash of War: Poisonous Mist": {},
        "Ash of War: Repeating Thrust": {},
        "Ash of War: Seppuku": {},
        "Ash of War: Stamp (Sweep)": {},
        "Ash of War: Stamp (Upward Cut)": {},
        "Ash of War: Storm Blade": {},
        "Ash of War: Stormcaller": {},
        "Ash of War: Sword Dance": {},
        "Ash of War: Troll's Roar": {},
        "Ash of War: Vacuum Slice": {},
        "Ash of War: War Cry": {},
        "Ash of War: Wild Strikes": {},
    },
    "Halberds": {
        "Halberd": {},
        "Banished Knight's Halberd": {},
        "Lucerne": {},
        "Glaive": {},
        "Vulgar Militia Shotel": {},
        "Vulgar Militia Saw": {},
        "Guardian's Swordspear": {},
        "Gargoyle's Halberd": {},
        "Gargoyle's Black Halberd": {},
        "Nightrider Glaive": {},
        "Pest's Glaive": {},
        "Ripple Crescent Halberd": {},
        "Golden Halberd": {},
        "Dragon Halberd": {},
        "Loretta's War Sickle": {},
        "Commander's Standard": {},
    },
    "Halberd Ashes": {
        "Ash of War: Barbaric Roar": {},
        "Ash of War: Black Flame Tornado": {},
        "Ash of War: Blood Tax": {},
        "Ash of War: Charge Forth": {},
        "Ash of War: Chilling Mist": {},
        "Ash of War: Cragblade": {},
        "Ash of War: Double Slash": {},
        "Ash of War: Flaming Strike": {},
        "Ash of War: Giant Hunt": {},
        "Ash of War: Glintstone Pebble": {},
        "Ash of War: Gravitas": {},
        "Ash of War: Ice Spear": {},
        "Ash of War: Impaling Thrust": {},
        "Ash of War: Loretta's Slash": {},
        "Ash of War: Phantom Slash": {},
        "Ash of War: Poisonous Mist": {},
        "Ash of War: Repeating Thrust": {},
        "Ash of War: Sacred Ring of Light": {},
        "Ash of War: Seppuku": {},
        "Ash of War: Spectral Lance": {},
        "Ash of War: Spinning Weapon": {},
        "Ash of War: Storm Assault": {},
        "Ash of War: Stormcaller": {},
        "Ash of War: Sword Dance": {},
        "Ash of War: War Cry": {},
    },
    "Hammers": {
        "Club": {},
        "Curved Club": {},
        "Envoy's Horn": {},
        "Hammer": {},
        "Mace": {},
        "Marika's Hammer": {},
        "Monk's Flamemace": {},
        "Morning Star": {},
        "Nox Flowing Hammer": {},
        "Ringed Finger": {},
        "Scepter of the All-Knowing": {},
        "Spiked Club": {},
        "Stone Club": {},
        "Varré's Bouquet": {},
        "Warpick": {},
    },
    "Hammer Ashes": {
        "Ash of War: Barbaric Roar": {},
        "Ash of War: Chilling Mist": {},
        "Ash of War: Cragblade": {},
        "Ash of War: Flaming Strike": {},
        "Ash of War: Gravitas": {},
        "Ash of War: Lightning Slash": {},
        "Ash of War: Lion's Claw": {},
        "Ash of War: Poisonous Mist": {},
        "Ash of War: Prayerful Strike": {},
        "Ash of War: Spinning Weapon": {},
        "Ash of War: Stamp (Sweep)": {},
        "Ash of War: Stamp (Upward Cut)": {},
        "Ash of War: Stormcaller": {},
        "Ash of War: Thunderbolt": {},
        "Ash of War: War Cry": {},
        "Ash of War: Wild Strikes": {},
    },
    "Heavy Thrusting Swords": {
        "Bloody Helice": {},
        "Dragon King's Cragblade": {},
        "Godskin Stitcher": {},
        "Great Épée": {},
    },
    "Heavy Thrusting Sword Ashes": {
        "Ash of War: Blood Tax": {},
        "Ash of War: Bloody Slash": {},
        "Ash of War: Carian Grandeur": {},
        "Ash of War: Carian Greatsword": {},
        "Ash of War: Charge Forth": {},
        "Ash of War: Chilling Mist": {},
        "Ash of War: Cragblade": {},
        "Ash of War: Eruption": {},
        "Ash of War: Flaming Strike": {},
        "Ash of War: Giant Hunt": {},
        "Ash of War: Glintstone Pebble": {},
        "Ash of War: Gravitas": {},
        "Ash of War: Impaling Thrust": {},
        "Ash of War: Lightning Slash": {},
        "Ash of War: Poisonous Mist": {},
        "Ash of War: Repeating Thrust": {},
        "Ash of War: Seppuku": {},
        "Ash of War: Stamp (Sweep)": {},
        "Ash of War: Stamp (Upward Cut)": {},
        "Ash of War: Storm Assault": {},
        "Ash of War: Storm Blade": {},
        "Ash of War: Troll's Roar": {},
        "Ash of War: Vacuum Slice": {},
    },
    "Katanas": {
        "Dragonscale Blade": {},
        "Hand of Malenia": {},
        "Meteoric Ore Blade": {},
        "Moonveil": {},
        "Rivers of Blood": {},
        "Serpentbone Blade": {},
        "Uchigatana": {},
    },
    "Katana Ashes": {
        "Ash of War: Assassin's Gambit": {},
        "Ash of War: Barbaric Roar": {},
        "Ash of War: Blood Blade": {},
        "Ash of War: Blood Tax": {},
        "Ash of War: Bloody Slash": {},
        "Ash of War: Carian Grandeur": {},
        "Ash of War: Carian Greatsword": {},
        "Ash of War: Chilling Mist": {},
        "Ash of War: Cragblade": {},
        "Ash of War: Double Slash": {},
        "Ash of War: Flaming Strike": {},
        "Ash of War: Glintstone Pebble": {},
        "Ash of War: Gravitas": {},
        "Ash of War: Impaling Thrust": {},
        "Ash of War: Lightning Slash": {},
        "Ash of War: Lion's Claw": {},
        "Ash of War: Poison Moth Flight": {},
        "Ash of War: Poisonous Mist": {},
        "Ash of War: Repeating Thrust": {},
        "Ash of War: Seppuku": {},
        "Ash of War: Spinning Weapon": {},
        "Ash of War: Storm Blade": {},
        "Ash of War: Stormcaller": {},
        "Ash of War: Sword Dance": {},
        "Ash of War: Unsheathe": {},
        "Ash of War: Vacuum Slice": {},
        "Ash of War: War Cry": {},
    },
    "Reapers": {
        "Scythe": {},
        "Grave Scythe": {},
        "Halo Scythe": {},
        "Winged Scythe": {},
    },
    "Reaper Ashes": {
        "Ash of War: Barbaric Roar": {},
        "Ash of War: Black Flame Tornado": {},
        "Ash of War: Chilling Mist": {},
        "Ash of War: Cragblade": {},
        "Ash of War: Double Slash": {},
        "Ash of War: Flaming Strike": {},
        "Ash of War: Gravitas": {},
        "Ash of War: Loretta's Slash": {},
        "Ash of War: Phantom Slash": {},
        "Ash of War: Poisonous Mist": {},
        "Ash of War: Sacred Ring of Light": {},
        "Ash of War: Spinning Weapon": {},
        "Ash of War: Stormcaller": {},
        "Ash of War: Sword Dance": {},
        "Ash of War: War Cry": {},
    },
    "Seals": {
        "Finger Seal": {},
        "Erdtree Seal": {},
        "Golden Order Seal": {},
        "Gravel Stone Seal": {},
        "Giant's Seal": {},
        "Godslayer's Seal": {},
        "Clawmark Seal": {},
        "Frenzied Flame Seal": {},
        "Dragon Communion Seal": {},
    },
    "Spears": {
        "Short Spear": {},
        "Iron Spear": {},
        "Spear": {},
        "Partisan": {},
        "Pike": {},
        "Spiked Spear": {},
        "Cross-Naginata": {},
        "Clayman's Harpoon": {},
        "Celebrant's Rib-Rake": {},
        "Torchpole": {},
        "Inquisitor's Girandole": {},
        "Crystal Spear": {},
        "Rotten Crystal Spear": {},
        "Cleanrot Spear": {},
        "Death Ritual Spear": {},
        "Bolt of Gransax": {},
    },
    "Spear Ashes": {
        "Ash of War: Barbaric Roar": {},
        "Ash of War: Black Flame Tornado": {},
        "Ash of War: Blood Tax": {},
        "Ash of War: Charge Forth": {},
        "Ash of War: Chilling Mist": {},
        "Ash of War: Cragblade": {},
        "Ash of War: Flaming Strike": {},
        "Ash of War: Giant Hunt": {},
        "Ash of War: Glintstone Pebble": {},
        "Ash of War: Gravitas": {},
        "Ash of War: Ice Spear": {},
        "Ash of War: Impaling Thrust": {},
        "Ash of War: Loretta's Slash": {},
        "Ash of War: Phantom Slash": {},
        "Ash of War: Poisonous Mist": {},
        "Ash of War: Repeating Thrust": {},
        "Ash of War: Sacred Ring of Light": {},
        "Ash of War: Seppuku": {},
        "Ash of War: Spectral Lance": {},
        "Ash of War: Spinning Weapon": {},
        "Ash of War: Storm Assault": {},
        "Ash of War: Stormcaller": {},
        "Ash of War: Sword Dance": {},
        "Ash of War: War Cry": {},
    },
    "Staves": {
        "Astrologer's Staff": {},
        "Glintstone Staff": {},
        "Academy Glintstone Staff": {},
        "Digger's Staff": {},
        "Demi-Human Queen's Staff": {},
        "Azur's Glintstone Staff": {},
        "Lusat's Glintstone Staff": {},
        "Carian Glintstone Staff": {},
        "Carian Glintblade Staff": {},
        "Carian Regal Scepter": {},
        "Albinauric Staff": {},
        "Staff of Loss": {},
        "Gelmir Glintstone Staff": {},
        "Crystal Staff": {},
        "Rotten Crystal Staff": {},
        "Meteorite Staff": {},
        "Staff of the Guilty": {},
        "Prince of Death's Staff": {},
        "Ash of War: Spinning Weapon": {},
    },
    "Straight Swords": {
        "Broadsword": {},
        "Cane Sword": {},
        "Carian Knight's Sword": {},
        "Coded Sword": {},
        "Crystal Sword": {},
        "Golden Epitaph": {},
        "Lazuli Glintstone Sword": {},
        "Longsword": {},
        "Lordsworn's Straight Sword": {},
        "Miquellan Knight's Sword": {},
        "Noble's Slender Sword": {},
        "Ornamental Straight Sword": {},
        "Regalia of Eochaid": {},
        "Rotten Crystal Sword": {},
        "Short Sword": {},
        "Sword of Night and Flame": {},
        "Sword of St. Trina": {},
        "Warhawk's Talon": {},
        "Weathered Straight Sword": {},
    },
    "Straight Sword Ashes": {
        "Ash of War: Assassin's Gambit": {},
        "Ash of War: Barbaric Roar": {},
        "Ash of War: Blood Blade": {},
        "Ash of War: Blood Tax": {},
        "Ash of War: Bloody Slash": {},
        "Ash of War: Carian Grandeur": {},
        "Ash of War: Carian Greatsword": {},
        "Ash of War: Chilling Mist": {},
        "Ash of War: Cragblade": {},
        "Ash of War: Double Slash": {},
        "Ash of War: Flaming Strike": {},
        "Ash of War: Glintstone Pebble": {},
        "Ash of War: Gravitas": {},
        "Ash of War: Impaling Thrust": {},
        "Ash of War: Lightning Slash": {},
        "Ash of War: Lion's Claw": {},
        "Ash of War: Poison Moth Flight": {},
        "Ash of War: Poisonous Mist": {},
        "Ash of War: Repeating Thrust": {},
        "Ash of War: Seppuku": {},
        "Ash of War: Spinning Weapon": {},
        "Ash of War: Square Off": {},
        "Ash of War: Storm Blade": {},
        "Ash of War: Stormcaller": {},
        "Ash of War: Sword Dance": {},
        "Ash of War: Vacuum Slice": {},
        "Ash of War: War Cry": {},
    },
    "Thrusting Swords": {
        "Antspur Rapier": {},
        "Cleanrot Knight's Sword": {},
        "Estoc": {},
        "Frozen Needle": {},
        "Noble's Estoc": {},
        "Rapier": {},
    },
    "Thrusting Sword Ashes": {
        "Ash of War: Assassin's Gambit": {},
        "Ash of War: Blood Blade": {},
        "Ash of War: Blood Tax": {},
        "Ash of War: Bloody Slash": {},
        "Ash of War: Carian Grandeur": {},
        "Ash of War: Carian Greatsword": {},
        "Ash of War: Chilling Mist": {},
        "Ash of War: Cragblade": {},
        "Ash of War: Flaming Strike": {},
        "Ash of War: Glintstone Pebble": {},
        "Ash of War: Gravitas": {},
        "Ash of War: Impaling Thrust": {},
        "Ash of War: Lightning Slash": {},
        "Ash of War: Parry": {},
        "Ash of War: Poison Moth Flight": {},
        "Ash of War: Poisonous Mist": {},
        "Ash of War: Repeating Thrust": {},
        "Ash of War: Seppuku": {},
        "Ash of War: Storm Blade": {},
        "Ash of War: Vacuum Slice": {},
    },
    "Twinblades": {
        "Twinblade": {},
        "Twinned Knight Swords": {},
        "Godskin Peeler": {},
        "Gargoyle's Twinblade": {},
        "Gargoyle's Black Blades": {},
        "Eleonora's Poleblade": {},
    },
    "Twinblade Ashes": {
        "Ash of War: Assassin's Gambit": {},
        "Ash of War: Barbaric Roar": {},
        "Ash of War: Black Flame Tornado": {},
        "Ash of War: Blood Blade": {},
        "Ash of War: Blood Tax": {},
        "Ash of War: Bloody Slash": {},
        "Ash of War: Carian Grandeur": {},
        "Ash of War: Carian Greatsword": {},
        "Ash of War: Charge Forth": {},
        "Ash of War: Chilling Mist": {},
        "Ash of War: Cragblade": {},
        "Ash of War: Double Slash": {},
        "Ash of War: Flaming Strike": {},
        "Ash of War: Giant Hunt": {},
        "Ash of War: Glintstone Pebble": {},
        "Ash of War: Gravitas": {},
        "Ash of War: Ice Spear": {},
        "Ash of War: Impaling Thrust": {},
        "Ash of War: Lightning Slash": {},
        "Ash of War: Lion's Claw": {},
        "Ash of War: Loretta's Slash": {},
        "Ash of War: Phantom Slash": {},
        "Ash of War: Poisonous Mist": {},
        "Ash of War: Repeating Thrust": {},
        "Ash of War: Seppuku": {},
        "Ash of War: Spinning Weapon": {},
        "Ash of War: Storm Assault": {},
        "Ash of War: Stormcaller": {},
        "Ash of War: Sword Dance": {},
        "Ash of War: Vacuum Slice": {},
        "Ash of War: War Cry": {},
    },
    "Whips": {
        "Whip": {},
        "Thorned Whip": {},
        "Urumi": {},
        "Hoslow's Petal Whip": {},
        "Magma Whip Candlestick": {},
        "Giant's Red Braid": {},
    },
    "Ballistae": {
        "Hand Ballista": {},
        "Jar Cannon": {},
    },
    "Bows": {
        "Longbow": {},
        "Albinauric Bow": {},
        "Black Bow": {},
        "Pulley Bow": {},
        "Horn Bow": {},
        "Serpent Bow": {},
        "Erdtree Bow": {},
        "Ash of War: Enchanted Shot": {},
        "Ash of War: Mighty Shot": {},
        "Ash of War: Rain of Arrows": {},
        "Ash of War: Sky Shot": {},
    },
    "Crossbows": {
        "Soldier's Crossbow": {},
        "Light Crossbow": {},
        "Heavy Crossbow": {},
        "Arbalest": {},
        "Crepus's Black-Key Crossbow": {},
        "Pulley Crossbow": {},
        "Full Moon Crossbow": {},
    },
    "Greatbows": {
        "Greatbow": {},
        "Golem Greatbow": {},
        "Erdtree Greatbow": {},
        "Lion Greatbow": {},
        "Ash of War: Rain of Arrows": {},
        "Ash of War: Through and Through": {},
    },
    "Light Bows": {
        "Shortbow": {},
        "Composite Bow": {},
        "Red Branch Shortbow": {},
        "Misbegotten Shortbow": {},
        "Harp Bow": {},
        "Ash of War: Barrage": {},
        "Ash of War: Enchanted Shot": {},
        "Ash of War: Mighty Shot": {},
        "Ash of War: Rain of Arrows": {},
        "Ash of War: Sky Shot": {},
    },
    "Medium Shields": {
        "Ash of War: Barricade Shield": {},
        "Ash of War: Carian Retaliation": {},
        "Ash of War: Golden Parry": {},
        "Ash of War: Holy Ground": {},
        "Ash of War: No Skill": {},
        "Ash of War: Parry": {},
        "Ash of War: Shield Bash": {},
        "Ash of War: Shield Crash": {},
        "Ash of War: Storm Wall": {},
        "Ash of War: Thops's Barrier": {},
        "Ash of War: Vow of the Indomitable": {},
        "Hawk Crest Wooden Shield": {},
        "Horse Crest Wooden Shield": {},
        "Candletree Wooden Shield": {},
        "Flame Crest Wooden Shield": {},
        "Marred Wooden Shield": {},
        "Sun Realm Shield": {},
        "Round Shield": {},
        "Large Leather Shield": {},
        "Black Leather Shield": {},
        "Marred Leather Shield": {},
        "Heater Shield": {},
        "Blue Crest Heater Shield": {},
        "Red Crest Heater Shield": {},
        "Beast Crest Heater Shield": {},
        "Inverted Hawk Heater Shield": {},
        "Eclipse Crest Heater Shield": {},
        "Kite Shield": {},
        "Blue-Gold Kite Shield": {},
        "Scorpion Kite Shield": {},
        "Twinbird Kite Shield": {},
        "Brass Shield": {},
        "Banished Knight's Shield": {},
        "Albinauric Shield": {},
        "Beastman's Jar-Shield": {},
        "Carian Knight's Shield": {},
        "Silver Mirrorshield": {},
        "Great Turtle Shell": {},
    },
    "Small Shields": {
        "Ash of War: Barricade Shield": {},
        "Ash of War: Carian Retaliation": {},
        "Ash of War: Golden Parry": {},
        "Ash of War: Holy Ground": {},
        "Ash of War: No Skill": {},
        "Ash of War: Parry": {},
        "Ash of War: Shield Bash": {},
        "Ash of War: Shield Crash": {},
        "Ash of War: Storm Wall": {},
        "Ash of War: Thops's Barrier": {},
        "Ash of War: Vow of the Indomitable": {},
        "Rickety Shield": {},
        "Riveted Wooden Shield": {},
        "Blue-White Wooden Shield": {},
        "Scripture Wooden Shield": {},
        "Red Thorn Roundshield": {},
        "Pillory Shield": {},
        "Buckler": {},
        "Iron Roundshield": {},
        "Gilded Iron Shield": {},
        "Man-Serpent's Shield": {},
        "Ice Crest Shield": {},
        "Rift Shield": {},
        "Perfumer's Shield": {},
        "Shield of the Guilty": {},
        "Spiralhorn Shield": {},
        "Smoldering Shield": {},
        "Coil Shield": {},
    },
    "Greatshields": {
        "Ash of War: Barricade Shield": {},
        "Ash of War: Holy Ground": {},
        "Ash of War: No Skill": {},
        "Ash of War: Shield Bash": {},
        "Ash of War: Shield Crash": {},
        "Ash of War: Vow of the Indomitable": {},
        "Wooden Greatshield": {},
        "Lordsworn's Shield": {},
        "Briar Greatshield": {},
        "Spiked Palisade Shield": {},
        "Icon Shield": {},
        "Golden Beast Crest Shield": {},
        "Manor Towershield": {},
        "Crossed-Tree Towershield": {},
        "Inverted Hawk Towershield": {},
        "Dragon Towershield": {},
        "Distinguished Greatshield": {},
        "Gilded Greatshield": {},
        "Cuckoo Greatshield": {},
        "Redmane Greatshield": {},
        "Golden Greatshield": {},
        "Haligtree Crest Greatshield": {},
        "Crucible Hornshield": {},
        "Dragonclaw Shield": {},
        "Fingerprint Stone Shield": {},
        "Eclipse Crest Greatshield": {},
        "Ant's Skull Plate": {},
        "Erdtree Greatshield": {},
        "Jellyfish Shield": {},
        "Visage Shield": {},
        "One-Eyed Shield": {},
    },
    "Torches": {
        "Ash of War: No Skill": {},
        "Torch": {},
        "Beast-Repellent Torch": {},
        "Steel-Wire Torch": {},
        "Sentry's Torch": {},
        "Ghostflame Torch": {},
        "St. Trina's Torch": {},
    },
    "Melee Ashes": {
        "Ash of War: Beast's Roar": {},
        "Ash of War: Bloodhound's Step": {},
        "Ash of War: Determination": {},
        "Ash of War: Endure": {},
        "Ash of War: Flame of the Redmanes": {},
        "Ash of War: Golden Slam": {},
        "Ash of War: Golden Vow": {},
        "Ash of War: Ground Slam": {},
        "Ash of War: Hoarah Loux's Earthshaker": {},
        "Ash of War: Hoarfrost Stomp": {},
        "Ash of War: Kick": {},
        "Ash of War: Lightning Ram": {},
        "Ash of War: Quickstep": {},
        "Ash of War: Raptor of the Mists": {},
        "Ash of War: Royal Knight's Resolve": {},
        "Ash of War: Sacred Blade": {},
        "Ash of War: Sacred Order": {},
        "Ash of War: Shared Order": {},
        "Ash of War: Storm Stomp": {},
        "Ash of War: Thunderbolt": {},
        "Ash of War: White Shadow's Lure": {},
    },
    "Ashes of War": {
        "Ash of War: Assassin's Gambit": {},
        "Ash of War: Barbaric Roar": {},
        "Ash of War: Barrage": {},
        "Ash of War: Barricade Shield": {},
        "Ash of War: Beast's Roar": {},
        "Ash of War: Black Flame Tornado": {},
        "Ash of War: Blood Blade": {},
        "Ash of War: Blood Tax": {},
        "Ash of War: Bloodhound's Step": {},
        "Ash of War: Bloody Slash": {},
        "Ash of War: Carian Grandeur": {},
        "Ash of War: Carian Greatsword": {},
        "Ash of War: Carian Retaliation": {},
        "Ash of War: Charge Forth": {},
        "Ash of War: Chilling Mist": {},
        "Ash of War: Cragblade": {},
        "Ash of War: Determination": {},
        "Ash of War: Double Slash": {},
        "Ash of War: Earthshaker": {},
        "Ash of War: Enchanted Shot": {},
        "Ash of War: Endure": {},
        "Ash of War: Eruption": {},
        "Ash of War: Flame of the Redmanes": {},
        "Ash of War: Flaming Strike": {},
        "Ash of War: Giant Hunt": {},
        "Ash of War: Glintstone Pebble": {},
        "Ash of War: Golden Land": {},
        "Ash of War: Golden Parry": {},
        "Ash of War: Golden Slam": {},
        "Ash of War: Golden Vow": {},
        "Ash of War: Gravitas": {},
        "Ash of War: Ground Slam": {},
        "Ash of War: Hoarah Loux's Earthshaker": {},
        "Ash of War: Hoarfrost Stomp": {},
        "Ash of War: Holy Ground": {},
        "Ash of War: Ice Spear": {},
        "Ash of War: Impaling Thrust": {},
        "Ash of War: Kick": {},
        "Ash of War: Lifesteal Fist": {},
        "Ash of War: Lightning Ram": {},
        "Ash of War: Lightning Slash": {},
        "Ash of War: Lion's Claw": {},
        "Ash of War: Loretta's Slash": {},
        "Ash of War: Mighty Shot": {},
        "Ash of War: No Skill": {},
        "Ash of War: Parry": {},
        "Ash of War: Phantom Slash": {},
        "Ash of War: Poison Moth Flight": {},
        "Ash of War: Poisonous Mist": {},
        "Ash of War: Prayerful Strike": {},
        "Ash of War: Prelate's Charge": {},
        "Ash of War: Quickstep": {},
        "Ash of War: Rain of Arrows": {},
        "Ash of War: Raptor of the Mists": {},
        "Ash of War: Repeating Thrust": {},
        "Ash of War: Royal Knight's Resolve": {},
        "Ash of War: Sacred Blade": {},
        "Ash of War: Sacred Order": {},
        "Ash of War: Sacred Ring of Light": {},
        "Ash of War: Seppuku": {},
        "Ash of War: Shared Order": {},
        "Ash of War: Shield Bash": {},
        "Ash of War: Shield Crash": {},
        "Ash of War: Sky Shot": {},
        "Ash of War: Spectral Lance": {},
        "Ash of War: Spinning Slash": {},
        "Ash of War: Spinning Weapon": {},
        "Ash of War: Square Off": {},
        "Ash of War: Stamp (Sweep)": {},
        "Ash of War: Stamp (Upward Cut)": {},
        "Ash of War: Storm Assault": {},
        "Ash of War: Storm Blade": {},
        "Ash of War: Storm Stomp": {},
        "Ash of War: Storm Wall": {},
        "Ash of War: Stormcaller": {},
        "Ash of War: Sword Dance": {},
        "Ash of War: Thops's Barrier": {},
        "Ash of War: Through and Through": {},
        "Ash of War: Thunderbolt": {},
        "Ash of War: Troll's Roar": {},
        "Ash of War: Unsheathe": {},
        "Ash of War: Vacuum Slice": {},
        "Ash of War: Vow of the Indomitable": {},
        "Ash of War: War Cry": {},
        "Ash of War: Waves of Darkness": {},
        "Ash of War: White Shadow's Lure": {},
        "Ash of War: Wild Strikes": {},
        "Ash-of-War Scarab": {},
        "Carian Filigreed Crest": {},
        "Lost Ashes of War": {},
    },
    "Archer": {
        "Aeonian Butterfly": {'drop': True},
        "Albinauric Bow": {},
        "Ancient Dragon Apostle's Cookbook [1]": {},
        "Armorer's Cookbook [2]": {},
        "Arrow": {'drop': True},
        "Arrow's Reach Talisman": {},
        "Arrow's Sting Talisman": {},
        "Ash of War: Barrage": {},
        "Ash of War: Enchanted Shot": {},
        "Ash of War: Mighty Shot": {},
        "Ash of War: Rain of Arrows": {},
        "Ash of War: Sky Shot": {},
        "Ash of War: Through and Through": {},
        "Black Bow": {},
        "Bloodrose": {'drop': True},
        "Composite Bow": {},
        "Concealing Veil": {},
        "Cracked Crystal": {'drop': True},
        "Crepus's Vial": {},
        "Dexterity-knot Crystal Tear": {},
        "Dwelling Arrow": {'drop': True},
        "Erdtree Bow": {},
        "Erdtree Greatbow": {},
        "Fevor's Cookbook [2]": {},
        "Fire Arrow": {'drop': True},
        "Flight Pinion": {'drop': True},
        "Fulgurbloom": {'drop': True},
        "Glintstone Craftsman's Cookbook [5]": {},
        "Glintstone Craftsman's Cookbook [7]": {},
        "Glintstone Firefly": {'drop': True},
        "Golden Arrow": {'drop': True},
        "Golden Great Arrow": {'drop': True},
        "Golden Sunflower": {'drop': True},
        "Golem Greatbow": {},
        "Golem's Great Arrow": {'drop': True},
        "Golem's Magic Arrow": {'drop': True},
        "Great Arrow": {'drop': True},
        "Greatbow": {},
        "Harp Bow": {},
        "Hefty Beast Bone": {'drop': True},
        "Horn Bow": {},
        "Lion Greatbow": {},
        "Longbow": {},
        "Millicent's Prosthesis": {},
        "Misbegotten Shortbow": {},
        "Missionary's Cookbook [4]": {},
        "Nomadic Warrior's Cookbook [1]": {},
        "Nomadic Warrior's Cookbook [10]": {},
        "Nomadic Warrior's Cookbook [11]": {},
        "Nomadic Warrior's Cookbook [13]": {},
        "Nomadic Warrior's Cookbook [15]": {},
        "Nomadic Warrior's Cookbook [3]": {},
        "Nomadic Warrior's Cookbook [6]": {},
        "Nomadic Warrior's Cookbook [7]": {},
        "Poisonbloom": {'drop': True},
        "Prosthesis-Wearer Heirloom": {},
        "Pulley Bow": {},
        "Radagon's Scarseal": {},
        "Radagon's Soreseal": {},
        "Radahn's Spear": {},
        "Red Branch Shortbow": {},
        "Rimed Crystal Bud": {'drop': True},
        "Ruin Fragment": {'drop': True},
        "Serpent Arrow": {'drop': True},
        "Serpent Bow": {},
        "Shortbow": {},
        "Smoldering Butterfly": {'drop': True},
        "Spear Talisman": {},
        "Spiritflame Arrow": {'drop': True},
        "St. Trina's Arrow": {'drop': True},
        "Starscourge Heirloom": {},
        "Stormhawk Feather": {'drop': True},
        "Thin Beast Bones": {'drop': True},
        "Trina's Lily": {'drop': True},
    },
    "Priest": {
        "Agheel's Flame": {},
        "Ancient Dragons' Lightning Spear": {},
        "Ancient Dragons' Lightning Strike": {},
        "Ash of War: Golden Land": {},
        "Ash of War: Golden Slam": {},
        "Ash of War: Sacred Blade": {},
        "Ash of War: Sacred Order": {},
        "Ash of War: Sacred Ring of Light": {},
        "Ash of War: Shared Order": {},
        "Aspects of the Crucible: Breath": {},
        "Aspects of the Crucible: Horns": {},
        "Aspects of the Crucible: Tail": {},
        "Assassin's Approach": {},
        "Barrier of Gold": {},
        "Beast Claw": {},
        "Bestial Constitution": {},
        "Bestial Sling": {},
        "Bestial Vitality": {},
        "Black Blade": {},
        "Black Flame": {},
        "Black Flame Blade": {},
        "Black Flame Ritual": {},
        "Black Flame's Protection": {},
        "Black Knife": {},
        "Blade of Calling": {},
        "Bloodboon": {},
        "Bloodflame Blade": {},
        "Bloodflame Talons": {},
        "Borealis's Mist": {},
        "Burn, O Flame!": {},
        "Catch Flame": {},
        "Cerulean Hidden Tear": {},
        "Cinquedea": {},
        "Clawmark Seal": {},
        "Commoner's Garb": {},
        "Commoner's Simple Garb": {},
        "Crucible Axe Armor": {},
        "Crucible Axe Helm": {},
        "Crucible Gauntlets": {},
        "Crucible Greaves": {},
        "Crucible Tree Armor": {},
        "Crucible Tree Helm": {},
        "Cure Poison": {},
        "Darkness": {},
        "Death Lightning": {},
        "Dexterity-knot Crystal Tear": {},
        "Discus of Light": {},
        "Divine Fortification": {},
        "Dragon Communion Seal": {},
        "Dragonbolt Blessing": {},
        "Dragonclaw": {},
        "Dragonfire": {},
        "Dragonice": {},
        "Dragonmaw": {},
        "Ekzykes's Decay": {},
        "Elden Stars": {},
        "Electrify Armament": {},
        "Envoy Crown": {},
        "Erdtree Heal": {},
        "Erdtree Seal": {},
        "Faith-knot Crystal Tear": {},
        "Faithful's Canvas Talisman": {},
        "Finger Seal": {},
        "Fire's Deadly Sin": {},
        "Flame, Fall Upon Them": {},
        "Flame Fortification": {},
        "Flame of the Fell God": {},
        "Flame Sling": {},
        "Flame, Cleanse Me": {},
        "Flame, Grant Me Strength": {},
        "Flame, Protect Me": {},
        "Flight Pinion": {'drop': True},
        "Flock's Canvas Talisman": {},
        "Fortissax's Lightning Spear": {},
        "Frenzied Burst": {},
        "Frenzied Flame Seal": {},
        "Frozen Lightning Spear": {},
        "Giant's Seal": {},
        "Giantsflame Take Thee": {},
        "Glintstone Breath": {},
        "Godfrey Icon": {},
        "Godskin Noble Robe": {},
        "Godslayer's Seal": {},
        "Golden Centipede": {'drop': True},
        "Golden Lightning Fortification": {},
        "Golden Order Seal": {},
        "Golden Sunflower": {'drop': True},
        "Golden Vow": {},
        "Grave Violet": {'drop': True},
        "Gravel Stone Seal": {},
        "Great Heal": {},
        "Greathood": {},
        "Greyoll's Roar": {},
        "Gurranq's Beast Claw": {},
        "Haligtree Helm": {},
        "Haligtree Knight Helm": {},
        "Heal": {},
        "Holy-Shrouding Cracked Tear": {},
        "Honed Bolt": {},
        "Howl of Shabriri": {},
        "Human Bone Shard": {'drop': True},
        "Immutable Shield": {},
        "Imp Head (Corpse)": {},
        "Incantation Scarab": {},
        "Inescapable Frenzy": {},
        "Lansseax's Glaive": {},
        "Law of Causality": {},
        "Law of Regression": {},
        "Lightning Fortification": {},
        "Lightning Spear": {},
        "Lightning Strike": {},
        "Litany of Proper Death": {},
        "Lord's Aid": {},
        "Lord's Divine Fortification": {},
        "Lord's Heal": {},
        "Magic Fortification": {},
        "Magma Breath": {},
        "Marika's Scarseal": {},
        "Marika's Soreseal": {},
        "Missionary's Cookbook [1]": {},
        "Missionary's Cookbook [4]": {},
        "Missionary's Cookbook [5]": {},
        "Mushroom": {'drop': True},
        "Navy Hood": {},
        "Noble Presence": {},
        "Nomadic Warrior's Cookbook [9]": {},
        "O, Flame!": {},
        "Old Lord's Talisman": {},
        "Omen Armor": {},
        "Omen Bairn": {},
        "Omen Gauntlets": {},
        "Omen Greaves": {},
        "Omen Helm": {},
        "Order Healing": {},
        "Order's Blade": {},
        "Pest Threads": {},
        "Placidusax's Ruin": {},
        "Poison Armament": {},
        "Poison Mist": {},
        "Preceptor's Big Hat": {},
        "Primal Glintstone Blade": {},
        "Prince of Death's Staff": {},
        "Protection of the Erdtree": {},
        "Radagon Icon": {},
        "Radagon's Rings of Light": {},
        "Radiant Gold Mask": {},
        "Regal Omen Bairn": {},
        "Rejection": {},
        "Root Resin": {'drop': True},
        "Rotten Breath": {},
        "Ruler's Mask": {},
        "Sacred Crown Helm": {},
        "Sacred Scorpion Charm": {},
        "Scarlet Aeonia": {},
        "Scouring Black Flame": {},
        "Sentry's Torch": {},
        "Shadow Bait": {},
        "Smarag's Glintstone Breath": {},
        "Stone of Gurranq": {},
        "String": {'drop': True},
        "Surge, O Flame!": {},
        "Swarm of Flies": {},
        "Tarnished Golden Sunflower": {'drop': True},
        "The Flame of Frenzy": {},
        "Theodorix's Magma": {},
        "Thin Beast Bones": {'drop': True},
        "Triple Rings of Light": {},
        "Two Fingers Heirloom": {},
        "Unendurable Frenzy": {},
        "Urgent Heal": {},
        "Vyke's Dragonbolt": {},
        "Whirl, O Flame!": {},
        "Wrath of Gold": {},
    },
    "Sorcerer": {
        "Academy Glintstone Staff": {},
        "Adula's Moonblade": {},
        "Alberich's Bracers": {},
        "Alberich's Pointed Hat": {},
        "Alberich's Robe": {},
        "Alberich's Trousers": {},
        "Albinauric Staff": {},
        "Ambush Shard": {},
        "Ancestral Infant's Head": {},
        "Ash of War: Carian Grandeur": {},
        "Ash of War: Carian Greatsword": {},
        "Ash of War: Carian Retaliation": {},
        "Ash of War: Glintstone Pebble": {},
        "Ash of War: Gravitas": {},
        "Ash of War: Hoarfrost Stomp": {},
        "Ash of War: Ice Spear": {},
        "Ash of War: Loretta's Slash": {},
        "Ash of War: Spinning Weapon": {},
        "Ash of War: Waves of Darkness": {},
        "Astrologer's Staff": {},
        "Azur's Glintstone Crown": {},
        "Azur's Glintstone Staff": {},
        "Cannon of Haima": {},
        "Carian Glintblade Staff": {},
        "Carian Glintstone Staff": {},
        "Carian Greatsword": {},
        "Carian Phalanx": {},
        "Carian Piercer": {},
        "Carian Regal Scepter": {},
        "Carian Retaliation": {},
        "Carian Slicer": {},
        "Cerulean Hidden Tear": {},
        "Collapsing Stars": {},
        "Comet": {},
        "Comet Azur": {},
        "Consort's Mask": {},
        "Cracked Crystal": {'drop': True},
        "Crystal Barrage": {},
        "Crystal Bud": {'drop': True},
        "Crystal Burst": {},
        "Crystal Knife": {},
        "Crystal Release": {},
        "Crystal Staff": {},
        "Crystal Torrent": {},
        "Demi-Human Queen's Staff": {},
        "Dexterity-knot Crystal Tear": {},
        "Digger's Staff": {},
        "Eternal Darkness": {},
        "Flight Pinion": {'drop': True},
        "Founding Rain of Stars": {},
        "Freezing Mist": {},
        "Frozen Armament": {},
        "Gavel of Haima": {},
        "Gelmir Glintstone Staff": {},
        "Ghostflame Torch": {},
        "Glintblade Phalanx": {},
        "Glintstone Arc": {},
        "Glintstone Cometshard": {},
        "Glintstone Craftsman's Cookbook [1]": {},
        "Glintstone Craftsman's Cookbook [4]": {},
        "Glintstone Craftsman's Cookbook [5]": {},
        "Glintstone Craftsman's Cookbook [8]": {},
        "Glintstone Firefly": {'drop': True},
        "Glintstone Icecrag": {},
        "Glintstone Kris": {},
        "Glintstone Pebble": {},
        "Glintstone Scarab": {},
        "Glintstone Scrap": {'drop': True},
        "Glintstone Staff": {},
        "Glintstone Stars": {},
        "Godfrey Icon": {},
        "Graven-Mass Talisman": {},
        "Graven-School Talisman": {},
        "Grave Violet": {'drop': True},
        "Gravity Stone Chunk": {'drop': True},
        "Gravity Stone Fan": {'drop': True},
        "Gravity Well": {},
        "Greatblade Phalanx": {},
        "Great Glintstone Shard": {},
        "Greathood": {},
        "Great Oracular Bubble": {},
        "Haima Glintstone Crown": {},
        "Hierodas Glintstone Crown": {},
        "Human Bone Shard": {'drop': True},
        "Imp Head (Cat)": {},
        "Imp Head (Long-Tongued)": {},
        "Intelligence-knot Crystal Tear": {},
        "Ivory Sickle": {},
        "Karolos Glintstone Crown": {},
        "Large Glintstone Scrap": {'drop': True},
        "Law of Causality": {},
        "Law of Regression": {},
        "Lazuli Glintstone Crown": {},
        "Loretta's Greatbow": {},
        "Loretta's Mastery": {},
        "Lucidity": {},
        "Lusat's Glintstone Crown": {},
        "Lusat's Glintstone Staff": {},
        "Magic Downpour": {},
        "Magic Glintblade": {},
        "Magic Scorpion Charm": {},
        "Magic-Shrouding Cracked Tear": {},
        "Marika's Scarseal": {},
        "Marika's Soreseal": {},
        "Meteorite": {},
        "Meteorite of Astel": {},
        "Meteorite Staff": {},
        "Moon of Nokstella": {},
        "Navy Hood": {},
        "Night Comet": {},
        "Night Maiden's Mist": {},
        "Night Shard": {},
        "Nomadic Warrior's Cookbook [11]": {},
        "Nomadic Warrior's Cookbook [9]": {},
        "Okina Mask": {},
        "Old Fang": {'drop': True},
        "Old Lord's Talisman": {},
        "Olivinus Glintstone Crown": {},
        "Omen Armor": {},
        "Omen Bairn": {},
        "Omen Gauntlets": {},
        "Omen Greaves": {},
        "Omen Helm": {},
        "Oracle Bubbles": {},
        "Preceptor's Big Hat": {},
        "Primal Glintstone Blade": {},
        "Prince of Death's Staff": {},
        "Prosthesis-Wearer Heirloom": {},
        "Queen's Crescent Crown": {},
        "Radagon Icon": {},
        "Ranni's Dark Moon": {},
        "Regal Omen Bairn": {},
        "Rennala's Full Moon": {},
        "Rock Blaster": {},
        "Rock Sling": {},
        "Root Resin": {'drop': True},
        "Rotten Crystal Staff": {},
        "Scholar's Armament": {},
        "Scholar's Shield": {},
        "Shard Spiral": {},
        "Shatter Earth": {},
        "Shattering Crystal": {},
        "Shining Horned Headband": {},
        "Snow Witch Hat": {},
        "Spellblade's Gloves": {},
        "Spellblade's Pointed Hat": {},
        "Spellblade's Traveling Attire": {},
        "Spellblade's Trousers": {},
        "Staff of Loss": {},
        "Staff of the Guilty": {},
        "Stargazer Heirloom": {},
        "Starlight": {},
        "Star Shower": {},
        "Stars of Ruin": {},
        "String": {'drop': True},
        "Swift Glintstone Shard": {},
        "Terra Magica": {},
        "Thin Beast Bones": {'drop': True},
        "Thops's Barrier": {},
        "Twinsage Glintstone Crown": {},
        "Witch's Glintstone Crown": {},
        "Wraith Calling Bell": {},
        "Zamor Ice Storm": {},
    },
}
