# Copyright (c) 2023 The Old Man and the C
#
# This file is part of Elden Ring Randomizer Hints.
#
# Elden Ring Randomizer Hints is free software: you can redistribute it and/or
# modify it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Elden Ring Randomizer Hints is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
# or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License
# for more details.
#
# You should have received a copy of the GNU Affero General Public License along
# with Elden Ring Randomizer Hints. If not, see <https://www.gnu.org/licenses/>.

categoryLocalizaiton = {
    "Archer": {
        "engus": "Archer",
        "deude": "Bogenschütze",
        "frafr": "Archer",
        "itait": "Arciere",
        "jpnjp": "射手",
        "korkr": "궁수",
        "polpl": "Łucznik",
        "porbr": "Arqueiro",
        "rusru": "Лучник",
        "spaar": "Arquero",
        "spaes": "Arquero",
        "thath": "อาร์เชอร์",
        "zhocn": "射手",
        "zhotw": "射手",
    },
    "Ashes of War": {
        "engus": "Ashes of War",
        "deude": "Asche des Krieges",
        "frafr": "Cendre de guerre",
        "itait": "Cenere di guerra",
        "jpnjp": "戦争の灰",
        "korkr": "애쉬 오브 워",
        "polpl": "Popiół wojny",
        "porbr": "Cinzas da Guerra",
        "rusru": "Пепел войны",
        "spaar": "Ceniza de guerra",
        "spaes": "Ceniza de guerra",
        "thath": "เถ้าแห่งสงคราม",
        "zhocn": "战争灰烬",
        "zhotw": "戰爭灰燼",
    },
    "Axes": {
        "engus": "Axes",
        "deude": "Axt",
        "frafr": "Hache",
        "itait": "Ascia",
        "jpnjp": "斧の武器",
        "korkr": "도끼",
        "polpl": "Topór",
        "porbr": "Machado",
        "rusru": "Топор",
        "spaar": "Hacha",
        "spaes": "Hacha",
        "thath": "ขวาน",
        "zhocn": "斧头",
        "zhotw": "斧頭",
    },
    "Axe Ashes": {
        "engus": "Axe Ashes",
        "deude": "Axt Asche",
        "frafr": "Cendres de Hache",
        "itait": "Ceneri del Ascia",
        "jpnjp": "斧の灰",
        "korkr": "도끼 전회",
        "polpl": "Topór Popiół",
        "porbr": "Cinzas de Machado",
        "rusru": "Топор Пепел",
        "spaar": "Cenizas de Hacha",
        "spaes": "Cenizas de Hacha",
        "thath": "ขวาน เถ้า​สงคราม",
        "zhocn": "斧头灰烬",
        "zhotw": "斧頭灰燼",
    },
    "Ballistae": {
        "engus": "Ballistae",
        "deude": "Balliste",
        "frafr": "Baliste",
        "itait": "Balista",
        "jpnjp": "バリスタの武器",
        "korkr": "발리스타",
        "polpl": "Balista",
        "porbr": "Ballista",
        "rusru": "Баллиста",
        "spaar": "Balista",
        "spaes": "Balista",
        "thath": "บาลิสต้า",
        "zhocn": "弩炮",
        "zhotw": "弩砲",
    },
    "Beast": {
        "engus": "Beast",
        "deude": "Tier",
        "frafr": "Bête",
        "itait": "Bestia",
        "jpnjp": "獣",
        "korkr": "짐승",
        "polpl": "Bestia",
        "porbr": "Fera",
        "rusru": "Зверь",
        "spaar": "Bestia",
        "spaes": "Bestia",
        "thath": "สัตว์ร้าย",
        "zhocn": "兽",
        "zhotw": "獸",
    },
    "Blood": {
        "engus": "Blood",
        "deude": "Blut",
        "frafr": "Sang",
        "itait": "Sangue",
        "jpnjp": "血",
        "korkr": "피",
        "polpl": "Krew",
        "porbr": "Sangue",
        "rusru": "Кровь",
        "spaar": "Sangre",
        "spaes": "Sangre",
        "thath": "เลือด",
        "zhocn": "血",
        "zhotw": "血",
    },
    "Bows": {
        "engus": "Bows",
        "deude": "Bogen",
        "frafr": "Arc",
        "itait": "Arco",
        "jpnjp": "弓の武器",
        "korkr": "보우",
        "polpl": "Łuk",
        "porbr": "Arco",
        "rusru": "Поклон",
        "spaar": "Arco",
        "spaes": "Arco",
        "thath": "ธนู​",
        "zhocn": "弓",
        "zhotw": "弓",
    },
    "Claws": {
        "engus": "Claws",
        "deude": "Klaue",
        "frafr": "Les griffes",
        "itait": "Artiglio",
        "jpnjp": "爪の武器",
        "korkr": "집게발",
        "polpl": "Pazurów",
        "porbr": "Garra",
        "rusru": "Когти",
        "spaar": "Garra",
        "spaes": "Garra",
        "thath": "กรง​เล็บ​ส",
        "zhocn": "爪",
        "zhotw": "爪",
    },
    "Claw Ashes": {
        "engus": "Claw Ashes",
        "deude": "Klaue Asche",
        "frafr": "Cendres de Griffes",
        "itait": "Ceneri del Artiglio",
        "jpnjp": "爪の灰",
        "korkr": "갈고리 발톱 전회",
        "polpl": "Pazurów Popiół",
        "porbr": "Cinzas de Garra",
        "rusru": "Когти Пепел",
        "spaar": "Cenizas de Garra",
        "spaes": "Cenizas de Garra",
        "thath": "กรง​เล็บ​ส เถ้า​สงคราม",
        "zhocn": "爪灰烬",
        "zhotw": "爪灰燼",
    },
    "Colossal Swords": {
        "engus": "Colossal Swords",
        "deude": "Kolossales Schwert",
        "frafr": "Épée colossale",
        "itait": "Spada colossale",
        "jpnjp": "巨大な剣の武器",
        "korkr": "거대한 검",
        "polpl": "Kolosalny Miecz",
        "porbr": "Espada Colossal",
        "rusru": "Колоссальный меч",
        "spaar": "Espada colosal",
        "spaes": "Espada colosal",
        "thath": "ดาบมหึมา",
        "zhocn": "大剑武器",
        "zhotw": "大劍武器",
    },
    "Colossal Sword Ashes": {
        "engus": "Colossal Sword Ashes",
        "deude": "Kolossales Schwert Asche",
        "frafr": "Cendres de Épée colossale",
        "itait": "Ceneri del Spada colossale",
        "jpnjp": "巨大な剣の灰",
        "korkr": "거대한 검 전회",
        "polpl": "Kolosalny Miecz Popiół",
        "porbr": "Cinzas de Espada Colossal",
        "rusru": "Колоссальный меч Пепел",
        "spaar": "Cenizas de Espada colosal",
        "spaes": "Cenizas de Espada colosal",
        "thath": "ดาบมหึมา เถ้า​สงคราม",
        "zhocn": "大剑灰烬",
        "zhotw": "大劍灰燼",
    },
    "Colossal Weapons": {
        "engus": "Colossal Weapons",
        "deude": "Kolossale Waffe",
        "frafr": "Arme colossale",
        "itait": "Arma colossale",
        "jpnjp": "巨大兵器の武器",
        "korkr": "거대 무기",
        "polpl": "Kolosalna broń",
        "porbr": "Arma Colossal",
        "rusru": "Колоссальное оружие",
        "spaar": "Arma colosal",
        "spaes": "Arma colosal",
        "thath": "อาวุธมหึมา",
        "zhocn": "巨型武器",
        "zhotw": "巨型武器",
    },
    "Colossal Weapon Ashes": {
        "engus": "Colossal Weapon Ashes",
        "deude": "Kolossale Waffe Asche",
        "frafr": "Cendres de Arme colossale",
        "itait": "Ceneri del Arma colossale",
        "jpnjp": "巨大兵器の灰",
        "korkr": "거대 무기 전회",
        "polpl": "Kolosalna broń Popiół",
        "porbr": "Cinzas de Arma Colossal",
        "rusru": "Колоссальное оружие Пепел",
        "spaar": "Cenizas de Arma colosal",
        "spaes": "Cenizas de Arma colosal",
        "thath": "อาวุธมหึมา เถ้า​สงคราม",
        "zhocn": "巨型武器灰烬",
        "zhotw": "巨型武器灰燼",
    },
    "Crossbows": {
        "engus": "Crossbows",
        "deude": "Armbrust",
        "frafr": "Arbalète",
        "itait": "Balestra",
        "jpnjp": "クロスボウの武器",
        "korkr": "석궁",
        "polpl": "Kusza",
        "porbr": "Besta",
        "rusru": "Арбалет",
        "spaar": "Ballesta",
        "spaes": "Ballesta",
        "thath": "หน้าไม้",
        "zhocn": "弩",
        "zhotw": "弩",
    },
    "Curved Greatswords": {
        "engus": "Curved Greatswords",
        "deude": "Gebogenes Großschwert",
        "frafr": "Grande épée incurvée",
        "itait": "Grande Spada Ricurva",
        "jpnjp": "曲りの大剣の武器",
        "korkr": "곡선의 대검",
        "polpl": "Zakrzywiony Wielki Miecz",
        "porbr": "Grande Espada Curva",
        "rusru": "Изогнутый большой меч",
        "spaar": "Gran espada curva",
        "spaes": "Gran espada curva",
        "thath": "ดาบใหญ่โค้ง",
        "zhocn": "弯曲大剑",
        "zhotw": "彎曲大劍",
    },
    "Curved Greatsword Ashes": {
        "engus": "Curved Greatsword Ashes",
        "deude": "Gebogenes Großschwert Asche",
        "frafr": "Cendres de Grande épée incurvée",
        "itait": "Ceneri del Grande Spada Ricurva",
        "jpnjp": "曲りの大剣の灰",
        "korkr": "곡선의 대검 전회",
        "polpl": "Zakrzywiony Wielki Miecz Popiół",
        "porbr": "Cinzas de Grande Espada Curva",
        "rusru": "Изогнутый большой меч Пепел",
        "spaar": "Cenizas de Gran espada curva",
        "spaes": "Cenizas de Gran espada curva",
        "thath": "ดาบใหญ่โค้ง เถ้า​สงคราม",
        "zhocn": "弯曲大剑灰烬",
        "zhotw": "彎曲大劍灰燼",
    },
    "Curved Swords": {
        "engus": "Curved Swords",
        "deude": "Gebogenes Schwert",
        "frafr": "Épée courbée",
        "itait": "Spada curva",
        "jpnjp": "曲剣の武器",
        "korkr": "휘어진 검",
        "polpl": "Zakrzywiony Miecz",
        "porbr": "Espada curva",
        "rusru": "Изогнутый меч",
        "spaar": "Espada curva",
        "spaes": "Espada curva",
        "thath": "ดาบโค้ง",
        "zhocn": "弯剑",
        "zhotw": "彎劍",
    },
    "Curved Sword Ashes": {
        "engus": "Curved Sword Ashes",
        "deude": "Gebogenes Schwert Asche",
        "frafr": "Cendres de Épée courbée",
        "itait": "Ceneri del Spada curva",
        "jpnjp": "曲剣の灰",
        "korkr": "휘어진 검 전회",
        "polpl": "Zakrzywiony Miecz Popiół",
        "porbr": "Cinzas de Espada curva",
        "rusru": "Изогнутый меч Пепел",
        "spaar": "Cenizas de Espada curva",
        "spaes": "Cenizas de Espada curva",
        "thath": "ดาบโค้ง เถ้า​สงคราม",
        "zhocn": "弯剑灰烬",
        "zhotw": "彎劍灰燼",
    },
    "Daggers": {
        "engus": "Daggers",
        "deude": "Dolche",
        "frafr": "Dagues",
        "itait": "Pugnali",
        "jpnjp": "ダガーの武器",
        "korkr": "단검",
        "polpl": "Sztylety",
        "porbr": "Adagas",
        "rusru": "Кинжалы",
        "spaar": "Dagas",
        "spaes": "Dagas",
        "thath": "มีดสั้น",
        "zhocn": "匕首武器",
        "zhotw": "匕首武器",
    },
    "Dagger Ashes": {
        "engus": "Dagger Ashes",
        "deude": "Dolch Asche",
        "frafr": "Cendres de Dague",
        "itait": "Ceneri del Pugnale",
        "jpnjp": "ダガーの灰",
        "korkr": "대거 전회",
        "polpl": "Sztylet Popiół",
        "porbr": "Cinzas de Adaga",
        "rusru": "Кинжал Пепел",
        "spaar": "Cenizas de Daga",
        "spaes": "Cenizas de Daga",
        "thath": "มีด​สัน เถ้า​สงคราม",
        "zhocn": "匕首灰烬",
        "zhotw": "匕首灰燼",
    },
    "Death": {
        "engus": "Death",
        "deude": "Tod",
        "frafr": "La mort",
        "itait": "Morte",
        "jpnjp": "死",
        "korkr": "죽음",
        "polpl": "Śmierć",
        "porbr": "Morte",
        "rusru": "Смерть",
        "spaar": "Muerte",
        "spaes": "Muerte",
        "thath": "ความตาย",
        "zhocn": "死亡",
        "zhotw": "死亡",
    },
    "Defense": {
        "engus": "Defense",
        "deude": "Verteidigung",
        "frafr": "La défense",
        "itait": "Difesa",
        "jpnjp": "防衛",
        "korkr": "방어",
        "polpl": "Obrona",
        "porbr": "Defesa",
        "rusru": "Защита",
        "spaar": "Defensa",
        "spaes": "Defensa",
        "thath": "ป้อง",
        "zhocn": "防御",
        "zhotw": "防禦",
    },
    "Exploring": {
        "engus": "Exploring",
        "deude": "Erkunden",
        "frafr": "Explorant",
        "itait": "Esplorando",
        "jpnjp": "探検する",
        "korkr": "탐험하다",
        "polpl": "odkryć",
        "porbr": "Explorando",
        "rusru": "эксплорация",
        "spaar": "Explorador",
        "spaes": "Explorador",
        "thath": "กำลังสำรวจ",
        "zhocn": "探索",
        "zhotw": "探索",
    },
    "Fire": {
        "engus": "Fire",
        "deude": "Feuer",
        "frafr": "Feu",
        "itait": "Fuoco",
        "jpnjp": "火",
        "korkr": "불",
        "polpl": "Ogień",
        "porbr": "Incêndio",
        "rusru": "Огонь",
        "spaar": "Fuego",
        "spaes": "Fuego",
        "thath": "เพลิง",
        "zhocn": "火",
        "zhotw": "火",
    },
    "Fists": {
        "engus": "Fists",
        "deude": "Faust",
        "frafr": "Poing",
        "itait": "Pugno",
        "jpnjp": "拳の武器",
        "korkr": "주먹",
        "polpl": "Pięść",
        "porbr": "Punho",
        "rusru": "Кулак",
        "spaar": "Puño",
        "spaes": "Puño",
        "thath": "กำปั้น",
        "zhocn": "拳头",
        "zhotw": "拳頭",
    },
    "Fist Ashes": {
        "engus": "Fist Ashes",
        "deude": "Faust Asche",
        "frafr": "Cendres de Poing",
        "itait": "Ceneri del Pugno",
        "jpnjp": "拳の灰",
        "korkr": "주먹 전회",
        "polpl": "Pięść Popiół",
        "porbr": "Cinzas de Punho",
        "rusru": "Кулак Пепел",
        "spaar": "Cenizas de Puño",
        "spaes": "Cenizas de Puño",
        "thath": "กำปั้น เถ้า​สงคราม",
        "zhocn": "拳头灰烬",
        "zhotw": "拳頭灰燼",
    },
    "Flails": {
        "engus": "Flails",
        "deude": "Dreschflegel",
        "frafr": "Fléaux",
        "itait": "Flagelli",
        "jpnjp": "フレイルの武器",
        "korkr": "플레일스",
        "polpl": "Cepki",
        "porbr": "Manguais",
        "rusru": "Цепы",
        "spaar": "Manguales",
        "spaes": "Mayales",
        "thath": "ไม้ตีนกบ",
        "zhocn": "连枷武器",
        "zhotw": "連枷武器",
    },
    "Flail Ashes": {
        "engus": "Flail Ashes",
        "deude": "Flegel Asche",
        "frafr": "Cendres de Fléau d'armes",
        "itait": "Ceneri del Flagello",
        "jpnjp": "フレイルの灰",
        "korkr": "철퇴 전회",
        "polpl": "Korbacz Popiół",
        "porbr": "Cinzas de Mangual",
        "rusru": "Цеп Пепел",
        "spaar": "Cenizas de Mangual",
        "spaes": "Cenizas de Mayal",
        "thath": "ลูก​ตุ้ม เถ้า​สงคราม",
        "zhocn": "连枷灰烬",
        "zhotw": "連枷灰燼",
    },
    "Frenzy": {
        "engus": "Frenzy",
        "deude": "Raserei",
        "frafr": "Frénésie",
        "itait": "Frenesia",
        "jpnjp": "狂乱",
        "korkr": "격분",
        "polpl": "Szał",
        "porbr": "Frenesi",
        "rusru": "безумие",
        "spaar": "Frenesí",
        "spaes": "Frenesí",
        "thath": "ความบ้าคลั่ง",
        "zhocn": "疯狂",
        "zhotw": "瘋狂",
    },
    "Frost": {
        "engus": "Frost",
        "deude": "Frost",
        "frafr": "Gel",
        "itait": "Gelo",
        "jpnjp": "霜",
        "korkr": "서리",
        "polpl": "Mróz",
        "porbr": "Geada",
        "rusru": "Мороз",
        "spaar": "escarcha",
        "spaes": "escarcha",
        "thath": "น้ำแข็ง",
        "zhocn": "霜",
        "zhotw": "霜",
    },
    "Golden Order": {
        "engus": "Golden Order",
        "deude": "Goldener Orden",
        "frafr": "Ordre d'Or",
        "itait": "Ordine d'Oro",
        "jpnjp": "黄金律",
        "korkr": "골든 오더",
        "polpl": "Złoty Porządek",
        "porbr": "Ordem de Ouro",
        "rusru": "Золотой Орден",
        "spaar": "Orden Dorada",
        "spaes": "Orden Dorada",
        "thath": "ออเดอร์ทอง",
        "zhocn": "黄金勋章",
        "zhotw": "黃金勳章",
    },
    "Gravity": {
        "engus": "Gravity",
        "deude": "Schwerkraft",
        "frafr": "La gravité",
        "itait": "Gravità",
        "jpnjp": "重力",
        "korkr": "중력",
        "polpl": "ciężar gatunkowy",
        "porbr": "Gravidade",
        "rusru": "Сила тяжести",
        "spaar": "Gravedad",
        "spaes": "Gravitatoria",
        "thath": "แรงโน้มถ่วง",
        "zhocn": "重力",
        "zhotw": "重力",
    },
    "Greataxes": {
        "engus": "Greataxes",
        "deude": "Großäxte",
        "frafr": "Grandes haches",
        "itait": "Grandi asce",
        "jpnjp": "グレートアクスの武器",
        "korkr": "대도끼",
        "polpl": "Wielkie topory",
        "porbr": "Grandes Machados",
        "rusru": "Большие топоры",
        "spaar": "Grande hachas",
        "spaes": "Grande hachas",
        "thath": "ขวานใหญ่",
        "zhocn": "巨斧武器",
        "zhotw": "巨斧武器",
    },
    "Greataxe Ashes": {
        "engus": "Greataxe Ashes",
        "deude": "Großaxt Asche",
        "frafr": "Cendres de Grande hache",
        "itait": "Ceneri del Grandascia",
        "jpnjp": "グレートアクスの灰",
        "korkr": "그레이트 액스 전회",
        "polpl": "Wielki topór Popiół",
        "porbr": "Cinzas de Machado Grande",
        "rusru": "Большой топор Пепел",
        "spaar": "Cenizas de Gran hacha",
        "spaes": "Cenizas de Gran hacha",
        "thath": "ขวาน​ยักษ์ เถ้า​สงคราม",
        "zhocn": "巨斧灰烬",
        "zhotw": "巨斧灰燼",
    },
    "Greatbows": {
        "engus": "Greatbows",
        "deude": "Großbögen",
        "frafr": "Grands arcs",
        "itait": "Grandi archi",
        "jpnjp": "大弓の武器",
        "korkr": "대궁 무기",
        "polpl": "Wielkie łuki",
        "porbr": "Grandes arcos",
        "rusru": "Большие луки",
        "spaar": "Grandes arcos",
        "spaes": "Grandes arcos",
        "thath": "ธนูใหญ่",
        "zhocn": "巨弓",
        "zhotw": "巨弓",
    },
    "Great Hammers": {
        "engus": "Great Hammers",
        "deude": "Großhammer",
        "frafr": "Grand marteau",
        "itait": "Grande Martello",
        "jpnjp": "大槌の武器",
        "korkr": "대형 망치",
        "polpl": "Wielki Młot",
        "porbr": "Grande Martelo",
        "rusru": "Великие молоты",
        "spaar": "Gran Martillo",
        "spaes": "Gran Martillo",
        "thath": "ค้อน​ใหญ่",
        "zhocn": "大锤",
        "zhotw": "大鎚",
    },
    "Great Hammer Ashes": {
        "engus": "Great Hammer Ashes",
        "deude": "Großhammer Asche",
        "frafr": "Cendres de Grand marteau",
        "itait": "Ceneri del Grande Martello",
        "jpnjp": "大槌の灰",
        "korkr": "대형 망치 전회",
        "polpl": "Wielki Młot Popiół",
        "porbr": "Cinzas de Grande Martelo",
        "rusru": "Большой молот Пепел",
        "spaar": "Cenizas de Gran Martillo",
        "spaes": "Cenizas de Gran Martillo",
        "thath": "ค้อน​ใหญ่ เถ้า​สงคราม",
        "zhocn": "大锤灰烬",
        "zhotw": "大鎚灰燼",
    },
    "Great Spears": {
        "engus": "Great Spears",
        "deude": "Großer Speer",
        "frafr": "Grande lance",
        "itait": "Grande Lancia",
        "jpnjp": "大槍の武器",
        "korkr": "그레이트 스피어",
        "polpl": "Wielka Włócznia",
        "porbr": "Grande Lança",
        "rusru": "Большое Копье",
        "spaar": "Gran lanza",
        "spaes": "Gran lanza",
        "thath": "หอกผู้ยิ่งใหญ่",
        "zhocn": "大矛",
        "zhotw": "大矛",
    },
    "Great Spear Ashes": {
        "engus": "Great Spear Ashes",
        "deude": "Großer Speer Asche",
        "frafr": "Cendres de Grande lance",
        "itait": "Ceneri del Grande Lancia",
        "jpnjp": "大槍の灰",
        "korkr": "그레이트 스피어 전회",
        "polpl": "Wielka Włócznia Popiół",
        "porbr": "Cinzas de Grande Lança",
        "rusru": "Большое Копье Пепел",
        "spaar": "Cenizas de Gran lanza",
        "spaes": "Cenizas de Gran lanza",
        "thath": "หอกผู้ยิ่งใหญ่ เถ้า​สงคราม",
        "zhocn": "大矛灰烬",
        "zhotw": "大矛灰燼",
    },
    "Greatshields": {
        "engus": "Greatshields",
        "deude": "Großer Schild",
        "frafr": "Grand Bouclier",
        "itait": "Grande Scudo",
        "jpnjp": "大盾の武器",
        "korkr": "그레이트 쉴드",
        "polpl": "Wielka Tarcza",
        "porbr": "Grande Escudo",
        "rusru": "Большой Щит",
        "spaar": "Gran escudo",
        "spaes": "Gran escudo",
        "thath": "โล่ใหญ่",
        "zhocn": "巨盾",
        "zhotw": "大盾",
    },
    "Greatswords": {
        "engus": "Greatswords",
        "deude": "Großschwerter",
        "frafr": "Grandes épées",
        "itait": "Grandispade",
        "jpnjp": "グレートソードの武器",
        "korkr": "그레이트소드",
        "polpl": "Wielkie Miecze",
        "porbr": "Grandes Espadas",
        "rusru": "Двуручные мечи",
        "spaar": "Grandes espadas",
        "spaes": "Grandes espadas",
        "thath": "ดาบใหญ่",
        "zhocn": "巨剑武器",
        "zhotw": "巨劍武器",
    },
    "Greatsword Ashes": {
        "engus": "Greatsword Ashes",
        "deude": "Großschwert Asche",
        "frafr": "Cendres de Grand espadon",
        "itait": "Ceneri del Spadone",
        "jpnjp": "グレートソードの灰",
        "korkr": "그레이트 소드 전회",
        "polpl": "Wielki miecz Popiół",
        "porbr": "Cinzas de Espada Grande",
        "rusru": "Двуручник Пепел",
        "spaar": "Cenizas de Espadón",
        "spaes": "Cenizas de Espadón",
        "thath": "ดาบ​ยักษ์ เถ้า​สงคราม",
        "zhocn": "巨剑灰烬",
        "zhotw": "巨劍灰燼",
    },
    "Greed": {
        "engus": "Greed",
        "deude": "Gier",
        "frafr": "Avidité",
        "itait": "Avidità",
        "jpnjp": "貪欲",
        "korkr": "탐욕",
        "polpl": "Chciwość",
        "porbr": "Ganância",
        "rusru": "Жадность",
        "spaar": "Codicia",
        "spaes": "Codicia",
        "thath": "ความโลภ",
        "zhocn": "贪婪",
        "zhotw": "貪婪",
    },
    "Halberds": {
        "engus": "Halberds",
        "deude": "Hellebarden",
        "frafr": "Hallebardes",
        "itait": "Alabarde",
        "jpnjp": "ハルバードの武器",
        "korkr": "할버드 무기",
        "polpl": "Halabardy",
        "porbr": "Alabardas",
        "rusru": "Алебарды",
        "spaar": "Alabardas",
        "spaes": "Alabardas",
        "thath": "อาวุธง้าว",
        "zhocn": "戟武器",
        "zhotw": "戟武器",
    },
    "Halberd Ashes": {
        "engus": "Halberd Ashes",
        "deude": "Hellebarde Asche",
        "frafr": "Cendres de Hallebarde",
        "itait": "Ceneri del Alabarda",
        "jpnjp": "ハルバードの灰",
        "korkr": "할버드 전회",
        "polpl": "Halabarda Popiół",
        "porbr": "Cinzas de Alabarda",
        "rusru": "Алебарда Пепел",
        "spaar": "Cenizas de Alabarda",
        "spaes": "Cenizas de Alabarda",
        "thath": "ง้าว​ปลายข​วาน เถ้า​สงคราม",
        "zhocn": "戟灰烬",
        "zhotw": "戟灰燼",
    },
    "Hammers": {
        "engus": "Hammers",
        "deude": "Hämmer",
        "frafr": "Marteaux",
        "itait": "Martelli",
        "jpnjp": "ハンマーの武器",
        "korkr": "망치",
        "polpl": "Młotki",
        "porbr": "Martelos",
        "rusru": "Молотки",
        "spaar": "Martillos",
        "spaes": "Martillos",
        "thath": "อาวุธค้อน",
        "zhocn": "锤子",
        "zhotw": "錘子",
    },
    "Hammer Ashes": {
        "engus": "Hammer Ashes",
        "deude": "Hammer Asche",
        "frafr": "Cendres de Marteau",
        "itait": "Ceneri del Martello",
        "jpnjp": "ハンマーの灰",
        "korkr": "해머 전회",
        "polpl": "Młot Popiół",
        "porbr": "Cinzas de Martelo",
        "rusru": "Молот Пепел",
        "spaar": "Cenizas de Martillo",
        "spaes": "Cenizas de Martillo",
        "thath": "ค้อน เถ้า​สงคราม",
        "zhocn": "石槌灰烬",
        "zhotw": "石槌灰燼",
    },
    "Heavy Thrusting Swords": {
        "engus": "Heavy Thrusting Swords",
        "deude": "Schweres Stoßschwert",
        "frafr": "Épée de poussée lourde",
        "itait": "Spada pesante e perforante",
        "jpnjp": "重突き剣の武器",
        "korkr": "무거운 찌르는 검",
        "polpl": "Ciężki miecz pchający",
        "porbr": "Espada perfurante pesada",
        "rusru": "Тяжелый колющий меч",
        "spaar": "Espada perforadora pesada",
        "spaes": "Espada perforadora pesada",
        "thath": "ดาบเจาะหนัก",
        "zhocn": "重刺剑",
        "zhotw": "重刺劍",
    },
    "Heavy Thrusting Sword Ashes": {
        "engus": "Heavy Thrusting Sword Ashes",
        "deude": "Schweres Stoßschwert Asche",
        "frafr": "Cendres de Épée de poussée lourde",
        "itait": "Ceneri del Spada pesante e perforante",
        "jpnjp": "重突き剣の灰",
        "korkr": "무거운 찌르는 검 전회",
        "polpl": "Ciężki miecz pchający Popiół",
        "porbr": "Cinzas de Espada perfurante pesada",
        "rusru": "Тяжелый колющий меч Пепел",
        "spaar": "Cenizas de Espada perforadora pesada",
        "spaes": "Cenizas de Espada perforadora pesada",
        "thath": "ดาบเจาะหนัก เถ้า​สงคราม",
        "zhocn": "重刺剑灰烬",
        "zhotw": "重刺劍灰燼",
    },
    "Holy": {
        "engus": "Holy",
        "deude": "Heilig",
        "frafr": "Saint",
        "itait": "Santo",
        "jpnjp": "聖なる",
        "korkr": "거룩한",
        "polpl": "Święty",
        "porbr": "Santo",
        "rusru": "Святой",
        "spaar": "Santo",
        "spaes": "Santo",
        "thath": "ศักดิ์สิทธิ์",
        "zhocn": "圣",
        "zhotw": "聖",
    },
    "Katanas": {
        "engus": "Katanas",
        "deude": "Katana",
        "frafr": "Katana",
        "itait": "Katana",
        "jpnjp": "刀の武器",
        "korkr": "카타나",
        "polpl": "Katana",
        "porbr": "Katana",
        "rusru": "Катана",
        "spaar": "Katana",
        "spaes": "Katana",
        "thath": "คาทานา",
        "zhocn": "武士刀",
        "zhotw": "武士刀",
    },
    "Katana Ashes": {
        "engus": "Katana Ashes",
        "deude": "Katana Asche",
        "frafr": "Cendres de Katana",
        "itait": "Ceneri del Katana",
        "jpnjp": "刀の灰",
        "korkr": "카타나 전회",
        "polpl": "Katana Popiół",
        "porbr": "Cinzas de Katana",
        "rusru": "Катана Пепел",
        "spaar": "Cenizas de Katana",
        "spaes": "Cenizas de Katana",
        "thath": "คาทานา เถ้า​สงคราม",
        "zhocn": "武士刀灰烬",
        "zhotw": "武士刀灰燼",
    },
    "Light Bows": {
        "engus": "Light Bows",
        "deude": "Leichter Bogen",
        "frafr": "Arc léger",
        "itait": "Arco leggero",
        "jpnjp": "軽い弓の武器",
        "korkr": "가벼운 활",
        "polpl": "Lekki Łuk",
        "porbr": "Arco leve",
        "rusru": "Легкий лук",
        "spaar": "Arco ligero",
        "spaes": "Arco ligero",
        "thath": "ไลท์โบว์",
        "zhocn": "轻弓",
        "zhotw": "輕弓",
    },
    "Lightning": {
        "engus": "Lightning",
        "deude": "Blitz",
        "frafr": "Foudre",
        "itait": "Fulmine",
        "jpnjp": "雷",
        "korkr": "벼락",
        "polpl": "błyskawic",
        "porbr": "Relâmpago",
        "rusru": "молнии",
        "spaar": "Rayo",
        "spaes": "Rayo",
        "thath": "สายฟา",
        "zhocn": "雷电",
        "zhotw": "雷電",
    },
    "Lord": {
        "engus": "Lord",
        "deude": "Fürst",
        "frafr": "Seigneur",
        "itait": "Lord",
        "jpnjp": "王",
        "korkr": "왕",
        "polpl": "Władca",
        "porbr": "Lorde",
        "rusru": "повелитель",
        "spaar": "Señor",
        "spaes": "Señor",
        "thath": "ราชา",
        "zhocn": "王",
        "zhotw": "王",
    },
    "Magic": {
        "engus": "Magic",
        "deude": "Magie",
        "frafr": "la magie",
        "itait": "Magia",
        "jpnjp": "魔法",
        "korkr": "마법",
        "polpl": "magia",
        "porbr": "Magia",
        "rusru": "Магия",
        "spaar": "magia",
        "spaes": "magia",
        "thath": "มายากล",
        "zhocn": "魔法",
        "zhotw": "魔法",
    },
    "Medium Shields": {
        "engus": "Medium Shields",
        "deude": "Mittlerer Schild",
        "frafr": "Bouclier moyen",
        "itait": "Scudo medio",
        "jpnjp": "中盾の武器",
        "korkr": "미디엄 쉴드",
        "polpl": "Średnia Tarcza",
        "porbr": "Escudo Médio",
        "rusru": "Средний щит",
        "spaar": "Escudo medio",
        "spaes": "Escudo medio",
        "thath": "โล่กลาง",
        "zhocn": "中型盾牌",
        "zhotw": "中型盾牌",
    },
    "Melee Ashes": {
        "engus": "Melee Ashes",
        "deude": "Nahkampfasche",
        "frafr": "Cendres de mêlée",
        "itait": "Ceneri da mischia",
        "jpnjp": "近接灰",
        "korkr": "근접전 전회",
        "polpl": "Popiół do walki wręcz",
        "porbr": "Melee Cinzas",
        "rusru": "Пепел ближнего боя",
        "spaar": "Cenizas cuerpo a cuerpo",
        "spaes": "Cenizas cuerpo a cuerpo",
        "thath": "ระยะประชิดขี้เถ้า",
        "zhocn": "近战灰烬",
        "zhotw": "近戰灰燼",
    },
    "Offense": {
        "engus": "Offense",
        "deude": "Angriff",
        "frafr": "Attaque",
        "itait": "Attaccare",
        "jpnjp": "攻撃",
        "korkr": "공격",
        "polpl": "Agresja",
        "porbr": "Atacar",
        "rusru": "Нападение",
        "spaar": "Atacar",
        "spaes": "Atacar",
        "thath": "ต่อสู้",
        "zhocn": "攻击",
        "zhotw": "攻擊",
    },
    "Perfume": {
        "engus": "Perfume",
        "deude": "Parfüm",
        "frafr": "Parfum",
        "itait": "Profumo",
        "jpnjp": "香水",
        "korkr": "향수",
        "polpl": "Perfum",
        "porbr": "Perfume",
        "rusru": "Духи",
        "spaar": "Perfume",
        "spaes": "Perfume",
        "thath": "น้ำหอม",
        "zhocn": "香水",
        "zhotw": "香水",
    },
    "Poison": {
        "engus": "Poison",
        "deude": "Gift",
        "frafr": "Poison",
        "itait": "Veleno",
        "jpnjp": "毒",
        "korkr": "독",
        "polpl": "Zatruć",
        "porbr": "Veneno",
        "rusru": "яда",
        "spaar": "Veneno",
        "spaes": "Veneno",
        "thath": "พิษ",
        "zhocn": "毒",
        "zhotw": "毒",
    },
    "Pots": {
        "engus": "Pots",
        "deude": "Töpfe",
        "frafr": "Pots",
        "itait": "Vasi",
        "jpnjp": "壺",
        "korkr": "항아리",
        "polpl": "Garnki",
        "porbr": "Potes",
        "rusru": "Горшки",
        "spaar": "Macetas",
        "spaes": "Frasco",
        "thath": "ไห",
        "zhocn": "壶",
        "zhotw": "壺",
    },
    "Priest": {
        "engus": "Priest",
        "deude": "Priester",
        "frafr": "Prêtre",
        "itait": "Sacerdote",
        "jpnjp": "祭司",
        "korkr": "성직자",
        "polpl": "Kapłan",
        "porbr": "Sacerdote",
        "rusru": "Священник",
        "spaar": "Sacerdote",
        "spaes": "Sacerdote",
        "thath": "นักบวช",
        "zhocn": "牧师",
        "zhotw": "牧師",
    },
    "Reapers": {
        "engus": "Reapers",
        "deude": "Schnitter",
        "frafr": "Fauchet",
        "itait": "Mietitori",
        "jpnjp": "鎌の武器",
        "korkr": "회복 무기",
        "polpl": "Żniwiarze",
        "porbr": "Ceifadores",
        "rusru": "коса",
        "spaar": "Guadañas",
        "spaes": "Guadañas",
        "thath": "เคียว",
        "zhocn": "收割者",
        "zhotw": "收割者",
    },
    "Reaper Ashes": {
        "engus": "Reaper Ashes",
        "deude": "Sense Asche",
        "frafr": "Cendres de Fauchet",
        "itait": "Ceneri del Falce",
        "jpnjp": "鎌の灰",
        "korkr": "큰 낫 전회",
        "polpl": "Kosa Popiół",
        "porbr": "Cinzas de Foice",
        "rusru": "коса Пепел",
        "spaar": "Cenizas de Guadaña",
        "spaes": "Cenizas de Guadaña",
        "thath": "เคียว เถ้า​สงคราม",
        "zhocn": "大镰刀灰烬",
        "zhotw": "大鐮刀灰燼",
    },
    "Recovery": {
        "engus": "Recovery",
        "deude": "Genesung",
        "frafr": "Récupération",
        "itait": "Recupero",
        "jpnjp": "回復アイテム",
        "korkr": "회복 아이템",
        "polpl": "Powrót do zdrowia",
        "porbr": "Recuperação",
        "rusru": "Восстановление",
        "spaar": "Recuperación",
        "spaes": "Recuperación",
        "thath": "การกู้คืน",
        "zhocn": "恢复物品",
        "zhotw": "恢復物品",
    },
    "Roar": {
        "engus": "Roar",
        "deude": "Brüllen",
        "frafr": "Rugir",
        "itait": "Ruggito",
        "jpnjp": "咆哮",
        "korkr": "노호",
        "polpl": "Ryk",
        "porbr": "Rugido",
        "rusru": "Рев",
        "spaar": "Rugido",
        "spaes": "Rugido",
        "thath": "คำราม",
        "zhocn": "吼",
        "zhotw": "吼",
    },
    "Rot": {
        "engus": "Rot",
        "deude": "Verrotten",
        "frafr": "Pourrir",
        "itait": "Marcire",
        "jpnjp": "腐敗",
        "korkr": "썩음",
        "polpl": "Gnić",
        "porbr": "Apodrecimento",
        "rusru": "Гниль",
        "spaar": "Putrefacción",
        "spaes": "Putrefacción",
        "thath": "เน่า",
        "zhocn": "腐烂",
        "zhotw": "腐爛",
    },
    "Seals": {
        "engus": "Seals",
        "deude": "Siegel",
        "frafr": "Sceau",
        "itait": "Sigillo",
        "jpnjp": "聖印の武器",
        "korkr": "성인",
        "polpl": "Pieczęć",
        "porbr": "Selo",
        "rusru": "Печать",
        "spaar": "Sello",
        "spaes": "Sello",
        "thath": "ตรา​ประทับ",
        "zhocn": "圣印记",
        "zhotw": "聖印記",
    },
    "Sleep": {
        "engus": "Sleep",
        "deude": "Schlafen",
        "frafr": "Dormir",
        "itait": "Sonno",
        "jpnjp": "寝る",
        "korkr": "잠",
        "polpl": "Spać",
        "porbr": "Sono",
        "rusru": "Спать",
        "spaar": "Dormir",
        "spaes": "Dormir",
        "thath": "นอน",
        "zhocn": "睡觉",
        "zhotw": "睡覺",
    },
    "Small Shields": {
        "engus": "Small Shields",
        "deude": "Kleiner Schild",
        "frafr": "Petit Bouclier",
        "itait": "Piccolo scudo",
        "jpnjp": "小さな盾の武器",
        "korkr": "작은 방패",
        "polpl": "Mała Tarcza",
        "porbr": "Escudo Pequeno",
        "rusru": "Маленький Щит",
        "spaar": "Escudo pequeño",
        "spaes": "Escudo pequeño",
        "thath": "โล่เล็ก",
        "zhocn": "小盾",
        "zhotw": "小盾",
    },
    "Smithing": {
        "engus": "Smithing",
        "deude": "Schmieden",
        "frafr": "Forge",
        "itait": "Forgiatura",
        "jpnjp": "鍛冶",
        "korkr": "스미딩",
        "polpl": "Smithinga",
        "porbr": "Soares",
        "rusru": "Кузнечное дело",
        "spaar": "herrería",
        "spaes": "herrería",
        "thath": "การตีเหล็ก",
        "zhocn": "锻造",
        "zhotw": "鍛造",
    },
    "Sorcerer": {
        "engus": "Sorcerer",
        "deude": "Zauberer",
        "frafr": "Sorcier",
        "itait": "Stregone",
        "jpnjp": "魔術師",
        "korkr": "마법사",
        "polpl": "Czarownik",
        "porbr": "Feiticeiro",
        "rusru": "Колдун",
        "spaar": "Hechicero",
        "spaes": "Hechicero",
        "thath": "หมอผี",
        "zhocn": "巫师",
        "zhotw": "巫師",
    },
    "Spears": {
        "engus": "Spears",
        "deude": "Speere",
        "frafr": "Lances",
        "itait": "Lance",
        "jpnjp": "スピアの武器",
        "korkr": "스피어스",
        "polpl": "Włócznie",
        "porbr": "Lanças",
        "rusru": "Спирс",
        "spaar": "Lanzas",
        "spaes": "Lanzas",
        "thath": "อาวุธหอก",
        "zhocn": "斯皮尔斯",
        "zhotw": "史皮爾斯",
    },
    "Spear Ashes": {
        "engus": "Spear Ashes",
        "deude": "Speer Asche",
        "frafr": "Cendres de Lance",
        "itait": "Ceneri del Lancia",
        "jpnjp": "スピアの灰",
        "korkr": "스피어 전회",
        "polpl": "Włócznia Popiół",
        "porbr": "Cinzas de Lança",
        "rusru": "Копьё Пепел",
        "spaar": "Cenizas de Lanza",
        "spaes": "Cenizas de Lanza",
        "thath": "หอก เถ้า​สงคราม",
        "zhocn": "矛灰烬",
        "zhotw": "矛灰燼",
    },
    "Spirits": {
        "engus": "Spirits",
        "deude": "Geist",
        "frafr": "Esprits",
        "itait": "Spiriti",
        "jpnjp": "霊",
        "korkr": "혼",
        "polpl": "Duchów",
        "porbr": "Espíritos",
        "rusru": "духов",
        "spaar": "Espíritus",
        "spaes": "Espíritus",
        "thath": "วิญญาณ",
        "zhocn": "魂",
        "zhotw": "魂",
    },
    "Stats": {
        "engus": "Stats",
        "deude": "Statistiken",
        "frafr": "Statistiques",
        "itait": "Statistiche",
        "jpnjp": "統計",
        "korkr": "통계",
        "polpl": "Statystyki",
        "porbr": "Estatísticas",
        "rusru": "Статистика",
        "spaar": "Estadísticas",
        "spaes": "Estadísticas",
        "thath": "สถิติ",
        "zhocn": "统计数据",
        "zhotw": "統計數據",
    },
    "Staves": {
        "engus": "Staves",
        "deude": "Stab",
        "frafr": "Bâton",
        "itait": "Bastone",
        "jpnjp": "杖の武器",
        "korkr": "지팡이",
        "polpl": "Kostur",
        "porbr": "Cajado",
        "rusru": "Посох",
        "spaar": "Báculo",
        "spaes": "Bastón",
        "thath": "คทา",
        "zhocn": "杖",
        "zhotw": "杖",
    },
    "Stealth": {
        "engus": "Stealth",
        "deude": "Heimlichkeit",
        "frafr": "Furtivité",
        "itait": "Furtivo",
        "jpnjp": "秘密",
        "korkr": "몰래 하기",
        "polpl": "Ukradkowy",
        "porbr": "Furtividade",
        "rusru": "Скрытность",
        "spaar": "Sigilo",
        "spaes": "Sigilo",
        "thath": "ชิงทรัพย์",
        "zhocn": "隐身",
        "zhotw": "隱身",
    },
    "Straight Swords": {
        "engus": "Straight Swords",
        "deude": "Gerades Schwert",
        "frafr": "Épée droite",
        "itait": "Spada dritta",
        "jpnjp": "直剣の武器",
        "korkr": "직선검",
        "polpl": "Prosty Miecz",
        "porbr": "Espada reta",
        "rusru": "Прямой меч",
        "spaar": "Espada recta",
        "spaes": "Espada recta",
        "thath": "ดาบตรง",
        "zhocn": "直剑",
        "zhotw": "直劍",
    },
    "Straight Sword Ashes": {
        "engus": "Straight Sword Ashes",
        "deude": "Gerades Schwert Asche",
        "frafr": "Cendres de Épée droite",
        "itait": "Ceneri del Spada dritta",
        "jpnjp": "直剣の灰",
        "korkr": "직선검 전회",
        "polpl": "Prosty Miecz Popiół",
        "porbr": "Cinzas de Espada reta",
        "rusru": "Прямой меч Пепел",
        "spaar": "Cenizas de Espada recta",
        "spaes": "Cenizas de Espada recta",
        "thath": "ดาบตรง เถ้า​สงคราม",
        "zhocn": "直剑灰烬",
        "zhotw": "直劍灰燼",
    },
    "Thrusting Swords": {
        "engus": "Thrusting Swords",
        "deude": "Stoßendes Schwert",
        "frafr": "Épée de poussée",
        "itait": "Spada perforante",
        "jpnjp": "突き剣の武器",
        "korkr": "찌르는 검",
        "polpl": "Pchający Miecz",
        "porbr": "Espada perfurante",
        "rusru": "Пронзающий меч",
        "spaar": "Espada perforadora",
        "spaes": "Espada perforadora",
        "thath": "แทงดาบ",
        "zhocn": "刺剑武器",
        "zhotw": "刺劍武器",
    },
    "Thrusting Sword Ashes": {
        "engus": "Thrusting Sword Ashes",
        "deude": "Stoßendes Schwert Asche",
        "frafr": "Cendres de Épée de poussée",
        "itait": "Ceneri del Spada perforante",
        "jpnjp": "突き剣の灰",
        "korkr": "찌르는 검 전회",
        "polpl": "Pchający Miecz Popiół",
        "porbr": "Cinzas de Espada perfurante",
        "rusru": "Пронзающий меч Пепел",
        "spaar": "Cenizas de Espada perforadora",
        "spaes": "Cenizas de Espada perforadora",
        "thath": "แทงดาบ เถ้า​สงคราม",
        "zhocn": "刺剑灰烬",
        "zhotw": "刺劍灰燼",
    },
    "Torches": {
        "engus": "Torches",
        "deude": "Fackeln",
        "frafr": "Torches",
        "itait": "Torce",
        "jpnjp": "松明の武器",
        "korkr": "횃불 무기",
        "polpl": "Pochodnie",
        "porbr": "Tochas",
        "rusru": "Факелы",
        "spaar": "Antorchas",
        "spaes": "Antorchas",
        "thath": "คบเพลิง",
        "zhocn": "火把武器",
        "zhotw": "火把武器",
    },
    "Twinblades": {
        "engus": "Twinblades",
        "deude": "Zwillingsklingen",
        "frafr": "Lames jumelles",
        "itait": "Lame gemelle",
        "jpnjp": "ツインブレードの武器",
        "korkr": "쌍날검",
        "polpl": "Bliźniacze ostrza",
        "porbr": "Lâminas Duplas",
        "rusru": "Твинблейды",
        "spaar": "Cuchillas Gemelas",
        "spaes": "Hojas dobles",
        "thath": "ใบมีดแฝด",
        "zhocn": "双头剑武器",
        "zhotw": "雙頭劍武器",
    },
    "Twinblade Ashes": {
        "engus": "Twinblade Ashes",
        "deude": "Doppelklinge Asche",
        "frafr": "Cendres de Lame double",
        "itait": "Ceneri del Lama gemella",
        "jpnjp": "ツインブレードの灰",
        "korkr": "트윈 블레이드 전회",
        "polpl": "Podwójne ostrze Popiół",
        "porbr": "Cinzas de Lâminas-Gêmeas",
        "rusru": "Парный клинок Пепел",
        "spaar": "Cenizas de Hojas gemelas",
        "spaes": "Cenizas de Hoja doble",
        "thath": "ดาบส​อง​ปลาย เถ้า​สงคราม",
        "zhocn": "双刀片",
        "zhotw": "雙頭劍灰燼",
    },
    "Whips": {
        "engus": "Whips",
        "deude": "Peitschen",
        "frafr": "Fouets",
        "itait": "Fruste",
        "jpnjp": "ウィップの武器",
        "korkr": "채찍 무기",
        "polpl": "Bicze",
        "porbr": "Chicotes",
        "rusru": "Кнуты",
        "spaar": "Látigos",
        "spaes": "Látigos",
        "thath": "อาวุธแส้",
        "zhocn": "鞭子",
        "zhotw": "鞭子",
    },
}
