# Copyright (c) 2023 The Old Man and the C
#
# This file is part of Elden Ring Randomizer Hints.
#
# Elden Ring Randomizer Hints is free software: you can redistribute it and/or
# modify it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Elden Ring Randomizer Hints is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
# or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License
# for more details.
#
# You should have received a copy of the GNU Affero General Public License along
# with Elden Ring Randomizer Hints. If not, see <https://www.gnu.org/licenses/>.

uiText_engus = {
    "mainController": {
        "changeLanguageTitle_engus": "Restart Required",
        "changeLanguagePrompt_engus": "Changing the language requires a restart. Please quit and restart the program.",
        "changeLanguageTitle_deude": "Neustart erforderlich",
        "changeLanguagePrompt_deude": "Das Ändern der Sprache erfordert einen Neustart. Bitte beenden Sie das Programm und starten Sie es neu.",
        "changeLanguageTitle_frafr": "Redémarrage requis",
        "changeLanguagePrompt_frafr": "Changer la langue nécessite un redémarrage. Veuillez quitter et redémarrer le programme.",
        "changeLanguageTitle_itait": "Riavvio richiesto",
        "changeLanguagePrompt_itait": "La modifica della lingua richiede un riavvio. Si prega di uscire e riavviare il programma.",
        "changeLanguageTitle_jpnjp": "再起動が必要です",
        "changeLanguagePrompt_jpnjp": "言語を変更するには再起動が必要です。 プログラムを終了して再起動してください。",
        "changeLanguageTitle_korkr": "다시 시작 필요",
        "changeLanguagePrompt_korkr": "언어를 변경하려면 다시 시작해야 합니다. 프로그램을 종료하고 다시 시작하십시오.",
        "changeLanguageTitle_polpl": "Wymagane jest ponowne uruchomienie",
        "changeLanguagePrompt_polpl": "Zmiana języka wymaga ponownego uruchomienia. Proszę wyjść i uruchomić ponownie program.",
        "changeLanguageTitle_porbr": "Reinicialização necessária",
        "changeLanguagePrompt_porbr": "Alterar o idioma requer uma reinicialização. Feche e reinicie o programa.",
        "changeLanguageTitle_rusru": "Требуется перезагрузка",
        "changeLanguagePrompt_rusru": "Изменение языка требует перезагрузки. Пожалуйста, закройте и перезапустите программу.",
        "changeLanguageTitle_spaar": "Reinicio requerido",
        "changeLanguagePrompt_spaar": "Cambiar el idioma requiere un reinicio. Salga y reinicie el programa.",
        "changeLanguageTitle_spaes": "Reinicio requerido",
        "changeLanguagePrompt_spaes": "Cambiar el idioma requiere un reinicio. Salga y reinicie el programa.",
        "changeLanguageTitle_thath": "จำเป็นต้องรีสตาร์ท",
        "changeLanguagePrompt_thath": "การเปลี่ยนภาษาจำเป็นต้องรีสตาร์ท กรุณาออกและรีสตาร์ทโปรแกรม",
        "changeLanguageTitle_zhocn": "需要重新启动",
        "changeLanguagePrompt_zhocn": "更改语言需要重新启动。 请退出并重新启动该程序。",
        "changeLanguageTitle_zhotw": "需要重新啟動",
        "changeLanguagePrompt_zhotw": "更改語言需要重新啟動。 請退出並重新啟動該程式。",
        "languageChangedTitle": "Language Changed",
        "languageChangedPrompt": "The language has changed. If you want localized category names, it is recommended that you \"Reload default categories\" in the \"Edit Categories\" tab, then \"Reload default category selections\" in the \"Category Selections\" tab. However, this is not required.",
        "newTitle": "New Category",
        "newPrompt": "Enter the name for the new category:",
        "renameTitle": "Rename Category",
        "renamePrompt": "Enter the new name for the category:",
        "reloadTitle": "Reload defaults?",
        "reloadPrompt": "Are you sure you want to reload the default hint categories? This cannot be undone.",
        "reloadActivePrompt": "Are you sure you want to reload the default active category lists? This cannot be undone.",
        "shopTitle": "Load Shop Inventory",
        "shopPrompt": "Are you sure you want to load the Twin Maiden Husks shop inventory?  Any changes to the inventory you have made will be lost.",
        "invalidMaidenTitle": "Can't Add Finger Maiden Item",
        "invalidPropertyTitle": "Can't Set Property",
        "invalidDropPrompt": "Only individual item hints can have the \"drop only\" property set.",
        "fullMaidenPrompt": "Finger Maiden item lots are full. Note that four hints can be contained in one item lot.",
        "maidenSpace": "{}/{} item lots used, room for {} more hints in currently used lots",
        "itemPriceTitle": "Set Item Price",
        "itemPricePrompt": "Enter the price of the item in runes:",
        "clearConsoleTitle": "Clear Console?",
        "clearConsolePrompt": "Are you sure you want to clear the console panel?",
        "saveSettingsTitle": "Save Settings",
        "loadSettingsTitle": "Load Settings",
        "settingsFileType": "Elden Ring Randomizer Hints Settings",
        "exportSettingsTitle": "Export Settings",
        "importSettingsTitle": "Import Settings",
        "exportSettingsFileType": "Elden Ring Randomizer Hints Export",
        "shopChangedText": "\nNOTICE: The base inventory of the Twin Maiden Husks shop has changed, so any changes to the shop have been reset. Please check the \"Starting Items\" tab.\n",
        "shopChangedTitle": "Shop Inventory Changed",
        "shopChangedPrompt": "The base inventory of the Twin Maiden Husks shop has changed, so any changes to the shop have been reset.",
        "loadSettingsText": "\nLoading settings...",
        "importSettingsText": "\nImporting settings...",
        "readSpoilersText": "Reading Elden Ring Item and Enemy Randomizer spoiler file...",
        "seedText": "Randomizer seed: {}",
        "fogSeedText": "Fog gate randomizer seed: {}",
        "readFogText": "Reading Elden Ring Fog Gate Randomizer spoiler file...",
        "readRegulationText": "Reading regulation.bin file...",
        "invalidPathsText": "File paths are not valid.  Please select valid executables.\n",
        "notBuildReadyText": "No randomizers are enabled, hint generation disabled.",
        "buildReadyText": "File paths are valid, ready to generate hints.\nClick the \"Generate Hints\" button when ready to proceed.",
        "noBuildText": "No randomizers enabled, nothing to generate! Please enable a randomizer and try again.",
        "readingFilesText": "\nReading XML files...",
        "generatingHintsText": "Starting item hint generation...",
        "generatingFogHintsText": "Starting fog gate hint generation...",
        "usedSeedText": "Using seed: {}",
        "processingItemsText": "Processing items...",
        "numLotsText": "Number of item lots: {}",
        "useMaidenItemsText": "Building Finger Maiden items and hints in Chapel of Anticipation...",
        "useQuestHintsText": "Building quest hints...",
        "useCategoryHintsText": "Building category hints...",
        "useChestHintsText": "Adding item hints to chests...",
        "useBossHintsText": "Adding item hints to boss drops...",
        "useNearbyHintsText": "Adding important gate key item hints to nearby locations...",
        "useNearbyFogHintsText": "Adding gate hints to nearby locations...",
        "useChestFogHintsText": "Adding gate hints to chests...",
        "useBossFogHintsText": "Adding gate hints to boss drops...",
        "numItemsText": "Number of placed items: {}",
        "numHintsText": "Number of generated hint items: {}",
        "totalNumHintsText": "Total number of generated hint items: {}",
        "useShopText": "Making changes to Twin Maiden Husks shop...",
        "shopNumText": "Number of changed inventory entries: {}",
        "writingFilesText": "Writing XML files...",
        "writingParamsText": "Building regulation.bin from params...",
        "tomlText": "Generating Mod Engine configuration file...",
        "buildDoneText": "Hint generation complete!  Please start a new game.\n",
        "buildError": "There were errors during the hint generation process. Please check your executable installations.\n",
        "missingXMLFileError": "ERROR: Missing {} XML file for {}",
        "witchyError": "Make sure oo2core_6_win64.dll has been installed in WitchyBND's folder.",
        "yabberError": "Make sure oo2core_6_win64.dll has been installed in Yabber's lib folder.",
    },
    "mainView": {
        "settingsTab": "Elden Ring Randomizer Hints",
        "missableTab": "Missable Items",
        "selectCategoriesTab": "Category Selections",
        "startingTab": "Starting Items",
        "editCategoriesTab": "Edit Categories"
    },
    "settingsPane": {
        "gameLabel": "Elden Ring executable",
        "gameButton": "Select Elden Ring",
        "gameTooltip": "A valid path to the Elden Ring game executable. Required to generate hints.",
        "gameFileType": "Elden Ring",
        "randomizerLabel": "Elden Ring Item and Enemy Randomizer executable (optional)",
        "randomizerButton": "Select Randomizer",
        "randomizerTooltip": "A valid path to the Elden Ring Item and Enemy Randomizer executable. Only required if using it.",
        "randomizerFileType": "Elden Ring Item and Enemy Randomizer",
        "fogLabel": "Elden Ring Fog Gate Randomizer executable (optional)",
        "fogButton": "Select Fog Randomizer",
        "fogTooltip": "A valid path to the Elden Ring Fog Gate Randomizer executable. Only required if using it. Note that this mod is only intended for use with the fog gate randomizer's World Shuffle mode. Other modes may have unexpected results.",
        "fogFileType": "Elden Ring Fog Gate Randomizer",
        "yabberLabel": "Yabber/WitchyBND executable",
        "yabberButton": "Select Yabber/WitchyBND",
        "yabberTooltip": "A valid path to either the Yabber or WitchyBND executable. Required to generate hints.",
        "yabberFileType": "Yabber",
        "witchyBNDFileType": "WitchyBND",
        "dsmspLabel": "DSMSPortable executable",
        "dsmspButton": "Select DSMSPortable",
        "dsmspTooltip": "A valid path to the DSMSPortable executable. Required to generate hints.",
        "dsmspFileType": "DSMSPortable",
        "fileDialog": "Choose File",
        "dirDialog": "Choose Directory",
        "languageText": "Language",
        "languageTooltip": "Change the language. (Requires restart)",
        "useRandomizerText": "Use Elden Ring Item and Enemy Randomizer",
        "useRandomizerTooltip": "Enable if using the Elden Ring Item and Enemy Randomizer, even if none of the following item hint options are enabled, so that the Mod Engine files will have the correct references.",
        "seedLabel": "Custom seed:",
        "seedTooltip": "Enter a custom random seed that will be used to generate item hints. If left blank, the seed from the Elden Ring Item and Enemy Randomizer spoiler file will be used.",
        "useQuestHintsText": "Generate hints for NPC quest items",
        "useQuestHintsTooltip": "Enable to place hints in NPC item lots that point to the actual items required for their quests.",
        "useCategoryHintsText": "Generate hints with items in the same category",
        "useCategoryHintsTooltip": "Enable to place hints in item locations that point to other items in the same categories. For any given item location, a hint object will be placed with hints pointing to other items in the same categories as the items that are found there. This only applies to items in \"General Categories\". You can set these categories in the \"Category Selections\" tab.",
        "useNeighboringBiasText": "Bias category hints towards nearby regions",
        "useNeighboringBiasTooltip": "Enable to make category hints more likely to point to items in regions closer to where the hint object is found. Note that this option will do nothing if the Elden Ring Fog Gate Randomizer is used.",
        "percentHintsText": "Generate item hints in",
        "chestHintsPercentText": "% of chests",
        "changePercentButton": "Change %",
        "getPercentTitle": "Enter Percentage",
        "getPercentPrompt": "Enter the new percentage:",
        "useChestHintsTooltip": "Enable to place hints for items in the \"Chest Categories\" into a percentage of all chests. You can set these categories in the \"Category Selections\" tab.",
        "bossHintsPercentText": "% of boss drops",
        "useBossHintsTooltip": "Enable to place hints for items in the \"Boss Categories\" into a percentage of all boss drops. You can set these categories in the \"Category Selections\" tab.",
        "useNearbyHintsText": "Generate hints for key items to important gates and warps nearby",
        "useNearbyHintsTooltip": "Enable to place hints for key items that are needed for important gates and warps in random locations near those gates. This includes the Dectus, Rold, and Haligtree Secret Medallions, the Academy Glintstone Key, the Carian Inverted Statue, the Imbued Sword Keys, and the Dark Moon Ring. Note that a hint to the Drawing-Room Key is available from Tanith under the \"Generate hints for NPC quest items\" option.",
        "useAllDirectionsText": "Use compass directions for all hints",
        "useAllDirectionsTooltip": "Normally hints to items in large areas show compass directions and distance estimates from the nearest map landmark, but hints to items in smaller named areas only show the area name. Enable to show this directional information in all item hints.",
        "useFogText": "Use Elden Ring Fog Gate Randomizer",
        "useFogTooltip": "Enable if using the Elden Ring Fog Gate Randomizer, even if none of the following fog hint options are enabled, so that the Mod Engine files will have the correct references. Note that area descriptions in both item and gate hints will be different from the base game.",
        "fogSeedLabel": "Custom fog seed:",
        "fogSeedTooltip": "Enter a custom random seed that will be used to generate fog gate hints. If left blank, the seed from the Elden Ring Fog Gate Randomizer spoiler file will be used.",
        "useNearbyFogHintsText": "Generate fog gate hints near gates",
        "useNearbyFogHintsTooltip": "Enable to place hints for fog gates and warps in random locations near those gates. Note that some gates may not have available locations or space within available locations.",
        "percentFogHintsText": "Generate fog gate hints in",
        "useChestFogHintsText": "Generate fog gate hints in chests",
        "useChestFogHintsTooltip": "Enable to place hints for fog gates and warps into a percentage of all chests. These hints are not limited to the area the chest is in.",
        "useBossFogHintsText": "Generate fog gate hints in boss drops",
        "useBossFogHintsTooltip": "Enable to place hints for fog gates and warps into a percentage of all boss drops. These hints are not limited to the area the boss is in.",
        "useMaidenItemsText": "Add items to Finger Maiden corpse in Chapel of Anticipation",
        "useMaidenItemsTooltip": "Enable to add items and/or item hints to the Finger Maiden corpse in the Chapel of Anticipation at the start of the game. You can set these in the \"Starting Items\" tab. Note that if the Elden Ring Item and Enemy Randomizer is not being used, item hints and category hints will not be placed.",
        "useShopText": "Use custom shop inventory for Twin Maiden Husks in Roundtable Hold",
        "useShopTooltip": "Enable to set a custom shop inventory for the Twin Maiden Husks shop in Roundtable Hold. You can edit this in the \"Starting Items\" tab.",
        "buildButton": "Generate Hints",
        "buildTooltip": "Start generating the hints that will be placed in the game world.",
        "consoleLabel": "Console:",
        "consoleTooltip": "Output panel displaying processing results.",
        "consoleClearButton": "Clear Console",
        "consoleClearTooltip": "Clear the contents of the console panel.",
        "consoleCopyButton": "Copy Console",
        "consoleCopyTooltip": "Copy the contents of the console panel to the clipboard.",
        "loadSettingsButton": "Load Settings",
        "loadSettingsTooltip": "Load all settings, categories, and starting items from a file. Warning, all current settings, categories, and starting items will be lost.",
        "saveSettingsButton": "Save Settings",
        "saveSettingsTooltip": "Save all settings, categories, and starting items to a file.",
        "importSettingsButton": "Import Settings",
        "importSettingsTooltip": "Import all categories, Finger Maiden items, and non-file path settings from a portable settings file. File paths and shop changes will not be changed.",
        "exportSettingsButton": "Export Settings",
        "exportSettingsTooltip": "Export all categories, Finger Maiden items, and non-file path settings to a file, for portable settings transfer. Note that shop changes will not be exported.",
        "helpIcon": "General settings and hint generation. File paths must be valid before generating hints or editing the Twin Maiden Husks shop inventory."
    },
    "missablePane": {
        "missableLabel": "Missable Items:",
        "selectorTooltip": "Items that can easily be missed or are impossible to get. Select an item to reveal information about how it is obtained.",
        "spoilersLabel": "Spoilers:",
        "spoilersTooltip": "Spoilers about how to obtain the item selected in the panel to the left.",
        "helpIcon": "Missable Items. Items which are impossible to get or easily missed are shown here. Select an item to reveal information about how to obtain it and how it can be missed. If any of these items are important to you, you can either close this program and rerun the Elden Ring Item and Enemy Randomizer again, or you can add the items to the Finger Maiden items or the Twin Maiden Husks shop. Those can be edited in the \"Starting Items\" tab."
    },
    "selectionsPane": {
        "generalLabel": "General Categories",
        "generalTooltip": "Categories of items where their item locations will have hints added pointing to other items in the same categories.",
        "chestLabel": "Chest Categories",
        "chestTooltip": "Categories of items which will have hints placed in chests.",
        "bossLabel": "Boss Categories",
        "bossTooltip": "Categories of items which will have hints placed in boss drops.",
        "categoriesLabel": "All Categories:",
        "categoriesTooltip": "All available hint categories. You can edit these in the \"Edit Categories\" tab.",
        "defaultButton": "Reload default category selections",
        "defaultTooltip": "Reload the default active category selections. Warning, this cannot be undone. Note that only categories that also exist in the \"Edit Categories\" tab will be loaded.",
        "helpIcon": "Category Selections. Active categories for connected location hints, hints in chests, and hints in boss drops can be selected here. For each type, the left panel shows the hint categories selected. The right panel shows a list of all hint categories. The '<->' button will add selected categories in the right panel to the category lists, and remove selected categories in the left panel from the category lists."
    },
    "startingPane": {
        "maidenTooltip": "Items, item hints, and item category hints to be placed on the Finger Maiden corpse in the Chapel of Anticipation. Note that there is limited space available, and that up to four hints can be placed in one item lot.",
        "maidenSpaceTooltip": "Current Finger Maiden item lots used by selections. Note that the fog gate randomizer and other mods can change the number of available lots, that four hints can fit in one item lot, and when hints are generated selected hints will be stacked into as few item lots as possible. If there are more selections in the list than lots available when generating hints, only the top selections that fit will be used.",
        "propertyDropTooltip": "Selected item hints below will be switched between having all hints generated and only having enemy drop hints generated.",
        "propertyQtyTag": " (qty: {})",
        "propertyQtyButton": "Set Quantity",
        "propertyQtyTitle": "Item Quantity",
        "propertyQtyPrompt": "Enter the quantity:",
        "propertyQtyTooltip": "Set the quantity of the selections below.",
        "propertyItemTag": " (item)",
        "propertyHintTag": " (item hint)",
        "propertyCategoryTag": " (hint category)",
        "maidenLabel": "Finger Maiden Items:",
        "itemListLabel": "Items:",
        "itemListTooltip": "All available items.",
        "hintListLabel": "Item Hints:",
        "hintListTooltip": "Hints for all available items.",
        "categoryListLabel": "Category Hints:",
        "categoryListTooltip": "Hints for all available categories.",
        "shopLabel": "Twin Maiden Husks Shop:",
        "shopTooltip": "Edit the initial inventory of the Twin Maiden Husks shop in Roundtable Hold.",
        "slotLabel": "Slot",
        "useItemTooltip": "Replace the item in the shop inventory slot with the selected item from the panel on the right.",
        "priceTag": " ({})",
        "priceButton": "Set Price",
        "priceTooltip": "Enter the price in runes for this shop inventory slot. The price cannot be less than 1.",
        "loadButton": "Load Shop Inventory",
        "loadTooltip": "Load the randomized contents of the Twin Maiden Husks shop. Any changes you have made will be lost.",
        "helpIcon": "Starting Items. Add items and hints to the Finger Maiden corpse in the Chapel of Anticipation, and edit the initial inventory of the Twin Maiden Husks shop in Roundtable Hold."
    },
    "editPane": {
        "categoryLabel": "Categories:",
        "categoryTooltip": "All available hint categories.",
        "addButton": "Add",
        "addTooltip": "Add a new category. The new category will be at the bottom of the list.",
        "duplicateButton": "Duplicate",
        "duplicateTooltip": "Duplicate the selected category. The new category will be at the bottom of the list.",
        "renameButton": "Rename",
        "renameTooltip": "Rename the selected category. The renamed category will move to the bottom of the list.",
        "removeButton": "Remove",
        "removeTooltip": "Remove the selected category. Warning, this cannot be undone.",
        "reloadButton": "Reload default categories",
        "reloadTooltip": "Reload the default item hint categories. Warning, this cannot be undone. Note that this will not reset the category selections in the \"Category Selections\" tab.",
        "propertyDropTooltip": "Selected items below will be switched between having all hints generated and only having enemy drop hints generated.",
        "builderTooltip": "The contents of the category currently being edited.",
        "itemListLabel": "Items:",
        "itemListTooltip": "All available items.",
        "helpIcon": "Edit Categories. The left panel shows the hint categories. The buttons below allow you to add, duplicate, remove, or rename categories. The middle panel shows the items within the selected category. The \"Toggle drop only\" button above will switch selected items in the category between having all hints generated for them, or only hints for enemy drops. The right panel shows a list of all items. The \"<->\" button will add selected items in the right panel to the category, and remove selected items in the middle panel from the category.",
    },
    "**COMMON**": {
        "filterLabel": "Filter:",
        "filterTooltip": "Enter text to filter the display of items in the "
                         "panel below.",
        "filterButton": "Clear Filter",
        "filterButtonTooltip": "Clear the filter for this pane.",
        "builderButtonTooltip": "If items are selected in the panel to the left, they will be removed. If items are selected in a panel to the right, they will be added to the panel to the left.",
        "propertyDropTag": " (drop only)",
        "propertyDropButton": "Toggle drop only",
    },
}
